/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.forecast.service.impl;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.forecast.entity.PurchaseForecastDetail;
import com.els.modules.forecast.entity.PurchaseForecastHead;
import com.els.modules.forecast.entity.PurchaseForecastMonthItem;
import com.els.modules.forecast.entity.PurchaseForecastWeekItem;
import com.els.modules.forecast.enumerate.DateConditionEnum;
import com.els.modules.forecast.enumerate.DetailSourceTypeEnum;
import com.els.modules.forecast.enumerate.DetailStatusEnum;
import com.els.modules.forecast.enumerate.OrgConditionEnum;
import com.els.modules.forecast.mapper.PurchaseForecastDetailMapper;
import com.els.modules.forecast.service.PurchaseForecastDetailService;
import com.els.modules.forecast.service.PurchaseForecastHeadService;
import com.els.modules.forecast.vo.AssignSupplierVO;
import com.els.modules.forecast.vo.AssignVO;
import com.els.modules.forecast.vo.GenerateVO;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.temporal.WeekFields;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class PurchaseForecastDetailServiceImpl
extends BaseServiceImpl<PurchaseForecastDetailMapper, PurchaseForecastDetail>
implements PurchaseForecastDetailService {
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Autowired
    private PurchaseForecastHeadService purchaseForecastHeadService;
    private BigDecimal oneHundred = BigDecimal.valueOf(100L);

    @Override
    public void add(PurchaseForecastDetail detail) {
        detail.setBusAccount(TenantContext.getTenant());
        detail.setElsAccount(TenantContext.getTenant());
        String detailNumber = this.invokeBaseRpcService.getNextCode("srmForecastDetailNumber", (Object)detail);
        detail.setDetailNumber(detailNumber);
        detail.setDetailStatus(DetailStatusEnum.NEW.getValue());
        detail.setSourceType(DetailSourceTypeEnum.NEW.getValue());
        if (detail.getRequireQuantity().compareTo(BigDecimal.ZERO) <= 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_field_TVWRTfUW_fbc54f0f", (String)"\u9700\u6c42\u6570\u91cf\u987b\u5927\u4e8e0"));
        }
        ((PurchaseForecastDetailMapper)this.baseMapper).insert((Object)detail);
    }

    @Override
    public void submit(PurchaseForecastDetail detail) {
        if (detail.getRequireQuantity().compareTo(BigDecimal.ZERO) <= 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_field_TVWRTfUW_fbc54f0f", (String)"\u9700\u6c42\u6570\u91cf\u987b\u5927\u4e8e0"));
        }
        detail.setBusAccount(TenantContext.getTenant());
        detail.setElsAccount(TenantContext.getTenant());
        String status = StrUtil.isBlank((CharSequence)detail.getToElsAccount()) ? DetailStatusEnum.WAITE_ASSIGN.getValue() : DetailStatusEnum.ENABLE.getValue();
        detail.setDetailStatus(status);
        detail.setForecastDate(new Date());
        LocalDate requireDate = detail.getRequireDate().toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        WeekFields weekFields = WeekFields.of(Locale.getDefault());
        int week = requireDate.get(weekFields.weekOfWeekBasedYear());
        int year = requireDate.getYear();
        int month = requireDate.getMonthValue();
        detail.setRequireYear(String.valueOf(year));
        detail.setRequireMonth(month < 10 ? "0" + month : String.valueOf(month));
        detail.setRequireWeek(week < 10 ? "0" + week : String.valueOf(week));
        int count = ((PurchaseForecastDetailMapper)this.baseMapper).updateById((Object)detail);
        if (count == 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539"));
        }
    }

    @Override
    public void delete(String id) {
        ((PurchaseForecastDetailMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void enable(String id) {
        PurchaseForecastDetail detail = new PurchaseForecastDetail();
        detail.setId(id);
        detail.setDetailStatus(DetailStatusEnum.ENABLE.getValue());
        detail.setForecastDate(new Date());
        int count = ((PurchaseForecastDetailMapper)this.baseMapper).updateById((Object)detail);
        if (count == 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539"));
        }
    }

    @Override
    public void disable(String id) {
        PurchaseForecastDetail detail = new PurchaseForecastDetail();
        detail.setId(id);
        detail.setDetailStatus(DetailStatusEnum.DISABLE.getValue());
        detail.setForecastDate(new Date());
        int count = ((PurchaseForecastDetailMapper)this.baseMapper).updateById((Object)detail);
        if (count == 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539"));
        }
    }

    @Override
    @Transactional
    public void assignSupplier(AssignVO assignVO) {
        boolean isProportion = "1".equals(assignVO.getProportion());
        List<String> idList = assignVO.getIdList();
        List dbList = ((PurchaseForecastDetailMapper)this.baseMapper).selectBatchIds(idList);
        ((PurchaseForecastDetailMapper)this.baseMapper).physicalDeleteByIds(idList);
        List<AssignSupplierVO> supplierList = assignVO.getSupplierList();
        Assert.notEmpty(supplierList, (String)I18nUtil.translate((String)"i18n_alert_VRRiFImRdX_341b994e", (String)"\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u4e2a\u4f9b\u5e94\u5546"));
        this.checkQuota(supplierList, isProportion, (PurchaseForecastDetail)((Object)dbList.get(0)));
        ArrayList<PurchaseForecastDetail> insertList = new ArrayList<PurchaseForecastDetail>();
        Date now = new Date();
        for (PurchaseForecastDetail detail : dbList) {
            for (AssignSupplierVO vo : supplierList) {
                PurchaseForecastDetail insertDetail = new PurchaseForecastDetail();
                BeanUtils.copyProperties((Object)((Object)detail), (Object)((Object)insertDetail));
                insertDetail.setId(null);
                insertDetail.setDetailStatus(DetailStatusEnum.ENABLE.getValue());
                insertDetail.setToElsAccount(vo.getToElsAccount());
                insertDetail.setSupplierCode(vo.getSupplierCode());
                insertDetail.setSupplierName(vo.getSupplierName());
                BigDecimal quantity = isProportion ? detail.getRequireQuantity().divide(this.oneHundred).multiply(vo.getQuota()) : vo.getQuota();
                insertDetail.setRequireQuantity(quantity);
                detail.setForecastDate(now);
                insertList.add(insertDetail);
            }
        }
        if (!insertList.isEmpty()) {
            this.saveBatch(insertList, 2000);
        }
    }

    private void checkQuota(List<AssignSupplierVO> supplierList, boolean isProportion, PurchaseForecastDetail dbDetail) {
        if (isProportion) {
            BigDecimal sumProportion = BigDecimal.ZERO;
            for (AssignSupplierVO vo : supplierList) {
                Assert.notNull((Object)vo.getQuota(), (String)I18nUtil.translate((String)"i18n_alert_RdXWWWWEfxOLV_8f980531", (String)"\u4f9b\u5e94\u5546${0}\u914d\u989d\u4e0d\u80fd\u4e3a\u7a7a", (String[])new String[]{vo.getSupplierName()}));
                sumProportion = sumProportion.add(vo.getQuota());
            }
            Assert.isTrue((sumProportion.compareTo(this.oneHundred) == 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_EfRnlTEUWWW_feab8625", (String)"\u914d\u989d\u4e4b\u548c\u5fc5\u987b\u7b49\u4e8e100"));
        } else {
            BigDecimal sumQuantity = BigDecimal.ZERO;
            for (AssignSupplierVO vo : supplierList) {
                Assert.notNull((Object)vo.getQuota(), (String)I18nUtil.translate((String)"i18n_alert_RdXWWWWEfxOLV_8f980531", (String)"\u4f9b\u5e94\u5546${0}\u914d\u989d\u4e0d\u80fd\u4e3a\u7a7a", (String[])new String[]{vo.getSupplierName()}));
                sumQuantity = sumQuantity.add(vo.getQuota());
            }
            Assert.isTrue((sumQuantity.compareTo(dbDetail.getRequireQuantity()) == 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_EfRnlTEUTVWR_1cf5856d", (String)"\u914d\u989d\u4e4b\u548c\u5fc5\u987b\u7b49\u4e8e\u9700\u6c42\u6570\u91cf"));
        }
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void generate(GenerateVO generateVO) {
        List<PurchaseForecastDetail> generateList = ((PurchaseForecastDetailMapper)this.baseMapper).getGenerateList();
        Assert.notEmpty(generateList, (String)I18nUtil.translate((String)"i18n_alert_BjqIbLTVUijRHVH_aeb52772", (String)"\u6ca1\u6709\u53ef\u4ee5\u751f\u6210\u9700\u6c42\u9884\u6d4b\u7684\u660e\u7ec6\u4fe1\u606f"));
        Map<String, PurchaseForecastDetail> weekMap = generateList.stream().collect(Collectors.toMap(item -> this.getKey(generateVO, (PurchaseForecastDetail)((Object)((Object)item)), true), Function.identity(), (oldVal, newVal) -> {
            BigDecimal quantity = oldVal.getRequireQuantity().add(newVal.getRequireQuantity());
            oldVal.setRequireQuantity(quantity);
            return oldVal;
        }));
        Map<String, List<PurchaseForecastDetail>> sameWeekMap = this.getSameMap(weekMap);
        ArrayList<PurchaseForecastWeekItem> weekItemList = new ArrayList<PurchaseForecastWeekItem>();
        for (Map.Entry<String, List<PurchaseForecastDetail>> entry : sameWeekMap.entrySet()) {
            List<PurchaseForecastDetail> value = entry.getValue();
            PurchaseForecastWeekItem weekItem = new PurchaseForecastWeekItem();
            BeanUtils.copyProperties((Object)((Object)value.get(0)), (Object)((Object)weekItem));
            if (OrgConditionEnum.FACTORY_NO.getValue().equals(generateVO.getOrgCondition())) {
                weekItem.setFactory(null);
            }
            weekItem.setRequireWeekJson(this.getJsonString(value, true));
            weekItemList.add(weekItem);
        }
        Map<String, PurchaseForecastDetail> monthMap = generateList.stream().collect(Collectors.toMap(item -> this.getKey(generateVO, (PurchaseForecastDetail)((Object)((Object)item)), false), Function.identity(), (oldVal, newVal) -> {
            BigDecimal quantity = oldVal.getRequireQuantity().add(newVal.getRequireQuantity());
            oldVal.setRequireQuantity(quantity);
            return oldVal;
        }));
        Map<String, List<PurchaseForecastDetail>> sameMonthMap = this.getSameMap(monthMap);
        ArrayList<PurchaseForecastMonthItem> monthItemList = new ArrayList<PurchaseForecastMonthItem>();
        for (Map.Entry entry : sameMonthMap.entrySet()) {
            List value = (List)entry.getValue();
            PurchaseForecastMonthItem monthItem = new PurchaseForecastMonthItem();
            BeanUtils.copyProperties(value.get(0), (Object)((Object)monthItem));
            if (OrgConditionEnum.FACTORY_NO.getValue().equals(generateVO.getOrgCondition())) {
                monthItem.setFactory(null);
            }
            monthItem.setRequireMonthJson(this.getJsonString(value, false));
            monthItemList.add(monthItem);
        }
        PurchaseForecastHead head = new PurchaseForecastHead();
        this.purchaseForecastHeadService.add(head, monthItemList, weekItemList);
        for (PurchaseForecastDetail detail : generateList) {
            detail.setRequireForecastNumber(head.getForecastNumber());
            detail.setRequireForecastId(head.getId());
        }
        this.updateBatchById(generateList);
    }

    private String getKey(GenerateVO generateVO, PurchaseForecastDetail item, boolean isWeek) {
        StringBuilder key = new StringBuilder(item.getRequireYear());
        key.append("_").append(isWeek ? item.getRequireWeek() : item.getRequireMonth()).append("_").append(item.getToElsAccount()).append("_").append(item.getMaterialNumber());
        if (OrgConditionEnum.FACTORY_YES.getValue().equals(generateVO.getOrgCondition())) {
            key.append("_").append(item.getFactory());
        }
        if (DateConditionEnum.NO_SUM.getValue().equals(generateVO.getDateCondition())) {
            key.append("_").append(item.getId());
        }
        return key.toString();
    }

    private Map<String, List<PurchaseForecastDetail>> getSameMap(Map<String, PurchaseForecastDetail> map) {
        ConcurrentHashMap<String, List<PurchaseForecastDetail>> sameMap = new ConcurrentHashMap<String, List<PurchaseForecastDetail>>();
        for (Map.Entry<String, PurchaseForecastDetail> entry : map.entrySet()) {
            String[] keyArray = entry.getKey().split("_");
            StringBuilder sameKey = new StringBuilder();
            for (int i = 2; i < keyArray.length; ++i) {
                sameKey.append(keyArray[i]).append("_");
            }
            if (sameMap.containsKey(sameKey.toString())) {
                ((List)sameMap.get(sameKey.toString())).add(entry.getValue());
                continue;
            }
            ArrayList<PurchaseForecastDetail> list = new ArrayList<PurchaseForecastDetail>();
            list.add(entry.getValue());
            sameMap.put(sameKey.toString(), list);
        }
        return sameMap;
    }

    private String getJsonString(List<PurchaseForecastDetail> detailList, boolean isWeek) {
        JSONObject object = new JSONObject();
        for (PurchaseForecastDetail detail : detailList) {
            String key = isWeek ? detail.getRequireYear() + "_" + detail.getRequireWeek() : detail.getRequireYear() + "_" + detail.getRequireMonth();
            object.put(key, (Object)detail.getRequireQuantity());
        }
        return object.toJSONString();
    }
}

