/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.inquiry.qualification.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.aspect.annotation.PermissionDataView;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.common.util.I18nUtil;
import com.els.common.vo.CountVO;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.DictDTO;
import com.els.modules.base.api.dto.PurchaseAttachmentDTO;
import com.els.modules.inquiry.qualification.entity.PurchaseQualificationReview;
import com.els.modules.inquiry.qualification.enumerate.ReviewStatusEnum;
import com.els.modules.inquiry.qualification.service.PurchaseQualificationReviewService;
import com.els.modules.inquiry.qualification.vo.PurchaseQualificationReviewVO;
import com.els.rpc.service.InvokeBaseRpcService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.BeanUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u8d44\u683c\u5ba1\u67e5"})
@RestController
@RequestMapping(value={"/qualification/purchaseQualificationReview"})
public class PurchaseQualificationReviewController
extends BaseController<PurchaseQualificationReview, PurchaseQualificationReviewService> {
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    @PermissionDataView(businessType="purchaseQualificationReview")
    public Result<?> queryPageList(PurchaseQualificationReview purchaseQualificationReview, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)purchaseQualificationReview), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = ((PurchaseQualificationReviewService)this.service).page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @AutoLog(value="\u8d44\u683c\u5ba1\u67e5-\u7f16\u8f91")
    @ApiOperation(value="\u7f16\u8f91", notes="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    @RequiresPermissions(value={"qualification#purchaseQualificationReview:edit"})
    public Result<?> edit(@RequestBody PurchaseQualificationReview review) {
        ((PurchaseQualificationReviewService)this.service).update(review);
        return this.commonSuccessResult(3);
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    @RequiresPermissions(value={"qualification#purchaseQualificationReview:queryById"})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        PurchaseQualificationReviewVO reviewVO = new PurchaseQualificationReviewVO();
        PurchaseQualificationReview review = (PurchaseQualificationReview)((Object)((PurchaseQualificationReviewService)this.service).getById((Serializable)((Object)id)));
        BeanUtils.copyProperties((Object)((Object)review), (Object)((Object)reviewVO));
        List<PurchaseAttachmentDTO> attachmentList = this.invokeBaseRpcService.selectPurchaseAttachmentByMainId(review.getRelationId()).stream().filter(attachment -> review.getToElsAccount().equals(attachment.getUploadElsAccount())).collect(Collectors.toList());
        reviewVO.setPurchaseAttachmentList(attachmentList);
        return Result.ok((Object)((Object)reviewVO));
    }

    @AutoLog(value="\u8d44\u683c\u5ba1\u67e5-\u901a\u8fc7")
    @ApiOperation(value="\u901a\u8fc7", notes="\u901a\u8fc7")
    @PostMapping(value={"/pass"})
    @RequiresPermissions(value={"qualification#purchaseQualificationReview:pass"})
    public Result<?> pass(@RequestBody PurchaseQualificationReview review) {
        review.setReviewStatus(ReviewStatusEnum.PASS.getValue());
        ((PurchaseQualificationReviewService)this.service).review(review);
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u8d44\u683c\u5ba1\u67e5-\u62d2\u7edd")
    @ApiOperation(value="\u62d2\u7edd", notes="\u62d2\u7edd")
    @PostMapping(value={"/reject"})
    @RequiresPermissions(value={"qualification#purchaseQualificationReview:reject"})
    public Result<?> reject(@RequestBody PurchaseQualificationReview review) {
        review.setReviewStatus(ReviewStatusEnum.REJECT.getValue());
        ((PurchaseQualificationReviewService)this.service).review(review);
        return this.commonSuccessResult(3);
    }

    @ApiOperation(value="\u901a\u8fc7\u5217\u8868\u9875\u9875\u7b7e\u6570\u91cf\u67e5\u8be2", notes="\u5217\u8868\u9875\u9875\u7b7e\u6570\u91cf\u67e5\u8be2")
    @GetMapping(value={"/counts"})
    public Result<?> queryTabsCount(PurchaseQualificationReview purchaseQualificationReview, HttpServletRequest req) {
        ArrayList<CountVO> result = new ArrayList<CountVO>();
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)purchaseQualificationReview), (Map)req.getParameterMap());
        queryWrapper.select(new String[]{"review_status", "count(0) as participateQuantity"});
        queryWrapper.groupBy((Object)"review_status");
        List list = ((PurchaseQualificationReviewService)this.service).list((Wrapper)queryWrapper);
        Map<String, Integer> countMap = list.stream().collect(Collectors.toMap(PurchaseQualificationReview::getReviewStatus, PurchaseQualificationReview::getParticipateQuantity));
        Integer all = 0;
        for (Map.Entry<String, Integer> entry : countMap.entrySet()) {
            all = all + entry.getValue();
        }
        result.add(new CountVO(I18nUtil.translate((String)"i18n_title_all", (String)"\u5168\u90e8"), "reviewStatus", null, all));
        List srmRequestStatus = this.invokeBaseRpcService.queryDictItemsByCode("srmReviewStatus", TenantContext.getTenant());
        for (DictDTO status : srmRequestStatus) {
            Integer total = countMap.get(status.getValue()) == null ? Integer.valueOf(0) : countMap.get(status.getValue());
            result.add(new CountVO(I18nUtil.translate((String)status.getTextI18nKey(), (String)status.getText()), "reviewStatus", status.getValue(), total));
        }
        return Result.ok(result);
    }
}

