/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.tender.approval.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.common.vo.CountVO;
import com.els.modules.base.api.dto.PurchaseAttachmentDTO;
import com.els.modules.tender.approval.entity.TenderProjectApprovalHead;
import com.els.modules.tender.approval.enumerate.TenderProjectApprovalStateEnum;
import com.els.modules.tender.approval.mapper.TenderProjectApprovalHeadMapper;
import com.els.modules.tender.approval.service.TenderProjectApprovalHeadService;
import com.els.modules.tender.approval.vo.TenderProjectApprovalHeadVO;
import com.els.modules.tender.archive.enumerate.TenderProjectArchiveAttachmentEnum;
import com.els.modules.tender.archive.utils.ArchiveUtil;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@Service
public class TenderProjectApprovalHeadServiceImpl
extends BaseServiceImpl<TenderProjectApprovalHeadMapper, TenderProjectApprovalHead>
implements TenderProjectApprovalHeadService {
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void saveMain(TenderProjectApprovalHeadVO tenderProjectApprovalHeadVo) {
        TenderProjectApprovalHead tenderProjectApprovalHead = new TenderProjectApprovalHead();
        BeanUtils.copyProperties((Object)((Object)tenderProjectApprovalHeadVo), (Object)((Object)tenderProjectApprovalHead));
        tenderProjectApprovalHead.setSourceStatus(TenderProjectApprovalStateEnum.NEW.getValue());
        tenderProjectApprovalHead.setProjectNumber(this.invokeBaseRpcService.getNextCode("tenderProjectApprovalNumber", (Object)tenderProjectApprovalHead));
        tenderProjectApprovalHead.setDeleted(Integer.valueOf("0"));
        if ("0".equals(tenderProjectApprovalHead.getAudit())) {
            tenderProjectApprovalHead.setAuditStatus(AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
        } else {
            tenderProjectApprovalHead.setAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
        }
        ((TenderProjectApprovalHeadMapper)this.baseMapper).insert((Object)tenderProjectApprovalHead);
        List<PurchaseAttachmentDTO> purchaseAttachmentList = tenderProjectApprovalHeadVo.getPurchaseAttachmentList();
        this.invokeBaseRpcService.deletePurchaseAttachmentByMainId(tenderProjectApprovalHead.getId());
        purchaseAttachmentList.parallelStream().forEach(attachment -> attachment.setHeadId(tenderProjectApprovalHead.getId()));
        this.invokeBaseRpcService.insertPurchaseAttachmentBatchSomeColumn(purchaseAttachmentList);
        BeanUtils.copyProperties((Object)((Object)tenderProjectApprovalHead), (Object)((Object)tenderProjectApprovalHeadVo));
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void updateMain(TenderProjectApprovalHeadVO tenderProjectApprovalHeadVo) {
        TenderProjectApprovalHead tenderProjectApprovalHead = new TenderProjectApprovalHead();
        BeanUtils.copyProperties((Object)((Object)tenderProjectApprovalHeadVo), (Object)((Object)tenderProjectApprovalHead));
        if ("0".equals(tenderProjectApprovalHead.getAudit())) {
            tenderProjectApprovalHead.setAuditStatus(AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
        } else {
            tenderProjectApprovalHead.setAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
        }
        int count = ((TenderProjectApprovalHeadMapper)this.baseMapper).updateById((Object)tenderProjectApprovalHead);
        Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        List<PurchaseAttachmentDTO> purchaseAttachmentList = tenderProjectApprovalHeadVo.getPurchaseAttachmentList();
        this.invokeBaseRpcService.deletePurchaseAttachmentByMainId(tenderProjectApprovalHead.getId());
        purchaseAttachmentList.parallelStream().forEach(attachment -> attachment.setHeadId(tenderProjectApprovalHead.getId()));
        this.invokeBaseRpcService.insertPurchaseAttachmentBatchSomeColumn(purchaseAttachmentList);
    }

    @Override
    public TenderProjectApprovalHeadVO queryById(String id) {
        TenderProjectApprovalHeadVO tenderProjectApprovalHeadVO = new TenderProjectApprovalHeadVO();
        TenderProjectApprovalHead projectApprovalHead = (TenderProjectApprovalHead)((Object)((TenderProjectApprovalHeadMapper)this.baseMapper).selectById((Serializable)((Object)id)));
        BeanUtils.copyProperties((Object)((Object)projectApprovalHead), (Object)((Object)tenderProjectApprovalHeadVO));
        List purchaseAttachmentList = this.invokeBaseRpcService.selectPurchaseAttachmentByMainId(id);
        tenderProjectApprovalHeadVO.setPurchaseAttachmentList(purchaseAttachmentList);
        return tenderProjectApprovalHeadVO;
    }

    @Override
    public List<CountVO> queryTabsCount(String elsAccount) {
        return ((TenderProjectApprovalHeadMapper)this.baseMapper).queryTabsCount(elsAccount);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void deleteMain(String id) {
        ((TenderProjectApprovalHeadMapper)this.baseMapper).deleteById((Serializable)((Object)id));
        this.invokeBaseRpcService.deletePurchaseAttachmentByMainId(id);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void deleteBatchMain(List<String> idList) {
        for (String id : idList) {
            ((TenderProjectApprovalHeadMapper)this.baseMapper).deleteById((Serializable)((Object)id));
            this.invokeBaseRpcService.deletePurchaseAttachmentByMainId(id);
        }
    }

    @Override
    public void abandonStatus(TenderProjectApprovalHead tenderProjectApprovalHead) {
        UpdateWrapper updateWrapper = new UpdateWrapper();
        ((UpdateWrapper)updateWrapper.eq((Object)"id", (Object)tenderProjectApprovalHead.getId())).set((Object)"source_status", (Object)TenderProjectApprovalStateEnum.CANCELLATION.getValue());
        ((TenderProjectApprovalHeadMapper)this.baseMapper).update(null, (Wrapper)updateWrapper);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void publish(String id) {
        TenderProjectApprovalHead projectApprovalHead = (TenderProjectApprovalHead)((Object)this.getById((Serializable)((Object)id)));
        this.checkAndSetParam(projectApprovalHead);
        projectApprovalHead.setSourceStatus(TenderProjectApprovalStateEnum.ISSUE.getValue());
        this.updateById((Object)projectApprovalHead);
        List purchaseAttachmentList = this.invokeBaseRpcService.selectPurchaseAttachmentByMainId(id);
        ArchiveUtil.saveArchiveByPurchaseAttachmentDTO(purchaseAttachmentList, id, null, null, TenderProjectArchiveAttachmentEnum.PROJECT_APPROVAL_PREFIX.getValue());
    }

    private void checkAndSetParam(TenderProjectApprovalHead tenderProjectApprovalHead) {
        Assert.isTrue((boolean)StringUtils.hasText((String)tenderProjectApprovalHead.getProjectType()), (String)I18nUtil.translate((String)"i18n_import_dIAcxOLVW_ee21a94c", (String)"\u9879\u76ee\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        Assert.isTrue((boolean)StringUtils.hasText((String)tenderProjectApprovalHead.getBudgetAmount().toString()), (String)I18nUtil.translate((String)"i18n_import_UdHfxOLVW_17586092", (String)"\u9884\u7b97\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        Assert.isTrue((tenderProjectApprovalHead.getBudgetAmount().compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_import_UdHflTPfUQW_3a4f801e", (String)"\u9884\u7b97\u91d1\u989d\u5fc5\u987b\u8981\u5927\u4e8e\u96f6\uff01"));
        Assert.isTrue((boolean)StringUtils.hasText((String)tenderProjectApprovalHead.getPurchaseOrgType()), (String)I18nUtil.translate((String)"i18n_import_YBVRcKxOLVW_a5049835", (String)"\u62db\u6807\u7ec4\u7ec7\u5f62\u5f0f\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        Assert.isTrue((boolean)StringUtils.hasText((String)tenderProjectApprovalHead.getProjectContacts()), (String)I18nUtil.translate((String)"i18n_import_dIKHLxOLVW_628aa8f3", (String)"\u9879\u76ee\u8054\u7cfb\u4eba\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        Assert.isTrue((boolean)StringUtils.hasText((String)tenderProjectApprovalHead.getContactsNumber()), (String)I18nUtil.translate((String)"i18n_import_KHCExOLVW_28acbba2", (String)"\u8054\u7cfb\u7535\u8bdd\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        Assert.isTrue((boolean)StringUtils.hasText((String)tenderProjectApprovalHead.getProjectAddress()), (String)I18nUtil.translate((String)"i18n_import_dInRxOLVW_a82271ac", (String)"\u9879\u76ee\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
    }
}

