/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.tender.evaluation.strategy.review.handler;

import com.els.modules.tender.attachment.entity.PurchaseTenderEvaluationGroup;
import com.els.modules.tender.attachment.entity.PurchaseTenderEvaluationPrinciples;
import com.els.modules.tender.evaluation.entity.PurchaseTenderProjectBidEvaRegulationResult;
import com.els.modules.tender.evaluation.strategy.review.AbstractSummaryStrategy;
import com.els.modules.tender.evaluation.vo.SupplierEvaRankingVO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;

@Component(value="reviewScoreSummaryStrategy")
public class ReviewScoreSummaryStrategy
extends AbstractSummaryStrategy {
    @Override
    public SupplierEvaRankingVO.EvaGroupSummaryResult summaryResult(PurchaseTenderEvaluationGroup evaluationGroup, PurchaseTenderEvaluationPrinciples evaluationPrinciples, List<PurchaseTenderProjectBidEvaRegulationResult> evaGroupRegulationResultList) {
        String reviewSummaryRules = evaluationPrinciples.getReviewSummaryRules();
        ArrayList<PurchaseTenderProjectBidEvaRegulationResult> summaryResultList = new ArrayList<PurchaseTenderProjectBidEvaRegulationResult>();
        Map<String, List<PurchaseTenderProjectBidEvaRegulationResult>> regulationResultMap = evaGroupRegulationResultList.parallelStream().collect(Collectors.groupingBy(PurchaseTenderProjectBidEvaRegulationResult::getRegulationId));
        for (String regulationId : regulationResultMap.keySet()) {
            List<PurchaseTenderProjectBidEvaRegulationResult> regulationResultList = regulationResultMap.get(regulationId);
            PurchaseTenderProjectBidEvaRegulationResult summaryResult = this.buildSummaryResult(regulationResultList);
            long notPassCount = regulationResultList.parallelStream().filter(result -> "0".equals(result.getResult())).count();
            long passCount = regulationResultList.parallelStream().filter(result -> "1".equals(result.getResult())).count();
            if (passCount > notPassCount) {
                summaryResult.setResult("1");
            } else if (passCount == notPassCount) {
                summaryResult.setResult("0".equals(reviewSummaryRules) ? "1" : "0");
            } else {
                summaryResult.setResult("0");
            }
            summaryResultList.add(summaryResult);
        }
        SupplierEvaRankingVO.EvaGroupSummaryResult.EvaGroupSummaryResultBuilder resultBuilder = SupplierEvaRankingVO.EvaGroupSummaryResult.builder().evaGroupName(evaluationGroup.getGroupName()).evaGroupId(evaluationGroup.getId()).evaGroupType(evaluationGroup.getGroupType()).evaGroupResult("1").weight(evaluationGroup.getWeights()).orderBy(evaluationGroup.getOrderBy()).invalid("0").totalScore(BigDecimal.valueOf(evaluationGroup.getScore().intValue()));
        Integer vetoCondition = evaluationGroup.getVetoCondition() == null ? 0 : evaluationGroup.getVetoCondition();
        Integer reviewGradingType = evaluationGroup.getReviewGradingType() == null ? 0 : evaluationGroup.getReviewGradingType();
        long notPassCount = summaryResultList.parallelStream().filter(result -> "0".equals(result.getResult())).count();
        if (notPassCount >= (long)vetoCondition.intValue()) {
            resultBuilder.invalid(reviewGradingType.equals(Integer.valueOf("0")) ? "0" : "1");
            resultBuilder.totalScore(BigDecimal.ZERO);
        }
        return resultBuilder.build();
    }
}

