/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.tender.openbid.job;

import com.alibaba.fastjson.JSONObject;
import com.els.common.constant.CommonConstant;
import com.els.common.util.DateUtils;
import com.els.common.util.I18nUtil;
import com.els.common.util.SpringContextUtils;
import com.els.config.mybatis.TenantContext;
import com.els.modules.inquiry.rpc.service.InquriyInvokeJobRpcService;
import com.els.modules.job.api.dto.QuartzJobDTO;
import com.els.modules.tender.common.aspect.TenderFlagInjectionContext;
import com.els.modules.tender.project.entity.PurchaseTenderProjectSubpackageInfo;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TenderJobUtil {
    private static final Logger log = LoggerFactory.getLogger(TenderJobUtil.class);
    private static InquriyInvokeJobRpcService inquriyInvokeJobRpcService = (InquriyInvokeJobRpcService)SpringContextUtils.getBean(InquriyInvokeJobRpcService.class);
    public static final String OPEN_BID_ALERT_JOB = "tenderOpenBidAlertJobServiceImpl";
    public static final String OPEN_BID_DECRYPT_ALERT_JOB = "tenderOpenBidDecryptAlertJobServiceImpl";

    private static void createJob(PurchaseTenderProjectSubpackageInfo purchaseTenderProjectSubpackageInfo, Date time, String jobName, String jobNameKey) {
        String elsAccount = TenantContext.getTenant();
        String cron = DateUtils.formatDate((Date)time, (String)"ss mm HH dd MM ? yyyy");
        QuartzJobDTO job = new QuartzJobDTO();
        job.setCronExpression(cron);
        job.setJobClassName("com.els.modules.quartz.job.BusinessJob");
        job.setStatus(CommonConstant.STATUS_NORMAL);
        job.setJobNameKey(jobNameKey);
        JSONObject paramObj = new JSONObject();
        paramObj.put("id", (Object)purchaseTenderProjectSubpackageInfo.getId());
        paramObj.put("jobImplName", (Object)jobName);
        paramObj.put("checkType", (Object)TenderFlagInjectionContext.getTenderCheckType());
        paramObj.put("processType", (Object)TenderFlagInjectionContext.getTenderProcessType());
        paramObj.put("currentStep", (Object)TenderFlagInjectionContext.getTenderCurrentStep());
        paramObj.put("jobKey", (Object)job.getJobNameKey());
        paramObj.put("tenantId", (Object)elsAccount);
        job.setParameter(paramObj.toJSONString());
        job.setElsAccount(elsAccount);
        try {
            inquriyInvokeJobRpcService.createJob(job);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            if (e.getMessage().contains("will never fire")) {
                throw new RuntimeException(I18nUtil.translate((String)"i18n_alert_vBKIRHWRRTPfUAPKIWzsIX_ecf1fd8", (String)"\u5f00\u6807\u65f6\u95f4\u8fc7\u8fd1\uff0c\u81f3\u5c11\u9700\u8981\u5927\u4e8e\u5f53\u524d\u65f6\u95f45\u5206\u949f\u4ee5\u4e0a"));
            }
            throw new RuntimeException(e.getMessage());
        }
    }

    public static void createOrUpdateOpenBidAlertJob(PurchaseTenderProjectSubpackageInfo subpackageInfo, Date time) {
        String jobNameKey = "tenderOpenBidAlertJobServiceImpl_" + subpackageInfo.getSubpackageNumber() + "_" + subpackageInfo.getElsAccount();
        List<QuartzJobDTO> jobList = inquriyInvokeJobRpcService.findJobList(jobNameKey);
        if (!jobList.isEmpty()) {
            TenderJobUtil.deleteJob(jobNameKey);
        }
        TenderJobUtil.createJob(subpackageInfo, time, OPEN_BID_ALERT_JOB, jobNameKey);
    }

    public static void createOrUpdateOpenBidDecryptAlertJob(PurchaseTenderProjectSubpackageInfo subpackageInfo, Date time) {
        String jobNameKey = "tenderOpenBidDecryptAlertJobServiceImpl_" + subpackageInfo.getSubpackageNumber() + "_" + subpackageInfo.getElsAccount();
        List<QuartzJobDTO> jobList = inquriyInvokeJobRpcService.findJobList(jobNameKey);
        if (!jobList.isEmpty()) {
            TenderJobUtil.deleteJob(jobNameKey);
        }
        TenderJobUtil.createJob(subpackageInfo, time, OPEN_BID_DECRYPT_ALERT_JOB, jobNameKey);
    }

    public static void updateJob(QuartzJobDTO job, String jobNameKey, Date endTime) {
        String cron = DateUtils.formatDate((Date)endTime, (String)"ss mm HH dd MM ? yyyy");
        job.setCronExpression(cron);
        job.setJobClassName("com.els.modules.quartz.job.BusinessJob");
        job.setStatus(CommonConstant.STATUS_NORMAL);
        job.setJobNameKey(jobNameKey);
        try {
            inquriyInvokeJobRpcService.updateJob(job);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            if (e.getMessage().contains("will never fire")) {
                throw new RuntimeException(I18nUtil.translate((String)"i18n_alert_vBKIRHWRRTPfUAPKIWzsIX_ecf1fd8", (String)"\u5f00\u6807\u65f6\u95f4\u8fc7\u8fd1\uff0c\u81f3\u5c11\u9700\u8981\u5927\u4e8e\u5f53\u524d\u65f6\u95f45\u5206\u949f\u4ee5\u4e0a"));
            }
            throw new RuntimeException(e.getMessage());
        }
    }

    public static void deleteOpenBidDecryptAlertJob(PurchaseTenderProjectSubpackageInfo subpackageInfo) {
        String jobNameKey = "tenderOpenBidDecryptAlertJobServiceImpl_" + subpackageInfo.getSubpackageNumber() + "_" + subpackageInfo.getElsAccount();
        TenderJobUtil.deleteJob(jobNameKey);
    }

    public static void deleteJob(String jobKey) {
        List<QuartzJobDTO> jobList = inquriyInvokeJobRpcService.findJobList(jobKey);
        if (!jobList.isEmpty()) {
            inquriyInvokeJobRpcService.deleteJob(jobList.get(0));
        }
    }
}

