/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.tender.project.controller;

import com.els.common.api.vo.Result;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.modules.tender.common.utils.OpenBidRecordLogUtils;
import com.els.modules.tender.common.utils.TenderOperationFieldUtils;
import com.els.modules.tender.openbid.enumerate.PurchaseOpenBidStatusEnum;
import com.els.modules.tender.openbid.job.TenderJobUtil;
import com.els.modules.tender.project.entity.PurchaseTenderProjectSubpackageInfo;
import com.els.modules.tender.project.service.PurchaseTenderProjectSubpackageInfoService;
import com.els.modules.tender.project.vo.PurchaseTenderProjectOpenInfoHeadVO;
import com.els.modules.tender.sale.entity.SaleTenderPriceOpenings;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.util.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/tender/purchaseTenderProjectSubpackageInfo"})
@Api(tags={"\u91c7\u8d2d\u62db\u6807\u5206\u5305\u9879\u76ee\u5f00\u6807\u57fa\u672c\u4fe1\u606f"})
public class PurchaseTenderProjectSubpackageInfoController
extends BaseController<PurchaseTenderProjectSubpackageInfo, PurchaseTenderProjectSubpackageInfoService> {
    private static final Logger log = LoggerFactory.getLogger(PurchaseTenderProjectSubpackageInfoController.class);
    @Autowired
    private PurchaseTenderProjectSubpackageInfoService subpackageInfoService;

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2\u5f00\u6807\u4fe1\u606f", notes="\u901a\u8fc7id\u67e5\u8be2\u5f00\u6807\u4fe1\u606f")
    @GetMapping(value={"/queryById"})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        PurchaseTenderProjectOpenInfoHeadVO tenderProjectOpenInfoHeadVO = this.subpackageInfoService.queryOpenInfoById(id);
        return Result.ok((Object)((Object)tenderProjectOpenInfoHeadVO));
    }

    @ApiOperation(value="\u5f00\u6807", notes="\u5f00\u6807")
    @PostMapping(value={"/openBid"})
    public Result<?> openBid(@RequestBody PurchaseTenderProjectOpenInfoHeadVO openInfoHead) {
        PurchaseTenderProjectSubpackageInfo subpackageInfo = (PurchaseTenderProjectSubpackageInfo)((Object)this.subpackageInfoService.getById((Serializable)((Object)openInfoHead.getId())));
        String openBidStatus = TenderOperationFieldUtils.getOpenBidStatus((Object)subpackageInfo);
        TenderOperationFieldUtils.setOpenBidSubpackageStatus((Object)subpackageInfo);
        TenderOperationFieldUtils.setOpenBidStatus((Object)subpackageInfo, PurchaseOpenBidStatusEnum.DECRYPTING.getValue());
        Assert.isTrue((boolean)PurchaseOpenBidStatusEnum.NOT_OPEN_BID.getValue().equals(openBidStatus), (String)I18nUtil.translate((String)"i18n__xiTVBvBW_c56fe716", (String)"\u4e0d\u5141\u8bb8\u91cd\u590d\u5f00\u6807\uff01"));
        openInfoHead = this.subpackageInfoService.updateOpenBidStatus(subpackageInfo);
        LoginUser loginUser = SysUtil.getLoginUser();
        OpenBidRecordLogUtils.saveRecordMsg(openInfoHead, "\u62db\u6807\u4eba " + loginUser.getEnterpriseName() + " " + loginUser.getRealname() + " \u5ba3\u5e03\u5f00\u6807");
        return Result.ok((Object)((Object)openInfoHead));
    }

    @ApiOperation(value="\u89e3\u5bc6\u7ed3\u675f", notes="\u89e3\u5bc6\u7ed3\u675f")
    @PostMapping(value={"/decrypted"})
    public Result<?> decrypted(@RequestBody PurchaseTenderProjectOpenInfoHeadVO openInfoHead) {
        PurchaseTenderProjectOpenInfoHeadVO openInfoHeadVO = this.subpackageInfoService.queryOpenInfoById(openInfoHead.getId());
        PurchaseTenderProjectSubpackageInfo subpackageInfo = (PurchaseTenderProjectSubpackageInfo)((Object)SysUtil.copyProperties((Object)((Object)openInfoHeadVO), PurchaseTenderProjectSubpackageInfo.class));
        String openBidStatus = TenderOperationFieldUtils.getOpenBidStatus((Object)subpackageInfo);
        TenderOperationFieldUtils.setDecryptedSubpackageStatus((Object)subpackageInfo);
        TenderOperationFieldUtils.setOpenBidStatus((Object)subpackageInfo, PurchaseOpenBidStatusEnum.DECRYPTED.getValue());
        Assert.isTrue((boolean)PurchaseOpenBidStatusEnum.DECRYPTING.getValue().equals(openBidStatus), (String)I18nUtil.translate((String)"", (String)"\u5f53\u524d\u5f00\u6807\u5927\u5385\u72b6\u6001\u4e3a[${0}],\u4e0d\u80fd\u8fdb\u884c\u89e3\u5bc6\u7ed3\u675f\u64cd\u4f5c\uff01", (String[])new String[]{PurchaseOpenBidStatusEnum.getOpenBidStatusDesc(openBidStatus)}));
        Assert.isTrue((openInfoHeadVO.getDecryptNumber() == openInfoHeadVO.getFileSubmitNumber() ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n__QInJLWUywLWxIRWxiTDPyWW_14d17a4f", (String)"\u6587\u4ef6\u9012\u4ea4\u4eba\u6570\u4e0e\u89e3\u5bc6\u4eba\u6570\u4e0d\u4e00\u81f4\uff0c\u4e0d\u5141\u8bb8\u63d0\u524d\u7ed3\u675f\uff01"));
        openInfoHead = this.subpackageInfoService.updateOpenBidStatus(subpackageInfo);
        TenderJobUtil.deleteOpenBidDecryptAlertJob(openInfoHeadVO);
        OpenBidRecordLogUtils.saveRecordMsg(openInfoHead, "\u89e3\u5bc6\u73af\u8282\u7ed3\u675f");
        return Result.ok((Object)((Object)openInfoHead));
    }

    @ApiOperation(value="\u7ed3\u675f\u5f00\u6807", notes="\u7ed3\u675f\u5f00\u6807")
    @PostMapping(value={"/endBid"})
    public Result<?> endBid(@RequestBody PurchaseTenderProjectOpenInfoHeadVO openInfoHead) {
        PurchaseTenderProjectSubpackageInfo subpackageInfo = (PurchaseTenderProjectSubpackageInfo)((Object)this.subpackageInfoService.getById((Serializable)((Object)openInfoHead.getId())));
        String openBidStatus = TenderOperationFieldUtils.getOpenBidStatus((Object)subpackageInfo);
        TenderOperationFieldUtils.setEndBidSubpackageStatus((Object)subpackageInfo);
        TenderOperationFieldUtils.setOpenBidStatus((Object)subpackageInfo, PurchaseOpenBidStatusEnum.END_BID.getValue());
        Assert.isTrue((boolean)PurchaseOpenBidStatusEnum.DECRYPTED.getValue().equals(openBidStatus), (String)I18nUtil.translate((String)"i18n__xiTVByWvBW_e6f10daa", (String)"\u4e0d\u5141\u8bb8\u91cd\u590d\u7ed3\u675f\u5f00\u6807\uff01"));
        openInfoHead = this.subpackageInfoService.updateOpenBidStatus(subpackageInfo);
        LoginUser loginUser = SysUtil.getLoginUser();
        OpenBidRecordLogUtils.saveRecordMsg(openInfoHead, "\u62db\u6807\u4eba " + loginUser.getEnterpriseName() + " " + loginUser.getRealname() + " \u5ba3\u5e03\u7ed3\u675f\u5f00\u6807");
        return Result.ok((Object)((Object)openInfoHead));
    }

    @ApiOperation(value="\u83b7\u53d6\u4ef7\u683c\u4e00\u89c8\u8868", notes="\u83b7\u53d6\u4ef7\u683c\u4e00\u89c8\u8868")
    @PostMapping(value={"/priceOpeningsBySubpackageId"})
    public Result<?> getPriceOpeningsBySubpackageId(@RequestParam(name="id") String id) {
        List<SaleTenderPriceOpenings> tenderPriceOpeningsList = this.subpackageInfoService.getPurchasePriceOpeningsById(id);
        return Result.ok(tenderPriceOpeningsList);
    }

    @ApiOperation(value="\u5bfc\u51fa\u4ef7\u683c\u4e00\u89c8\u8868excel", notes="\u5bfc\u51fa\u4ef7\u683c\u4e00\u89c8\u8868")
    @GetMapping(value={"/exportPriceOpenings"})
    public void exportPriceOpenings(@RequestParam(name="id") String id, HttpServletResponse response) {
        this.subpackageInfoService.exportPriceOpenings(id, response);
    }

    @ApiOperation(value="\u5bfc\u51fa\u4ef7\u683c\u4e00\u89c8\u8868pdf", notes="\u5bfc\u51fa\u4ef7\u683c\u4e00\u89c8\u8868pdf")
    @GetMapping(value={"/exportPriceOpeningsPDF"})
    public void exportPriceOpeningsPDF(@RequestParam(name="id") String id, HttpServletResponse response) {
        this.subpackageInfoService.exportPriceOpeningsPDF(id, response);
    }
}

