/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.tender.archive.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.modules.base.api.dto.PurchaseAttachmentDTO;
import com.els.modules.tender.archive.entity.TenderProjectArchiveAttachmentHead;
import com.els.modules.tender.archive.entity.TenderProjectArchiveAttachmentInfo;
import com.els.modules.tender.archive.enumerate.TenderProjectArchiveAttachmentEnum;
import com.els.modules.tender.archive.mapper.TenderProjectArchiveAttachmentHeadMapper;
import com.els.modules.tender.archive.service.TenderProjectArchiveAttachmentHeadService;
import com.els.modules.tender.archive.service.TenderProjectArchiveAttachmentInfoService;
import com.els.modules.tender.archive.utils.ArchiveUtil;
import com.els.modules.tender.archive.vo.ArchiveAttachmentHeadProjectAllVo;
import com.els.modules.tender.archive.vo.TenderProjectArchiveAttachmentInfoVo;
import com.els.modules.tender.project.entity.PurchaseTenderProjectHead;
import com.els.modules.tender.project.service.PurchaseTenderProjectHeadService;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class TenderProjectArchiveAttachmentHeadServiceImpl
extends BaseServiceImpl<TenderProjectArchiveAttachmentHeadMapper, TenderProjectArchiveAttachmentHead>
implements TenderProjectArchiveAttachmentHeadService {
    @Autowired
    private TenderProjectArchiveAttachmentInfoService archiveAttachmentInfoService;
    @Autowired
    private PurchaseTenderProjectHeadService tenderProjectHeadService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void add(TenderProjectArchiveAttachmentHead tenderProjectArchiveAttachmentHead, List<TenderProjectArchiveAttachmentInfo> infoList) {
        ((TenderProjectArchiveAttachmentHeadMapper)this.baseMapper).insert((Object)tenderProjectArchiveAttachmentHead);
        this.insertData(tenderProjectArchiveAttachmentHead, infoList);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void edit(TenderProjectArchiveAttachmentHead tenderProjectArchiveAttachmentHead, List<TenderProjectArchiveAttachmentInfo> infoList) {
        int count = ((TenderProjectArchiveAttachmentHeadMapper)this.baseMapper).updateById((Object)tenderProjectArchiveAttachmentHead);
        Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        this.insertData(tenderProjectArchiveAttachmentHead, infoList);
    }

    private void insertData(TenderProjectArchiveAttachmentHead tenderProjectArchiveAttachmentHead, List<TenderProjectArchiveAttachmentInfo> infoList) {
        if (CollectionUtil.isEmpty(infoList)) {
            return;
        }
        ArrayList purchaseAttachmentDTOList = SysUtil.copyProperties(infoList, PurchaseAttachmentDTO.class);
        this.invokeBaseRpcService.deletePurchaseAttachmentByMainId(tenderProjectArchiveAttachmentHead.getId());
        purchaseAttachmentDTOList.parallelStream().forEach(attachment -> attachment.setHeadId(tenderProjectArchiveAttachmentHead.getId()));
        this.invokeBaseRpcService.insertPurchaseAttachmentBatchSomeColumn((List)purchaseAttachmentDTOList);
        this.archiveAttachmentInfoService.deleteByHeadId(tenderProjectArchiveAttachmentHead.getId());
        ArchiveUtil.saveArchiveByPurchaseAttachmentDTO(purchaseAttachmentDTOList, tenderProjectArchiveAttachmentHead.getId(), null, tenderProjectArchiveAttachmentHead.getTenderProjectId(), TenderProjectArchiveAttachmentEnum.ARCHIVE_ATTACHMENT_PREFIX.getValue());
    }

    @Override
    public void delete(String id) {
        ((TenderProjectArchiveAttachmentHeadMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void deleteBatch(List<String> idList) {
        ((TenderProjectArchiveAttachmentHeadMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    public List<TenderProjectArchiveAttachmentInfoVo> queryByProjectId(String tenderProjectId) {
        List<TenderProjectArchiveAttachmentInfo> archiveAttachmentInfoList = this.archiveAttachmentInfoService.selectByTenderProjectIds(Arrays.asList(tenderProjectId));
        PurchaseTenderProjectHead purchaseTenderProjectHead = (PurchaseTenderProjectHead)((Object)this.tenderProjectHeadService.getBaseMapper().selectById((Serializable)((Object)tenderProjectId)));
        String projectId = purchaseTenderProjectHead.getProjectId();
        List<TenderProjectArchiveAttachmentInfo> archiveAttachmentInfoByApprpvalList = null;
        if (StringUtils.isNotBlank((CharSequence)projectId)) {
            archiveAttachmentInfoByApprpvalList = this.archiveAttachmentInfoService.selectByMainIds(Arrays.asList(projectId));
        }
        if (CollectionUtil.isNotEmpty(archiveAttachmentInfoList) && CollectionUtil.isNotEmpty(archiveAttachmentInfoByApprpvalList)) {
            archiveAttachmentInfoList.addAll(archiveAttachmentInfoByApprpvalList);
        }
        List<TenderProjectArchiveAttachmentInfoVo> archiveAttachmentInfoVoList = this.dataConvert(archiveAttachmentInfoList);
        return archiveAttachmentInfoVoList;
    }

    @Override
    public List<TenderProjectArchiveAttachmentInfoVo> queryBySubpackageId(String subpackageId) {
        List<TenderProjectArchiveAttachmentInfo> archiveAttachmentInfoList = this.archiveAttachmentInfoService.selectBySubpackageId(subpackageId);
        List<TenderProjectArchiveAttachmentInfoVo> archiveAttachmentInfoVoList = this.dataConvert(archiveAttachmentInfoList);
        return archiveAttachmentInfoVoList;
    }

    @Override
    public List<ArchiveAttachmentHeadProjectAllVo> queryProjectArchiveInfo() {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        List archiveAttachmentHeadList = ((TenderProjectArchiveAttachmentHeadMapper)this.baseMapper).selectList((Wrapper)queryWrapper);
        if (CollectionUtil.isEmpty((Collection)archiveAttachmentHeadList)) {
            return null;
        }
        ArrayList archiveAttachmentHeadProjectAllVoList = SysUtil.copyProperties((List)archiveAttachmentHeadList, ArchiveAttachmentHeadProjectAllVo.class);
        List<String> tenderProjectIds = archiveAttachmentHeadList.parallelStream().map(TenderProjectArchiveAttachmentHead::getTenderProjectId).collect(Collectors.toList());
        List<TenderProjectArchiveAttachmentInfo> projectArchiveAttachmentInfoList = this.archiveAttachmentInfoService.selectByTenderProjectIds(tenderProjectIds);
        List purchaseTenderProjectHeadList = this.tenderProjectHeadService.getBaseMapper().selectBatchIds(tenderProjectIds);
        List<String> tenderApprovalIds = purchaseTenderProjectHeadList.parallelStream().map(PurchaseTenderProjectHead::getProjectId).collect(Collectors.toList());
        List<TenderProjectArchiveAttachmentInfo> approvalArchiveInfoList = null;
        if (CollectionUtil.isNotEmpty(tenderApprovalIds)) {
            approvalArchiveInfoList = this.archiveAttachmentInfoService.selectByMainIds(tenderApprovalIds);
        }
        Map<String, List<TenderProjectArchiveAttachmentInfo>> projectMap = null;
        Map<String, List<TenderProjectArchiveAttachmentInfo>> approvalMap = null;
        if (CollectionUtil.isNotEmpty(projectArchiveAttachmentInfoList)) {
            projectMap = projectArchiveAttachmentInfoList.parallelStream().collect(Collectors.groupingBy(TenderProjectArchiveAttachmentInfo::getTenderProjectId));
        }
        if (CollectionUtil.isNotEmpty(approvalArchiveInfoList)) {
            approvalMap = approvalArchiveInfoList.parallelStream().collect(Collectors.groupingBy(TenderProjectArchiveAttachmentInfo::getTenderProjectId));
        }
        for (ArchiveAttachmentHeadProjectAllVo headVo : archiveAttachmentHeadProjectAllVoList) {
            List<TenderProjectArchiveAttachmentInfo> infos;
            int count = 0;
            if (null != projectMap && CollectionUtil.isNotEmpty(infos = projectMap.get(headVo.getTenderProjectId()))) {
                count += infos.size();
            }
            if (null != approvalMap && CollectionUtil.isNotEmpty(infos = approvalMap.get(headVo.getTenderApprovalId()))) {
                count += infos.size();
            }
            headVo.setFileCount(count);
        }
        return archiveAttachmentHeadProjectAllVoList;
    }

    private List<TenderProjectArchiveAttachmentInfoVo> dataConvert(List<TenderProjectArchiveAttachmentInfo> archiveAttachmentInfoList) {
        if (CollectionUtil.isEmpty(archiveAttachmentInfoList)) {
            return null;
        }
        Map<String, List<TenderProjectArchiveAttachmentInfo>> map = archiveAttachmentInfoList.parallelStream().collect(Collectors.groupingBy(tenderProjectArchiveAttachmentInfo -> TenderProjectArchiveAttachmentEnum.getAttachmentStatusStage(tenderProjectArchiveAttachmentInfo.getBusinessType())));
        if (null == map) {
            return null;
        }
        ArrayList<TenderProjectArchiveAttachmentInfoVo> archiveAttachmentInfoVoList = new ArrayList<TenderProjectArchiveAttachmentInfoVo>();
        for (String key : map.keySet()) {
            TenderProjectArchiveAttachmentInfoVo tenderProjectArchiveAttachmentInfoVo = new TenderProjectArchiveAttachmentInfoVo();
            tenderProjectArchiveAttachmentInfoVo.setTitle(key);
            tenderProjectArchiveAttachmentInfoVo.setInfoList(map.get(key));
            archiveAttachmentInfoVoList.add(tenderProjectArchiveAttachmentInfoVo);
        }
        return archiveAttachmentInfoVoList;
    }
}

