/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.tender.attachment.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.constant.CommonConstant;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.modules.tender.attachment.entity.PurchaseTenderBidLetter;
import com.els.modules.tender.attachment.entity.PurchaseTenderBidLetterFormatGroup;
import com.els.modules.tender.attachment.entity.PurchaseTenderPriceOpeningsTemplate;
import com.els.modules.tender.attachment.entity.PurchaseTenderProjectAttachmentHead;
import com.els.modules.tender.attachment.enumerate.PurchaseTenderBidLetterFormatTypeEnum;
import com.els.modules.tender.attachment.mapper.PurchaseTenderBidLetterFormatGroupMapper;
import com.els.modules.tender.attachment.service.PurchaseTenderBidLetterFormatGroupService;
import com.els.modules.tender.attachment.service.PurchaseTenderBidLetterService;
import com.els.modules.tender.attachment.service.PurchaseTenderPriceOpeningsTemplateService;
import com.els.modules.tender.attachment.service.PurchaseTenderProjectAttachmentHeadService;
import com.els.modules.tender.attachment.vo.PurchaseTenderBidLetterFormatGroupVO;
import com.els.modules.tender.attachment.vo.PurchaseTenderBidLetterVO;
import com.els.modules.tender.attachment.vo.PurchaseTenderProjectAttachmentHeadViewVO;
import com.els.modules.tender.common.aspect.TenderFlagInjectionContext;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class PurchaseTenderBidLetterFormatGroupServiceImpl
extends BaseServiceImpl<PurchaseTenderBidLetterFormatGroupMapper, PurchaseTenderBidLetterFormatGroup>
implements PurchaseTenderBidLetterFormatGroupService {
    @Autowired
    @Lazy
    private PurchaseTenderProjectAttachmentHeadService attachmentHeadService;
    @Autowired
    private PurchaseTenderBidLetterService purchaseTenderBidLetterService;
    @Autowired
    private PurchaseTenderPriceOpeningsTemplateService purchaseTenderPriceOpeningsTemplateService;

    @Override
    public void add(PurchaseTenderBidLetterFormatGroup purchaseTenderBidLetterFormatGroup) {
        ((PurchaseTenderBidLetterFormatGroupMapper)this.baseMapper).insert((Object)purchaseTenderBidLetterFormatGroup);
    }

    @Override
    public void edit(PurchaseTenderBidLetterFormatGroup purchaseTenderBidLetterFormatGroup) {
        int count = ((PurchaseTenderBidLetterFormatGroupMapper)this.baseMapper).updateById((Object)purchaseTenderBidLetterFormatGroup);
        Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
    }

    @Override
    public void delete(String id) {
        ((PurchaseTenderBidLetterFormatGroupMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void deleteBatch(List<String> idList) {
        ((PurchaseTenderBidLetterFormatGroupMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    public void deleteByMainId(String headId) {
        ((PurchaseTenderBidLetterFormatGroupMapper)this.baseMapper).deleteByMainId(headId);
    }

    @Override
    public void addTenderBidLetter(PurchaseTenderProjectAttachmentHead attachmentHead, PurchaseTenderBidLetterFormatGroupVO tenderBidLetterFormatGroupVo) {
        tenderBidLetterFormatGroupVo.setSubpackageId(attachmentHead.getSubpackageId());
        tenderBidLetterFormatGroupVo.setTenderProjectId(attachmentHead.getTenderProjectId());
        tenderBidLetterFormatGroupVo.setHeadId(attachmentHead.getId());
        tenderBidLetterFormatGroupVo.setDeleted(CommonConstant.DEL_FLAG_0);
        PurchaseTenderBidLetterFormatGroup purchaseTenderBidLetterFormatGroup = (PurchaseTenderBidLetterFormatGroup)((Object)SysUtil.copyProperties((Object)((Object)tenderBidLetterFormatGroupVo), PurchaseTenderBidLetterFormatGroup.class));
        ((PurchaseTenderBidLetterFormatGroupMapper)this.baseMapper).insert((Object)purchaseTenderBidLetterFormatGroup);
        List<PurchaseTenderBidLetterVO> tenderBidLetterVoList = tenderBidLetterFormatGroupVo.getTenderBidTetterVoList();
        ArrayList priceOpeningsList = new ArrayList(10);
        List tenderBidLetterList = tenderBidLetterVoList.stream().map(tenderBidLetterVo -> {
            PurchaseTenderBidLetter tenderBidLetter = new PurchaseTenderBidLetter();
            if (tenderBidLetterVo.getId() == null) {
                tenderBidLetterVo.setId(IdWorker.getIdStr());
            }
            tenderBidLetterVo.setSubpackageId(attachmentHead.getSubpackageId());
            tenderBidLetterVo.setTenderProjectId(attachmentHead.getTenderProjectId());
            tenderBidLetterVo.setHeadId(attachmentHead.getId());
            tenderBidLetterVo.setGroupId(purchaseTenderBidLetterFormatGroup.getId());
            tenderBidLetterVo.setDeleted(CommonConstant.DEL_FLAG_0);
            tenderBidLetterVo.setProcessType(TenderFlagInjectionContext.getTenderProcessType());
            tenderBidLetterVo.setCheckType(attachmentHead.getCheckType());
            if ("1".equals(attachmentHead.getCheckType()) && "1".equals(TenderFlagInjectionContext.getTenderProcessType())) {
                String formatType = tenderBidLetterVo.getFormatType();
                if (!PurchaseTenderBidLetterFormatTypeEnum.OTHER.getValue().equals(formatType)) {
                    tenderBidLetterVo.setCurrentStep(formatType);
                }
            }
            PurchaseTenderPriceOpeningsTemplate tenderPriceOpenings = tenderBidLetterVo.getPriceOpenings();
            tenderPriceOpenings.setSubpackageId(attachmentHead.getSubpackageId());
            tenderPriceOpenings.setTenderProjectId(attachmentHead.getTenderProjectId());
            tenderPriceOpenings.setHeadId(attachmentHead.getId());
            tenderPriceOpenings.setBidLetterId(tenderBidLetterVo.getId());
            tenderPriceOpenings.setDeleted(CommonConstant.DEL_FLAG_0);
            priceOpeningsList.add(tenderPriceOpenings);
            BeanUtils.copyProperties((Object)tenderBidLetterVo, (Object)((Object)tenderBidLetter));
            return tenderBidLetter;
        }).collect(Collectors.toList());
        this.purchaseTenderBidLetterService.saveBatch(tenderBidLetterList, 2000);
        this.purchaseTenderPriceOpeningsTemplateService.saveBatch(priceOpeningsList, 2000);
    }

    @Override
    public void updateTenderBidLetter(PurchaseTenderProjectAttachmentHead attachmentHead, PurchaseTenderBidLetterFormatGroupVO tenderBidLetterFormatGroupVo) {
        PurchaseTenderBidLetterFormatGroup purchaseTenderBidLetterFormatGroup = new PurchaseTenderBidLetterFormatGroup();
        BeanUtils.copyProperties((Object)((Object)tenderBidLetterFormatGroupVo), (Object)((Object)purchaseTenderBidLetterFormatGroup));
        this.updateById((Object)purchaseTenderBidLetterFormatGroup);
        List<PurchaseTenderBidLetterVO> tenderBidLetterVoList = tenderBidLetterFormatGroupVo.getTenderBidTetterVoList();
        ArrayList priceOpeningsList = new ArrayList(10);
        List tenderBidLetterList = tenderBidLetterVoList.stream().map(tenderBidLetterVo -> {
            PurchaseTenderBidLetter tenderBidLetter = new PurchaseTenderBidLetter();
            if (StringUtils.isEmpty((CharSequence)tenderBidLetter.getId())) {
                tenderBidLetter.setId(IdWorker.getIdStr());
            }
            BeanUtils.copyProperties((Object)tenderBidLetterVo, (Object)((Object)tenderBidLetter));
            PurchaseTenderPriceOpeningsTemplate tenderPriceOpenings = tenderBidLetterVo.getPriceOpenings();
            tenderPriceOpenings.setHeadId(attachmentHead.getId());
            tenderPriceOpenings.setBidLetterId(tenderBidLetter.getId());
            tenderPriceOpenings.setSubpackageId(tenderBidLetter.getSubpackageId());
            tenderPriceOpenings.setTenderProjectId(tenderBidLetter.getTenderProjectId());
            priceOpeningsList.add(tenderPriceOpenings);
            return tenderBidLetter;
        }).collect(Collectors.toList());
        this.purchaseTenderBidLetterService.deleteByMainId(attachmentHead.getSubpackageId());
        this.purchaseTenderPriceOpeningsTemplateService.deleteByMainId(attachmentHead.getSubpackageId());
        this.purchaseTenderBidLetterService.saveBatch(tenderBidLetterList, 2000);
        this.purchaseTenderPriceOpeningsTemplateService.saveBatch(priceOpeningsList, 2000);
    }

    @Override
    public PurchaseTenderBidLetterFormatGroupVO queryPurchaseTenderBidLetterFormatGroupVoInfo(PurchaseTenderProjectAttachmentHead purchaseTenderProjectAttachmentHead) {
        PurchaseTenderBidLetterFormatGroupVO groupVo = new PurchaseTenderBidLetterFormatGroupVO();
        List<PurchaseTenderBidLetterFormatGroup> purchaseTenderBidLetterFormatGroupList = ((PurchaseTenderBidLetterFormatGroupMapper)this.baseMapper).selectByMainId(purchaseTenderProjectAttachmentHead.getId());
        if (purchaseTenderBidLetterFormatGroupList.isEmpty()) {
            return groupVo;
        }
        PurchaseTenderBidLetterFormatGroup purchaseTenderBidLetterFormatGroup = purchaseTenderBidLetterFormatGroupList.get(0);
        BeanUtils.copyProperties((Object)((Object)purchaseTenderBidLetterFormatGroup), (Object)((Object)groupVo));
        List<PurchaseTenderBidLetter> PurchaseTenderBidLetters = this.purchaseTenderBidLetterService.selectByMainId(purchaseTenderBidLetterFormatGroup.getId());
        if (CollectionUtil.isEmpty(PurchaseTenderBidLetters)) {
            return groupVo;
        }
        List<String> bidLetterIds = PurchaseTenderBidLetters.stream().map(BaseEntity::getId).collect(Collectors.toList());
        List<PurchaseTenderPriceOpeningsTemplate> priceOpenings = this.purchaseTenderPriceOpeningsTemplateService.selectByMainIds(bidLetterIds);
        List<PurchaseTenderBidLetterVO> bidLetterVoList = PurchaseTenderBidLetters.stream().map(item -> {
            List priceOpeningsList;
            PurchaseTenderBidLetterVO itemVo = new PurchaseTenderBidLetterVO();
            BeanUtils.copyProperties((Object)item, (Object)((Object)itemVo));
            if (CollectionUtil.isNotEmpty((Collection)priceOpenings) && CollectionUtil.isNotEmpty(priceOpeningsList = priceOpenings.stream().filter(priceOpening -> item.getId().equals(priceOpening.getBidLetterId())).collect(Collectors.toList()))) {
                PurchaseTenderPriceOpeningsTemplate purchaseTenderPriceOpeningsTemplate = (PurchaseTenderPriceOpeningsTemplate)((Object)((Object)priceOpeningsList.get(0)));
                itemVo.setPriceOpenings(purchaseTenderPriceOpeningsTemplate);
                itemVo.setCustomizeFieldData(purchaseTenderPriceOpeningsTemplate.getCustomizeFieldData());
                itemVo.setCustomizeFieldModel(purchaseTenderPriceOpeningsTemplate.getCustomizeFieldModel());
            }
            return itemVo;
        }).collect(Collectors.toList());
        groupVo.setTenderBidTetterVoList(bidLetterVoList);
        return groupVo;
    }

    @Override
    public PurchaseTenderProjectAttachmentHeadViewVO queryBidLetterFormatGroup(String subpackageId) {
        PurchaseTenderProjectAttachmentHeadViewVO headViewVO = new PurchaseTenderProjectAttachmentHeadViewVO();
        PurchaseTenderProjectAttachmentHead attachmentHead = this.attachmentHeadService.getPurchaseTenderProjectAttachmentHandBySubpackageId(subpackageId);
        BeanUtils.copyProperties((Object)((Object)attachmentHead), (Object)((Object)headViewVO));
        PurchaseTenderBidLetterFormatGroupVO purchaseTenderBidLetterFormatGroupVO = this.queryPurchaseTenderBidLetterFormatGroupVoInfo(attachmentHead);
        headViewVO.setTenderBidLetterFormatGroupVo(purchaseTenderBidLetterFormatGroupVO);
        return headViewVO;
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void addBidLetterFormatGroup(PurchaseTenderProjectAttachmentHead purchaseTenderProjectAttachmentHead, PurchaseTenderBidLetterFormatGroupVO bidLetterFormatGroupVo) {
        this.attachmentHeadService.saveOrUpdate((Object)purchaseTenderProjectAttachmentHead);
        this.addTenderBidLetter(purchaseTenderProjectAttachmentHead, bidLetterFormatGroupVo);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void editBidLetterFormatGroup(PurchaseTenderProjectAttachmentHead purchaseTenderProjectAttachmentHead, PurchaseTenderBidLetterFormatGroupVO bidLetterFormatGroupVo) {
        this.attachmentHeadService.saveOrUpdate((Object)purchaseTenderProjectAttachmentHead);
        this.deleteByMainId(purchaseTenderProjectAttachmentHead.getSubpackageId());
        this.purchaseTenderBidLetterService.deleteByMainId(purchaseTenderProjectAttachmentHead.getSubpackageId());
        this.purchaseTenderPriceOpeningsTemplateService.deleteByMainId(purchaseTenderProjectAttachmentHead.getSubpackageId());
        this.addTenderBidLetter(purchaseTenderProjectAttachmentHead, bidLetterFormatGroupVo);
    }
}

