/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.tender.calibration.adapter;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.els.aspect.DictAspect;
import com.els.common.api.vo.Result;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.system.vo.MsgParamsVO;
import com.els.common.util.MqUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.ElsSubAccountDTO;
import com.els.modules.tender.calibration.entity.BidWinningCandidatePublicity;
import com.els.modules.tender.calibration.service.BidWinningCandidatePublicityService;
import com.els.modules.workflow.dto.AuditInputParamDTO;
import com.els.modules.workflow.dto.AuditOutputParamDTO;
import com.els.modules.workflow.enums.WorkFlowType;
import com.els.modules.workflow.rpc.service.AuditOptCallBackService;
import com.els.rpc.service.InvokeAccountRpcService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="bidWinningCandidatePublicityAdapter")
public class BidWinningCandidatePublicityAdapter
implements AuditOptCallBackService {
    private static final Logger log = LoggerFactory.getLogger(BidWinningCandidatePublicityAdapter.class);
    @Resource
    private BidWinningCandidatePublicityService bidWinningCandidatePublicityService;
    @Resource
    private InvokeAccountRpcService invokeAccountRpcService;

    public void startCallBack(AuditInputParamDTO inputParamDTO, AuditOutputParamDTO outputParamDTO) {
        this.updateAuditStatus(inputParamDTO, outputParamDTO);
        String operataion = "submitAudit";
        if (WorkFlowType.BPMN.getValue().equals(outputParamDTO.getBpmnType())) {
            operataion = outputParamDTO.getBpmnType() + "_" + "submitAudit";
        }
        this.sendMsg(inputParamDTO, outputParamDTO, operataion);
    }

    private void updateAuditStatus(AuditInputParamDTO inputParamDTO, AuditOutputParamDTO outputParamDTO) {
        this.bidWinningCandidatePublicityService.updateAuditStatus(inputParamDTO.getBusinessId(), outputParamDTO.getProcessRootId(), outputParamDTO.getAuditStatus(), outputParamDTO.getBpmnType());
    }

    public void completeCallBack(AuditInputParamDTO inputParamDTO, AuditOutputParamDTO outputParamDTO) {
        log.info("\u4e2d\u6807\u5019\u9009\u4eba\u516c\u793a\u5ba1\u6279\u53c2\u6570:{}", JSON.toJSON((Object)inputParamDTO));
        log.info("\u4e2d\u6807\u5019\u9009\u4eba\u516c\u793a\u8f93\u51fa\u53c2\u6570:{}", JSON.toJSON((Object)outputParamDTO));
        this.updateAuditStatus(inputParamDTO, outputParamDTO);
        if (AuditStatusEnum.AUDIT_FINISH.getValue().equals(outputParamDTO.getAuditStatus())) {
            BidWinningCandidatePublicity bidWinningCandidatePublicity = (BidWinningCandidatePublicity)((Object)JSON.parseObject((String)inputParamDTO.getParams(), BidWinningCandidatePublicity.class));
            this.bidWinningCandidatePublicityService.publish(bidWinningCandidatePublicity);
            this.sendMsg(inputParamDTO, outputParamDTO, "auditPass");
        } else {
            this.sendMsg(inputParamDTO, outputParamDTO, "submitAudit");
        }
    }

    public void rejectCallBack(AuditInputParamDTO inputParamDTO, AuditOutputParamDTO outputParamDTO) {
        this.updateAuditStatus(inputParamDTO, outputParamDTO);
        this.sendMsg(inputParamDTO, outputParamDTO, "auditReject");
    }

    public void cancelCallBack(AuditInputParamDTO inputParamDTO, AuditOutputParamDTO outputParamDTO) {
        this.updateAuditStatus(inputParamDTO, outputParamDTO);
    }

    private void sendMsg(AuditInputParamDTO inputParamDTO, AuditOutputParamDTO outputParamDTO, String optType) {
        String elsAccount = TenantContext.getTenant();
        if (AuditStatusEnum.AUDIT_FINISH.getValue().equals(outputParamDTO.getAuditStatus())) {
            MsgParamsVO msgParamsVO = this.parameterAssemble(inputParamDTO, outputParamDTO, outputParamDTO.getSubmitUser());
            MqUtil.sendBusMsg((String)elsAccount, (String)inputParamDTO.getBusinessType(), (String)optType, (MsgParamsVO)msgParamsVO);
        } else {
            List accountList = outputParamDTO.getNextAuditUserList();
            for (String account : accountList) {
                MsgParamsVO msgParamsVO = this.parameterAssemble(inputParamDTO, outputParamDTO, account);
                MqUtil.sendBusMsg((String)elsAccount, (String)inputParamDTO.getBusinessType(), (String)optType, (MsgParamsVO)msgParamsVO);
            }
        }
    }

    private MsgParamsVO parameterAssemble(AuditInputParamDTO inputParamDTO, AuditOutputParamDTO outputParamDTO, String account) {
        MsgParamsVO msgParamsVO = new MsgParamsVO();
        ArrayList<ElsSubAccountDTO> accountList = new ArrayList<ElsSubAccountDTO>();
        HashMap<String, ArrayList<ElsSubAccountDTO>> receiverMap = new HashMap<String, ArrayList<ElsSubAccountDTO>>();
        ElsSubAccountDTO subAccount = this.invokeAccountRpcService.getAccount(TenantContext.getTenant(), account.split("_")[1]);
        accountList.add(subAccount);
        receiverMap.put(TenantContext.getTenant(), accountList);
        msgParamsVO.setReceiverMap(receiverMap);
        String businessType = inputParamDTO.getBusinessType();
        String flowId = outputParamDTO.getProcessRootId();
        String headId = inputParamDTO.getBusinessId();
        String outAuditPassUrl = SysUtil.getOutAuditPassUrl((ElsSubAccountDTO)subAccount, (String)flowId, (String)businessType, (String)headId);
        String outAuditRejectUrl = SysUtil.getOutAuditRejectUrl((ElsSubAccountDTO)subAccount, (String)flowId, (String)businessType, (String)headId);
        BidWinningCandidatePublicity bidWinningCandidatePublicity = (BidWinningCandidatePublicity)((Object)this.bidWinningCandidatePublicityService.getById((Serializable)((Object)headId)));
        Result result = Result.ok((Object)((Object)bidWinningCandidatePublicity));
        DictAspect dictAspect = (DictAspect)SpringContextUtils.getBean(DictAspect.class);
        dictAspect.parseDictText((Object)result);
        JSONObject jsonObject = (JSONObject)result.getResult();
        Map paramMap = (Map)JSON.parse((String)jsonObject.toString());
        paramMap.put("userName", subAccount.getRealname());
        paramMap.put("outAuditPassUrl", outAuditPassUrl);
        paramMap.put("outAuditRejectUrl", outAuditRejectUrl);
        msgParamsVO.setParams((Object)paramMap);
        HashMap<String, JSONObject> receiveParamMap = new HashMap<String, JSONObject>();
        JSONObject paramObj = new JSONObject();
        paramObj.put("businessId", (Object)inputParamDTO.getBusinessId());
        paramObj.put("businessType", (Object)inputParamDTO.getBusinessType());
        if (account.split("_").length > 2) {
            paramObj.put("taskId", (Object)account.split("_")[2]);
        }
        if (account.split("_").length > 3) {
            paramObj.put("processInstanceId", (Object)account.split("_")[3]);
        }
        receiveParamMap.put(TenantContext.getTenant(), paramObj);
        msgParamsVO.setReceiveParamMap(receiveParamMap);
        return msgParamsVO;
    }
}

