/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.tender.evaluation.service.impl;

import cn.hutool.core.collection.CollUtil;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.common.util.SpringContextUtils;
import com.els.modules.tender.attachment.entity.PurchaseTenderEvaluationGroup;
import com.els.modules.tender.attachment.entity.PurchaseTenderEvaluationPrinciples;
import com.els.modules.tender.attachment.service.PurchaseTenderEvaluationGroupService;
import com.els.modules.tender.attachment.service.PurchaseTenderEvaluationPrinciplesService;
import com.els.modules.tender.evaluation.entity.PurchaseTenderProjectBidEvaRegulationResult;
import com.els.modules.tender.evaluation.enumerate.TenderEvaGroupTypeEnum;
import com.els.modules.tender.evaluation.mapper.PurchaseTenderProjectBidEvaRegulationResultMapper;
import com.els.modules.tender.evaluation.service.PurchaseTenderProjectBidEvaRegulationResultService;
import com.els.modules.tender.evaluation.strategy.review.SummaryStrategy;
import com.els.modules.tender.evaluation.vo.SupplierEvaRankingVO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class PurchaseTenderProjectBidEvaRegulationResultServiceImpl
extends BaseServiceImpl<PurchaseTenderProjectBidEvaRegulationResultMapper, PurchaseTenderProjectBidEvaRegulationResult>
implements PurchaseTenderProjectBidEvaRegulationResultService {
    @Autowired
    private PurchaseTenderEvaluationGroupService evaluationGroupService;
    @Autowired
    private PurchaseTenderEvaluationPrinciplesService principlesService;

    @Override
    public List<PurchaseTenderProjectBidEvaRegulationResult> selectBySubpackageId(String subpackageId, String evaGroupId) {
        return ((PurchaseTenderProjectBidEvaRegulationResultMapper)this.baseMapper).selectBySubpackageId(subpackageId, evaGroupId);
    }

    @Override
    public void deleteByGroupIdAndJudgesAccount(String evaGroupId, String judgesElsAccount, String judgesElsSubAccount) {
        ((PurchaseTenderProjectBidEvaRegulationResultMapper)this.baseMapper).deleteByGroupIdAndJudgesAccount(evaGroupId, judgesElsAccount, judgesElsSubAccount);
    }

    @Override
    public void deleteByMainId(String evaGroupId, String judgesTaskItemId) {
        ((PurchaseTenderProjectBidEvaRegulationResultMapper)this.baseMapper).deleteByMainId(evaGroupId, judgesTaskItemId);
    }

    @Override
    public List<PurchaseTenderProjectBidEvaRegulationResult> selectByMainId(String judgesTaskItemId, String evaGroupId) {
        return ((PurchaseTenderProjectBidEvaRegulationResultMapper)this.baseMapper).selectByMainId(judgesTaskItemId, evaGroupId);
    }

    @Override
    public List<PurchaseTenderProjectBidEvaRegulationResult> querySupplierByEvaGroupId(String supplierAccount, String evaGroupId, String subpackageId) {
        return ((PurchaseTenderProjectBidEvaRegulationResultMapper)this.baseMapper).querySupplierByEvaGroupId(supplierAccount, evaGroupId, subpackageId);
    }

    @Override
    public List<SupplierEvaRankingVO> summaryEvaResult(String subpackageId, String evaGroupId) {
        ArrayList<SupplierEvaRankingVO> result = new ArrayList<SupplierEvaRankingVO>();
        List<PurchaseTenderEvaluationGroup> evaluationGroupList = this.evaluationGroupService.queryEvaGroupBySubpackageId(subpackageId);
        Assert.isTrue((boolean)CollUtil.isNotEmpty(evaluationGroupList), (String)I18nUtil.translate((String)"i18n_alert_TvVVHLVWVImW_4c384209", (String)"\u6761\u4f8b\u7ec4\u4fe1\u606f\u4e3a\u7a7a,\u8bf7\u68c0\u67e5!"));
        PurchaseTenderEvaluationPrinciples purchaseTenderEvaluationPrinciples = this.principlesService.queryPurchaseTenderEvaluationPrinciples(evaluationGroupList.get(0).getHeadId());
        Map evaluationGroupMap = evaluationGroupList.parallelStream().collect(Collectors.toMap(BaseEntity::getId, Function.identity()));
        List<PurchaseTenderProjectBidEvaRegulationResult> regulationResultList = this.selectBySubpackageId(subpackageId, evaGroupId);
        Map<String, List<PurchaseTenderProjectBidEvaRegulationResult>> supplierAccountMap = regulationResultList.parallelStream().collect(Collectors.groupingBy(PurchaseTenderProjectBidEvaRegulationResult::getSupplierAccount));
        for (String supplierAccount : supplierAccountMap.keySet()) {
            List<PurchaseTenderProjectBidEvaRegulationResult> supplierAllRegulationResultList = supplierAccountMap.get(supplierAccount);
            SupplierEvaRankingVO supplierEvaRankingVO = new SupplierEvaRankingVO();
            BeanUtils.copyProperties((Object)((Object)supplierAllRegulationResultList.get(0)), (Object)supplierEvaRankingVO);
            Map<String, List<PurchaseTenderProjectBidEvaRegulationResult>> evaGroupAllRegulationResultMap = supplierAllRegulationResultList.parallelStream().collect(Collectors.groupingBy(PurchaseTenderProjectBidEvaRegulationResult::getEvaGroupId));
            for (String groupId : evaGroupAllRegulationResultMap.keySet()) {
                PurchaseTenderEvaluationGroup evaluationGroup = (PurchaseTenderEvaluationGroup)((Object)evaluationGroupMap.get(groupId));
                List<PurchaseTenderProjectBidEvaRegulationResult> evaRegulationResultList = evaGroupAllRegulationResultMap.get(groupId);
                SummaryStrategy summaryStrategy = (SummaryStrategy)SpringContextUtils.getBean((String)TenderEvaGroupTypeEnum.getTenderEvaGroupTypeEnum(evaluationGroup.getGroupType()).getBeanName(), SummaryStrategy.class);
                SupplierEvaRankingVO.EvaGroupSummaryResult summaryResult = summaryStrategy.summaryResult(evaluationGroup, purchaseTenderEvaluationPrinciples, evaRegulationResultList);
                supplierEvaRankingVO.setGroupOrder(evaluationGroup.getOrderBy());
                supplierEvaRankingVO.setResultMap(groupId, summaryResult);
            }
            Map<String, SupplierEvaRankingVO.EvaGroupSummaryResult> groupResultMap = supplierEvaRankingVO.getResult();
            BigDecimal totalScore = BigDecimal.ZERO;
            for (String key : groupResultMap.keySet()) {
                SupplierEvaRankingVO.EvaGroupSummaryResult summaryResult = groupResultMap.get(key);
                supplierEvaRankingVO.setInvalid(summaryResult.getInvalid());
                if ("1".equals(summaryResult.getInvalid())) break;
                totalScore = totalScore.add(summaryResult.getTotalScore() == null ? BigDecimal.ZERO : summaryResult.getTotalScore());
            }
            supplierEvaRankingVO.setTotalScore(totalScore);
            result.add(supplierEvaRankingVO);
        }
        return result;
    }
}

