/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.bidding.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.I18nUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.AttachmentSendDTO;
import com.els.modules.base.api.dto.ElsInitialTableDTO;
import com.els.modules.base.api.dto.PurchaseAttachmentDTO;
import com.els.modules.base.api.dto.PurchaseAttachmentDemandDTO;
import com.els.modules.base.api.dto.SaleAttachmentDTO;
import com.els.modules.bidding.entity.BiddingSupplier;
import com.els.modules.bidding.entity.PurchaseBiddingHead;
import com.els.modules.bidding.entity.PurchaseBiddingItem;
import com.els.modules.bidding.enumerate.StageTypeEnum;
import com.els.modules.bidding.mapper.BiddingSupplierMapper;
import com.els.modules.bidding.mapper.PurchaseBiddingHeadMapper;
import com.els.modules.bidding.service.PurchaseBiddingHeadService;
import com.els.modules.bidding.service.impl.PurchaseBiddingHeadServiceImpl;
import com.els.modules.bidding.vo.PurchaseBiddingHeadVO;
import com.els.modules.inquiry.enumerate.QualificationReviewEnum;
import com.els.modules.inquiry.qualification.entity.PurchaseQualificationReview;
import com.els.modules.inquiry.qualification.enumerate.SourceTypeEnum;
import com.els.modules.inquiry.qualification.service.PurchaseQualificationReviewService;
import com.els.modules.inquiry.rpc.service.InquiryInvokeSupplierRpcService;
import com.els.modules.inquiry.service.PublicInquiryService;
import com.els.modules.inquiry.vo.PublicInquiryVO;
import com.els.modules.supplier.api.dto.SupplierMasterDataDTO;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class PublicBiddingServiceImpl
extends BaseServiceImpl<PurchaseBiddingHeadMapper, PurchaseBiddingHead>
implements PublicInquiryService {
    @Autowired
    private PurchaseQualificationReviewService reviewService;
    @Autowired
    private BiddingSupplierMapper biddingSupplierMapper;
    @Resource
    private InquiryInvokeSupplierRpcService inquiryInvokeSupplierRpcService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;

    @Override
    public Result<?> getPublicResult(String headId) {
        PurchaseBiddingHead dbHead = (PurchaseBiddingHead)((Object)this.getById((Serializable)((Object)headId)));
        PurchaseBiddingHeadVO headVO = new PurchaseBiddingHeadVO();
        String supplierAccount = TenantContext.getTenant();
        BeanUtils.copyProperties((Object)((Object)dbHead), (Object)((Object)headVO));
        ElsInitialTableDTO initInfo = this.invokeBaseRpcService.selectElsInitialTableOne(headId);
        List initItemList = JSON.parseArray((String)initInfo.getBusinessInfoJson(), PurchaseBiddingItem.class);
        headVO.setInitItemList(initItemList);
        headVO.setPurchaseAttachmentDemandList(this.invokeBaseRpcService.selectPurchaseAttachmentDemandByMainId(headId));
        List<PurchaseAttachmentDTO> collect = this.invokeBaseRpcService.selectPurchaseAttachmentByMainId(headId).stream().filter(x -> x.getUploadElsAccount().equals(supplierAccount)).collect(Collectors.toList());
        headVO.setPurchaseAttachmentList(collect);
        return Result.ok((Object)((Object)headVO));
    }

    @Override
    @SrmTransaction
    public void apply(PublicInquiryVO inquiryVO) {
        String headId = inquiryVO.getId();
        PurchaseBiddingHead dbHead = (PurchaseBiddingHead)((Object)this.getById((Serializable)((Object)headId)));
        Date applyEndTime = dbHead.getApplyEndTime();
        Assert.isTrue((applyEndTime != null && applyEndTime.after(new Date()) ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_fail_registration_time_time_out", (String)"\u62a5\u540d\u622a\u6b62\u65f6\u95f4\u5df2\u8fc7\uff0c\u4e0d\u53ef\u62a5\u540d"));
        String supplierAccount = TenantContext.getTenant();
        List demandList = this.invokeBaseRpcService.selectPurchaseAttachmentDemandByMainId(headId).stream().filter(demand -> "1".equals(demand.getRequired())).filter(demand -> StageTypeEnum.APPLY.getValue().equals(demand.getStageType())).collect(Collectors.toList());
        List<SaleAttachmentDTO> saleAttachmentList = this.invokeBaseRpcService.selectSaleAttachmentByMainId(dbHead.getId()).stream().filter(attachment -> attachment.getUploadElsAccount().equals(supplierAccount)).collect(Collectors.toList());
        Map<String, List<SaleAttachmentDTO>> checkMap = saleAttachmentList.stream().filter(o -> StrUtil.isNotBlank((CharSequence)o.getFileType())).collect(Collectors.groupingBy(SaleAttachmentDTO::getFileType));
        for (PurchaseAttachmentDemandDTO demand2 : demandList) {
            if (checkMap.containsKey(demand2.getFileType())) continue;
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_fail_must_upload_file", (String)"\u8bf7\u6309\u7167\u8981\u6c42\u4e0a\u4f20\u5bf9\u5e94\u7c7b\u578b\u7684\u6587\u4ef6\uff01"));
        }
        List reviewList = this.reviewService.selectByMainId(headId).stream().filter(o -> supplierAccount.equals(o.getToElsAccount())).collect(Collectors.toList());
        Assert.isTrue((boolean)CollectionUtil.isEmpty(reviewList), (String)I18nUtil.translate((String)"i18n_alert_IqPVsUvmYBSJRUJIeRWSTsRW_c7bde32b", (String)"\u5df2\u88ab\u9080\u8bf7\u53c2\u4e0e\u672c\u6b21\u62db\u6807\u6216\u8d44\u8d28\u5ba1\u67e5\u5df2\u901a\u8fc7\uff0c\u65e0\u9700\u62a5\u540d!"));
        List<BiddingSupplier> biddingSupplierList = this.biddingSupplierMapper.selectByMainId(headId);
        List list = biddingSupplierList.stream().map(BiddingSupplier::getToElsAccount).collect(Collectors.toList());
        if (list.contains(supplierAccount)) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_oper_no_registration_bidding", (String)"\u5df2\u7ecf\u88ab\u9080\u8bf7\u53c2\u4e0e\u672c\u6b21\u62db\u6807\uff0c\u65e0\u987b\u62a5\u540d\uff01"));
        }
        Assert.isTrue((!dbHead.getElsAccount().equals(supplierAccount) ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_mdIhxtLUAPeyAEVHIRWxiTsu_b780cc07", (String)"\u6b64\u9879\u76ee\u53d1\u5e03\u5355\u4f4d\u4e0e\u5f53\u524d\u8d26\u53f7\u4f01\u4e1a\u4fe1\u606f\u4e00\u81f4\uff0c\u4e0d\u5141\u8bb8\u53c2\u52a0"));
        SupplierMasterDataDTO masterData = this.inquiryInvokeSupplierRpcService.getByAccount(dbHead.getElsAccount(), supplierAccount);
        if (masterData == null) {
            masterData = this.inquiryInvokeSupplierRpcService.addUnfamiliarSupplier(supplierAccount);
        }
        LoginUser user = SysUtil.getLoginUser();
        PurchaseQualificationReview review = new PurchaseQualificationReview();
        review.setElsAccount(dbHead.getElsAccount());
        review.setRelationId(dbHead.getId());
        review.setSupplierQualification(dbHead.getSupplierQualification());
        review.setToElsAccount(supplierAccount);
        review.setSupplierCode(masterData.getSupplierCode());
        review.setSupplierId(masterData.getId());
        review.setSupplierName(masterData.getSupplierName());
        review.setBidder(user.getSubAccount() + "_" + user.getRealname());
        review.setSourceType(SourceTypeEnum.BIDDING.getValue());
        review.setSourceNumber(dbHead.getBiddingNumber());
        review.setContacts(inquiryVO.getContacts());
        review.setPhone(inquiryVO.getPhone());
        review.setEmail(inquiryVO.getEmail());
        review.setAddress(inquiryVO.getAddress());
        review.setReviewTime(applyEndTime);
        this.reviewService.add(review);
        saleAttachmentList.forEach(attachment -> attachment.setHeadId(review.getId()));
        this.invokeBaseRpcService.updateSaleAttachmentBatchById(saleAttachmentList);
        this.invokeBaseRpcService.deleteSaleAttachmentByMainId(review.getId());
        ArrayList purchaseAttachmentList = SysUtil.copyProperties(saleAttachmentList, PurchaseAttachmentDTO.class);
        purchaseAttachmentList.forEach(attachment -> {
            attachment.setId(null);
            attachment.setHeadId(review.getId());
            attachment.setBusinessType("qualification");
        });
        this.invokeBaseRpcService.insertPurchaseAttachmentBatchSomeColumn((List)purchaseAttachmentList);
        AttachmentSendDTO sendVO = new AttachmentSendDTO();
        sendVO.setHeadId(dbHead.getId());
        sendVO.setElsAccount(supplierAccount);
        ConcurrentHashMap<String, String> toSend = new ConcurrentHashMap<String, String>();
        toSend.put(dbHead.getId(), dbHead.getElsAccount());
        sendVO.setToSend(toSend);
        this.invokeBaseRpcService.sendSaleFile(sendVO);
        if (QualificationReviewEnum.BEFORE_QUOTE.getValue().equals(dbHead.getQualificationReview())) {
            PurchaseBiddingHeadService purchaseBiddingHeadService = (PurchaseBiddingHeadService)SpringContextUtils.getBean(PurchaseBiddingHeadServiceImpl.class);
            purchaseBiddingHeadService.executeReview(dbHead, review);
        }
        String url = "id=" + review.getId();
        super.sendMsg(TenantContext.getTenant(), review.getElsAccount(), (Object)review, url, "bidding", "check");
    }
}

