/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.bidding.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.els.api.dto.BaseDTO;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.constant.CommonConstant;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.PurchaseAttachmentDTO;
import com.els.modules.base.api.dto.SaleAttachmentDTO;
import com.els.modules.bidding.entity.PurchaseMentoringHead;
import com.els.modules.bidding.entity.PurchaseMentoringItem;
import com.els.modules.bidding.entity.SaleMentoringHead;
import com.els.modules.bidding.entity.SaleMentoringItem;
import com.els.modules.bidding.enumerate.MentoringObjectEnum;
import com.els.modules.bidding.mapper.PurchaseMentoringHeadMapper;
import com.els.modules.bidding.mapper.PurchaseMentoringItemMapper;
import com.els.modules.bidding.mapper.SaleMentoringHeadMapper;
import com.els.modules.bidding.mapper.SaleMentoringItemMapper;
import com.els.modules.bidding.service.PurchaseMentoringHeadService;
import com.els.modules.bidding.service.PurchaseMentoringItemService;
import com.els.modules.bidding.service.SendToSupplierService;
import com.els.modules.bidding.service.impl.SendToSupplierServiceFactory;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class PurchaseMentoringHeadServiceImpl
extends BaseServiceImpl<PurchaseMentoringHeadMapper, PurchaseMentoringHead>
implements PurchaseMentoringHeadService {
    private static final Logger log = LoggerFactory.getLogger(PurchaseMentoringHeadServiceImpl.class);
    @Autowired
    private PurchaseMentoringHeadMapper purchaseMentoringHeadMapper;
    @Autowired
    private PurchaseMentoringItemMapper purchaseMentoringItemMapper;
    @Autowired
    private SaleMentoringHeadMapper saleMentoringHeadMapper;
    @Autowired
    private SaleMentoringItemMapper saleMentoringItemMapper;
    @Autowired
    private PurchaseMentoringItemService purchaseMentoringItemService;
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void saveMain(PurchaseMentoringHead purchaseMentoringHead, List<PurchaseMentoringItem> purchaseMentoringItemList, List<PurchaseAttachmentDTO> attachments) {
        this.purchaseMentoringHeadMapper.insert((Object)purchaseMentoringHead);
        this.insertData(purchaseMentoringHead, purchaseMentoringItemList, attachments);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void updateMain(PurchaseMentoringHead purchaseMentoringHead, List<PurchaseMentoringItem> purchaseMentoringItemList, List<PurchaseAttachmentDTO> attachments) {
        int count = this.purchaseMentoringHeadMapper.updateById((Object)purchaseMentoringHead);
        if (count == 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539"));
        }
        this.purchaseMentoringItemMapper.deleteByMainId(purchaseMentoringHead.getId());
        if (attachments != null && attachments.size() > 0) {
            this.invokeBaseRpcService.deletePurchaseAttachmentByMainIdAndBusinessType(purchaseMentoringHead.getId(), "purchase_mentoring");
        }
        this.insertData(purchaseMentoringHead, purchaseMentoringItemList, attachments);
    }

    private void insertData(PurchaseMentoringHead purchaseMentoringHead, List<PurchaseMentoringItem> purchaseMentoringItemList, List<PurchaseAttachmentDTO> attachments) {
        if (!CollectionUtils.isEmpty(purchaseMentoringItemList)) {
            for (PurchaseMentoringItem entity : purchaseMentoringItemList) {
                entity.setHeadId(purchaseMentoringHead.getId());
                SysUtil.setSysParam((BaseEntity)entity, (BaseEntity)purchaseMentoringHead);
            }
            this.purchaseMentoringItemService.saveBatch(purchaseMentoringItemList, 2000);
        }
        if (CollectionUtils.isEmpty(attachments)) {
            return;
        }
        for (PurchaseAttachmentDTO attachment : attachments) {
            attachment.setHeadId(purchaseMentoringHead.getId());
            attachment.setBusinessType("purchase_mentoring");
            SysUtil.setSysParam((BaseDTO)attachment, (BaseEntity)purchaseMentoringHead);
            attachment.setId(null);
        }
        this.invokeBaseRpcService.insertPurchaseAttachmentBatchSomeColumn(attachments);
    }

    @Override
    public void publish(PurchaseMentoringHead head, List<PurchaseMentoringItem> purchaseMentoringItemList, List<PurchaseAttachmentDTO> attachments, PurchaseMentoringItem item) {
        head.setMentoringTimes(head.getMentoringTimes() == null ? 1 : head.getMentoringTimes() + 1);
        this.purchaseMentoringHeadMapper.updateById((Object)head);
        this.savePurchaseMentoringItem(head, item);
        SaleMentoringHead saleMentoringHead = (SaleMentoringHead)((Object)this.saleMentoringHeadMapper.selectById((Serializable)((Object)head.getRelationId())));
        if (MentoringObjectEnum.QUESTIONER.getValue().equals(head.getMentoringObject()) && saleMentoringHead != null) {
            this.updateSaleMentoring(head, item, saleMentoringHead);
            String url = "id=" + head.getRelationId();
            super.sendMsg(TenantContext.getTenant(), head.getToElsAccount(), (Object)head, url, "mentoring", "reply");
            return;
        }
        SendToSupplierService send = SendToSupplierServiceFactory.getbusinessTypeService(head.getBusinessType());
        Map<String, String> suppliers = send.handleSupplier(head);
        if (CollectionUtils.isEmpty(suppliers)) {
            return;
        }
        this.sendToSupplier(head, item, attachments, suppliers);
    }

    private void savePurchaseMentoringItem(PurchaseMentoringHead head, PurchaseMentoringItem item) {
        if (StringUtils.isNotBlank((CharSequence)item.getId())) {
            item.setAnswerStatus("1");
            this.purchaseMentoringItemMapper.updateById((Object)item);
            return;
        }
        item.setHeadId(head.getId());
        SysUtil.setSysParam((BaseEntity)item, (BaseEntity)head);
        item.setDeleted(CommonConstant.DEL_FLAG_0);
        item.setAnswerStatus("1");
        item.setElsAccount(head.getElsAccount());
        item.setToElsAccount(head.getToElsAccount());
        this.purchaseMentoringItemMapper.insert((Object)item);
    }

    public void updateSaleMentoring(PurchaseMentoringHead purchaseMentoringHead, PurchaseMentoringItem purchaseMentoringItem, SaleMentoringHead saleMentoringHead) {
        SaleMentoringItem item = new SaleMentoringItem();
        BeanUtils.copyProperties((Object)((Object)purchaseMentoringItem), (Object)((Object)item));
        item.setId(null);
        item.setRelationId(purchaseMentoringItem.getId());
        item.setHeadId(saleMentoringHead.getId());
        item.setElsAccount(saleMentoringHead.getElsAccount());
        item.setToElsAccount(saleMentoringHead.getToElsAccount());
        item.setViewStatus("0");
        this.saleMentoringItemMapper.insert((Object)item);
        if (StringUtils.isBlank((CharSequence)saleMentoringHead.getRelationId())) {
            saleMentoringHead.setRelationId(purchaseMentoringHead.getId());
        }
        saleMentoringHead.setMentoringTimes(purchaseMentoringHead.getMentoringTimes());
        if (saleMentoringHead.getUnreadTimes() == null) {
            saleMentoringHead.setUnreadTimes(1);
        } else {
            saleMentoringHead.setUnreadTimes(saleMentoringHead.getUnreadTimes() + 1);
        }
        this.saleMentoringHeadMapper.updateById((Object)saleMentoringHead);
    }

    public void updateSaleMentoring(PurchaseMentoringHead purchaseMentoringHead, List<PurchaseMentoringItem> purchaseMentoringItems, SaleMentoringHead saleMentoringHead) {
        ArrayList saleMentoringItems = new ArrayList();
        purchaseMentoringItems.forEach(purchaseMentoringItem -> {
            SaleMentoringItem item = new SaleMentoringItem();
            BeanUtils.copyProperties((Object)purchaseMentoringItem, (Object)((Object)item));
            item.setId(null);
            item.setRelationId(purchaseMentoringItem.getId());
            item.setHeadId(purchaseMentoringHead.getRelationId());
            item.setElsAccount(purchaseMentoringHead.getToElsAccount());
            item.setToElsAccount(purchaseMentoringHead.getElsAccount());
            item.setViewStatus("0");
            saleMentoringItems.add(item);
        });
        this.saleMentoringItemMapper.insertBatchSomeColumn(saleMentoringItems);
        if (StringUtils.isBlank((CharSequence)saleMentoringHead.getRelationId())) {
            saleMentoringHead.setRelationId(purchaseMentoringHead.getId());
        }
        saleMentoringHead.setMentoringTimes(purchaseMentoringHead.getMentoringTimes());
        if (saleMentoringHead.getUnreadTimes() == null) {
            saleMentoringHead.setUnreadTimes(1);
        } else {
            saleMentoringHead.setUnreadTimes(saleMentoringHead.getUnreadTimes() + 1);
        }
        this.saleMentoringHeadMapper.updateById((Object)saleMentoringHead);
    }

    public void sendToSupplier(PurchaseMentoringHead purchaseMentoringHead, PurchaseMentoringItem purchaseMentoringItem, List<PurchaseAttachmentDTO> attachments, Map<String, String> suppliers) {
        if (suppliers != null && suppliers.size() > 0) {
            Set<String> toElsAccounts = suppliers.keySet();
            ArrayList<String> recevieAccountList = new ArrayList<String>(toElsAccounts);
            this.saveSaleMentoring(purchaseMentoringHead, purchaseMentoringItem, recevieAccountList, suppliers, attachments);
            String url = "id=" + purchaseMentoringHead.getRelationId();
            super.sendMsg(TenantContext.getTenant(), recevieAccountList, (Object)purchaseMentoringHead, url, "mentoring", "reply");
        }
    }

    public void saveSaleMentoring(PurchaseMentoringHead purchaseMentoringHead, PurchaseMentoringItem purchaseMentoringItem, List<String> toELsAccountList, Map<String, String> suppliers, List<PurchaseAttachmentDTO> attachments) {
        SaleMentoringHead mentoringHead = (SaleMentoringHead)((Object)this.saleMentoringHeadMapper.selectById((Serializable)((Object)purchaseMentoringHead.getRelationId())));
        if (mentoringHead != null && toELsAccountList.contains(mentoringHead.getElsAccount())) {
            this.updateSaleMentoring(purchaseMentoringHead, purchaseMentoringItem, mentoringHead);
            toELsAccountList.remove(mentoringHead.getElsAccount());
        }
        this.updateOtherSaleMentoringHeadList(purchaseMentoringHead, purchaseMentoringItem, toELsAccountList);
        if (CollectionUtils.isEmpty(toELsAccountList)) {
            return;
        }
        log.info("toELsAccountList:{}", (Object)JSONObject.toJSONString(toELsAccountList));
        ArrayList saleMentoringHeads = new ArrayList();
        toELsAccountList.forEach(toELsAccount -> {
            SaleMentoringHead addMentoringHead = new SaleMentoringHead();
            BeanUtils.copyProperties((Object)((Object)purchaseMentoringHead), (Object)((Object)addMentoringHead));
            addMentoringHead.setId(null);
            addMentoringHead.setElsAccount((String)toELsAccount);
            addMentoringHead.setToElsAccount(purchaseMentoringHead.getElsAccount());
            addMentoringHead.setSupplierName((String)suppliers.get(toELsAccount));
            addMentoringHead.setRelationId(purchaseMentoringHead.getId());
            addMentoringHead.setUnreadTimes(1);
            saleMentoringHeads.add(addMentoringHead);
        });
        this.saleMentoringHeadMapper.insertBatchSomeColumn(saleMentoringHeads);
        ArrayList itemList = new ArrayList();
        saleMentoringHeads.forEach(e -> {
            SaleMentoringItem item = this.handleSaleMentoringItem((SaleMentoringHead)((Object)e), purchaseMentoringItem);
            itemList.add(item);
            this.saveSaleAttachments(attachments, (SaleMentoringHead)((Object)e));
        });
        this.saleMentoringItemMapper.insertBatchSomeColumn(itemList);
    }

    private void updateOtherSaleMentoringHeadList(PurchaseMentoringHead purchaseMentoringHead, PurchaseMentoringItem purchaseMentoringItem, List<String> toELsAccountList) {
        List<SaleMentoringHead> saleMentoringHeadList = this.saleMentoringHeadMapper.selectWithoutElsAccountSaleMentoringList(purchaseMentoringHead);
        log.info("saleMentoringHeadList:{}, getRelationId:{}, getId:{}", new Object[]{JSONObject.toJSONString(saleMentoringHeadList), purchaseMentoringHead.getId(), purchaseMentoringHead.getRelationId()});
        if (CollectionUtils.isEmpty(saleMentoringHeadList)) {
            return;
        }
        saleMentoringHeadList.forEach(saleMentoringHead -> {
            this.updateSaleMentoring(purchaseMentoringHead, purchaseMentoringItem, (SaleMentoringHead)((Object)saleMentoringHead));
            toELsAccountList.remove(saleMentoringHead.getElsAccount());
        });
    }

    private void saveSaleAttachments(List<PurchaseAttachmentDTO> attachments, SaleMentoringHead mentoringHead) {
        if (CollectionUtils.isEmpty(attachments)) {
            return;
        }
        ArrayList<SaleAttachmentDTO> saleAttachments = new ArrayList<SaleAttachmentDTO>();
        for (PurchaseAttachmentDTO purchaseAttachment : attachments) {
            SaleAttachmentDTO attachment = new SaleAttachmentDTO();
            BeanUtils.copyProperties((Object)purchaseAttachment, (Object)attachment);
            attachment.setId(null);
            attachment.setRelationId(mentoringHead.getId());
            attachment.setElsAccount(mentoringHead.getElsAccount());
            attachment.setHeadId(mentoringHead.getId());
            attachment.setDeleted(CommonConstant.DEL_FLAG_0);
            saleAttachments.add(attachment);
        }
        this.invokeBaseRpcService.insertSaleAttachmentBatchSomeColumn(saleAttachments);
    }

    public void saveSaleMentoring(PurchaseMentoringHead purchaseMentoringHead, List<PurchaseMentoringItem> purchaseMentoringItems, String toELsAccount, String supplierName, List<PurchaseAttachmentDTO> attachments) {
        SaleMentoringHead mentoringHead = (SaleMentoringHead)((Object)this.saleMentoringHeadMapper.selectById((Serializable)((Object)purchaseMentoringHead.getRelationId())));
        if (mentoringHead != null && toELsAccount.equals(mentoringHead.getElsAccount())) {
            this.updateSaleMentoring(purchaseMentoringHead, purchaseMentoringItems, mentoringHead);
        }
        if (mentoringHead != null && !toELsAccount.equals(mentoringHead.getElsAccount())) {
            SaleMentoringHead addMentoringHead = new SaleMentoringHead();
            BeanUtils.copyProperties((Object)((Object)purchaseMentoringHead), (Object)((Object)addMentoringHead));
            addMentoringHead.setId(null);
            addMentoringHead.setElsAccount(toELsAccount);
            addMentoringHead.setToElsAccount(mentoringHead.getElsAccount());
            addMentoringHead.setSupplierName(supplierName);
            addMentoringHead.setRelationId(purchaseMentoringHead.getId());
            addMentoringHead.setUnreadTimes(1);
            this.saleMentoringHeadMapper.insert((Object)addMentoringHead);
            ArrayList saleMentoringItems = new ArrayList();
            purchaseMentoringItems.forEach(purchaseMentoringItem -> {
                SaleMentoringItem item = this.handleSaleMentoringItem(mentoringHead, (PurchaseMentoringItem)((Object)purchaseMentoringItem));
                saleMentoringItems.add(item);
            });
            this.saleMentoringItemMapper.insertBatchSomeColumn(saleMentoringItems);
            this.saveSaleAttachments(attachments, mentoringHead);
        }
    }

    private SaleMentoringItem handleSaleMentoringItem(SaleMentoringHead mentoringHead, PurchaseMentoringItem purchaseMentoringItem) {
        SaleMentoringItem item = new SaleMentoringItem();
        BeanUtils.copyProperties((Object)((Object)purchaseMentoringItem), (Object)((Object)item));
        item.setId(null);
        item.setRelationId(purchaseMentoringItem.getId());
        item.setHeadId(mentoringHead.getId());
        item.setElsAccount(mentoringHead.getElsAccount());
        item.setToElsAccount(mentoringHead.getToElsAccount());
        item.setViewStatus("0");
        return item;
    }

    @Override
    public void addMentoringInfoForSupplier(String businessType, String businessNumber, String toElsAccount, String supplierName) {
        List<PurchaseMentoringHead> heads = this.purchaseMentoringHeadMapper.getByKey(TenantContext.getTenant(), businessType, businessNumber);
        if (CollectionUtils.isEmpty(heads)) {
            return;
        }
        List<PurchaseMentoringHead> collect1 = heads.stream().filter(purchaseMentoringHead -> !MentoringObjectEnum.QUESTIONER.getValue().equals(purchaseMentoringHead.getMentoringObject()) || toElsAccount.equals(purchaseMentoringHead.getToElsAccount())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(collect1)) {
            return;
        }
        collect1.forEach(purchaseMentoringHead -> {
            List<PurchaseMentoringItem> items = this.purchaseMentoringItemMapper.selectByMainId(purchaseMentoringHead.getId());
            List attachments = this.invokeBaseRpcService.selectPurchaseAttachmentByMainId(purchaseMentoringHead.getId());
            List<PurchaseMentoringItem> collect = items.stream().filter(item -> item.getAnswerStatus().equals("1")).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(collect)) {
                return;
            }
            this.saveSaleMentoring((PurchaseMentoringHead)((Object)purchaseMentoringHead), collect, toElsAccount, supplierName, (List<PurchaseAttachmentDTO>)attachments);
        });
    }
}

