/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.demand.excel;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.els.common.excel.service.ErrorExcelHandlerService;
import com.els.common.util.ConvertUtils;
import com.els.common.util.I18nUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.ExcelImportDTO;
import com.els.modules.base.api.dto.TemplateConfigItemDTO;
import com.els.modules.base.api.dto.TemplateHeadDTO;
import com.els.modules.base.api.service.ExcelItemByConfigRpcService;
import com.els.modules.demand.entity.PurchaseRequestHead;
import com.els.modules.demand.entity.PurchaseRequestItem;
import com.els.modules.demand.rpc.ElsTaxLocalRpcService;
import com.els.modules.demand.rpc.PurchaseMaterialHeadLocalRpcService;
import com.els.modules.demand.rpc.TemplateLocalRpcService;
import com.els.modules.demand.service.PurchaseRequestHeadService;
import com.els.modules.demand.service.PurchaseRequestItemService;
import com.els.modules.material.api.dto.PurchaseMaterialHeadDTO;
import com.els.modules.system.dto.ExcelByConfigDTO;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;

@Scope(value="prototype")
@Service(value="purchaseRequestItemExcelHandler")
public class PurchaseRequestItemExcelHandler
extends ErrorExcelHandlerService
implements ExcelItemByConfigRpcService {
    private static final Logger log = LoggerFactory.getLogger(PurchaseRequestItemExcelHandler.class);
    @Autowired
    private PurchaseRequestHeadService purchaseRequestHeadService;
    @Autowired
    private PurchaseRequestItemService purchaseRequestItemService;
    @Resource
    private TemplateLocalRpcService templateHeadService;
    @Resource
    private ElsTaxLocalRpcService elsTaxService;
    @Resource
    private PurchaseMaterialHeadLocalRpcService purchaseMaterialHeadService;
    private List<TemplateConfigItemDTO> templateConfigItemDTOList;
    private static final List<String> MATER_STRING = Lists.newArrayList((Object[])new String[]{"materialNumber", "materialName", "materialDesc", "materialSpec", "materialGroup", "materialGroupName", "cateCode", "cateName"});

    public TemplateHeadDTO getTemplate(ExcelByConfigDTO excelByConfigDTO) {
        String templateAccount = excelByConfigDTO.getTemplateAccount();
        String templateVersion = excelByConfigDTO.getTemplateVersion();
        String templateNumber = excelByConfigDTO.getTemplateNumber();
        if (StrUtil.isNotBlank((CharSequence)excelByConfigDTO.getHeadId()) && !"undefined".equals(excelByConfigDTO.getHeadId())) {
            PurchaseRequestHead dbHead = (PurchaseRequestHead)((Object)this.purchaseRequestHeadService.getById((Serializable)((Object)excelByConfigDTO.getHeadId())));
            templateAccount = StringUtils.isNotBlank((CharSequence)dbHead.getTemplateAccount()) ? dbHead.getTemplateAccount() : dbHead.getElsAccount();
            templateVersion = String.valueOf(dbHead.getTemplateVersion());
            templateNumber = String.valueOf(dbHead.getTemplateNumber());
        }
        TemplateHeadDTO config = this.templateHeadService.getConfig(templateAccount, templateNumber, templateVersion);
        this.templateConfigItemDTOList = JSON.parseArray((String)JSON.toJSONString((Object)config.getTemplateConfigItemList()), TemplateConfigItemDTO.class);
        return config;
    }

    public List<Object> getExportData(ExcelByConfigDTO excelByConfigDTO) {
        List<PurchaseRequestItem> itemList = this.purchaseRequestItemService.selectByMainId(excelByConfigDTO.getHeadId());
        return new ArrayList<PurchaseRequestItem>(itemList);
    }

    public List<Map<String, Object>> importExcel(ExcelImportDTO excelImportDTO) {
        List dataList = excelImportDTO.getDataList();
        int totalCount = 0 == excelImportDTO.getTotalCount() ? dataList.size() : excelImportDTO.getTotalCount();
        String[] excludeColumn = new String[]{"materialNumber", "taxCode"};
        List editColumn = this.templateConfigItemDTOList.stream().filter(item -> "1".equals(item.getPurchaseEdit())).map(TemplateConfigItemDTO::getFieldName).collect(Collectors.toList());
        editColumn.addAll(Arrays.asList(excludeColumn));
        Map<String, Integer> taxMap = this.elsTaxService.getAllTax(TenantContext.getTenant());
        ArrayList<Map<String, Object>> returnDataList = new ArrayList<Map<String, Object>>();
        String errorTitle = this.getErrorTitle();
        for (Map data : dataList) {
            String materialNumber;
            HashMap errorData = new HashMap(data);
            for (String field : data.keySet()) {
                if (editColumn.contains(field)) continue;
                data.put(field, null);
            }
            String taxCode = (String)data.get("taxCode");
            if (StringUtils.isNotBlank((CharSequence)taxCode)) {
                if (!taxMap.containsKey(taxCode)) {
                    String msg = I18nUtil.translate((String)"i18n_alert_foWWWWWWWxMK_e919daf8", (String)"\u7a0e\u7801\uff1a[${0}]\u4e0d\u5b58\u5728", (String[])new String[]{taxCode});
                    this.errorAdd(excelImportDTO, msg, errorData);
                    continue;
                }
                data.put("taxRate", taxMap.get(taxCode));
            }
            if (StringUtils.isNotBlank((CharSequence)(materialNumber = (String)data.get("materialNumber")))) {
                Field[] fields;
                PurchaseMaterialHeadDTO materialHead = this.purchaseMaterialHeadService.getMaterialHeadByNumber(materialNumber);
                if (null == materialHead) {
                    String msg = I18nUtil.translate((String)"i18n_alert_SLAoWWWWWWWxMK_44822940", (String)"\u7269\u6599\u7f16\u7801\uff1a[${0}]\u4e0d\u5b58\u5728", (String[])new String[]{materialNumber});
                    this.errorAdd(excelImportDTO, msg, errorData);
                    continue;
                }
                for (Field field : fields = ConvertUtils.getAllFields((Object)materialHead)) {
                    if (!data.containsKey(field.getName()) || !MATER_STRING.contains(field.getName())) continue;
                    try {
                        field.setAccessible(true);
                        data.put(field.getName(), field.get(materialHead));
                    }
                    catch (IllegalAccessException e) {
                        log.error("\u53cd\u5c04\u83b7\u53d6\u503c\u5f02\u5e38", (Throwable)e);
                    }
                }
            }
            returnDataList.add(data);
        }
        this.errorHandle(true, excelImportDTO, TenantContext.getTenant(), totalCount);
        return returnDataList;
    }
}

