/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.searchSourceConfig.utils;

import com.els.common.util.AssertI18nUtil;
import com.els.modules.searchSourceConfig.enums.I18nSearSourEnum;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class SearSourConfigUtil {
    protected static final Map<String, String> SearSourTypeMap = Maps.newHashMap();

    private SearSourConfigUtil() {
    }

    public static String validSearSourType(String sourceType, String configType) {
        List<String> configTypes = Arrays.asList(configType.split(","));
        if (configTypes.contains(sourceType)) {
            return null;
        }
        for (Map.Entry<String, String> entry : SearSourTypeMap.entrySet()) {
            configType = configType.replace(entry.getKey(), entry.getValue());
        }
        return configType;
    }

    public static void validSearSourType(String cateCode, String sourceType, String configType) {
        String result = SearSourConfigUtil.validSearSourType(sourceType, configType);
        if (result == null) {
            return;
        }
        if (StringUtils.isNotBlank((CharSequence)cateCode)) {
            AssertI18nUtil.isTrue((boolean)true, (Enum)I18nSearSourEnum.SAVE_SEAR_SOUR_NO_CONFIG, (String[])new String[]{cateCode, result});
        } else {
            AssertI18nUtil.isTrue((boolean)true, (Enum)I18nSearSourEnum.SAVE_SEAR_SOUR_ALL_NO_CONFIG, (String[])new String[]{result});
        }
    }

    static {
        SearSourTypeMap.put("0", "\u8be2\u4ef7");
        SearSourTypeMap.put("1", "\u7ade\u4ef7");
        SearSourTypeMap.put("2", "\u62db\u6807");
    }
}

