/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.tender.abnormal.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.constant.CommonConstant;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.modules.base.api.dto.PurchaseAttachmentDTO;
import com.els.modules.inquiry.rpc.service.InquiryInvokeWorkFlowRpcService;
import com.els.modules.tender.abnormal.entity.PurchaseTenderAgainSubpackageHead;
import com.els.modules.tender.abnormal.entity.PurchaseTenderAgainSubpackageItem;
import com.els.modules.tender.abnormal.mapper.PurchaseTenderAgainSubpackageHeadMapper;
import com.els.modules.tender.abnormal.service.PurchaseTenderAgainSubpackageHeadService;
import com.els.modules.tender.abnormal.service.PurchaseTenderAgainSubpackageItemService;
import com.els.modules.tender.abnormal.vo.PurchaseTenderAgainSubpackageHeadVO;
import com.els.modules.tender.calibration.enumerate.BidWinningAffirmNoticeEnum;
import com.els.modules.tender.openbid.enumerate.PurchaseOpenBidStatusEnum;
import com.els.modules.tender.project.entity.PurchaseTenderProjectHead;
import com.els.modules.tender.project.entity.PurchaseTenderProjectSubpackageInfo;
import com.els.modules.tender.project.enumerate.TenderProjectSubpackageStatusEnum;
import com.els.modules.tender.project.enumerate.TenderSubpackageDiscardTypeEnum;
import com.els.modules.tender.project.service.PurchaseTenderProjectHeadService;
import com.els.modules.tender.project.service.PurchaseTenderProjectSubpackageInfoService;
import com.els.modules.tender.project.vo.PurchaseTenderProjectSubpackageInfoVO;
import com.els.modules.tender.sale.enumerate.TenderProjectPurchaseBidStatusEnum;
import com.els.modules.tender.sale.enumerate.TenderProjectSignUpStatusEnum;
import com.els.modules.tender.sale.vo.TenderProjectPurchaseBidVO;
import com.els.modules.tender.sale.vo.TenderProjectSignUpVO;
import com.els.modules.tender.supplier.entity.TenderProjectPurchaseBid;
import com.els.modules.tender.supplier.entity.TenderProjectSignUp;
import com.els.modules.tender.supplier.entity.TenderProjectSupplier;
import com.els.modules.tender.supplier.service.TenderInvoiceInfoService;
import com.els.modules.tender.supplier.service.TenderProjectPurchaseBidService;
import com.els.modules.tender.supplier.service.TenderProjectSignUpService;
import com.els.modules.tender.supplier.service.TenderProjectSupplierService;
import com.els.modules.workflow.dto.AuditInputParamDTO;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class PurchaseTenderAgainSubpackageHeadServiceImpl
extends BaseServiceImpl<PurchaseTenderAgainSubpackageHeadMapper, PurchaseTenderAgainSubpackageHead>
implements PurchaseTenderAgainSubpackageHeadService {
    @Autowired
    private PurchaseTenderAgainSubpackageItemService againSubpackageItemService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Resource
    private InquiryInvokeWorkFlowRpcService inquiryInvokeWorkFlowRpcService;
    @Resource
    private PurchaseTenderProjectHeadService tenderProjectHeadService;
    @Resource
    private PurchaseTenderProjectSubpackageInfoService subpackageInfoService;
    @Autowired
    private TenderProjectSignUpService tenderProjectSignUpService;
    @Autowired
    private TenderProjectPurchaseBidService saleTenderProjectPurchaseBidService;
    @Autowired
    private TenderProjectSupplierService supplierService;
    @Resource
    private TenderProjectPurchaseBidService purchaseBidService;
    @Autowired
    private TenderInvoiceInfoService saleTenderInvoiceInfoService;

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void saveMain(PurchaseTenderAgainSubpackageHead purchaseTenderAgainSubpackageHead, List<PurchaseTenderAgainSubpackageItem> purchaseTenderAgainSubpackageItemList, List<PurchaseAttachmentDTO> attachmentDTOList) {
        if ("1".equals(purchaseTenderAgainSubpackageHead.getAudit())) {
            purchaseTenderAgainSubpackageHead.setAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
        } else {
            purchaseTenderAgainSubpackageHead.setAuditStatus(AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
        }
        purchaseTenderAgainSubpackageHead.setStatus("0");
        purchaseTenderAgainSubpackageHead.setDeleted(CommonConstant.DEL_FLAG_0);
        purchaseTenderAgainSubpackageHead.setAgainNumber(this.invokeBaseRpcService.getNextCode("tenderAgainSubpackageNumber", (Object)purchaseTenderAgainSubpackageHead));
        ((PurchaseTenderAgainSubpackageHeadMapper)this.baseMapper).insert((Object)purchaseTenderAgainSubpackageHead);
        this.insertData(purchaseTenderAgainSubpackageHead, purchaseTenderAgainSubpackageItemList, attachmentDTOList);
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void updateMain(PurchaseTenderAgainSubpackageHead purchaseTenderAgainSubpackageHead, List<PurchaseTenderAgainSubpackageItem> purchaseTenderAgainSubpackageItemList, List<PurchaseAttachmentDTO> attachmentDTOList) {
        if ("1".equals(purchaseTenderAgainSubpackageHead.getAudit())) {
            purchaseTenderAgainSubpackageHead.setAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
        } else {
            purchaseTenderAgainSubpackageHead.setAuditStatus(AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
        }
        int count = ((PurchaseTenderAgainSubpackageHeadMapper)this.baseMapper).updateById((Object)purchaseTenderAgainSubpackageHead);
        Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        this.againSubpackageItemService.deleteByMainId(purchaseTenderAgainSubpackageHead.getId());
        this.insertData(purchaseTenderAgainSubpackageHead, purchaseTenderAgainSubpackageItemList, attachmentDTOList);
    }

    private void insertData(PurchaseTenderAgainSubpackageHead purchaseTenderAgainSubpackageHead, List<PurchaseTenderAgainSubpackageItem> purchaseTenderAgainSubpackageItemList, List<PurchaseAttachmentDTO> attachmentDTOList) {
        if (CollectionUtil.isNotEmpty(purchaseTenderAgainSubpackageItemList)) {
            for (PurchaseTenderAgainSubpackageItem entity : purchaseTenderAgainSubpackageItemList) {
                entity.setHeadId(purchaseTenderAgainSubpackageHead.getId());
                SysUtil.setSysParam((BaseEntity)entity, (BaseEntity)purchaseTenderAgainSubpackageHead);
            }
            this.againSubpackageItemService.saveBatch(purchaseTenderAgainSubpackageItemList, 2000);
        }
        if (CollectionUtil.isNotEmpty(attachmentDTOList)) {
            this.invokeBaseRpcService.deletePurchaseAttachmentByMainId(purchaseTenderAgainSubpackageHead.getId());
            attachmentDTOList.parallelStream().forEach(attachment -> attachment.setHeadId(purchaseTenderAgainSubpackageHead.getId()));
            this.invokeBaseRpcService.insertPurchaseAttachmentBatchSomeColumn(attachmentDTOList);
        }
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void deleteMain(String id) {
        this.againSubpackageItemService.deleteByMainId(id);
        ((PurchaseTenderAgainSubpackageHeadMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void deleteBatchMain(List<String> idList) {
        for (Serializable serializable : idList) {
            this.againSubpackageItemService.deleteByMainId(serializable.toString());
            ((PurchaseTenderAgainSubpackageHeadMapper)this.baseMapper).deleteById(serializable);
        }
    }

    @Override
    public PurchaseTenderAgainSubpackageHead queryAgainSubpackageBySubpackageId(String subpackageId) {
        return ((PurchaseTenderAgainSubpackageHeadMapper)this.baseMapper).queryAgainSubpackageBySubpackageId(subpackageId);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void publish(PurchaseTenderAgainSubpackageHeadVO headVo) {
        PurchaseTenderAgainSubpackageHead purchaseTenderAgainSubpackageHead = (PurchaseTenderAgainSubpackageHead)((Object)SysUtil.copyProperties((Object)((Object)headVo), PurchaseTenderAgainSubpackageHead.class));
        this.checkParam(purchaseTenderAgainSubpackageHead, headVo.getPurchaseTenderAgainSubpackageItemList());
        PurchaseTenderAgainSubpackageHead newVersionAgain = (PurchaseTenderAgainSubpackageHead)((Object)((PurchaseTenderAgainSubpackageHeadMapper)this.baseMapper).selectById((Serializable)((Object)purchaseTenderAgainSubpackageHead.getId())));
        purchaseTenderAgainSubpackageHead.setDataVersion(newVersionAgain.getDataVersion());
        if ("1".equals(headVo.getAudit())) {
            AuditInputParamDTO dto = new AuditInputParamDTO();
            dto.setBusinessId(headVo.getId());
            dto.setBusinessType("againSubpackage");
            dto.setAuditSubject("\u91cd\u65b0\u62db\u6807 \u5355\u53f7: " + purchaseTenderAgainSubpackageHead.getAgainNumber());
            dto.setParams(JSONObject.toJSONString((Object)((Object)purchaseTenderAgainSubpackageHead)));
            this.inquiryInvokeWorkFlowRpcService.submit(dto);
        } else {
            purchaseTenderAgainSubpackageHead.setStatus(BidWinningAffirmNoticeEnum.ISSUE.getValue());
            ((PurchaseTenderAgainSubpackageHeadMapper)this.baseMapper).updateById((Object)purchaseTenderAgainSubpackageHead);
            this.againSubpackage(purchaseTenderAgainSubpackageHead, headVo.getPurchaseTenderAgainSubpackageItemList());
            PurchaseTenderProjectSubpackageInfo projectSubpackageInfo = this.subpackageInfoService.selectById(headVo.getSubpackageId());
            projectSubpackageInfo.setStatus(TenderProjectSubpackageStatusEnum.BIDDING_HAS_ENDED.getValue());
            projectSubpackageInfo.setInvalid("1");
            projectSubpackageInfo.setInvalidType(TenderSubpackageDiscardTypeEnum.RE_TENDER.getValue());
            this.subpackageInfoService.updateById((Object)projectSubpackageInfo);
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void againSubpackage(PurchaseTenderAgainSubpackageHead purchaseTenderAgainSubpackageHead, List<PurchaseTenderAgainSubpackageItem> purchaseTenderAgainSubpackageItemList) {
        String againProject = purchaseTenderAgainSubpackageHead.getAgainProject();
        String againSupplier = purchaseTenderAgainSubpackageHead.getAgainSupplier();
        String oldProjectId = purchaseTenderAgainSubpackageHead.getProjectId();
        String newProjectId = purchaseTenderAgainSubpackageHead.getProjectId();
        PurchaseTenderProjectHead purchaseTenderProjectHead = (PurchaseTenderProjectHead)((Object)this.tenderProjectHeadService.getBaseMapper().selectById((Serializable)((Object)oldProjectId)));
        List<String> oldIds = purchaseTenderAgainSubpackageItemList.stream().map(PurchaseTenderAgainSubpackageItem::getSubpackageId).collect(Collectors.toList());
        List<PurchaseTenderProjectSubpackageInfo> oldSubpackageInfos = this.subpackageInfoService.selectBatchIds(oldIds);
        ArrayList<PurchaseTenderProjectSubpackageInfo> newSubpackageInfos = new ArrayList<PurchaseTenderProjectSubpackageInfo>();
        List<TenderProjectSupplier> oldTenderProjectSupplierList = this.supplierService.selectByMainIds(oldIds);
        Map<String, List<TenderProjectSupplier>> oldsupplierMaps = null;
        List<TenderProjectSupplier> newTenderProjectSuppliers = null;
        if (CollectionUtil.isNotEmpty(oldTenderProjectSupplierList)) {
            oldsupplierMaps = oldTenderProjectSupplierList.stream().collect(Collectors.groupingBy(TenderProjectSupplier::getSubpackageId));
        }
        List<TenderProjectSignUpVO> oldTenderSignUpVo = this.tenderProjectSignUpService.selectByMainIds(oldIds);
        Map<String, List<TenderProjectSignUpVO>> oldSignUpMaps = null;
        List<TenderProjectSignUpVO> newTenderProjectSignUpVOS = null;
        if (CollectionUtil.isNotEmpty(oldTenderSignUpVo)) {
            oldSignUpMaps = oldTenderSignUpVo.stream().collect(Collectors.groupingBy(TenderProjectSignUp::getSubpackageId));
        }
        List<TenderProjectPurchaseBidVO> oldPurchaseBidVo = this.purchaseBidService.selectByMainIds(oldIds);
        Map<String, List<TenderProjectPurchaseBidVO>> oldPurchaseBidMaps = null;
        List<TenderProjectPurchaseBidVO> newTenderProjectPurchaseBidVOS = null;
        if (CollectionUtil.isNotEmpty(oldPurchaseBidVo)) {
            oldPurchaseBidMaps = oldPurchaseBidVo.stream().collect(Collectors.groupingBy(TenderProjectPurchaseBid::getSubpackageId));
        }
        if ("1".equals(againProject)) {
            newProjectId = IdWorker.getIdStr();
            purchaseTenderProjectHead.setId(newProjectId);
            this.tenderProjectHeadService.saveMain(purchaseTenderProjectHead, new ArrayList<PurchaseTenderProjectSubpackageInfoVO>(), new ArrayList<PurchaseAttachmentDTO>());
        }
        for (PurchaseTenderAgainSubpackageItem oldSubpackageInfo : purchaseTenderAgainSubpackageItemList) {
            PurchaseTenderProjectSubpackageInfo oldSubpackage = (PurchaseTenderProjectSubpackageInfo)((Object)SysUtil.copyProperties((Object)((Object)oldSubpackageInfo), PurchaseTenderProjectSubpackageInfo.class));
            PurchaseTenderProjectSubpackageInfo newSubpackage = (PurchaseTenderProjectSubpackageInfo)((Object)SysUtil.copyProperties((Object)((Object)oldSubpackageInfo), PurchaseTenderProjectSubpackageInfo.class));
            this.builderSubpackageInfo(newSubpackage, newProjectId, oldProjectId, "1".equals(againProject));
            if (oldsupplierMaps != null && oldsupplierMaps.size() > 0) {
                List<TenderProjectSupplier> tenderProjectSuppliers = oldsupplierMaps.get(oldSubpackage.getId());
                newTenderProjectSuppliers = this.builderTenderSupplier(tenderProjectSuppliers, newSubpackage, "1".equals(againProject));
            }
            if (oldSignUpMaps != null && oldSignUpMaps.size() > 0) {
                List<TenderProjectSignUpVO> tenderProjectSignUpVOS = oldSignUpMaps.get(oldSubpackage.getId());
                newTenderProjectSignUpVOS = this.builderSignUp(tenderProjectSignUpVOS, newSubpackage, "1".equals(againProject));
            }
            if (oldSignUpMaps != null && oldSignUpMaps.size() > 0) {
                List<TenderProjectPurchaseBidVO> tenderProjectPurchaseBidVOS = oldPurchaseBidMaps.get(oldSubpackage.getId());
                newTenderProjectPurchaseBidVOS = this.builderBidding(tenderProjectPurchaseBidVOS, newSubpackage, "1".equals(againProject));
            }
            newSubpackageInfos.add(newSubpackage);
        }
        oldSubpackageInfos.stream().forEach(item -> {
            item.setStatus(TenderProjectSubpackageStatusEnum.BIDDING_HAS_AGAIN.getValue());
            item.setInvalid("1");
            item.setInvalidType(TenderSubpackageDiscardTypeEnum.RE_TENDER.getValue());
        });
        this.subpackageInfoService.updateBatchById(oldSubpackageInfos);
        this.subpackageInfoService.saveBatch(newSubpackageInfos);
        if ("1".equals(againSupplier)) {
            this.supplierService.saveBatch(newTenderProjectSuppliers);
            this.tenderProjectSignUpService.dataVoSaveBatch(newTenderProjectSignUpVOS);
            this.purchaseBidService.dataVoSaveBatch(newTenderProjectPurchaseBidVOS);
        }
    }

    private void builderSubpackageInfo(PurchaseTenderProjectSubpackageInfo subpackageInfo, String newProjectId, String oldProjectId, boolean againProject) {
        subpackageInfo.setId(IdWorker.getIdStr());
        if (againProject) {
            subpackageInfo.setHeadId(newProjectId);
            subpackageInfo.setStatus(TenderProjectSubpackageStatusEnum.NEW.getValue());
        } else {
            subpackageInfo.setHeadId(oldProjectId);
            subpackageInfo.setStatus(TenderProjectSubpackageStatusEnum.ENABLED.getValue());
        }
        subpackageInfo.setSubpackageNumber(this.invokeBaseRpcService.getNextCode("subpackageNumber", (Object)subpackageInfo));
        subpackageInfo.setDeleted(CommonConstant.DEL_FLAG_0);
    }

    private List<TenderProjectSupplier> builderTenderSupplier(List<TenderProjectSupplier> tenderProjectSuppliers, PurchaseTenderProjectSubpackageInfo subpackageInfo, boolean againProject) {
        for (TenderProjectSupplier tenderProjectSupplier : tenderProjectSuppliers) {
            tenderProjectSupplier.setSubpackageId(subpackageInfo.getId());
            tenderProjectSupplier.setTenderProjectId(subpackageInfo.getHeadId());
            tenderProjectSupplier.setCheckType(subpackageInfo.getCheckType());
            tenderProjectSupplier.setSubpackageName(subpackageInfo.getSubpackageName());
            if (againProject) {
                tenderProjectSupplier.setSignUp("0");
                tenderProjectSupplier.setPurchaseBid("0");
                tenderProjectSupplier.setPrePurchaseBid("0");
            }
            tenderProjectSupplier.setPreSignIn("0");
            tenderProjectSupplier.setPreDecrypt("0");
            tenderProjectSupplier.setSignature("0");
            tenderProjectSupplier.setPreShortlisted("0");
            tenderProjectSupplier.setInvite("0");
            tenderProjectSupplier.setDecrypt("0");
            tenderProjectSupplier.setResultDecrypt("0");
            tenderProjectSupplier.setWinner("0");
            tenderProjectSupplier.setOpenBidStatus(PurchaseOpenBidStatusEnum.NOT_OPEN_BID.getValue());
            tenderProjectSupplier.setSignIn("0");
            tenderProjectSupplier.setDeleted(CommonConstant.DEL_FLAG_0);
            tenderProjectSupplier.setShortlisted("0");
            tenderProjectSupplier.setResultShortlisted("0");
            tenderProjectSupplier.setId(null);
            tenderProjectSupplier.setPreResponseStatus("0");
            tenderProjectSupplier.setPreResponseTime(null);
            tenderProjectSupplier.setResponseStatus("0");
            tenderProjectSupplier.setResponseTime(null);
            tenderProjectSupplier.setResultResponseTime(null);
            tenderProjectSupplier.setResultResponseStatus("0");
            tenderProjectSupplier.setFilePassword(null);
            tenderProjectSupplier.setPreFilePassword(null);
        }
        return tenderProjectSuppliers;
    }

    private List<TenderProjectSignUpVO> builderSignUp(List<TenderProjectSignUpVO> tenderProjectSignUpVOs, PurchaseTenderProjectSubpackageInfo subpackageInfo, boolean againProject) {
        for (TenderProjectSignUpVO tenderProjectSignUpVO : tenderProjectSignUpVOs) {
            tenderProjectSignUpVO.setId(IdWorker.getIdStr());
            tenderProjectSignUpVO.setSubpackageId(subpackageInfo.getId());
            tenderProjectSignUpVO.setSubpackageName(subpackageInfo.getSubpackageName());
            tenderProjectSignUpVO.setTenderProjectId(subpackageInfo.getHeadId());
            tenderProjectSignUpVO.setTenderProjectName(subpackageInfo.getTenderProjectName());
            tenderProjectSignUpVO.getAttachmentList().stream().forEach(item -> {
                item.setId(null);
                item.setHeadId(tenderProjectSignUpVO.getId());
            });
            if (!againProject) continue;
            tenderProjectSignUpVO.setStatus(TenderProjectSignUpStatusEnum.NEW.getValue());
        }
        return tenderProjectSignUpVOs;
    }

    private List<TenderProjectPurchaseBidVO> builderBidding(List<TenderProjectPurchaseBidVO> tenderProjectPurchaseBidVos, PurchaseTenderProjectSubpackageInfo subpackageInfo, boolean againProject) {
        for (TenderProjectPurchaseBidVO tenderProjectPurchaseBidVo : tenderProjectPurchaseBidVos) {
            tenderProjectPurchaseBidVo.setId(IdWorker.getIdStr());
            tenderProjectPurchaseBidVo.setSubpackageId(subpackageInfo.getId());
            tenderProjectPurchaseBidVo.setTenderProjectId(subpackageInfo.getHeadId());
            tenderProjectPurchaseBidVo.setTenderProjectName(subpackageInfo.getTenderProjectName());
            if (CollectionUtil.isNotEmpty(tenderProjectPurchaseBidVo.getSaleTenderInvoiceInfoList())) {
                tenderProjectPurchaseBidVo.getSaleTenderInvoiceInfoList().stream().forEach(item -> item.setId(tenderProjectPurchaseBidVo.getId()));
            }
            if (CollectionUtil.isNotEmpty(tenderProjectPurchaseBidVo.getAttachmentList())) {
                tenderProjectPurchaseBidVo.getAttachmentList().stream().forEach(item -> {
                    item.setId(null);
                    item.setHeadId(tenderProjectPurchaseBidVo.getId());
                });
            }
            if (!againProject) continue;
            tenderProjectPurchaseBidVo.setStatus(TenderProjectPurchaseBidStatusEnum.NEW.getValue());
        }
        return tenderProjectPurchaseBidVos;
    }

    private void checkParam(PurchaseTenderAgainSubpackageHead purchaseTenderAgainSubpackageHead, List<PurchaseTenderAgainSubpackageItem> purchaseTenderAgainSubpackageItemList) {
        Assert.isTrue((boolean)CollectionUtil.isNotEmpty(purchaseTenderAgainSubpackageItemList), (String)I18nUtil.translate((String)"", (String)"\u5206\u5305\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a!"));
    }
}

