/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.tender.attachment.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.modules.tender.attachment.entity.PurchaseTenderProjectAttachmentHead;
import com.els.modules.tender.attachment.entity.PurchaseTenderProjectAttachmentInfo;
import com.els.modules.tender.attachment.mapper.PurchaseTenderProjectAttachmentInfoMapper;
import com.els.modules.tender.attachment.service.PurchaseTenderProjectAttachmentHeadService;
import com.els.modules.tender.attachment.service.PurchaseTenderProjectAttachmentInfoService;
import com.els.modules.tender.attachment.vo.PurchaseTenderProjectAttachmentHeadViewVO;
import com.els.modules.tender.common.aspect.TenderFlagInjectionContext;
import java.io.Serializable;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class PurchaseTenderProjectAttachmentInfoServiceImpl
extends BaseServiceImpl<PurchaseTenderProjectAttachmentInfoMapper, PurchaseTenderProjectAttachmentInfo>
implements PurchaseTenderProjectAttachmentInfoService {
    @Autowired
    @Lazy
    private PurchaseTenderProjectAttachmentHeadService purchaseTenderProjectAttachmentHeadService;

    @Override
    public void add(PurchaseTenderProjectAttachmentInfo projectAttachmentInfo) {
        ((PurchaseTenderProjectAttachmentInfoMapper)this.baseMapper).insert((Object)projectAttachmentInfo);
    }

    @Override
    public void edit(PurchaseTenderProjectAttachmentInfo projectAttachmentInfo) {
        int count = ((PurchaseTenderProjectAttachmentInfoMapper)this.baseMapper).updateById((Object)projectAttachmentInfo);
        Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
    }

    @Override
    public void delete(String id) {
        ((PurchaseTenderProjectAttachmentInfoMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void deleteBatch(List<String> idList) {
        ((PurchaseTenderProjectAttachmentInfoMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    public void deleteByMainId(String headId) {
        ((PurchaseTenderProjectAttachmentInfoMapper)this.baseMapper).deleteByMainId(headId);
    }

    @Override
    public List<PurchaseTenderProjectAttachmentInfo> queryTenderProjectAttachmentInfo(PurchaseTenderProjectAttachmentHead purchaseTenderProjectAttachmentHead) {
        return ((PurchaseTenderProjectAttachmentInfoMapper)this.baseMapper).selectByMainId(purchaseTenderProjectAttachmentHead.getId());
    }

    @Override
    public void addTenderProjectAttachmentInfo(PurchaseTenderProjectAttachmentHead attachmentHead, List<PurchaseTenderProjectAttachmentInfo> purchaseTenderProjectAttachmentInfoList) {
        if (CollectionUtil.isNotEmpty(purchaseTenderProjectAttachmentInfoList)) {
            purchaseTenderProjectAttachmentInfoList.parallelStream().forEach(info -> info.setHeadId(attachmentHead.getId()));
            this.saveBatch(purchaseTenderProjectAttachmentInfoList);
        }
    }

    @Override
    public void updateTenderProjectAttachmentInfo(PurchaseTenderProjectAttachmentHead attachmentHead, List<PurchaseTenderProjectAttachmentInfo> purchaseTenderProjectAttachmentInfoList) {
        this.deleteByMainId(attachmentHead.getSubpackageId());
        this.saveBatch(purchaseTenderProjectAttachmentInfoList, 1000);
    }

    @Override
    public List<PurchaseTenderProjectAttachmentInfo> selectByMainId(String subpackageId) {
        return ((PurchaseTenderProjectAttachmentInfoMapper)this.baseMapper).selectByMainId(subpackageId);
    }

    @Override
    public List<PurchaseTenderProjectAttachmentInfo> selectBySubpackageId(String subpackageId) {
        return ((PurchaseTenderProjectAttachmentInfoMapper)this.baseMapper).selectBySubpackageId(subpackageId, TenderFlagInjectionContext.getTenderCheckType());
    }

    @Override
    public PurchaseTenderProjectAttachmentHeadViewVO queryAttachmentInfo(String subpackageId) {
        PurchaseTenderProjectAttachmentHeadViewVO purchaseTenderProjectAttachmentHeadViewVO = new PurchaseTenderProjectAttachmentHeadViewVO();
        PurchaseTenderProjectAttachmentHead attachmentHead = this.purchaseTenderProjectAttachmentHeadService.getPurchaseTenderProjectAttachmentHandBySubpackageId(subpackageId);
        attachmentHead = Optional.ofNullable(attachmentHead).orElse(new PurchaseTenderProjectAttachmentHead());
        List<PurchaseTenderProjectAttachmentInfo> attachmentInfoList = this.queryTenderProjectAttachmentInfo(attachmentHead);
        purchaseTenderProjectAttachmentHeadViewVO.setPurchaseTenderProjectAttachmentInfoList(attachmentInfoList);
        return purchaseTenderProjectAttachmentHeadViewVO;
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void addAttachmentInfo(PurchaseTenderProjectAttachmentHead purchaseTenderProjectAttachmentHead, List<PurchaseTenderProjectAttachmentInfo> attachmentInfoList) {
        this.purchaseTenderProjectAttachmentHeadService.saveOrUpdate((Object)purchaseTenderProjectAttachmentHead);
        this.saveBatch(attachmentInfoList, 1000);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void editAttachmentInfo(PurchaseTenderProjectAttachmentHead purchaseTenderProjectAttachmentHead, List<PurchaseTenderProjectAttachmentInfo> purchaseTenderProjectAttachmentInfoList) {
        this.purchaseTenderProjectAttachmentHeadService.saveOrUpdate((Object)purchaseTenderProjectAttachmentHead);
        this.deleteByMainId(purchaseTenderProjectAttachmentHead.getSubpackageId());
        this.saveBatch(purchaseTenderProjectAttachmentInfoList, 1000);
    }

    @Override
    public List<PurchaseTenderProjectAttachmentInfo> selectBySubpackageIds(List<String> subpackageIds) {
        return ((PurchaseTenderProjectAttachmentInfoMapper)this.baseMapper).selectBySubpackageIds(subpackageIds, TenderFlagInjectionContext.getTenderCheckType());
    }
}

