/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.tender.evaluation.job;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.els.common.api.service.JobRpcService;
import com.els.common.util.DateUtils;
import com.els.common.util.SpringContextUtils;
import com.els.modules.tender.evaluation.entity.TenderEvaQuotedPriceHead;
import com.els.modules.tender.evaluation.entity.TenderEvaQuotedPriceItem;
import com.els.modules.tender.evaluation.enumerate.TenderEvaQuotedPriceHeadStatusEnum;
import com.els.modules.tender.evaluation.service.TenderEvaQuotedPriceHeadService;
import com.els.modules.tender.evaluation.service.TenderEvaQuotedPriceItemService;
import com.els.modules.tender.openbid.job.TenderJobUtil;
import com.els.modules.tender.sale.enumerate.TenderProjectSupplieInviteQuotedPriceStatusEnum;
import com.els.modules.tender.supplier.service.TenderProjectSupplierService;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTenderEvaQuotedPriceBeanService
implements JobRpcService {
    private static final Logger log = LoggerFactory.getLogger(AbstractTenderEvaQuotedPriceBeanService.class);

    public void doExecute(String parameter) {
        log.info(" \u591a\u8f6e\u62a5\u4ef7\u5b9a\u65f6\u4efb\u52a1 tenderEvaQuotedPriceJobService \u5f00\u59cb\u6267\u884c\u65f6\u95f4:" + DateUtils.getTimestamp() + parameter);
        if (StrUtil.isEmpty((CharSequence)parameter)) {
            log.error("parameter must not be null.");
            return;
        }
        JSONObject paramObj = JSONObject.parseObject((String)parameter);
        String id = paramObj.getString("id");
        if (StrUtil.isEmpty((CharSequence)id)) {
            log.error("parameter must contain {}", (Object)id);
            return;
        }
        TenderEvaQuotedPriceHeadService tenderEvaQuotedPriceHeadService = (TenderEvaQuotedPriceHeadService)SpringContextUtils.getBean(TenderEvaQuotedPriceHeadService.class);
        TenderEvaQuotedPriceHead tenderEvaQuotedPriceHead = (TenderEvaQuotedPriceHead)((Object)tenderEvaQuotedPriceHeadService.getById((Serializable)((Object)id)));
        tenderEvaQuotedPriceHead.setStatus(TenderEvaQuotedPriceHeadStatusEnum.EVA_QUOTED_PRICE_FINISH.getValue());
        tenderEvaQuotedPriceHeadService.updateById((Object)tenderEvaQuotedPriceHead);
        TenderEvaQuotedPriceItemService tenderEvaQuotedPriceItemService = (TenderEvaQuotedPriceItemService)SpringContextUtils.getBean(TenderEvaQuotedPriceItemService.class);
        List<TenderEvaQuotedPriceItem> tenderEvaQuotedPriceItems = tenderEvaQuotedPriceItemService.selectByMainId(tenderEvaQuotedPriceHead.getId());
        List supplierAccounts = tenderEvaQuotedPriceItems.stream().map(TenderEvaQuotedPriceItem::getSupplierAccount).collect(Collectors.toList());
        if (CollectionUtil.isNotEmpty(supplierAccounts)) {
            TenderProjectSupplierService tenderProjectSupplierService = (TenderProjectSupplierService)SpringContextUtils.getBean(TenderProjectSupplierService.class);
            tenderProjectSupplierService.updateInviteQuotedPriceStatus(supplierAccounts, tenderEvaQuotedPriceHead.getSubpackageId(), TenderProjectSupplieInviteQuotedPriceStatusEnum.UNINVITED.getValue());
        }
        String jobKey = paramObj.getString("jobKey");
        TenderJobUtil.deleteJob(jobKey);
        log.info(" \u591a\u8f6e\u62a5\u4ef7\u5b9a\u65f6\u4efb\u52a1 tenderEvaQuotedPriceJobService \u6267\u884c\u5b8c\u6210\u65f6\u95f4:" + DateUtils.getTimestamp() + parameter);
    }
}

