/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.tender.evaluation.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.PurchaseAttachmentDTO;
import com.els.modules.tender.common.aspect.TenderFlagInjectionContext;
import com.els.modules.tender.evaluation.entity.PurchaseTenderProjectEvaSettingHead;
import com.els.modules.tender.evaluation.entity.PurchaseTenderProjectJuryHead;
import com.els.modules.tender.evaluation.entity.PurchaseTenderProjectJuryMember;
import com.els.modules.tender.evaluation.enumerate.PurchaseTenderJuryMemberConfirmStatusEnum;
import com.els.modules.tender.evaluation.enumerate.PurchaseTenderJuryMemberTypeEnum;
import com.els.modules.tender.evaluation.mapper.PurchaseTenderProjectJuryHeadMapper;
import com.els.modules.tender.evaluation.service.PurchaseTenderProjectBidEvaHeadService;
import com.els.modules.tender.evaluation.service.PurchaseTenderProjectEvaSettingHeadService;
import com.els.modules.tender.evaluation.service.PurchaseTenderProjectJuryHeadService;
import com.els.modules.tender.evaluation.service.PurchaseTenderProjectJuryMemberService;
import com.els.modules.tender.evaluation.vo.PurchaseTenderProjectJuryHeadVO;
import com.els.modules.tender.project.entity.PurchaseTenderProjectSubpackageInfo;
import com.els.modules.tender.project.enumerate.SubpackageInfoCheckTypeEnum;
import com.els.modules.tender.project.enumerate.SubpackageInfoCurrentStepEnum;
import com.els.modules.tender.project.enumerate.SubpackageInfoProcessTypeEnum;
import com.els.modules.tender.project.enumerate.TenderProjectSubpackageStatusEnum;
import com.els.modules.tender.project.service.PurchaseTenderProjectSubpackageInfoService;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class PurchaseTenderProjectJuryHeadServiceImpl
extends BaseServiceImpl<PurchaseTenderProjectJuryHeadMapper, PurchaseTenderProjectJuryHead>
implements PurchaseTenderProjectJuryHeadService {
    @Autowired
    private PurchaseTenderProjectJuryMemberService purchaseTenderProjectJuryMemberService;
    @Autowired
    private PurchaseTenderProjectEvaSettingHeadService purchaseTenderProjectEvaSettingHeadService;
    @Autowired
    private PurchaseTenderProjectSubpackageInfoService subpackageInfoService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Autowired
    @Lazy
    private PurchaseTenderProjectBidEvaHeadService bidEvaHeadService;

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void saveMain(PurchaseTenderProjectJuryHead juryHead, List<PurchaseTenderProjectJuryMember> juryMemberList, List<PurchaseAttachmentDTO> purchaseAttachmentList) {
        juryHead.setJuryNumber(this.invokeBaseRpcService.getNextCode("tenderJuryNumber", (Object)juryHead));
        juryHead.setHeadStatus("0");
        juryHead.setBidRepresentTotal(juryHead.getBidRepresentTotal() == null ? 0 : juryHead.getBidRepresentTotal());
        juryHead.setEvaExpertTotal(juryHead.getEvaExpertTotal() == null ? 0 : juryHead.getEvaExpertTotal());
        juryHead.setCountTotal(juryHead.getBidRepresentTotal() + juryHead.getEvaExpertTotal());
        super.setHeadDefaultValue((BaseEntity)juryHead);
        ((PurchaseTenderProjectJuryHeadMapper)this.baseMapper).insert((Object)juryHead);
        this.insertData(juryHead, juryMemberList, purchaseAttachmentList);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void updateMain(PurchaseTenderProjectJuryHead juryHead, List<PurchaseTenderProjectJuryMember> juryMemberList, List<PurchaseAttachmentDTO> purchaseAttachmentList) {
        PurchaseTenderProjectJuryHead dbJuryHead = (PurchaseTenderProjectJuryHead)((Object)this.getById((Serializable)((Object)juryHead.getId())));
        juryHead.setDataVersion(dbJuryHead.getDataVersion());
        juryHead.setBidRepresentTotal(juryHead.getBidRepresentTotal() == null ? 0 : juryHead.getBidRepresentTotal());
        juryHead.setEvaExpertTotal(juryHead.getEvaExpertTotal() == null ? 0 : juryHead.getEvaExpertTotal());
        juryHead.setCountTotal(juryHead.getBidRepresentTotal() + juryHead.getEvaExpertTotal());
        int count = ((PurchaseTenderProjectJuryHeadMapper)this.baseMapper).updateById((Object)juryHead);
        Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        this.purchaseTenderProjectJuryMemberService.deleteByMainId(juryHead.getId());
        this.purchaseTenderProjectEvaSettingHeadService.deleteBySubpackageId(juryHead.getSubpackageId());
        this.invokeBaseRpcService.deletePurchaseAttachmentByMainId(juryHead.getId());
        this.insertData(juryHead, juryMemberList, purchaseAttachmentList);
    }

    private void insertData(PurchaseTenderProjectJuryHead juryHead, List<PurchaseTenderProjectJuryMember> juryMemberList, List<PurchaseAttachmentDTO> purchaseAttachmentList) {
        if (!CollectionUtils.isEmpty(juryMemberList)) {
            for (PurchaseTenderProjectJuryMember entity : juryMemberList) {
                entity.setId(IdWorker.getIdStr());
                entity.setHeadId(juryHead.getId());
                entity.setSubpackageId(juryHead.getSubpackageId());
                entity.setTenderProjectId(juryHead.getTenderProjectId());
                entity.setConfirmStatus(PurchaseTenderJuryMemberConfirmStatusEnum.CONFIRMED.getValue());
                SysUtil.setSysParam((BaseEntity)entity, (BaseEntity)juryHead);
            }
            this.purchaseTenderProjectJuryMemberService.saveBatch(juryMemberList, 2000);
        }
        if (!purchaseAttachmentList.isEmpty()) {
            this.invokeBaseRpcService.insertPurchaseAttachmentBatchSomeColumn(purchaseAttachmentList);
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void deleteMain(String id) {
        this.purchaseTenderProjectJuryMemberService.deleteByMainId(id);
        ((PurchaseTenderProjectJuryHeadMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void deleteBatchMain(List<String> idList) {
        for (Serializable serializable : idList) {
            this.purchaseTenderProjectJuryMemberService.deleteByMainId(serializable.toString());
            ((PurchaseTenderProjectJuryHeadMapper)this.baseMapper).deleteById(serializable);
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void publish(PurchaseTenderProjectJuryHead projectJuryHead) {
        List<PurchaseTenderProjectJuryMember> juryMemberList = this.purchaseTenderProjectJuryMemberService.selectByMainId(projectJuryHead.getId());
        this.checkParams(projectJuryHead, juryMemberList);
        projectJuryHead.setHeadStatus("1");
        this.updateById((Object)projectJuryHead);
        this.saveEvaSettingHead(projectJuryHead, juryMemberList);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void saveOrUpdatePublish(PurchaseTenderProjectJuryHead purchaseTenderProjectJuryHead, List<PurchaseTenderProjectJuryMember> purchaseTenderProjectJuryMemberList, List<PurchaseAttachmentDTO> purchaseAttachmentList) {
        if (StringUtils.isBlank((CharSequence)purchaseTenderProjectJuryHead.getId())) {
            this.saveMain(purchaseTenderProjectJuryHead, purchaseTenderProjectJuryMemberList, purchaseAttachmentList);
        } else {
            this.updateMain(purchaseTenderProjectJuryHead, purchaseTenderProjectJuryMemberList, purchaseAttachmentList);
        }
        this.publish(purchaseTenderProjectJuryHead);
    }

    @Override
    public void change(PurchaseTenderProjectJuryHead purchaseTenderProjectJuryHead) {
        PurchaseTenderProjectSubpackageInfo subpackageInfo = (PurchaseTenderProjectSubpackageInfo)((Object)this.subpackageInfoService.getById((Serializable)((Object)(purchaseTenderProjectJuryHead = (PurchaseTenderProjectJuryHead)((Object)this.getById((Serializable)((Object)purchaseTenderProjectJuryHead.getId())))).getSubpackageId())));
        int subpackageStatus = subpackageInfo.getStatus() == null ? 0 : subpackageInfo.getStatus();
        boolean terminationFlag = false;
        boolean evaBeforeFlag = false;
        String tenderCheckType = TenderFlagInjectionContext.getTenderCheckType();
        if (SubpackageInfoCheckTypeEnum.PRE_TRIAL.getValue().equals(tenderCheckType)) {
            int preEvaTerminationstatus = TenderProjectSubpackageStatusEnum.PRE_BID_EVA_TERMINATION.getValue();
            terminationFlag = preEvaTerminationstatus == subpackageStatus;
            int preEndOpenBidStatus = TenderProjectSubpackageStatusEnum.PRE_END_OPEN_BID.getValue();
            evaBeforeFlag = subpackageStatus <= preEndOpenBidStatus;
        } else if (SubpackageInfoProcessTypeEnum.ONE_STEP.getValue().equals(subpackageInfo.getProcessType())) {
            int evaTerminationstatus = TenderProjectSubpackageStatusEnum.BID_EVA_TERMINATION.getValue();
            int endOpenBidStatus = TenderProjectSubpackageStatusEnum.BID_EVA_END.getValue();
            terminationFlag = evaTerminationstatus == subpackageStatus;
            evaBeforeFlag = subpackageStatus <= endOpenBidStatus;
        } else {
            int firstStepEvaTerminationstatus = TenderProjectSubpackageStatusEnum.FIRST_STEP_BID_EVA_TERMINATION.getValue();
            int resultStepEvaTerminationstatus = TenderProjectSubpackageStatusEnum.RESULT_BID_EVA_TERMINATION.getValue();
            int firstEndOpenBidStatus = TenderProjectSubpackageStatusEnum.FIRST_STEP_END_OPEN_BID.getValue();
            terminationFlag = firstStepEvaTerminationstatus == subpackageStatus || resultStepEvaTerminationstatus == subpackageStatus;
            evaBeforeFlag = subpackageStatus <= firstEndOpenBidStatus;
        }
        Assert.isTrue((terminationFlag || evaBeforeFlag ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_HAOUBPSUBsRzEIqAHULMVHW_e6fb265b", (String)"\u4ec5\u542f\u52a8\u8bc4\u6807\u524d\u6216\u8bc4\u6807\u7ec8\u6b62\u72b6\u6001\u4e0b\u53ef\u53d8\u66f4\u8bc4\u59d4\u4f1a\u4fe1\u606f\uff01"));
        purchaseTenderProjectJuryHead.setHeadStatus("0");
        this.updateById((Object)purchaseTenderProjectJuryHead);
    }

    private void saveEvaSettingHead(PurchaseTenderProjectJuryHead projectJuryHead, List<PurchaseTenderProjectJuryMember> purchaseTenderProjectJuryMemberList) {
        ArrayList evaSettingHeadList = new ArrayList();
        String tenderCheckType = TenderFlagInjectionContext.getTenderCheckType();
        PurchaseTenderProjectSubpackageInfo subpackageInfo = (PurchaseTenderProjectSubpackageInfo)((Object)this.subpackageInfoService.getById((Serializable)((Object)projectJuryHead.getSubpackageId())));
        String processType = subpackageInfo.getProcessType();
        boolean isPostTwoStepFlag = SubpackageInfoCheckTypeEnum.POST_TRIAL.getValue().equals(tenderCheckType) && SubpackageInfoProcessTypeEnum.TWO_STEP.getValue().equals(processType);
        purchaseTenderProjectJuryMemberList.stream().forEach(juryMember -> {
            PurchaseTenderProjectEvaSettingHead evaSettingHead = this.generateEvaSettingHead(projectJuryHead, processType, tenderCheckType, (PurchaseTenderProjectJuryMember)((Object)juryMember));
            if (isPostTwoStepFlag) {
                evaSettingHead.setCurrentStep(SubpackageInfoCurrentStepEnum.FIRST_STEP.getValue());
                PurchaseTenderProjectEvaSettingHead twoStepEvaSettingHead = this.generateEvaSettingHead(projectJuryHead, processType, tenderCheckType, (PurchaseTenderProjectJuryMember)((Object)juryMember));
                twoStepEvaSettingHead.setCurrentStep(SubpackageInfoCurrentStepEnum.SECOND_STEP.getValue());
                evaSettingHeadList.add(twoStepEvaSettingHead);
            }
            evaSettingHeadList.add(evaSettingHead);
        });
        this.purchaseTenderProjectEvaSettingHeadService.deleteBySubpackageId(projectJuryHead.getSubpackageId());
        this.purchaseTenderProjectEvaSettingHeadService.saveBatch(evaSettingHeadList, 1000);
    }

    private PurchaseTenderProjectEvaSettingHead generateEvaSettingHead(PurchaseTenderProjectJuryHead projectJuryHead, String tenderProcessType, String tenderCheckType, PurchaseTenderProjectJuryMember juryMember) {
        PurchaseTenderProjectEvaSettingHead evaSettingHead = new PurchaseTenderProjectEvaSettingHead();
        evaSettingHead.setElsAccount(TenantContext.getTenant());
        evaSettingHead.setJudgesElsAccount(juryMember.getElsAccount());
        evaSettingHead.setJudgesElsSubAccount(juryMember.getElsSubAccount());
        evaSettingHead.setJudgesGroupLeader("0");
        evaSettingHead.setJudgesName(juryMember.getElsRealname());
        evaSettingHead.setSubpackageId(projectJuryHead.getSubpackageId());
        evaSettingHead.setTenderProjectId(projectJuryHead.getTenderProjectId());
        evaSettingHead.setHeadStatus("0");
        evaSettingHead.setCheckType(tenderCheckType);
        evaSettingHead.setProcessType(tenderProcessType);
        evaSettingHead.setSpecialistClasses(juryMember.getSpecialistClasses());
        return evaSettingHead;
    }

    @Override
    public PurchaseTenderProjectJuryHeadVO queryByCondition(PurchaseTenderProjectJuryHead juryHead) {
        PurchaseTenderProjectJuryHeadVO headVO = new PurchaseTenderProjectJuryHeadVO();
        List<PurchaseTenderProjectJuryHead> purchaseTenderProjectJuryHeadList = ((PurchaseTenderProjectJuryHeadMapper)this.baseMapper).selectBySubpackageId(juryHead.getSubpackageId(), juryHead.getJuryType(), TenderFlagInjectionContext.getTenderCheckType());
        if (purchaseTenderProjectJuryHeadList.isEmpty()) {
            return null;
        }
        PurchaseTenderProjectJuryHead purchaseTenderProjectJuryHead = purchaseTenderProjectJuryHeadList.get(0);
        BeanUtils.copyProperties((Object)((Object)purchaseTenderProjectJuryHead), (Object)((Object)headVO));
        List<PurchaseTenderProjectJuryMember> juryMemberList = this.purchaseTenderProjectJuryMemberService.selectByMainId(purchaseTenderProjectJuryHead.getId());
        headVO.setPurchaseTenderProjectJuryMemberList(juryMemberList);
        return headVO;
    }

    private void checkParams(PurchaseTenderProjectJuryHead purchaseTenderProjectJuryHead, List<PurchaseTenderProjectJuryMember> purchaseTenderProjectJuryMemberList) {
        Assert.hasText((String)purchaseTenderProjectJuryHead.getJuryName(), (String)I18nUtil.translate((String)"i18n_alert_ULMRLxOLVW_5c6926a4", (String)"\u8bc4\u59d4\u4f1a\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a!"));
        Assert.hasText((String)purchaseTenderProjectJuryHead.getJuryType(), (String)I18nUtil.translate((String)"i18n_alert_ULMAcxOLVW_5f7a2fd7", (String)"\u8bc4\u59d4\u4f1a\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a!"));
        Assert.hasText((String)purchaseTenderProjectJuryHead.getContacts(), (String)I18nUtil.translate((String)"i18n_alert_KHLxOLVW_eddf217e", (String)"\u8054\u7cfb\u4eba\u4e0d\u80fd\u4e3a\u7a7a!"));
        Assert.hasText((String)purchaseTenderProjectJuryHead.getContactsPhone(), (String)I18nUtil.translate((String)"i18n_alert_KHCKxOLVW_96ec9654", (String)"\u8054\u7cfb\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a!"));
        Assert.hasText((String)purchaseTenderProjectJuryHead.getBidEvaAddress(), (String)I18nUtil.translate((String)"i18n_alert_UBnCxOLVW_9892605", (String)"\u8bc4\u6807\u5730\u70b9\u4e0d\u80fd\u4e3a\u7a7a!"));
        Assert.isTrue((purchaseTenderProjectJuryHead.getBidRepresentTotal() > 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_YBLoBLWxOXUEUWW_f0c170ce", (String)"\u62db\u6807\u4eba\u4ee3\u8868\u4eba\u6570\u4e0d\u80fd\u5c0f\u4e8e\u7b49\u4e8e0!"));
        Assert.isTrue((purchaseTenderProjectJuryHead.getEvaExpertTotal() > 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_UBsuxOXUEUWW_7c95cc8b", (String)"\u8bc4\u6807\u4e13\u5bb6\u4e0d\u80fd\u5c0f\u4e8e\u7b49\u4e8e0!"));
        Assert.isTrue(((purchaseTenderProjectJuryHead.getEvaExpertTotal() + purchaseTenderProjectJuryHead.getBidRepresentTotal() & 1) == 1 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_UBknLWxOLKWWVImW_99bc0637", (String)"\u8bc4\u6807\u603b\u548c\u4eba\u6570\u4e0d\u80fd\u4e3a\u5076\u6570,\u8bf7\u68c0\u67e5!"));
        Long tenderAdminCount = purchaseTenderProjectJuryMemberList.stream().filter(juryMember -> juryMember.getMemberType().equals(PurchaseTenderJuryMemberTypeEnum.TENDER_ADMIN.getValue())).count();
        Long evaluationExpertsCount = purchaseTenderProjectJuryMemberList.stream().filter(juryMember -> juryMember.getMemberType().equals(PurchaseTenderJuryMemberTypeEnum.EVALUATION_EXPERTS.getValue())).count();
        Assert.isTrue((boolean)tenderAdminCount.equals(purchaseTenderProjectJuryHead.getBidRepresentTotal().longValue()), (String)I18nUtil.translate((String)"i18n_alert_YBLoBLWxBWVImW_a9d865ef", (String)"\u62db\u6807\u4eba\u4ee3\u8868\u4eba\u6570\u4e0d\u7b26,\u8bf7\u68c0\u67e5!"));
        Assert.isTrue((boolean)evaluationExpertsCount.equals(purchaseTenderProjectJuryHead.getEvaExpertTotal().longValue()), (String)I18nUtil.translate((String)"i18n_alert_suLWxBWVImW_9dec25ff", (String)"\u4e13\u5bb6\u4eba\u6570\u4e0d\u7b26,\u8bf7\u68c0\u67e5!"));
        List dupList = purchaseTenderProjectJuryMemberList.stream().collect(Collectors.groupingBy(juryMember -> juryMember.getElsAccount() + "_" + juryMember.getElsSubAccount(), Collectors.counting())).entrySet().stream().filter(e -> (Long)e.getValue() > 1L).map(Map.Entry::getKey).collect(Collectors.toList());
        Assert.isTrue((boolean)dupList.isEmpty(), (String)I18nUtil.translate((String)"i18n__ULMLjsMKVBjjDVHWVVVAtSDJW_479b5bfe", (String)"\u8bc4\u59d4\u4f1a\u6210\u5458\u4e2d\u5b58\u5728\u91cd\u590d\u7684\u7528\u6237\u4fe1\u606f\uff0c\u8bf7\u91cd\u65b0\u7f16\u8f91\u540e\u63d0\u4ea4!"));
        if (CollectionUtil.isNotEmpty(purchaseTenderProjectJuryMemberList)) {
            for (PurchaseTenderProjectJuryMember purchaseTenderProjectJuryMember : purchaseTenderProjectJuryMemberList) {
                String userType = "0".equals(purchaseTenderProjectJuryMember.getMemberType()) ? PurchaseTenderJuryMemberTypeEnum.TENDER_ADMIN.getDesc() : PurchaseTenderJuryMemberTypeEnum.EVALUATION_EXPERTS.getDesc();
                Assert.hasText((String)purchaseTenderProjectJuryMember.getElsRealname(), (String)I18nUtil.translate((String)"i18n_alert_WWWWWWscRxOLVW_dd00ce8", (String)"[${0}]\u4e2d\u59d3\u540d\u4e0d\u80fd\u4e3a\u7a7a!", (String[])new String[]{userType}));
                if (StringUtils.isBlank((CharSequence)purchaseTenderProjectJuryMember.getPhone())) {
                    throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_WWWWWWWWWWWWltyxOLVW_d8101bc6", (String)"[${0}][${1}]\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a!", (String[])new String[]{userType, purchaseTenderProjectJuryMember.getElsRealname()}));
                }
                if (StringUtils.isBlank((CharSequence)purchaseTenderProjectJuryMember.getCertificateType())) {
                    throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_WWWWWWWWWWWWiIAcxOLVW_7e88740f", (String)"[${0}][${1}]\u8bc1\u4ef6\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a!", (String[])new String[]{userType, purchaseTenderProjectJuryMember.getElsRealname()}));
                }
                if (!StringUtils.isBlank((CharSequence)purchaseTenderProjectJuryMember.getCertificateNumber())) continue;
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_WWWWWWWWWWWWiIyxOLVW_2754ac4c", (String)"[${0}][${1}]\u8bc1\u4ef6\u53f7\u4e0d\u80fd\u4e3a\u7a7a!", (String[])new String[]{userType, purchaseTenderProjectJuryMember.getElsRealname()}));
            }
        }
    }
}

