/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.tender.openbid.job;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.els.common.api.service.JobRpcService;
import com.els.common.util.DateUtils;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.tender.common.aspect.TenderFlagInjectionContext;
import com.els.modules.tender.common.utils.OpenBidRecordLogUtils;
import com.els.modules.tender.common.utils.TenderOperationFieldUtils;
import com.els.modules.tender.openbid.enumerate.PurchaseOpenBidStatusEnum;
import com.els.modules.tender.openbid.job.TenderJobUtil;
import com.els.modules.tender.project.entity.PurchaseTenderProjectSubpackageInfo;
import com.els.modules.tender.project.service.PurchaseTenderProjectSubpackageInfoService;
import com.els.modules.tender.project.vo.PurchaseTenderProjectOpenInfoHeadVO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTenderOpenBidDecryptAlertJobService
implements JobRpcService {
    private static final Logger log = LoggerFactory.getLogger(AbstractTenderOpenBidDecryptAlertJobService.class);

    public void doExecute(String parameter) {
        log.info(" \u62db\u6807\u89e3\u5bc6\u5012\u8ba1\u65f6\u5b9a\u65f6\u4efb\u52a1 tenderOpenBidDecryptAlertJobServiceImpl \u5f00\u59cb\u6267\u884c\u65f6\u95f4:" + DateUtils.getTimestamp() + parameter);
        if (StrUtil.isEmpty((CharSequence)parameter)) {
            log.error("parameter must not be null.");
            return;
        }
        JSONObject paramObj = JSONObject.parseObject((String)parameter);
        String id = paramObj.getString("id");
        String checkType = paramObj.getString("checkType");
        String processType = paramObj.getString("processType");
        String currentStep = paramObj.getString("currentStep");
        if (StrUtil.isEmpty((CharSequence)id) || StrUtil.isEmpty((CharSequence)checkType)) {
            log.error("parameter must contain {}.{}.{}.{}", new Object[]{id, checkType, processType, currentStep});
            return;
        }
        TenderFlagInjectionContext.setTenderCheckType(checkType);
        TenderFlagInjectionContext.setTenderProcessType(processType);
        TenderFlagInjectionContext.setTenderCurrentStep(currentStep);
        PurchaseTenderProjectSubpackageInfoService subpackageInfoService = (PurchaseTenderProjectSubpackageInfoService)SpringContextUtils.getBean(PurchaseTenderProjectSubpackageInfoService.class);
        PurchaseTenderProjectOpenInfoHeadVO openInfoHeadVO = subpackageInfoService.queryOpenInfoById(id);
        PurchaseTenderProjectSubpackageInfo subpackageInfo = (PurchaseTenderProjectSubpackageInfo)((Object)SysUtil.copyProperties((Object)((Object)openInfoHeadVO), PurchaseTenderProjectSubpackageInfo.class));
        String openBidStatus = TenderOperationFieldUtils.getOpenBidStatus((Object)subpackageInfo);
        TenderOperationFieldUtils.setDecryptedSubpackageStatus((Object)subpackageInfo);
        TenantContext.setTenant((String)subpackageInfo.getElsAccount());
        if (PurchaseOpenBidStatusEnum.DECRYPTING.getValue().equals(openBidStatus)) {
            TenderOperationFieldUtils.setOpenBidStatus((Object)subpackageInfo, PurchaseOpenBidStatusEnum.DECRYPTED.getValue());
            subpackageInfoService.updateOpenBidStatus(subpackageInfo);
            OpenBidRecordLogUtils.saveRecordMsg(openInfoHeadVO, "\u89e3\u5bc6\u73af\u8282\u7ed3\u675f");
        }
        String jobKey = paramObj.getString("jobKey");
        TenderJobUtil.deleteJob(jobKey);
        log.info(" \u62db\u6807\u5f00\u6807\u9884\u8b66\u5b9a\u65f6\u4efb\u52a1 tenderOpenBidAlertJobServiceImpl \u6267\u884c\u5b8c\u6210\u65f6\u95f4:" + DateUtils.getTimestamp() + parameter);
    }
}

