/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.tender.sale.controller;

import cn.hutool.core.collection.CollectionUtil;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.tender.common.aspect.TenderFlagInjectionContext;
import com.els.modules.tender.evaluation.entity.TenderEvaQuotedPriceHead;
import com.els.modules.tender.evaluation.entity.TenderEvaQuotedPriceItem;
import com.els.modules.tender.evaluation.enumerate.TenderEvaQuotedPriceItemStatusEnum;
import com.els.modules.tender.evaluation.service.TenderEvaQuotedPriceHeadService;
import com.els.modules.tender.evaluation.service.TenderEvaQuotedPriceItemService;
import com.els.modules.tender.evaluation.vo.TenderEvaQuotedPriceItemVO;
import com.els.modules.tender.sale.service.SaleTenderPriceOpeningsService;
import com.els.modules.tender.sale.vo.SaleTenderBidLetterVo;
import com.els.modules.tender.sale.vo.SaleTenderQuotedPriceDetailInfoVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/tender/sale/tenderEvaQuotedPriceHead"})
@Api(tags={"\u4f9b\u5e94\u5546\u591a\u8f6e\u62a5\u4ef7"})
public class SaleTenderEvaQuotedPriceHeadController
extends BaseController<TenderEvaQuotedPriceHead, TenderEvaQuotedPriceHeadService> {
    private static final Logger log = LoggerFactory.getLogger(SaleTenderEvaQuotedPriceHeadController.class);
    @Autowired
    private TenderEvaQuotedPriceHeadService tenderEvaQuotedPriceHeadService;
    @Autowired
    private TenderEvaQuotedPriceItemService tenderEvaQuotedPriceItemService;
    @Autowired
    private SaleTenderPriceOpeningsService saleTenderPriceOpeningsService;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    public Result<?> queryList(@RequestParam(name="subpackageId") String subpackageId) {
        TenderEvaQuotedPriceItem queryQuotedPriceItem = new TenderEvaQuotedPriceItem();
        queryQuotedPriceItem.setSubpackageId(subpackageId);
        queryQuotedPriceItem.setSupplierAccount(TenantContext.getTenant());
        List<TenderEvaQuotedPriceItem> tenderEvaQuotedPriceItems = this.tenderEvaQuotedPriceItemService.selectBySubpackageId(queryQuotedPriceItem);
        if (CollectionUtil.isEmpty(tenderEvaQuotedPriceItems)) {
            return Result.ok(null);
        }
        List mainIds = tenderEvaQuotedPriceItems.stream().map(TenderEvaQuotedPriceItem::getHeadId).collect(Collectors.toList());
        List<TenderEvaQuotedPriceHead> tenderEvaQuotedPriceHeads = this.tenderEvaQuotedPriceHeadService.selectBatchIds(mainIds);
        Map evaQuotedPriceHeadMap = tenderEvaQuotedPriceHeads.stream().collect(Collectors.toMap(BaseEntity::getId, Function.identity()));
        ArrayList<SaleTenderQuotedPriceDetailInfoVO> detailInfoVOS = new ArrayList<SaleTenderQuotedPriceDetailInfoVO>();
        for (TenderEvaQuotedPriceItem tenderEvaQuotedPriceItem : tenderEvaQuotedPriceItems) {
            SaleTenderQuotedPriceDetailInfoVO detailInfoVO = new SaleTenderQuotedPriceDetailInfoVO();
            TenderEvaQuotedPriceHead tenderEvaQuotedPriceHead = (TenderEvaQuotedPriceHead)((Object)evaQuotedPriceHeadMap.get(tenderEvaQuotedPriceItem.getHeadId()));
            detailInfoVO.setQuotedPriceHeadId(tenderEvaQuotedPriceHead.getId());
            detailInfoVO.setEvaInfoId(tenderEvaQuotedPriceHead.getEvaInfoId());
            detailInfoVO.setStage(tenderEvaQuotedPriceHead.getStage());
            detailInfoVO.setQuotedPriceEndTime(tenderEvaQuotedPriceHead.getQuotedPriceEndTime());
            detailInfoVO.setProcessType(tenderEvaQuotedPriceHead.getProcessType());
            detailInfoVO.setCurrentStep(tenderEvaQuotedPriceHead.getCurrentStep());
            detailInfoVO.setQuotedPriceItemId(tenderEvaQuotedPriceItem.getId());
            detailInfoVO.setSubpackageId(tenderEvaQuotedPriceItem.getSubpackageId());
            detailInfoVO.setSupplierAccount(tenderEvaQuotedPriceItem.getSupplierAccount());
            detailInfoVO.setSupplierName(tenderEvaQuotedPriceItem.getSupplierName());
            detailInfoVO.setQuotedPriceTime(tenderEvaQuotedPriceItem.getQuotedPriceTime());
            detailInfoVO.setStatus(tenderEvaQuotedPriceItem.getStatus());
            detailInfoVOS.add(detailInfoVO);
        }
        return Result.ok(detailInfoVOS);
    }

    @ApiOperation(value="\u4f9b\u5e94\u5546\u591a\u8f6e\u62a5\u4ef7\u67e5\u8be2", notes="\u4f9b\u5e94\u5546\u591a\u8f6e\u62a5\u4ef7\u67e5\u8be2")
    @GetMapping(value={"/queryQuotedPriceInfo"})
    public Result<?> queryQuotedPriceInfo(@RequestParam(name="quotedPriceItemId") String quotedPriceItemId) {
        TenderEvaQuotedPriceItem tenderEvaQuotedPriceItem = (TenderEvaQuotedPriceItem)((Object)this.tenderEvaQuotedPriceItemService.getById((Serializable)((Object)quotedPriceItemId)));
        if (tenderEvaQuotedPriceItem == null) {
            return Result.ok();
        }
        TenderEvaQuotedPriceHead tenderEvaQuotedPriceHead = (TenderEvaQuotedPriceHead)((Object)this.tenderEvaQuotedPriceHeadService.getById((Serializable)((Object)tenderEvaQuotedPriceItem.getHeadId())));
        TenderFlagInjectionContext.setTenderCheckType("1");
        TenderFlagInjectionContext.setTenderProcessType(tenderEvaQuotedPriceHead.getProcessType());
        TenderFlagInjectionContext.setTenderCurrentStep(tenderEvaQuotedPriceHead.getCurrentStep());
        List<SaleTenderBidLetterVo> saleTenderBidLetterVos = TenderEvaQuotedPriceItemStatusEnum.NOT_EVA_QUOTED_PRICE.getValue().equals(tenderEvaQuotedPriceItem.getStatus()) ? this.saleTenderPriceOpeningsService.queryQuotedPriceInfo(tenderEvaQuotedPriceItem.getSubpackageId()) : this.saleTenderPriceOpeningsService.selectByQuotedPriceItemId(tenderEvaQuotedPriceItem);
        TenderEvaQuotedPriceItemVO tenderEvaQuotedPriceItemVO = (TenderEvaQuotedPriceItemVO)((Object)SysUtil.copyProperties((Object)((Object)tenderEvaQuotedPriceItem), TenderEvaQuotedPriceItemVO.class));
        tenderEvaQuotedPriceItemVO.setSaleTenderBidLetterVos(saleTenderBidLetterVos);
        return Result.ok((Object)((Object)tenderEvaQuotedPriceItemVO));
    }

    @ApiOperation(value="\u4f9b\u5e94\u5546\u62a5\u4ef7", notes="\u4f9b\u5e94\u5546\u62a5\u4ef7")
    @PostMapping(value={"/addQuotedPriceInfo"})
    public Result<?> addQuotedPriceInfo(@RequestBody TenderEvaQuotedPriceItemVO tenderEvaQuotedPriceItemVO) {
        this.tenderEvaQuotedPriceHeadService.addQuotedPriceInfo(tenderEvaQuotedPriceItemVO);
        return this.commonSuccessResult(3);
    }

    @AutoLog(busModule="\u64a4\u9500\u4f9b\u5e94\u5546\u62a5\u4ef7", value="\u64a4\u9500\u4f9b\u5e94\u5546\u62a5\u4ef7")
    @ApiOperation(value="\u64a4\u9500\u4f9b\u5e94\u5546\u62a5\u4ef7", notes="\u64a4\u9500\u4f9b\u5e94\u5546\u62a5\u4ef7")
    @GetMapping(value={"/revokeQuotedPriceInfo"})
    public Result<?> revokeSave(@RequestParam(name="quotedPriceItemId") String quotedPriceItemId) {
        this.tenderEvaQuotedPriceHeadService.revokeQuotedPriceInfo(quotedPriceItemId);
        return this.commonSuccessResult(3);
    }
}

