/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.tender.supplier.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.els.common.constant.CommonConstant;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.common.vo.CountVO;
import com.els.modules.base.api.dto.SaleAttachmentDTO;
import com.els.modules.tender.notice.entity.PurchaseTenderNoticeHead;
import com.els.modules.tender.notice.entity.PurchaseTenderNoticeItem;
import com.els.modules.tender.notice.entity.PurchaseTenderSupplierInvitation;
import com.els.modules.tender.notice.enumerate.PurchaseTenderNoticeStatusEnum;
import com.els.modules.tender.notice.service.PurchaseTenderNoticeHeadService;
import com.els.modules.tender.project.entity.PurchaseTenderProjectHead;
import com.els.modules.tender.project.service.PurchaseTenderProjectHeadService;
import com.els.modules.tender.sale.enumerate.TenderInvitationSupplierReceiptSourceTypeEnum;
import com.els.modules.tender.sale.enumerate.TenderInvitationSupplierReceiptStatusEnum;
import com.els.modules.tender.sale.vo.TenderInvitationSupplierReceiptVO;
import com.els.modules.tender.supplier.entity.TenderInvitationSupplierReceipt;
import com.els.modules.tender.supplier.entity.TenderProjectSupplier;
import com.els.modules.tender.supplier.mapper.TenderInvitationSupplierReceiptMapper;
import com.els.modules.tender.supplier.service.TenderInvitationSupplierReceiptService;
import com.els.modules.tender.supplier.service.TenderProjectSupplierService;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class TenderInvitationSupplierReceiptServiceImpl
extends BaseServiceImpl<TenderInvitationSupplierReceiptMapper, TenderInvitationSupplierReceipt>
implements TenderInvitationSupplierReceiptService {
    @Autowired
    private PurchaseTenderProjectHeadService purchaseTenderProjectHeadService;
    @Autowired
    @Lazy
    private PurchaseTenderNoticeHeadService purchaseTenderNoticeHeadService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Autowired
    @Lazy
    private TenderProjectSupplierService tenderProjectSupplierService;

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void addBatch(List<TenderInvitationSupplierReceipt> tenderInvitationSupplierReceiptList) {
        Assert.isTrue((boolean)CollectionUtil.isNotEmpty(tenderInvitationSupplierReceiptList), (String)I18nUtil.translate((String)"", (String)"\u975e\u6cd5\u64cd\u4f5c"));
        String subpackageId = tenderInvitationSupplierReceiptList.get(0).getSubpackageId();
        TenderInvitationSupplierReceipt queryInvitationSupplierReceipt = new TenderInvitationSupplierReceipt();
        queryInvitationSupplierReceipt.setSubpackageId(subpackageId);
        List<TenderInvitationSupplierReceipt> tenderInvitationSupplierReceipts = ((TenderInvitationSupplierReceiptMapper)this.baseMapper).selectBySubpackageId(queryInvitationSupplierReceipt);
        List<Object> supplierAccounts = new ArrayList();
        if (CollectionUtil.isNotEmpty(tenderInvitationSupplierReceipts)) {
            supplierAccounts = tenderInvitationSupplierReceipts.stream().map(TenderInvitationSupplierReceipt::getSupplierAccount).distinct().collect(Collectors.toList());
        }
        Set<String> projectIds = tenderInvitationSupplierReceiptList.stream().map(TenderInvitationSupplierReceipt::getTenderProjectId).collect(Collectors.toSet());
        List<PurchaseTenderProjectHead> purchaseTenderProjectHeads = this.purchaseTenderProjectHeadService.selectBatchIds(projectIds);
        Map<String, PurchaseTenderProjectHead> projectHeadMap = purchaseTenderProjectHeads.stream().collect(Collectors.toMap(BaseEntity::getId, projectHead -> projectHead, (o1, o2) -> o1));
        for (TenderInvitationSupplierReceipt tenderInvitationSupplierReceipt : tenderInvitationSupplierReceiptList) {
            Assert.isTrue((!supplierAccounts.contains(tenderInvitationSupplierReceipt.getSupplierAccount()) ? 1 : 0) != 0, (String)I18nUtil.translate((String)"", (String)String.format("\u4f9b\u5e94\u5546\u3010%s\u3011\u5df2\u5b58\u5728\uff0c\u4e0d\u53ef\u91cd\u590d\u9080\u8bf7\uff01", tenderInvitationSupplierReceipt.getSupplierName())));
            tenderInvitationSupplierReceipt.setElsAccount(tenderInvitationSupplierReceipt.getSupplierAccount());
            PurchaseTenderProjectHead projectHead2 = projectHeadMap.get(tenderInvitationSupplierReceipt.getTenderProjectId());
            tenderInvitationSupplierReceipt.setTenderProjectName(projectHead2.getTenderProjectName());
            tenderInvitationSupplierReceipt.setTenderProjectNumber(projectHead2.getTenderProjectNumber());
            tenderInvitationSupplierReceipt.setPurchaseEnterpriseName(projectHead2.getPurchaseEnterpriseName());
            tenderInvitationSupplierReceipt.setPurchaseEnterpriseAccount(projectHead2.getElsAccount());
        }
        this.saveBatch(tenderInvitationSupplierReceiptList, 2000);
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void addBatchByNotice(List<PurchaseTenderNoticeItem> purchaseTenderNoticeItemList, List<PurchaseTenderSupplierInvitation> purchaseTenderSupplierInvitationList) {
        ArrayList<TenderInvitationSupplierReceipt> tenderInvitationSupplierReceiptList = new ArrayList<TenderInvitationSupplierReceipt>();
        for (PurchaseTenderNoticeItem purchaseTenderNoticeItem : purchaseTenderNoticeItemList) {
            for (PurchaseTenderSupplierInvitation purchaseTenderSupplierInvitation : purchaseTenderSupplierInvitationList) {
                TenderInvitationSupplierReceipt tenderInvitationSupplierReceipt = new TenderInvitationSupplierReceipt();
                tenderInvitationSupplierReceipt.setReceiptStatus(TenderInvitationSupplierReceiptStatusEnum.NOT_CONFIRM.getValue());
                tenderInvitationSupplierReceipt.setSupplierAccount(purchaseTenderSupplierInvitation.getSupplierAccount());
                tenderInvitationSupplierReceipt.setSupplierName(purchaseTenderSupplierInvitation.getSupplierName());
                tenderInvitationSupplierReceipt.setSubpackageId(purchaseTenderNoticeItem.getSubpackageId());
                tenderInvitationSupplierReceipt.setTenderProjectId(purchaseTenderNoticeItem.getTenderProjectId());
                tenderInvitationSupplierReceipt.setContacts(purchaseTenderSupplierInvitation.getContacts());
                tenderInvitationSupplierReceipt.setContactsPhone(purchaseTenderSupplierInvitation.getContactsPhone());
                tenderInvitationSupplierReceipt.setSourceType(TenderInvitationSupplierReceiptSourceTypeEnum.ON_LINE.getValue());
                tenderInvitationSupplierReceipt.setSubpackageName(purchaseTenderNoticeItem.getSubpackageName());
                tenderInvitationSupplierReceiptList.add(tenderInvitationSupplierReceipt);
            }
        }
        this.addBatch(tenderInvitationSupplierReceiptList);
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void delete(String id) {
        TenderInvitationSupplierReceipt tenderInvitationSupplierReceipt = (TenderInvitationSupplierReceipt)((Object)((TenderInvitationSupplierReceiptMapper)this.baseMapper).selectById((Serializable)((Object)id)));
        Assert.notNull((Object)((Object)tenderInvitationSupplierReceipt), (String)I18nUtil.translate((String)"", (String)"\u975e\u6cd5\u64cd\u4f5c"));
        Assert.isTrue((boolean)TenderInvitationSupplierReceiptStatusEnum.NEW.getValue().equals(tenderInvitationSupplierReceipt.getReceiptStatus()), (String)I18nUtil.translate((String)"", (String)"\u5f53\u524d\u72b6\u6001\u4e0d\u5141\u8bb8\u5220\u9664"));
        ((TenderInvitationSupplierReceiptMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public TenderInvitationSupplierReceiptVO queryById(String id) {
        TenderInvitationSupplierReceipt invitationSupplierReceipt = (TenderInvitationSupplierReceipt)((Object)((TenderInvitationSupplierReceiptMapper)this.baseMapper).selectById((Serializable)((Object)id)));
        if (invitationSupplierReceipt == null) {
            return null;
        }
        TenderInvitationSupplierReceiptVO invitationSupplierReceiptVO = (TenderInvitationSupplierReceiptVO)((Object)SysUtil.copyProperties((Object)((Object)invitationSupplierReceipt), TenderInvitationSupplierReceiptVO.class));
        List<PurchaseTenderNoticeHead> noticeHeadList = this.purchaseTenderNoticeHeadService.queryNoticeHeadBySubpackageId(invitationSupplierReceiptVO.getSubpackageId(), null, null);
        PurchaseTenderNoticeHead purchaseTenderNoticeHead = noticeHeadList.stream().filter(noticeHead -> !PurchaseTenderNoticeStatusEnum.NEW.getValue().equals(noticeHead.getNoticeStatus())).max(Comparator.comparing(PurchaseTenderNoticeHead::getPublishTime)).get();
        invitationSupplierReceiptVO.setNoticeContent(purchaseTenderNoticeHead.getNoticeContent());
        List attachmentDTOS = this.invokeBaseRpcService.selectSaleAttachmentByMainId(id);
        invitationSupplierReceiptVO.setAttachmentDTOList(attachmentDTOS);
        return invitationSupplierReceiptVO;
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void publish(String id) {
        TenderInvitationSupplierReceipt tenderInvitationSupplierReceipt = (TenderInvitationSupplierReceipt)((Object)((TenderInvitationSupplierReceiptMapper)this.baseMapper).selectById((Serializable)((Object)id)));
        Assert.notNull((Object)((Object)tenderInvitationSupplierReceipt), (String)I18nUtil.translate((String)"", (String)"\u975e\u6cd5\u64cd\u4f5c"));
        Assert.isTrue((boolean)TenderInvitationSupplierReceiptStatusEnum.NEW.getValue().equals(tenderInvitationSupplierReceipt.getReceiptStatus()), (String)I18nUtil.translate((String)"", (String)"\u5f53\u524d\u72b6\u6001\u4e0d\u5141\u8bb8\u53d1\u5e03"));
        tenderInvitationSupplierReceipt.setReceiptStatus(TenderInvitationSupplierReceiptStatusEnum.NOT_CONFIRM.getValue());
        ((TenderInvitationSupplierReceiptMapper)this.baseMapper).updateById((Object)tenderInvitationSupplierReceipt);
        TenderProjectSupplier querySupplier = new TenderProjectSupplier();
        querySupplier.setSupplierAccount(tenderInvitationSupplierReceipt.getSupplierAccount()).setSubpackageId(tenderInvitationSupplierReceipt.getSubpackageId());
        List<TenderProjectSupplier> tenderProjectSuppliers = this.tenderProjectSupplierService.selectBySubpackageId(querySupplier, false);
        if (CollectionUtil.isEmpty(tenderProjectSuppliers)) {
            TenderProjectSupplier supplier = new TenderProjectSupplier();
            supplier.setPurchaseEnterpriseAccount(tenderInvitationSupplierReceipt.getPurchaseEnterpriseAccount());
            supplier.setPurchaseEnterpriseName(tenderInvitationSupplierReceipt.getPurchaseEnterpriseName());
            supplier.setSupplierAccount(tenderInvitationSupplierReceipt.getSupplierAccount());
            supplier.setSupplierSubAccount("1001");
            supplier.setSupplierName(tenderInvitationSupplierReceipt.getSupplierName());
            supplier.setSubpackageId(tenderInvitationSupplierReceipt.getSubpackageId());
            supplier.setSubpackageName(tenderInvitationSupplierReceipt.getSubpackageName());
            supplier.setTenderProjectId(tenderInvitationSupplierReceipt.getTenderProjectId());
            supplier.setTenderProjectNumber(tenderInvitationSupplierReceipt.getTenderProjectNumber());
            supplier.setTenderProjectName(tenderInvitationSupplierReceipt.getTenderProjectName());
            supplier.setSourceType(tenderInvitationSupplierReceipt.getSourceType());
            supplier.setEffective("0");
            supplier.setInviteQuotedPriceStatus("0");
            this.tenderProjectSupplierService.add(supplier);
        }
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public TenderInvitationSupplierReceipt edit(TenderInvitationSupplierReceiptVO tenderInvitationSupplierReceiptVO) {
        TenderInvitationSupplierReceipt tenderInvitationSupplierReceipt = (TenderInvitationSupplierReceipt)((Object)((TenderInvitationSupplierReceiptMapper)this.baseMapper).selectById((Serializable)((Object)tenderInvitationSupplierReceiptVO.getId())));
        Assert.notNull((Object)((Object)tenderInvitationSupplierReceipt), (String)I18nUtil.translate((String)"", (String)"\u975e\u6cd5\u64cd\u4f5c"));
        Assert.isTrue((boolean)TenderInvitationSupplierReceiptStatusEnum.NOT_CONFIRM.getValue().equals(tenderInvitationSupplierReceipt.getReceiptStatus()), (String)I18nUtil.translate((String)"", (String)"\u5f53\u524d\u72b6\u6001\u4e0d\u5141\u8bb8\u4fdd\u5b58"));
        this.updateInvitationSupplierReceipt(tenderInvitationSupplierReceiptVO, tenderInvitationSupplierReceipt);
        return tenderInvitationSupplierReceipt;
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public TenderInvitationSupplierReceipt comfirm(TenderInvitationSupplierReceiptVO tenderInvitationSupplierReceiptVO) {
        Assert.hasText((String)tenderInvitationSupplierReceiptVO.getReceiptPhone(), (String)I18nUtil.translate((String)"", (String)"\u56de\u6267\u7535\u8bdd\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        Assert.hasText((String)tenderInvitationSupplierReceiptVO.getReceiptPerson(), (String)I18nUtil.translate((String)"", (String)"\u56de\u6267\u4eba\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        TenderInvitationSupplierReceipt tenderInvitationSupplierReceipt = (TenderInvitationSupplierReceipt)((Object)((TenderInvitationSupplierReceiptMapper)this.baseMapper).selectById((Serializable)((Object)tenderInvitationSupplierReceiptVO.getId())));
        Assert.notNull((Object)((Object)tenderInvitationSupplierReceipt), (String)I18nUtil.translate((String)"", (String)"\u975e\u6cd5\u64cd\u4f5c"));
        Assert.isTrue((boolean)TenderInvitationSupplierReceiptStatusEnum.NOT_CONFIRM.getValue().equals(tenderInvitationSupplierReceipt.getReceiptStatus()), (String)I18nUtil.translate((String)"", (String)"\u5f53\u524d\u72b6\u6001\u4e0d\u5141\u8bb8\u786e\u8ba4"));
        tenderInvitationSupplierReceipt.setReceiptStatus(TenderInvitationSupplierReceiptStatusEnum.CONFIRM.getValue());
        tenderInvitationSupplierReceipt.setReceiptTime(new Date());
        this.updateInvitationSupplierReceipt(tenderInvitationSupplierReceiptVO, tenderInvitationSupplierReceipt);
        TenderProjectSupplier querySupplier = new TenderProjectSupplier();
        querySupplier.setSupplierAccount(tenderInvitationSupplierReceipt.getSupplierAccount()).setSubpackageId(tenderInvitationSupplierReceipt.getSubpackageId());
        List<TenderProjectSupplier> tenderProjectSuppliers = this.tenderProjectSupplierService.selectBySubpackageId(querySupplier, false);
        if (CollectionUtil.isEmpty(tenderProjectSuppliers)) {
            return tenderInvitationSupplierReceipt;
        }
        TenderProjectSupplier supplier = tenderProjectSuppliers.get(0);
        if (CommonConstant.STATUS_YES.equals(supplier.getEffective())) {
            return tenderInvitationSupplierReceipt;
        }
        this.tenderProjectSupplierService.updateEffectiveById(supplier.getId(), "1");
        return tenderInvitationSupplierReceipt;
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public TenderInvitationSupplierReceipt reject(String id) {
        TenderInvitationSupplierReceipt tenderInvitationSupplierReceipt = (TenderInvitationSupplierReceipt)((Object)((TenderInvitationSupplierReceiptMapper)this.baseMapper).selectById((Serializable)((Object)id)));
        Assert.notNull((Object)((Object)tenderInvitationSupplierReceipt), (String)I18nUtil.translate((String)"", (String)"\u975e\u6cd5\u64cd\u4f5c"));
        Assert.isTrue((boolean)TenderInvitationSupplierReceiptStatusEnum.NOT_CONFIRM.getValue().equals(tenderInvitationSupplierReceipt.getReceiptStatus()), (String)I18nUtil.translate((String)"", (String)"\u5f53\u524d\u72b6\u6001\u4e0d\u5141\u62d2\u7edd\u53c2\u52a0"));
        tenderInvitationSupplierReceipt.setReceiptStatus(TenderInvitationSupplierReceiptStatusEnum.REJECT.getValue());
        ((TenderInvitationSupplierReceiptMapper)this.baseMapper).updateById((Object)tenderInvitationSupplierReceipt);
        return tenderInvitationSupplierReceipt;
    }

    @Override
    public List<TenderInvitationSupplierReceipt> selectBySubpackageId(TenderInvitationSupplierReceipt tenderInvitationSupplierReceipt) {
        return ((TenderInvitationSupplierReceiptMapper)this.baseMapper).selectBySubpackageId(tenderInvitationSupplierReceipt);
    }

    private void updateInvitationSupplierReceipt(TenderInvitationSupplierReceiptVO tenderInvitationSupplierReceiptVO, TenderInvitationSupplierReceipt tenderInvitationSupplierReceipt) {
        tenderInvitationSupplierReceipt.setReceiptPerson(tenderInvitationSupplierReceiptVO.getReceiptPerson());
        tenderInvitationSupplierReceipt.setReceiptPhone(tenderInvitationSupplierReceiptVO.getReceiptPhone());
        tenderInvitationSupplierReceipt.setRemark(tenderInvitationSupplierReceiptVO.getRemark());
        ((TenderInvitationSupplierReceiptMapper)this.baseMapper).updateById((Object)tenderInvitationSupplierReceipt);
        this.invokeBaseRpcService.deleteSaleAttachmentByMainId(tenderInvitationSupplierReceiptVO.getId());
        List<SaleAttachmentDTO> attachmentDTOList = tenderInvitationSupplierReceiptVO.getAttachmentDTOList();
        if (CollectionUtil.isNotEmpty(attachmentDTOList)) {
            attachmentDTOList.parallelStream().forEach(attachment -> attachment.setHeadId(tenderInvitationSupplierReceiptVO.getId()));
            this.invokeBaseRpcService.insertSaleAttachmentBatchSomeColumn(attachmentDTOList);
        }
    }

    @Override
    public List<CountVO> queryTabsCount(String elsAccount) {
        return ((TenderInvitationSupplierReceiptMapper)this.baseMapper).queryTabsCount(elsAccount);
    }
}

