/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.tender.supplier.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.constant.CommonConstant;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.SaleAttachmentDTO;
import com.els.modules.tender.archive.enumerate.TenderProjectArchiveAttachmentEnum;
import com.els.modules.tender.archive.utils.ArchiveUtil;
import com.els.modules.tender.attachment.entity.PurchaseTenderProjectAttachmentInfo;
import com.els.modules.tender.attachment.service.PurchaseTenderProjectAttachmentInfoService;
import com.els.modules.tender.common.aspect.TenderFlagInjectionContext;
import com.els.modules.tender.project.entity.PurchaseTenderProjectSubpackageInfo;
import com.els.modules.tender.project.enumerate.SubpackageInfoCheckTypeEnum;
import com.els.modules.tender.project.service.PurchaseTenderProjectHeadService;
import com.els.modules.tender.project.service.PurchaseTenderProjectSubpackageInfoService;
import com.els.modules.tender.project.vo.PurchaseTenderProjectInfoVO;
import com.els.modules.tender.sale.enumerate.TenderProjectPurchaseBidStatusEnum;
import com.els.modules.tender.sale.vo.TenderProjectPurchaseBidOrderVO;
import com.els.modules.tender.sale.vo.TenderProjectPurchaseBidVO;
import com.els.modules.tender.supplier.entity.TenderInvoiceInfo;
import com.els.modules.tender.supplier.entity.TenderProjectPurchaseBid;
import com.els.modules.tender.supplier.entity.TenderProjectSupplier;
import com.els.modules.tender.supplier.mapper.TenderProjectPurchaseBidMapper;
import com.els.modules.tender.supplier.service.TenderInvoiceInfoService;
import com.els.modules.tender.supplier.service.TenderProjectPurchaseBidService;
import com.els.modules.tender.supplier.service.TenderProjectSupplierService;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class TenderProjectPurchaseBidServiceImpl
extends BaseServiceImpl<TenderProjectPurchaseBidMapper, TenderProjectPurchaseBid>
implements TenderProjectPurchaseBidService {
    @Autowired
    private TenderInvoiceInfoService saleTenderInvoiceInfoService;
    @Autowired
    private TenderProjectSupplierService tenderProjectSupplierService;
    @Autowired
    private PurchaseTenderProjectSubpackageInfoService subpackageInfoService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Autowired
    private PurchaseTenderProjectHeadService purchaseTenderProjectHeadService;
    @Autowired
    private PurchaseTenderProjectAttachmentInfoService attachmentInfoService;

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void saleSubmit(TenderProjectPurchaseBid tenderProjectPurchaseBid, List<TenderInvoiceInfo> saleTenderInvoiceInfoList, List<SaleAttachmentDTO> attachmentList) {
        this.saleSubmit(tenderProjectPurchaseBid, saleTenderInvoiceInfoList, attachmentList, true);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void saleSubmit(TenderProjectPurchaseBid tenderProjectPurchaseBid, List<TenderInvoiceInfo> saleTenderInvoiceInfoList, List<SaleAttachmentDTO> attachmentList, boolean isCheck) {
        if (isCheck) {
            this.checkParam(tenderProjectPurchaseBid, saleTenderInvoiceInfoList);
        }
        this.buildParam(tenderProjectPurchaseBid);
        TenderProjectPurchaseBid purchaseBid = (TenderProjectPurchaseBid)((Object)((TenderProjectPurchaseBidMapper)this.baseMapper).selectById((Serializable)((Object)tenderProjectPurchaseBid.getId())));
        Assert.isTrue((boolean)ObjectUtil.isNotEmpty((Object)((Object)purchaseBid)), (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u91cd\u8bd5\uff01"));
        tenderProjectPurchaseBid.setDataVersion(purchaseBid.getDataVersion());
        int count = ((TenderProjectPurchaseBidMapper)this.baseMapper).updateById((Object)tenderProjectPurchaseBid);
        Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        super.setHeadDefaultValue((BaseEntity)tenderProjectPurchaseBid);
        this.saleTenderInvoiceInfoService.deleteByMainId(tenderProjectPurchaseBid.getId());
        this.insertData(tenderProjectPurchaseBid, saleTenderInvoiceInfoList);
        Assert.isTrue((boolean)CollectionUtil.isNotEmpty(attachmentList), (String)I18nUtil.translate((String)"", (String)"\u8d2d\u6807\u9644\u4ef6\u4e0d\u80fd\u4e3a\u7a7a!"));
        this.invokeBaseRpcService.deleteSaleAttachmentByMainId(tenderProjectPurchaseBid.getId());
        attachmentList.parallelStream().forEach(attachment -> attachment.setHeadId(tenderProjectPurchaseBid.getId()));
        this.invokeBaseRpcService.insertSaleAttachmentBatchSomeColumn(attachmentList);
        ArchiveUtil.saveArchiveBySaleAttachmentDTO(attachmentList, tenderProjectPurchaseBid.getId(), tenderProjectPurchaseBid.getSubpackageId(), tenderProjectPurchaseBid.getTenderProjectId(), TenderProjectArchiveAttachmentEnum.PURCHASE_BID_PREFIX.getValue());
        this.tenderProjectSupplierService.saveOrUpdateByPurchaseBid(tenderProjectPurchaseBid);
        if ("1".equals(tenderProjectPurchaseBid.getSourceType())) {
            this.tenderProjectSupplierService.updateByPurchaseBidApproved(tenderProjectPurchaseBid.getSubpackageId(), tenderProjectPurchaseBid.getSupplierAccount());
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void purchaseSubmit(TenderProjectPurchaseBid tenderProjectPurchaseBid, List<TenderInvoiceInfo> saleTenderInvoiceInfoList, List<SaleAttachmentDTO> attachmentList) {
        this.saleSubmit(tenderProjectPurchaseBid, saleTenderInvoiceInfoList, attachmentList);
        this.approved(tenderProjectPurchaseBid.getId());
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void saveOrUpdatePublish(TenderProjectPurchaseBid tenderProjectPurchaseBid, List<TenderInvoiceInfo> saleTenderInvoiceInfoList, List<SaleAttachmentDTO> attachmentList) {
        if (StringUtils.isBlank((CharSequence)tenderProjectPurchaseBid.getId())) {
            this.saveMain(tenderProjectPurchaseBid, saleTenderInvoiceInfoList, attachmentList);
        } else {
            this.updateMain(tenderProjectPurchaseBid, saleTenderInvoiceInfoList, attachmentList);
        }
        tenderProjectPurchaseBid.setStatus(TenderProjectPurchaseBidStatusEnum.NOT_CONFIRM.getValue());
        this.saleSubmit(tenderProjectPurchaseBid, saleTenderInvoiceInfoList, attachmentList);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void saveMain(TenderProjectPurchaseBid tenderProjectPurchaseBid, List<TenderInvoiceInfo> saleTenderInvoiceInfoList, List<SaleAttachmentDTO> attachmentList) {
        Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)tenderProjectPurchaseBid.getSupplierAccount()), (String)I18nUtil.translate((String)"", (String)"\u4f9b\u5e94\u5546\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a!"));
        Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)tenderProjectPurchaseBid.getCheckType()), (String)I18nUtil.translate((String)"", (String)"\u5ba1\u67e5\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a!"));
        List<TenderProjectPurchaseBid> tenderProjectPurchaseBids = ((TenderProjectPurchaseBidMapper)this.baseMapper).selectBySubpackageId(tenderProjectPurchaseBid.getSubpackageId(), tenderProjectPurchaseBid.getSupplierAccount(), tenderProjectPurchaseBid.getCheckType());
        Assert.isTrue((boolean)CollectionUtil.isEmpty(tenderProjectPurchaseBids), (String)I18nUtil.translate((String)"", (String)"\u5df2\u5b58\u5728\u8d2d\u6807\u4fe1\u606f\uff0c\u4e0d\u53ef\u91cd\u590d\u8d2d\u6807!"));
        this.buildParam(tenderProjectPurchaseBid);
        tenderProjectPurchaseBid.setStatus(TenderProjectPurchaseBidStatusEnum.NEW.getValue());
        ((TenderProjectPurchaseBidMapper)this.baseMapper).insert((Object)tenderProjectPurchaseBid);
        super.setHeadDefaultValue((BaseEntity)tenderProjectPurchaseBid);
        this.insertData(tenderProjectPurchaseBid, saleTenderInvoiceInfoList);
        if (CollectionUtil.isNotEmpty(attachmentList)) {
            attachmentList.parallelStream().forEach(attachment -> attachment.setHeadId(tenderProjectPurchaseBid.getId()));
            this.invokeBaseRpcService.insertSaleAttachmentBatchSomeColumn(attachmentList);
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void updateMain(TenderProjectPurchaseBid tenderProjectPurchaseBid, List<TenderInvoiceInfo> saleTenderInvoiceInfoList, List<SaleAttachmentDTO> attachmentList) {
        Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)tenderProjectPurchaseBid.getSupplierAccount()), (String)I18nUtil.translate((String)"", (String)"\u4f9b\u5e94\u5546\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a!"));
        TenderProjectPurchaseBid purchaseBid = (TenderProjectPurchaseBid)((Object)((TenderProjectPurchaseBidMapper)this.baseMapper).selectById((Serializable)((Object)tenderProjectPurchaseBid.getId())));
        Assert.isTrue((boolean)ObjectUtil.isNotEmpty((Object)((Object)purchaseBid)), (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u91cd\u8bd5\uff01"));
        Assert.isTrue((boolean)TenderProjectPurchaseBidStatusEnum.NEW.getValue().equals(purchaseBid.getStatus()), (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u72b6\u6001\u4e0d\u53ef\u4fee\u6539\uff01"));
        tenderProjectPurchaseBid.setDataVersion(purchaseBid.getDataVersion());
        this.buildParam(tenderProjectPurchaseBid);
        tenderProjectPurchaseBid.setStatus(TenderProjectPurchaseBidStatusEnum.NEW.getValue());
        int count = ((TenderProjectPurchaseBidMapper)this.baseMapper).updateById((Object)tenderProjectPurchaseBid);
        Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        super.setHeadDefaultValue((BaseEntity)tenderProjectPurchaseBid);
        this.saleTenderInvoiceInfoService.deleteByMainId(tenderProjectPurchaseBid.getId());
        this.insertData(tenderProjectPurchaseBid, saleTenderInvoiceInfoList);
        if (CollectionUtil.isNotEmpty(attachmentList)) {
            this.invokeBaseRpcService.deleteSaleAttachmentByMainId(tenderProjectPurchaseBid.getId());
            attachmentList.parallelStream().forEach(attachment -> attachment.setHeadId(tenderProjectPurchaseBid.getId()));
            this.invokeBaseRpcService.insertSaleAttachmentBatchSomeColumn(attachmentList);
        }
    }

    private void insertData(TenderProjectPurchaseBid tenderProjectPurchaseBid, List<TenderInvoiceInfo> saleTenderInvoiceInfoList) {
        if (!CollectionUtils.isEmpty(saleTenderInvoiceInfoList)) {
            for (TenderInvoiceInfo entity : saleTenderInvoiceInfoList) {
                entity.setDeleted(CommonConstant.DEL_FLAG_0);
                entity.setHeadId(tenderProjectPurchaseBid.getId());
                SysUtil.setSysParam((BaseEntity)entity, (BaseEntity)tenderProjectPurchaseBid);
                entity.setElsAccount(tenderProjectPurchaseBid.getElsAccount());
            }
            this.saleTenderInvoiceInfoService.saveBatch(saleTenderInvoiceInfoList, 2000);
        }
    }

    @Override
    public TenderProjectPurchaseBidVO queryPurchaseBidInfo(String subpackageId) {
        String elsAccount = TenantContext.getTenant();
        TenderProjectPurchaseBidVO tenderProjectPurchaseBidVO = new TenderProjectPurchaseBidVO();
        TenderProjectPurchaseBid tenderProjectPurchaseBid = null;
        List<TenderProjectPurchaseBid> tenderProjectPurchaseBids = ((TenderProjectPurchaseBidMapper)this.baseMapper).selectBySubpackageId(subpackageId, elsAccount, TenderFlagInjectionContext.getTenderCheckType());
        if (CollectionUtil.isNotEmpty(tenderProjectPurchaseBids)) {
            tenderProjectPurchaseBid = tenderProjectPurchaseBids.get(0);
            BeanUtils.copyProperties((Object)((Object)tenderProjectPurchaseBid), (Object)((Object)tenderProjectPurchaseBidVO));
        }
        if (tenderProjectPurchaseBid != null) {
            List<TenderInvoiceInfo> tenderInvoiceInfos = this.saleTenderInvoiceInfoService.selectByMainId(tenderProjectPurchaseBidVO.getId());
            if (CollectionUtil.isEmpty(tenderInvoiceInfos)) {
                tenderInvoiceInfos = new ArrayList<TenderInvoiceInfo>();
            }
            tenderProjectPurchaseBidVO.setSaleTenderInvoiceInfoList(tenderInvoiceInfos);
            List saleAttachmentDemandDTOS = this.invokeBaseRpcService.selectSaleAttachmentByMainId(tenderProjectPurchaseBid.getId());
            tenderProjectPurchaseBidVO.setAttachmentList(saleAttachmentDemandDTOS);
        } else {
            PurchaseTenderProjectInfoVO purchaseTenderProjectInfoVO = this.purchaseTenderProjectHeadService.queryProjectInfoBySubpackageId(subpackageId);
            if (ObjectUtil.isNull((Object)purchaseTenderProjectInfoVO)) {
                return tenderProjectPurchaseBidVO;
            }
            BeanUtils.copyProperties((Object)purchaseTenderProjectInfoVO, (Object)((Object)tenderProjectPurchaseBidVO), (String[])new String[]{"id"});
            TenderProjectSupplier querySupplier = new TenderProjectSupplier().setSubpackageId(subpackageId).setSupplierAccount(elsAccount);
            List<TenderProjectSupplier> tenderProjectSupplierList = this.tenderProjectSupplierService.selectBySubpackageId(querySupplier);
            if (CollectionUtil.isNotEmpty(tenderProjectSupplierList)) {
                TenderProjectSupplier saleTenderProjectSupplier = tenderProjectSupplierList.get(0);
                tenderProjectPurchaseBidVO.setContacts(saleTenderProjectSupplier.getContacts());
                tenderProjectPurchaseBidVO.setContactsPhone(saleTenderProjectSupplier.getContactsPhone());
                tenderProjectPurchaseBidVO.setCombination(saleTenderProjectSupplier.getCombination());
                tenderProjectPurchaseBidVO.setCombinationName(saleTenderProjectSupplier.getCombinationName());
                tenderProjectPurchaseBidVO.setConsortiumBidding(saleTenderProjectSupplier.getConsortiumBidding());
            }
        }
        this.selectOrderInfo(tenderProjectPurchaseBidVO);
        return tenderProjectPurchaseBidVO;
    }

    @Override
    public void selectOrderInfo(TenderProjectPurchaseBidVO tenderProjectPurchaseBidVO) {
        List<PurchaseTenderProjectAttachmentInfo> attachmentInfos = this.attachmentInfoService.selectBySubpackageId(tenderProjectPurchaseBidVO.getSubpackageId());
        if (CollectionUtil.isNotEmpty(attachmentInfos)) {
            ArrayList tenderProjectPurchaseBidOrderVOList = SysUtil.copyProperties(attachmentInfos, TenderProjectPurchaseBidOrderVO.class);
            tenderProjectPurchaseBidVO.setTenderProjectPurchaseBidOrderVOList(tenderProjectPurchaseBidOrderVOList);
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void approved(String id) {
        TenderProjectPurchaseBid tenderProjectPurchaseBid = (TenderProjectPurchaseBid)((Object)((TenderProjectPurchaseBidMapper)this.baseMapper).selectById((Serializable)((Object)id)));
        Assert.isTrue((boolean)ObjectUtil.isNotEmpty((Object)((Object)tenderProjectPurchaseBid)), (String)I18nUtil.translate((String)"", (String)"\u8d2d\u6807\u6570\u636e\u4e0d\u5b58\u5728!"));
        if (TenderProjectPurchaseBidStatusEnum.CONFIRM.getValue().equals(tenderProjectPurchaseBid.getStatus())) {
            return;
        }
        tenderProjectPurchaseBid.setStatus(TenderProjectPurchaseBidStatusEnum.CONFIRM.getValue());
        ((TenderProjectPurchaseBidMapper)this.baseMapper).updateById((Object)tenderProjectPurchaseBid);
        this.tenderProjectSupplierService.updateByPurchaseBidApproved(tenderProjectPurchaseBid.getSubpackageId(), tenderProjectPurchaseBid.getSupplierAccount());
    }

    @Override
    public List<TenderProjectPurchaseBid> selectBySubpackageId(String subpackageId) {
        return ((TenderProjectPurchaseBidMapper)this.baseMapper).selectBySubpackageId(subpackageId, null, null);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delete(String id) {
        TenderProjectPurchaseBid tenderProjectPurchaseBid = (TenderProjectPurchaseBid)((Object)((TenderProjectPurchaseBidMapper)this.baseMapper).selectById((Serializable)((Object)id)));
        Assert.isTrue((boolean)ObjectUtil.isNotEmpty((Object)((Object)tenderProjectPurchaseBid)), (String)I18nUtil.translate((String)"", (String)"\u6570\u636e\u4e0d\u5b58\u5728!"));
        Assert.isTrue((boolean)TenderProjectPurchaseBidStatusEnum.NOT_CONFIRM.getValue().equals(tenderProjectPurchaseBid.getStatus()), (String)I18nUtil.translate((String)"", (String)"\u8d2d\u6807\u5df2\u786e\u8ba4\uff0c\u4e0d\u53ef\u5220\u9664!"));
        ((TenderProjectPurchaseBidMapper)this.baseMapper).deleteById((Serializable)((Object)id));
        this.saleTenderInvoiceInfoService.deleteByMainId(id);
    }

    @Override
    public List<TenderProjectPurchaseBidVO> selectByMainIds(List<String> oldIds) {
        List<TenderProjectPurchaseBid> purchaseBidList = ((TenderProjectPurchaseBidMapper)this.baseMapper).selectByMainIds(oldIds);
        if (CollectionUtil.isEmpty(purchaseBidList)) {
            return null;
        }
        List<String> purchaseBidIds = purchaseBidList.stream().map(BaseEntity::getId).collect(Collectors.toList());
        ArrayList purchaseBidVOList = SysUtil.copyProperties(purchaseBidList, TenderProjectPurchaseBidVO.class);
        List<TenderInvoiceInfo> tenderInvoiceInfos = this.saleTenderInvoiceInfoService.selectByMainIds(purchaseBidIds);
        Map<String, List<TenderInvoiceInfo>> tenderInvoiceInfoMaps = tenderInvoiceInfos.stream().collect(Collectors.groupingBy(TenderInvoiceInfo::getHeadId));
        for (TenderProjectPurchaseBidVO tenderProjectPurchaseBidVO : purchaseBidVOList) {
            List<TenderInvoiceInfo> saleInvoiceInfo = tenderInvoiceInfoMaps.get(tenderProjectPurchaseBidVO.getId());
            tenderProjectPurchaseBidVO.setSaleTenderInvoiceInfoList(saleInvoiceInfo);
            List saleAttachmentDemandDTOS = this.invokeBaseRpcService.selectSaleAttachmentByMainId(tenderProjectPurchaseBidVO.getId());
            tenderProjectPurchaseBidVO.setAttachmentList(saleAttachmentDemandDTOS);
            this.selectOrderInfo(tenderProjectPurchaseBidVO);
        }
        return purchaseBidVOList;
    }

    @Override
    public TenderProjectPurchaseBid queryById(String id) {
        return (TenderProjectPurchaseBid)((Object)((TenderProjectPurchaseBidMapper)this.baseMapper).selectById((Serializable)((Object)id)));
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void dataVoSaveBatch(List<TenderProjectPurchaseBidVO> newTenderProjectPurchaseBidVOS) {
        if (CollectionUtil.isEmpty(newTenderProjectPurchaseBidVOS)) {
            return;
        }
        ArrayList purchaseBidList = SysUtil.copyProperties(newTenderProjectPurchaseBidVOS, TenderProjectPurchaseBid.class);
        ArrayList tenderInvoiceInfoList = new ArrayList();
        ArrayList attachmentList = new ArrayList();
        newTenderProjectPurchaseBidVOS.stream().forEach(purchaseBidVo -> {
            List<SaleAttachmentDTO> saleAttachmentList;
            List<TenderInvoiceInfo> saleTenderInvoiceInfoList = purchaseBidVo.getSaleTenderInvoiceInfoList();
            if (CollectionUtil.isNotEmpty(saleTenderInvoiceInfoList)) {
                tenderInvoiceInfoList.addAll(saleTenderInvoiceInfoList);
            }
            if (CollectionUtil.isNotEmpty(saleAttachmentList = purchaseBidVo.getAttachmentList())) {
                attachmentList.addAll(saleAttachmentList);
            }
        });
        this.saveBatch(purchaseBidList);
        this.saleTenderInvoiceInfoService.saveBatch(tenderInvoiceInfoList, 2000);
        this.invokeBaseRpcService.insertSaleAttachmentBatchSomeColumn(attachmentList);
    }

    private void checkParam(TenderProjectPurchaseBid tenderProjectPurchaseBid, List<TenderInvoiceInfo> saleTenderInvoiceInfoList) {
        Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)tenderProjectPurchaseBid.getSupplierName()), (String)I18nUtil.translate((String)"", (String)"\u6295\u6807\u5355\u4f4d\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a!"));
        if ("1".equals(tenderProjectPurchaseBid.getCombination())) {
            Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)tenderProjectPurchaseBid.getCombinationName()), (String)I18nUtil.translate((String)"", (String)"\u8054\u5408\u4f53\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a!"));
        }
        Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)tenderProjectPurchaseBid.getPurchaseEnterpriseAccount()), (String)I18nUtil.translate((String)"", (String)"\u62db\u6807\u5355\u4f4d\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a!"));
        Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)tenderProjectPurchaseBid.getContacts()), (String)I18nUtil.translate((String)"", (String)"\u8054\u7cfb\u4eba\u4e0d\u80fd\u4e3a\u7a7a!"));
        Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)tenderProjectPurchaseBid.getContactsPhone()), (String)I18nUtil.translate((String)"", (String)"\u8054\u7cfb\u4eba\u7535\u8bdd\u4e0d\u80fd\u4e3a\u7a7a!"));
        Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)tenderProjectPurchaseBid.getTenderProjectNumber()), (String)I18nUtil.translate((String)"", (String)"\u9879\u76ee\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a!"));
        Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)tenderProjectPurchaseBid.getTenderProjectName()), (String)I18nUtil.translate((String)"", (String)"\u9879\u76ee\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a!"));
        Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)tenderProjectPurchaseBid.getSubpackageId()), (String)I18nUtil.translate((String)"", (String)"\u5206\u5305\u4e0d\u80fd\u4e3a\u7a7a!"));
        saleTenderInvoiceInfoList.forEach(supplierTenderInvoiceInfo -> {
            Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)supplierTenderInvoiceInfo.getPayType()), (String)I18nUtil.translate((String)"", (String)"\u652f\u4ed8\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a!"));
            Assert.isTrue((boolean)ObjectUtil.isNotEmpty((Object)supplierTenderInvoiceInfo.getPayMoney()), (String)I18nUtil.translate((String)"", (String)"\u652f\u4ed8\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a!"));
            Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)supplierTenderInvoiceInfo.getInvoice()), (String)I18nUtil.translate((String)"", (String)"\u8bf7\u9009\u62e9\u662f\u5426\u5f00\u53d1\u7968!"));
            if ("1".equals(supplierTenderInvoiceInfo.getInvoice())) {
                Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)supplierTenderInvoiceInfo.getInvoiceType()), (String)I18nUtil.translate((String)"", (String)"\u53d1\u7968\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a!"));
                Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)supplierTenderInvoiceInfo.getEnterpriseName()), (String)I18nUtil.translate((String)"", (String)"\u4f01\u4e1a\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a!"));
                Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)supplierTenderInvoiceInfo.getDutyParagraph()), (String)I18nUtil.translate((String)"", (String)"\u7a0e\u53f7\u4e0d\u80fd\u4e3a\u7a7a!"));
                Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)supplierTenderInvoiceInfo.getEnterpriseAddress()), (String)I18nUtil.translate((String)"", (String)"\u4f01\u4e1a\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a!"));
                Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)supplierTenderInvoiceInfo.getEnterprisePhone()), (String)I18nUtil.translate((String)"", (String)"\u4f01\u4e1a\u7535\u8bdd\u53f7\u4e0d\u80fd\u4e3a\u7a7a!"));
                Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)supplierTenderInvoiceInfo.getDepositBank()), (String)I18nUtil.translate((String)"", (String)"\u5f00\u6237\u94f6\u884c\u4e0d\u80fd\u4e3a\u7a7a!"));
                Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)supplierTenderInvoiceInfo.getBankNumber()), (String)I18nUtil.translate((String)"", (String)"\u94f6\u884c\u8d26\u6237\u4e0d\u80fd\u4e3a\u7a7a!"));
            }
        });
        PurchaseTenderProjectSubpackageInfo purchaseTenderProjectSubpackageInfo = this.subpackageInfoService.selectById(tenderProjectPurchaseBid.getSubpackageId());
        Assert.isTrue((boolean)ObjectUtil.isNotEmpty((Object)((Object)purchaseTenderProjectSubpackageInfo)), (String)I18nUtil.translate((String)"", (String)"\u9879\u76ee\u4fe1\u606f\u4e0d\u5b58\u5728!"));
        if ("1".equals(purchaseTenderProjectSubpackageInfo.getSignUp())) {
            TenderProjectSupplier querySupplier = new TenderProjectSupplier().setSubpackageId(tenderProjectPurchaseBid.getSubpackageId()).setSupplierAccount(tenderProjectPurchaseBid.getSupplierAccount());
            List<TenderProjectSupplier> list = this.tenderProjectSupplierService.selectBySubpackageId(querySupplier);
        }
        String tenderCheckType = TenderFlagInjectionContext.getTenderCheckType();
        Date currentDate = new Date();
        if (SubpackageInfoCheckTypeEnum.PRE_TRIAL.getValue().equals(tenderCheckType)) {
            Assert.isTrue((boolean)currentDate.after(purchaseTenderProjectSubpackageInfo.getPreBiddingBeginTime()), (String)I18nUtil.translate((String)"", (String)"\u552e\u6807\u672a\u5f00\u59cb!"));
            Assert.isTrue((boolean)currentDate.before(purchaseTenderProjectSubpackageInfo.getPreBiddingEndTime()), (String)I18nUtil.translate((String)"", (String)"\u552e\u6807\u5df2\u622a\u6b62!"));
        } else {
            Assert.isTrue((boolean)currentDate.before(purchaseTenderProjectSubpackageInfo.getBiddingEndTime()), (String)I18nUtil.translate((String)"", (String)"\u552e\u6807\u5df2\u622a\u6b62!"));
        }
    }

    private void buildParam(TenderProjectPurchaseBid tenderProjectPurchaseBid) {
        PurchaseTenderProjectSubpackageInfo purchaseTenderProjectSubpackageInfo = this.subpackageInfoService.selectById(tenderProjectPurchaseBid.getSubpackageId());
        Assert.isTrue((boolean)ObjectUtil.isNotEmpty((Object)((Object)purchaseTenderProjectSubpackageInfo)), (String)I18nUtil.translate((String)"", (String)"\u9879\u76ee\u4fe1\u606f\u4e0d\u5b58\u5728!"));
        tenderProjectPurchaseBid.setElsAccount(tenderProjectPurchaseBid.getSupplierAccount());
        tenderProjectPurchaseBid.setTenderProjectId(purchaseTenderProjectSubpackageInfo.getHeadId());
        tenderProjectPurchaseBid.setDeleted(CommonConstant.DEL_FLAG_0);
    }
}

