/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.demand.controller;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.aspect.annotation.PermissionDataView;
import com.els.common.aspect.annotation.SrmValidated;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.query.QueryGenerator;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.AdminFlagUtil;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.common.vo.CountVO;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.DictDTO;
import com.els.modules.demand.entity.PurchaseRequestHead;
import com.els.modules.demand.entity.PurchaseRequestItem;
import com.els.modules.demand.enumerate.PurchaseRequestStatusEnum;
import com.els.modules.demand.enumerate.PurchaseRequestStatusItemEnum;
import com.els.modules.demand.excel.PurchaseDemandPoolExportServiceImpl;
import com.els.modules.demand.rpc.BudgetManageLocalRpcService;
import com.els.modules.demand.service.PurchaseRequestHeadService;
import com.els.modules.demand.service.PurchaseRequestItemService;
import com.els.modules.demand.vo.PurchaseRequestHeadVO;
import com.els.rpc.service.InvokeAccountRpcService;
import com.els.rpc.service.InvokeBaseRpcService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@RestController
@RequestMapping(value={"/demand/purchaseDemandPool"})
@Api(tags={"\u91c7\u8d2d\u7533\u8bf7\u5934"})
public class PurchaseDemandPoolController
extends BaseController<PurchaseRequestItem, PurchaseRequestItemService> {
    private static final Logger log = LoggerFactory.getLogger(PurchaseDemandPoolController.class);
    @Autowired
    private PurchaseRequestHeadService purchaseRequestHeadService;
    @Autowired
    private PurchaseRequestItemService purchaseRequestItemService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Resource
    private InvokeAccountRpcService invokeAccountRpcService;
    @Resource
    private BudgetManageLocalRpcService budgetManageRpcService;

    @GetMapping(value={"/list"})
    @RequiresPermissions(value={"demandPool#purchaseDemandPool:list"})
    public Result<?> queryPageList(PurchaseRequestItem purchaseRequestItem, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)purchaseRequestItem), (Map)req.getParameterMap());
        queryWrapper.notIn((Object)"item_status", Arrays.asList(PurchaseRequestStatusItemEnum.APPROVED.getValue(), PurchaseRequestStatusItemEnum.SEND_BACK.getValue(), PurchaseRequestStatusItemEnum.CANCEL.getValue(), "12"));
        if (!"1".equals(AdminFlagUtil.getAdminFlag())) {
            LoginUser loginUser = SysUtil.getLoginUser();
            Set rolesSet = this.invokeAccountRpcService.getUserRolesSet(TenantContext.getTenant(), loginUser.getSubAccount());
            if (CollectionUtil.isNotEmpty((Collection)rolesSet)) {
                queryWrapper.and(i -> {
                    i.like((Object)"tactics_entity", (Object)loginUser.getSubAccount());
                    rolesSet.forEach(item -> i.or(k -> {
                        QueryWrapper cfr_ignored_0 = (QueryWrapper)k.like((Object)"tactics_entity", item);
                    }));
                    i.or(j -> {
                        QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)((QueryWrapper)j.isNull((Object)"tactics_entity")).or()).eq((Object)"tactics_entity", (Object)"");
                    });
                });
            }
        }
        queryWrapper.lambda().orderByDesc(BaseEntity::getCreateTime);
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.purchaseRequestItemService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @ApiOperation(value="\u5408\u540c\u67e5\u8be2\u91c7\u8d2d\u7533\u8bf7\u884c\u5206\u9875\u4fe1\u606f", notes="\u5408\u540c\u67e5\u8be2\u91c7\u8d2d\u7533\u8bf7\u884c\u5206\u9875\u4fe1\u606f")
    @GetMapping(value={"/contractQueryRequest"})
    @RequiresPermissions(value={"demandPool#purchaseDemandPool:queryById"})
    public Result<?> contractQueryRequest(PurchaseRequestItem item, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)item), (Map)req.getParameterMap());
        queryWrapper.eq((Object)"audit_status", (Object)AuditStatusEnum.AUDIT_FINISH.getValue());
        queryWrapper.inSql((Object)"request_number", "select request_number from purchase_request_head where request_status <> " + PurchaseRequestStatusEnum.REQUEST_CANCAL.getValue());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.purchaseRequestItemService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryPermissionById"})
    @RequiresPermissions(value={"demandPool#purchaseDemandPool:queryById"})
    public Result<?> queryPermissionById(@RequestParam(name="id", required=true) String id) {
        boolean b = this.purchaseRequestItemService.queryPermissionById(id);
        return Result.ok((Object)b);
    }

    @ApiOperation(value="\u91c7\u8d2d\u7533\u8bf7\u884c-\u4f5c\u5e9f", notes="\u91c7\u8d2d\u7533\u8bf7\u884c-\u4f5c\u5e9f")
    @PostMapping(value={"/cancel"})
    @SrmValidated
    @RequiresPermissions(value={"demandPool#purchaseDemandPool:cancel"})
    public Result<?> cancel(@RequestBody PurchaseRequestItem head) {
        this.purchaseRequestItemService.updateStatus(Arrays.asList(head), PurchaseRequestStatusItemEnum.CANCEL.getValue());
        return this.commonSuccessResult(7);
    }

    @ApiOperation(value="\u91c7\u8d2d\u7533\u8bf7\u884c-\u9000\u56de", notes="\u91c7\u8d2d\u7533\u8bf7\u884c-\u9000\u56de")
    @AutoLog(busModule="\u9700\u6c42\u6c60\u7ba1\u7406", value="\u9000\u56de")
    @PostMapping(value={"/returnItem"})
    @SrmValidated
    @RequiresPermissions(value={"demandPool#purchaseDemandPool:returnItem"})
    public Result<?> returnItem(@RequestBody PurchaseRequestItem requestItem) {
        PurchaseRequestItem head = (PurchaseRequestItem)((Object)this.purchaseRequestItemService.getById((Serializable)((Object)requestItem.getId())));
        head.setElsBusinessTransferHis(requestItem.getElsBusinessTransferHis());
        this.budgetManageRpcService.demandPoolRefund(head.getRequestNumber(), head.getItemNumber());
        if ("sample".equals(head.getSourceType())) {
            this.purchaseRequestItemService.returnSample(head);
            return this.commonSuccessResult(3);
        }
        QueryWrapper purchaseRequestHeadQueryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)purchaseRequestHeadQueryWrapper.lambda().eq(PurchaseRequestHead::getRequestNumber, (Object)head.getRequestNumber())).eq(BaseEntity::getElsAccount, (Object)head.getElsAccount());
        this.purchaseRequestItemService.returnItem(head);
        List list = this.purchaseRequestHeadService.list((Wrapper)purchaseRequestHeadQueryWrapper);
        if (!CollectionUtils.isEmpty((Collection)list)) {
            for (PurchaseRequestHead purchaseRequestHead : list) {
                String status = PurchaseRequestStatusEnum.REQUEST_RETURN.getValue();
                List<PurchaseRequestItem> purchaseRequestItems = this.purchaseRequestItemService.selectByMainId(purchaseRequestHead.getId());
                List collect = purchaseRequestItems.parallelStream().filter(item -> item.getItemStatus().equals(PurchaseRequestStatusItemEnum.SEND_BACK.getValue())).collect(Collectors.toList());
                if (collect.size() == purchaseRequestItems.size()) {
                    status = PurchaseRequestStatusEnum.ALL_RETURN.getValue();
                }
                if (purchaseRequestHead.getAudit().equals("1")) {
                    ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.purchaseRequestHeadService.lambdaUpdate().eq(BaseEntity::getId, (Object)purchaseRequestHead.getId())).set(PurchaseRequestHead::getRequestStatus, (Object)status)).set(PurchaseRequestHead::getAuditStatus, (Object)AuditStatusEnum.AUDIT_NEW.getValue())).update((Object)new PurchaseRequestHead());
                    continue;
                }
                ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.purchaseRequestHeadService.lambdaUpdate().eq(BaseEntity::getId, (Object)purchaseRequestHead.getId())).set(PurchaseRequestHead::getRequestStatus, (Object)status)).update((Object)new PurchaseRequestHead());
            }
            this.purchaseRequestItemService.sendPoolMsg(list, null, "refund");
        }
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.purchaseRequestItemService.lambdaUpdate().eq(BaseEntity::getId, (Object)head.getId())).set(PurchaseRequestItem::getBackRemark, (Object)requestItem.getBackRemark())).set(PurchaseRequestItem::getTacticsObject, null)).set(PurchaseRequestItem::getTacticsEntity, null)).update((Object)new PurchaseRequestItem());
        return this.commonSuccessResult(7);
    }

    @ApiOperation(value="\u7f16\u8f91", notes="\u7f16\u8f91")
    @AutoLog(busModule="\u9700\u6c42\u6c60\u7ba1\u7406", value="\u8f6c\u529e")
    @PostMapping(value={"/edit"})
    @SrmValidated
    @RequiresPermissions(value={"demandPool#purchaseDemandPool:edit"})
    public Result<?> edit(@RequestBody PurchaseRequestItem requestItem) {
        this.purchaseRequestItemService.updateItem(requestItem);
        if (!StringUtils.isEmpty((Object)requestItem.getHeadId())) {
            PurchaseRequestHead byId = (PurchaseRequestHead)((Object)this.purchaseRequestHeadService.getById((Serializable)((Object)requestItem.getHeadId())));
            this.purchaseRequestItemService.sendPoolMsg(null, Arrays.asList(requestItem), "transfer");
        }
        return this.commonSuccessResult(3);
    }

    public Result<?> updateStatus(List<PurchaseRequestItem> itemList, String status) {
        this.purchaseRequestItemService.updateStatus(itemList, status);
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u8f6c\u8ba2\u5355-\u6837\u54c1\u7533\u8bf7\u8f6c\u8ba2\u5355")
    @ApiOperation(value="\u6837\u54c1\u7533\u8bf7\u8f6c\u8ba2\u5355", notes="\u6837\u54c1\u7533\u8bf7\u8f6c\u8ba2\u5355")
    @PostMapping(value={"/requestSampleToOrder"})
    @RequiresPermissions(value={"demandPool#purchaseDemandPool:requestToOrder"})
    @SrmValidated
    public Result<?> requestSampleToOrder(@RequestBody PurchaseRequestHeadVO requestToOrderHeadVO) {
        Assert.notEmpty(requestToOrderHeadVO.getPurchaseRequestItemList(), (String)I18nUtil.translate((String)"i18n_alert_empty_toOrderLine", (String)"\u9009\u62e9\u7684\u8f6c\u8ba2\u5355\u7684\u9700\u6c42\u884c\u4e0d\u80fd\u4e3a\u7a7a"));
        String itemServiceOrder = this.purchaseRequestItemService.createOrder(requestToOrderHeadVO);
        return Result.ok((String)itemServiceOrder);
    }

    @ApiOperation(value="\u901a\u8fc7\u5217\u8868\u9875\u9875\u7b7e\u6570\u91cf\u67e5\u8be2", notes="\u5217\u8868\u9875\u9875\u7b7e\u6570\u91cf\u67e5\u8be2")
    @GetMapping(value={"/counts"})
    @RequiresPermissions(value={"demandPool#purchaseDemandPool:list"})
    public Result<?> queryTabsCount(PurchaseRequestItem purchaseRequestItem, HttpServletRequest req) {
        ArrayList<CountVO> result = new ArrayList<CountVO>();
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)purchaseRequestItem), (Map)req.getParameterMap());
        queryWrapper.select(new String[]{"item_status", "count(0) as participateQuantity"}).notIn((Object)"item_status", Arrays.asList(PurchaseRequestStatusItemEnum.APPROVED.getValue(), PurchaseRequestStatusItemEnum.SEND_BACK.getValue(), PurchaseRequestStatusItemEnum.CANCEL.getValue()));
        queryWrapper.groupBy((Object)"item_status");
        List list = ((PurchaseRequestItemService)this.service).list((Wrapper)queryWrapper);
        Map<String, Integer> countMap = list.stream().collect(Collectors.toMap(PurchaseRequestItem::getItemStatus, PurchaseRequestItem::getParticipateQuantity));
        Integer all = 0;
        for (Map.Entry<String, Integer> entry : countMap.entrySet()) {
            all = all + entry.getValue();
        }
        result.add(new CountVO(I18nUtil.translate((String)"i18n_title_all", (String)"\u5168\u90e8"), "itemStatus", null, all));
        List srmRequestStatus = this.invokeBaseRpcService.queryDictItemsByCode("srmPurchaseRequestItemStatus", TenantContext.getTenant());
        String[] statuses = new String[]{"1", "2", "4", "5", "6", "7", "8", "9", "13", "14"};
        List<String> statusList = Arrays.asList(statuses);
        for (DictDTO status : srmRequestStatus) {
            if (!statusList.contains(status.getValue())) continue;
            Integer total = countMap.get(status.getValue()) == null ? Integer.valueOf(0) : countMap.get(status.getValue());
            result.add(new CountVO(I18nUtil.translate((String)status.getTextI18nKey(), (String)status.getText()), "itemStatus", status.getValue(), total));
        }
        return Result.ok(result);
    }

    @GetMapping(value={"/exportXls"})
    @PermissionDataView(businessType="demandPool")
    @RequiresPermissions(value={"demandPool#purchaseDemandPool:export"})
    public ModelAndView exportXls(HttpServletRequest request, @RequestParam Map<String, Object> object) {
        return super.exportXls(request, object, PurchaseDemandPoolExportServiceImpl.class);
    }

    @GetMapping(value={"/download"})
    @RequiresPermissions(value={"demandPool#purchaseDemandPool:download"})
    public Result<?> download(String id, String itemNumber) {
        Assert.isTrue((boolean)StringUtils.hasText((String)id), (String)I18nUtil.translate((String)"i18n_alert_rcBjWWW_12842d17", (String)"\u8be5\u884c\u6ca1\u6709id\uff01"));
        Assert.isTrue((boolean)StringUtils.hasText((String)itemNumber), (String)I18nUtil.translate((String)"i18n_alert_rcBjWWWWWWWWWWW_d3c9d516", (String)"\u8be5\u884c\u6ca1\u6709itemNumber\uff01"));
        List attachmentDTOList = this.invokeBaseRpcService.selectPurchaseAttachmentByMainId(id);
        attachmentDTOList = attachmentDTOList.stream().filter(e -> {
            String s = Optional.ofNullable(e.getItemNumber()).orElse("");
            return s.equals(itemNumber);
        }).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(attachmentDTOList)) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_rcBjRKBI_64abf482", (String)"\u8be5\u884c\u6ca1\u6709\u5173\u8054\u9644\u4ef6"));
        }
        return Result.ok(attachmentDTOList);
    }
}

