/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.tender.clarification.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.modules.base.api.dto.PurchaseAttachmentDTO;
import com.els.modules.base.api.dto.SaleAttachmentDTO;
import com.els.modules.tender.clarification.entity.PurchaseTenderEvaClarificationHead;
import com.els.modules.tender.clarification.entity.PurchaseTenderEvaClarificationSupplier;
import com.els.modules.tender.clarification.entity.SaleTenderEvaClarificationHead;
import com.els.modules.tender.clarification.entity.SaleTenderEvaClarificationItem;
import com.els.modules.tender.clarification.enumerate.SaleTenderEvaClarificationItemStatusEnum;
import com.els.modules.tender.clarification.enumerate.TenderMentoringStatusEnum;
import com.els.modules.tender.clarification.mapper.SaleTenderEvaClarificationHeadMapper;
import com.els.modules.tender.clarification.service.PurchaseTenderEvaClarificationHeadService;
import com.els.modules.tender.clarification.service.SaleTenderEvaClarificationHeadService;
import com.els.modules.tender.clarification.service.SaleTenderEvaClarificationItemService;
import com.els.modules.tender.clarification.vo.SaleTenderEvaClarificationItemVO;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class SaleTenderEvaClarificationHeadServiceImpl
extends BaseServiceImpl<SaleTenderEvaClarificationHeadMapper, SaleTenderEvaClarificationHead>
implements SaleTenderEvaClarificationHeadService {
    @Autowired
    private SaleTenderEvaClarificationItemService saleTenderEvaClarificationItemService;
    @Autowired
    @Lazy
    private PurchaseTenderEvaClarificationHeadService purchaseTenderEvaClarificationHeadService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void add(PurchaseTenderEvaClarificationHead purchaseTenderEvaClarificationHead, List<PurchaseTenderEvaClarificationSupplier> purchaseTenderEvaClarificationSuppliers, List<PurchaseAttachmentDTO> attachmentList) {
        ArrayList<SaleTenderEvaClarificationHead> evaClarificationHeads = new ArrayList<SaleTenderEvaClarificationHead>();
        ArrayList<SaleAttachmentDTO> saleAttachmentDTOS = new ArrayList<SaleAttachmentDTO>();
        for (PurchaseTenderEvaClarificationSupplier evaClarificationSupplier : purchaseTenderEvaClarificationSuppliers) {
            SaleTenderEvaClarificationHead saleTenderEvaClarificationHead = (SaleTenderEvaClarificationHead)((Object)SysUtil.copyProperties((Object)((Object)purchaseTenderEvaClarificationHead), SaleTenderEvaClarificationHead.class));
            saleTenderEvaClarificationHead.setElsAccount(evaClarificationSupplier.getSupplierAccount());
            saleTenderEvaClarificationHead.setSupplierAccount(evaClarificationSupplier.getSupplierAccount());
            saleTenderEvaClarificationHead.setSupplierName(evaClarificationSupplier.getSupplierName());
            saleTenderEvaClarificationHead.setRelationId(evaClarificationSupplier.getId());
            saleTenderEvaClarificationHead.setEvaClarificationId(purchaseTenderEvaClarificationHead.getId());
            saleTenderEvaClarificationHead.setId(IdWorker.getIdStr());
            evaClarificationHeads.add(saleTenderEvaClarificationHead);
            if (!CollectionUtil.isNotEmpty(attachmentList)) continue;
            ArrayList saleAttachmentList = SysUtil.copyProperties(attachmentList, SaleAttachmentDTO.class);
            for (SaleAttachmentDTO saleAttachmentDTO : saleAttachmentList) {
                saleAttachmentDTO.setId(IdWorker.getIdStr());
                saleAttachmentDTO.setHeadId(saleTenderEvaClarificationHead.getId());
                saleAttachmentDTOS.add(saleAttachmentDTO);
            }
        }
        this.saveBatch(evaClarificationHeads);
        if (CollectionUtil.isNotEmpty(saleAttachmentDTOS)) {
            this.invokeBaseRpcService.insertSaleAttachmentBatchSomeColumn(saleAttachmentDTOS);
        }
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void changeRecord(PurchaseTenderEvaClarificationHead evaClarificationHead) {
        ((SaleTenderEvaClarificationHeadMapper)this.baseMapper).updateFileClarificationEndTimeByEvaClarificationId(evaClarificationHead.getId(), evaClarificationHead.getFileClarificationEndTime());
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public SaleTenderEvaClarificationItem replyAdd(SaleTenderEvaClarificationItemVO saleTenderEvaClarificationItemVO) {
        this.checkParamAndSet(saleTenderEvaClarificationItemVO);
        saleTenderEvaClarificationItemVO.setStatus(SaleTenderEvaClarificationItemStatusEnum.NEW.getValue());
        SaleTenderEvaClarificationItem saleTenderEvaClarificationItem = (SaleTenderEvaClarificationItem)((Object)SysUtil.copyProperties((Object)((Object)saleTenderEvaClarificationItemVO), SaleTenderEvaClarificationItem.class));
        this.saleTenderEvaClarificationItemService.save((Object)saleTenderEvaClarificationItem);
        this.invokeBaseRpcService.deleteSaleAttachmentByMainId(saleTenderEvaClarificationItem.getId());
        if (CollectionUtil.isNotEmpty(saleTenderEvaClarificationItemVO.getAttachmentList())) {
            saleTenderEvaClarificationItemVO.getAttachmentList().parallelStream().forEach(attachment -> attachment.setHeadId(saleTenderEvaClarificationItem.getId()));
            this.invokeBaseRpcService.insertSaleAttachmentBatchSomeColumn(saleTenderEvaClarificationItemVO.getAttachmentList());
        }
        return saleTenderEvaClarificationItem;
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public SaleTenderEvaClarificationItem replyEdit(SaleTenderEvaClarificationItemVO saleTenderEvaClarificationItemVO) {
        this.checkParamAndSet(saleTenderEvaClarificationItemVO);
        SaleTenderEvaClarificationItem item = (SaleTenderEvaClarificationItem)((Object)this.saleTenderEvaClarificationItemService.getById((Serializable)((Object)saleTenderEvaClarificationItemVO.getId())));
        Assert.notNull((Object)((Object)item), (String)I18nUtil.translate((String)"", (String)"\u975e\u6cd5\u64cd\u4f5c\uff01"));
        Assert.isTrue((boolean)SaleTenderEvaClarificationItemStatusEnum.NEW.getValue().equals(item.getStatus()), (String)I18nUtil.translate((String)"", (String)"\u5f53\u524d\u72b6\u6001\u4e0d\u5141\u8bb8\u7f16\u8f91\uff01"));
        SaleTenderEvaClarificationItem saleTenderEvaClarificationItem = (SaleTenderEvaClarificationItem)((Object)SysUtil.copyProperties((Object)((Object)saleTenderEvaClarificationItemVO), SaleTenderEvaClarificationItem.class));
        this.saleTenderEvaClarificationItemService.updateById((Object)saleTenderEvaClarificationItem);
        this.invokeBaseRpcService.deleteSaleAttachmentByMainId(saleTenderEvaClarificationItem.getId());
        if (CollectionUtil.isNotEmpty(saleTenderEvaClarificationItemVO.getAttachmentList())) {
            saleTenderEvaClarificationItemVO.getAttachmentList().parallelStream().forEach(attachment -> attachment.setHeadId(saleTenderEvaClarificationItem.getId()));
            this.invokeBaseRpcService.insertSaleAttachmentBatchSomeColumn(saleTenderEvaClarificationItemVO.getAttachmentList());
        }
        return saleTenderEvaClarificationItem;
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public SaleTenderEvaClarificationItem replySubmit(SaleTenderEvaClarificationItemVO saleTenderEvaClarificationItemVO) {
        Assert.hasText((String)saleTenderEvaClarificationItemVO.getReplyContent(), (String)I18nUtil.translate((String)"", (String)"\u56de\u590d\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        SaleTenderEvaClarificationHead evaClarificationHead = this.checkParamAndSet(saleTenderEvaClarificationItemVO);
        SaleTenderEvaClarificationItem saleTenderEvaClarificationItem = (SaleTenderEvaClarificationItem)((Object)this.saleTenderEvaClarificationItemService.getById((Serializable)((Object)saleTenderEvaClarificationItemVO.getId())));
        saleTenderEvaClarificationItem.setStatus(SaleTenderEvaClarificationItemStatusEnum.SUBMIT.getValue());
        saleTenderEvaClarificationItem.setReplyContent(saleTenderEvaClarificationItemVO.getReplyContent());
        this.saleTenderEvaClarificationItemService.updateById((Object)saleTenderEvaClarificationItem);
        evaClarificationHead.setStatus(TenderMentoringStatusEnum.REPLIED.getValue());
        ((SaleTenderEvaClarificationHeadMapper)this.baseMapper).updateById((Object)evaClarificationHead);
        this.invokeBaseRpcService.deleteSaleAttachmentByMainId(saleTenderEvaClarificationItem.getId());
        if (CollectionUtil.isNotEmpty(saleTenderEvaClarificationItemVO.getAttachmentList())) {
            saleTenderEvaClarificationItemVO.getAttachmentList().parallelStream().forEach(attachment -> attachment.setHeadId(saleTenderEvaClarificationItem.getId()));
            this.invokeBaseRpcService.insertSaleAttachmentBatchSomeColumn(saleTenderEvaClarificationItemVO.getAttachmentList());
        }
        this.purchaseTenderEvaClarificationHeadService.reply(evaClarificationHead, saleTenderEvaClarificationItemVO);
        return saleTenderEvaClarificationItem;
    }

    private SaleTenderEvaClarificationHead checkParamAndSet(SaleTenderEvaClarificationItemVO saleTenderEvaClarificationItem) {
        Assert.hasText((String)saleTenderEvaClarificationItem.getHeadId(), (String)I18nUtil.translate((String)"", (String)"\u975e\u6cd5\u64cd\u4f5c\uff01"));
        SaleTenderEvaClarificationHead evaClarificationHead = (SaleTenderEvaClarificationHead)((Object)((SaleTenderEvaClarificationHeadMapper)this.baseMapper).selectById((Serializable)((Object)saleTenderEvaClarificationItem.getHeadId())));
        Assert.notNull((Object)((Object)evaClarificationHead), (String)I18nUtil.translate((String)"", (String)"\u975e\u6cd5\u64cd\u4f5c\uff01"));
        Date currentDate = new Date();
        Assert.isTrue((currentDate.compareTo(evaClarificationHead.getFileClarificationEndTime()) != 1 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"", (String)"\u6f84\u6e05\u622a\u6b62\u65f6\u95f4\u5df2\u8fc7\uff01"));
        saleTenderEvaClarificationItem.setSubpackageId(evaClarificationHead.getSubpackageId());
        saleTenderEvaClarificationItem.setTenderProjectId(evaClarificationHead.getTenderProjectId());
        saleTenderEvaClarificationItem.setSupplierAccount(evaClarificationHead.getSupplierAccount());
        saleTenderEvaClarificationItem.setSupplierName(evaClarificationHead.getSupplierName());
        LoginUser loginUser = SysUtil.getLoginUser();
        saleTenderEvaClarificationItem.setRealName(loginUser.getRealname());
        return evaClarificationHead;
    }
}

