/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.tender.common.utils;

import com.els.common.exception.ELSBootException;
import com.els.common.util.I18nUtil;
import com.els.modules.tender.common.aspect.TenderFlagInjectionContext;
import com.els.modules.tender.common.utils.TenderBaseCommonUtils;
import com.els.modules.tender.project.enumerate.SubpackageInfoCheckTypeEnum;
import com.els.modules.tender.project.enumerate.SubpackageInfoCurrentStepEnum;
import com.els.modules.tender.project.enumerate.SubpackageInfoProcessTypeEnum;
import com.els.modules.tender.project.enumerate.TenderProjectSubpackageStatusEnum;
import java.util.Date;

public final class TenderOperationFieldUtils {
    private static final String OPEN_BID_STATUS = "openBidStatus";
    private static final String SUBPACKAGE_STATUS = "status";
    private static final String ANNOUNCE_OPEN_BID_TIME = "announceOpenBidTime";

    private TenderOperationFieldUtils() {
    }

    public static String getOpenBidStatus(Object obj) {
        Object fieldValue = TenderBaseCommonUtils.getFieldValue(obj, OPEN_BID_STATUS, true);
        if (fieldValue == null) {
            return null;
        }
        return (String)fieldValue;
    }

    public static void setOpenBidStatus(Object obj, Object value) {
        TenderBaseCommonUtils.setFieldValue(obj, OPEN_BID_STATUS, value, true);
    }

    public static void setAnnounceOpenBidTime(Object obj, Object value) {
        TenderBaseCommonUtils.setFieldValue(obj, ANNOUNCE_OPEN_BID_TIME, value, true);
    }

    public static String getFieldStringValue(Object obj, String fieldName) {
        Object fieldValue = TenderBaseCommonUtils.getFieldValue(obj, fieldName, true);
        if (fieldValue == null) {
            return null;
        }
        return (String)fieldValue;
    }

    public static Date getFieldDateValue(Object obj, String fieldName) {
        Object fieldValue = TenderBaseCommonUtils.getFieldValue(obj, fieldName, true);
        if (fieldValue == null) {
            return null;
        }
        return (Date)fieldValue;
    }

    public static void setFieldValue(Object obj, Object value, String fieldName) {
        TenderBaseCommonUtils.setFieldValue(obj, fieldName, value, true);
    }

    public static void setOpenBidSubpackageStatus(Object obj) {
        String tenderCheckType = TenderFlagInjectionContext.getTenderCheckType();
        String tenderProcessType = TenderFlagInjectionContext.getTenderProcessType();
        String currentStep = TenderFlagInjectionContext.getTenderCurrentStep();
        Integer subpackageStatus = null;
        if (SubpackageInfoCheckTypeEnum.PRE_TRIAL.getValue().equals(tenderCheckType)) {
            subpackageStatus = TenderProjectSubpackageStatusEnum.PRE_DECRYPTING.getValue();
        } else if (SubpackageInfoCheckTypeEnum.POST_TRIAL.getValue().equals(tenderCheckType) && SubpackageInfoProcessTypeEnum.ONE_STEP.getValue().equals(tenderProcessType)) {
            subpackageStatus = TenderProjectSubpackageStatusEnum.DECRYPTING.getValue();
        } else if (SubpackageInfoCheckTypeEnum.POST_TRIAL.getValue().equals(tenderCheckType) && SubpackageInfoProcessTypeEnum.TWO_STEP.getValue().equals(tenderProcessType) && SubpackageInfoCurrentStepEnum.FIRST_STEP.getValue().equals(currentStep)) {
            subpackageStatus = TenderProjectSubpackageStatusEnum.FIRST_STEP_DECRYPTING.getValue();
        } else if (SubpackageInfoCheckTypeEnum.POST_TRIAL.getValue().equals(tenderCheckType) && SubpackageInfoProcessTypeEnum.TWO_STEP.getValue().equals(tenderProcessType) && SubpackageInfoCurrentStepEnum.SECOND_STEP.getValue().equals(currentStep)) {
            subpackageStatus = TenderProjectSubpackageStatusEnum.RESULT_DECRYPTING.getValue();
        }
        if (subpackageStatus == null) {
            throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u5206\u5305\u72b6\u6001\u503c\u4e3a\u7a7a\uff01"));
        }
        TenderBaseCommonUtils.setFieldValue(obj, SUBPACKAGE_STATUS, subpackageStatus, false);
    }

    public static void setDecryptedSubpackageStatus(Object obj) {
        String tenderCheckType = TenderFlagInjectionContext.getTenderCheckType();
        String tenderProcessType = TenderFlagInjectionContext.getTenderProcessType();
        String currentStep = TenderFlagInjectionContext.getTenderCurrentStep();
        Integer subpackageStatus = null;
        if (SubpackageInfoCheckTypeEnum.PRE_TRIAL.getValue().equals(tenderCheckType)) {
            subpackageStatus = TenderProjectSubpackageStatusEnum.PRE_DECRYPTED.getValue();
        } else if (SubpackageInfoCheckTypeEnum.POST_TRIAL.getValue().equals(tenderCheckType) && SubpackageInfoProcessTypeEnum.ONE_STEP.getValue().equals(tenderProcessType)) {
            subpackageStatus = TenderProjectSubpackageStatusEnum.DECRYPTED.getValue();
        } else if (SubpackageInfoCheckTypeEnum.POST_TRIAL.getValue().equals(tenderCheckType) && SubpackageInfoProcessTypeEnum.TWO_STEP.getValue().equals(tenderProcessType) && SubpackageInfoCurrentStepEnum.FIRST_STEP.getValue().equals(currentStep)) {
            subpackageStatus = TenderProjectSubpackageStatusEnum.FIRST_STEP_DECRYPTED.getValue();
        } else if (SubpackageInfoCheckTypeEnum.POST_TRIAL.getValue().equals(tenderCheckType) && SubpackageInfoProcessTypeEnum.TWO_STEP.getValue().equals(tenderProcessType) && SubpackageInfoCurrentStepEnum.SECOND_STEP.getValue().equals(currentStep)) {
            subpackageStatus = TenderProjectSubpackageStatusEnum.RESULT_DECRYPTED.getValue();
        }
        if (subpackageStatus == null) {
            throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u5206\u5305\u72b6\u6001\u503c\u4e3a\u7a7a\uff01"));
        }
        TenderBaseCommonUtils.setFieldValue(obj, SUBPACKAGE_STATUS, subpackageStatus, false);
    }

    public static void setEndBidSubpackageStatus(Object obj) {
        String tenderCheckType = TenderFlagInjectionContext.getTenderCheckType();
        String tenderProcessType = TenderFlagInjectionContext.getTenderProcessType();
        String currentStep = TenderFlagInjectionContext.getTenderCurrentStep();
        Integer subpackageStatus = null;
        if (SubpackageInfoCheckTypeEnum.PRE_TRIAL.getValue().equals(tenderCheckType)) {
            subpackageStatus = TenderProjectSubpackageStatusEnum.PRE_END_OPEN_BID.getValue();
        } else if (SubpackageInfoCheckTypeEnum.POST_TRIAL.getValue().equals(tenderCheckType) && SubpackageInfoProcessTypeEnum.ONE_STEP.getValue().equals(tenderProcessType)) {
            subpackageStatus = TenderProjectSubpackageStatusEnum.END_OPEN_BID.getValue();
        } else if (SubpackageInfoCheckTypeEnum.POST_TRIAL.getValue().equals(tenderCheckType) && SubpackageInfoProcessTypeEnum.TWO_STEP.getValue().equals(tenderProcessType) && SubpackageInfoCurrentStepEnum.FIRST_STEP.getValue().equals(currentStep)) {
            subpackageStatus = TenderProjectSubpackageStatusEnum.FIRST_STEP_END_OPEN_BID.getValue();
        } else if (SubpackageInfoCheckTypeEnum.POST_TRIAL.getValue().equals(tenderCheckType) && SubpackageInfoProcessTypeEnum.TWO_STEP.getValue().equals(tenderProcessType) && SubpackageInfoCurrentStepEnum.SECOND_STEP.getValue().equals(currentStep)) {
            subpackageStatus = TenderProjectSubpackageStatusEnum.RESULT_END_OPEN_BID.getValue();
        }
        if (subpackageStatus == null) {
            throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u5206\u5305\u72b6\u6001\u503c\u4e3a\u7a7a\uff01"));
        }
        TenderBaseCommonUtils.setFieldValue(obj, SUBPACKAGE_STATUS, subpackageStatus, false);
    }

    public static Integer getEvaBiddingSubpackageStatus() {
        String tenderCheckType = TenderFlagInjectionContext.getTenderCheckType();
        String tenderProcessType = TenderFlagInjectionContext.getTenderProcessType();
        String currentStep = TenderFlagInjectionContext.getTenderCurrentStep();
        Integer subpackageStatus = null;
        if (SubpackageInfoCheckTypeEnum.PRE_TRIAL.getValue().equals(tenderCheckType)) {
            subpackageStatus = TenderProjectSubpackageStatusEnum.PRE_UNDER_EVALUATION.getValue();
        } else if (SubpackageInfoCheckTypeEnum.POST_TRIAL.getValue().equals(tenderCheckType) && SubpackageInfoProcessTypeEnum.ONE_STEP.getValue().equals(tenderProcessType)) {
            subpackageStatus = TenderProjectSubpackageStatusEnum.UNDER_EVALUATION.getValue();
        } else if (SubpackageInfoCheckTypeEnum.POST_TRIAL.getValue().equals(tenderCheckType) && SubpackageInfoProcessTypeEnum.TWO_STEP.getValue().equals(tenderProcessType) && SubpackageInfoCurrentStepEnum.FIRST_STEP.getValue().equals(currentStep)) {
            subpackageStatus = TenderProjectSubpackageStatusEnum.FIRST_STEP_UNDER_EVALUATION.getValue();
        } else if (SubpackageInfoCheckTypeEnum.POST_TRIAL.getValue().equals(tenderCheckType) && SubpackageInfoProcessTypeEnum.TWO_STEP.getValue().equals(tenderProcessType) && SubpackageInfoCurrentStepEnum.SECOND_STEP.getValue().equals(currentStep)) {
            subpackageStatus = TenderProjectSubpackageStatusEnum.RESULT_UNDER_EVALUATION.getValue();
        }
        if (subpackageStatus == null) {
            throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u5206\u5305\u72b6\u6001\u503c\u4e3a\u7a7a\uff01"));
        }
        return subpackageStatus;
    }

    public static Integer getEndEvaBidSubpackageStatus() {
        String tenderCheckType = TenderFlagInjectionContext.getTenderCheckType();
        String tenderProcessType = TenderFlagInjectionContext.getTenderProcessType();
        String currentStep = TenderFlagInjectionContext.getTenderCurrentStep();
        Integer subpackageStatus = null;
        if (SubpackageInfoCheckTypeEnum.PRE_TRIAL.getValue().equals(tenderCheckType)) {
            subpackageStatus = TenderProjectSubpackageStatusEnum.PRE_BID_EVA_END.getValue();
        } else if (SubpackageInfoCheckTypeEnum.POST_TRIAL.getValue().equals(tenderCheckType) && SubpackageInfoProcessTypeEnum.ONE_STEP.getValue().equals(tenderProcessType)) {
            subpackageStatus = TenderProjectSubpackageStatusEnum.BID_EVA_END.getValue();
        } else if (SubpackageInfoCheckTypeEnum.POST_TRIAL.getValue().equals(tenderCheckType) && SubpackageInfoProcessTypeEnum.TWO_STEP.getValue().equals(tenderProcessType) && SubpackageInfoCurrentStepEnum.FIRST_STEP.getValue().equals(currentStep)) {
            subpackageStatus = TenderProjectSubpackageStatusEnum.FIRST_STEP_BID_EVA_END.getValue();
        } else if (SubpackageInfoCheckTypeEnum.POST_TRIAL.getValue().equals(tenderCheckType) && SubpackageInfoProcessTypeEnum.TWO_STEP.getValue().equals(tenderProcessType) && SubpackageInfoCurrentStepEnum.SECOND_STEP.getValue().equals(currentStep)) {
            subpackageStatus = TenderProjectSubpackageStatusEnum.RESULT_BID_EVA_END.getValue();
        }
        if (subpackageStatus == null) {
            throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u5206\u5305\u72b6\u6001\u503c\u4e3a\u7a7a\uff01"));
        }
        return subpackageStatus;
    }

    public static Integer getTerminationEvaBidSubpackageStatus() {
        String tenderCheckType = TenderFlagInjectionContext.getTenderCheckType();
        String tenderProcessType = TenderFlagInjectionContext.getTenderProcessType();
        String currentStep = TenderFlagInjectionContext.getTenderCurrentStep();
        Integer subpackageStatus = null;
        if (SubpackageInfoCheckTypeEnum.PRE_TRIAL.getValue().equals(tenderCheckType)) {
            subpackageStatus = TenderProjectSubpackageStatusEnum.PRE_BID_EVA_TERMINATION.getValue();
        } else if (SubpackageInfoCheckTypeEnum.POST_TRIAL.getValue().equals(tenderCheckType) && SubpackageInfoProcessTypeEnum.ONE_STEP.getValue().equals(tenderProcessType)) {
            subpackageStatus = TenderProjectSubpackageStatusEnum.BID_EVA_TERMINATION.getValue();
        } else if (SubpackageInfoCheckTypeEnum.POST_TRIAL.getValue().equals(tenderCheckType) && SubpackageInfoProcessTypeEnum.TWO_STEP.getValue().equals(tenderProcessType) && SubpackageInfoCurrentStepEnum.FIRST_STEP.getValue().equals(currentStep)) {
            subpackageStatus = TenderProjectSubpackageStatusEnum.FIRST_STEP_BID_EVA_TERMINATION.getValue();
        } else if (SubpackageInfoCheckTypeEnum.POST_TRIAL.getValue().equals(tenderCheckType) && SubpackageInfoProcessTypeEnum.TWO_STEP.getValue().equals(tenderProcessType) && SubpackageInfoCurrentStepEnum.SECOND_STEP.getValue().equals(currentStep)) {
            subpackageStatus = TenderProjectSubpackageStatusEnum.RESULT_BID_EVA_TERMINATION.getValue();
        }
        if (subpackageStatus == null) {
            throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u5206\u5305\u72b6\u6001\u503c\u4e3a\u7a7a\uff01"));
        }
        return subpackageStatus;
    }
}

