/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.tender.evaluation.service.impl;

import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.constant.CommonConstant;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.tender.common.aspect.TenderFlagInjectionContext;
import com.els.modules.tender.evaluation.entity.PurchaseBidEvaJudgesWithdrawRecord;
import com.els.modules.tender.evaluation.entity.PurchaseTenderProjectBidEvaRegulationResult;
import com.els.modules.tender.evaluation.entity.PurchaseTenderProjectBidEvaRegulationResultHistory;
import com.els.modules.tender.evaluation.entity.PurchaseTenderProjectEvaExpertTask;
import com.els.modules.tender.evaluation.enumerate.TenderEvaGroupTypeEnum;
import com.els.modules.tender.evaluation.mapper.PurchaseBidEvaJudgesWithdrawRecordMapper;
import com.els.modules.tender.evaluation.service.PurchaseBidEvaJudgesWithdrawRecordService;
import com.els.modules.tender.evaluation.service.PurchaseTenderProjectBidEvaGroupSummaryResultService;
import com.els.modules.tender.evaluation.service.PurchaseTenderProjectBidEvaRegulationResultHistoryService;
import com.els.modules.tender.evaluation.service.PurchaseTenderProjectBidEvaRegulationResultService;
import com.els.modules.tender.evaluation.service.PurchaseTenderProjectEvaExpertTaskService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PurchaseBidEvaJudgesWithdrawRecordServiceImpl
extends BaseServiceImpl<PurchaseBidEvaJudgesWithdrawRecordMapper, PurchaseBidEvaJudgesWithdrawRecord>
implements PurchaseBidEvaJudgesWithdrawRecordService {
    @Autowired
    private PurchaseTenderProjectEvaExpertTaskService evaExpertTaskService;
    @Autowired
    private PurchaseTenderProjectBidEvaRegulationResultService evaRegulationResultService;
    @Autowired
    private PurchaseTenderProjectBidEvaGroupSummaryResultService evaSummaryResultService;
    @Autowired
    private PurchaseTenderProjectBidEvaRegulationResultHistoryService evaRegulationResultHistoryService;

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void withdraw(PurchaseBidEvaJudgesWithdrawRecord evaJudgesWithdrawRecord) {
        String judgesTaskItemId = evaJudgesWithdrawRecord.getJudgesTaskItemId();
        String evaGroupId = evaJudgesWithdrawRecord.getEvaGroupId();
        PurchaseTenderProjectEvaExpertTask evaExpertTask = (PurchaseTenderProjectEvaExpertTask)((Object)this.evaExpertTaskService.getById((Serializable)((Object)judgesTaskItemId)));
        evaExpertTask.setEvaGroupStatus("0");
        this.evaExpertTaskService.updateById((Object)evaExpertTask);
        this.evaSummaryResultService.deleteByMainId(evaExpertTask.getSubpackageId(), evaGroupId);
        List<PurchaseTenderProjectBidEvaRegulationResult> regulationResultList = this.evaRegulationResultService.selectByMainId(judgesTaskItemId, evaGroupId);
        ArrayList historyArrayList = SysUtil.copyProperties(regulationResultList, PurchaseTenderProjectBidEvaRegulationResultHistory.class);
        historyArrayList.stream().forEach(history -> history.setId(null));
        if (!regulationResultList.isEmpty()) {
            PurchaseTenderProjectBidEvaRegulationResult regulationResult = regulationResultList.get(0);
            if (TenderEvaGroupTypeEnum.PRICE_REVIEW.getValue().equals(regulationResult.getEvaGroupType())) {
                this.evaRegulationResultService.deleteByMainId(evaGroupId, judgesTaskItemId);
            }
        }
        evaJudgesWithdrawRecord.setId(IdWorker.getIdStr());
        evaJudgesWithdrawRecord.setEvaGroupId(evaExpertTask.getEvaGroupId());
        evaJudgesWithdrawRecord.setJudgesName(evaExpertTask.getJudgesName());
        evaJudgesWithdrawRecord.setJudgesElsAccount(evaExpertTask.getJudgesElsAccount());
        evaJudgesWithdrawRecord.setJudgesElsSubAccount(evaExpertTask.getJudgesElsSubAccount());
        evaJudgesWithdrawRecord.setJudgesTaskHeadId(evaExpertTask.getHeadId());
        evaJudgesWithdrawRecord.setJudgesTaskItemId(evaExpertTask.getId());
        evaJudgesWithdrawRecord.setSubpackageId(evaExpertTask.getSubpackageId());
        evaJudgesWithdrawRecord.setTenderProjectId(evaExpertTask.getTenderProjectId());
        evaJudgesWithdrawRecord.setWithDrawStatus("1");
        evaJudgesWithdrawRecord.setDeleted(CommonConstant.DEL_FLAG_0);
        evaJudgesWithdrawRecord.setElsAccount(TenantContext.getTenant());
        evaJudgesWithdrawRecord.setCheckType(TenderFlagInjectionContext.getTenderCheckType());
        evaJudgesWithdrawRecord.setProcessType(TenderFlagInjectionContext.getTenderProcessType());
        evaJudgesWithdrawRecord.setCurrentStep(TenderFlagInjectionContext.getTenderCurrentStep());
        this.save((Object)evaJudgesWithdrawRecord);
        historyArrayList.stream().forEach(history -> {
            history.setId(null);
            history.setJudgesWithdrawRecordId(evaJudgesWithdrawRecord.getId());
        });
        this.evaRegulationResultHistoryService.saveBatch(historyArrayList);
    }
}

