/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.tender.evaluation.service.impl;

import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.modules.tender.evaluation.entity.PurchaseTenderProjectBidEvaGroupSummaryResult;
import com.els.modules.tender.evaluation.mapper.PurchaseTenderProjectBidEvaGroupSummaryResultMapper;
import com.els.modules.tender.evaluation.service.PurchaseTenderProjectBidEvaGroupSummaryResultService;
import com.els.modules.tender.evaluation.vo.SupplierEvaRankingVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class PurchaseTenderProjectBidEvaGroupSummaryResultServiceImpl
extends BaseServiceImpl<PurchaseTenderProjectBidEvaGroupSummaryResultMapper, PurchaseTenderProjectBidEvaGroupSummaryResult>
implements PurchaseTenderProjectBidEvaGroupSummaryResultService {
    @Override
    public void add(PurchaseTenderProjectBidEvaGroupSummaryResult purchaseTenderProjectBidEvaGroupSummaryResult) {
        ((PurchaseTenderProjectBidEvaGroupSummaryResultMapper)this.baseMapper).insert((Object)purchaseTenderProjectBidEvaGroupSummaryResult);
    }

    @Override
    public void edit(PurchaseTenderProjectBidEvaGroupSummaryResult purchaseTenderProjectBidEvaGroupSummaryResult) {
        int count = ((PurchaseTenderProjectBidEvaGroupSummaryResultMapper)this.baseMapper).updateById((Object)purchaseTenderProjectBidEvaGroupSummaryResult);
        Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
    }

    @Override
    public void delete(String id) {
        ((PurchaseTenderProjectBidEvaGroupSummaryResultMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void deleteBatch(List<String> idList) {
        ((PurchaseTenderProjectBidEvaGroupSummaryResultMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    public List<SupplierEvaRankingVO> selectEvaGroupSummaryResultByMainId(String evaInfoId, String evaGroupId) {
        List<PurchaseTenderProjectBidEvaGroupSummaryResult> bidEvaGroupSummaryResultList = ((PurchaseTenderProjectBidEvaGroupSummaryResultMapper)this.baseMapper).selectByMainId(evaInfoId, evaGroupId);
        ArrayList<SupplierEvaRankingVO> result = new ArrayList<SupplierEvaRankingVO>();
        Map<String, List<PurchaseTenderProjectBidEvaGroupSummaryResult>> supplierAccountListMap = bidEvaGroupSummaryResultList.stream().collect(Collectors.groupingBy(PurchaseTenderProjectBidEvaGroupSummaryResult::getSupplierAccount));
        for (String supplierAccount : supplierAccountListMap.keySet()) {
            SupplierEvaRankingVO rankingVO = new SupplierEvaRankingVO();
            List<PurchaseTenderProjectBidEvaGroupSummaryResult> summaryResults = supplierAccountListMap.get(supplierAccount);
            if (summaryResults.isEmpty()) continue;
            rankingVO.setSupplierAccount(summaryResults.get(0).getSupplierAccount());
            rankingVO.setSupplierName(summaryResults.get(0).getSupplierName());
            this.calculateResult(rankingVO, summaryResults);
            result.add(rankingVO);
        }
        return result;
    }

    private void calculateResult(SupplierEvaRankingVO rankingVO, List<PurchaseTenderProjectBidEvaGroupSummaryResult> summaryResults) {
        Map groupResultListMap = summaryResults.stream().sorted(Comparator.comparingInt(PurchaseTenderProjectBidEvaGroupSummaryResult::getGroupOrderBy)).collect(Collectors.groupingBy(PurchaseTenderProjectBidEvaGroupSummaryResult::getEvaGroupId, LinkedHashMap::new, Collectors.toList()));
        for (String groupId : groupResultListMap.keySet()) {
            List summaryResultList = (List)groupResultListMap.get(groupId);
            for (Object summaryResult : summaryResultList) {
                SupplierEvaRankingVO.EvaGroupSummaryResult evaGroupSummaryResult = SupplierEvaRankingVO.EvaGroupSummaryResult.builder().evaGroupId(((PurchaseTenderProjectBidEvaGroupSummaryResult)((Object)summaryResult)).getEvaGroupId()).evaGroupType(((PurchaseTenderProjectBidEvaGroupSummaryResult)((Object)summaryResult)).getEvaGroupType()).totalScore(((PurchaseTenderProjectBidEvaGroupSummaryResult)((Object)summaryResult)).getScore()).invalid(((PurchaseTenderProjectBidEvaGroupSummaryResult)((Object)summaryResult)).getInvalid()).orderBy(((PurchaseTenderProjectBidEvaGroupSummaryResult)((Object)summaryResult)).getOrderBy()).weight(((PurchaseTenderProjectBidEvaGroupSummaryResult)((Object)summaryResult)).getWeight()).evaGroupResult(((PurchaseTenderProjectBidEvaGroupSummaryResult)((Object)summaryResult)).getResult()).build();
                rankingVO.setResultMap(groupId, evaGroupSummaryResult);
            }
        }
        Map<String, SupplierEvaRankingVO.EvaGroupSummaryResult> groupResultMap = rankingVO.getResult();
        BigDecimal totalScore = BigDecimal.ZERO;
        for (String key : groupResultMap.keySet()) {
            Object summaryResult;
            summaryResult = groupResultMap.get(key);
            rankingVO.setInvalid(((SupplierEvaRankingVO.EvaGroupSummaryResult)summaryResult).getInvalid());
            if ("1".equals(((SupplierEvaRankingVO.EvaGroupSummaryResult)summaryResult).getInvalid())) break;
            totalScore = totalScore.add(((SupplierEvaRankingVO.EvaGroupSummaryResult)summaryResult).getTotalScore() == null ? BigDecimal.ZERO : ((SupplierEvaRankingVO.EvaGroupSummaryResult)summaryResult).getTotalScore());
        }
        rankingVO.setTotalScore(totalScore);
    }

    @Override
    public void deleteByMainId(String evaInfoId, String evaGroupId) {
        ((PurchaseTenderProjectBidEvaGroupSummaryResultMapper)this.baseMapper).deleteByMainId(evaInfoId, evaGroupId);
    }

    @Override
    public List<SupplierEvaRankingVO> getSupplierEvaRanking(String evaInfoId) {
        List<SupplierEvaRankingVO> result = this.selectEvaGroupSummaryResultByMainId(evaInfoId, null);
        ArrayList<SupplierEvaRankingVO> invalidSupplierList = new ArrayList<SupplierEvaRankingVO>();
        Iterator<SupplierEvaRankingVO> iterator = result.iterator();
        while (iterator.hasNext()) {
            SupplierEvaRankingVO next = iterator.next();
            if (!"1".equals(next.getInvalid())) continue;
            next.setResult(null);
            next.setTotalScore(BigDecimal.ZERO);
            invalidSupplierList.add(next);
            iterator.remove();
        }
        result.sort(Comparator.comparing(SupplierEvaRankingVO::getTotalScore).reversed());
        int order = 1;
        if (!result.isEmpty()) {
            BigDecimal lastTotal = result.get(0).getTotalScore();
            for (SupplierEvaRankingVO supplierEvaRankingVO : result) {
                BigDecimal totalScore = supplierEvaRankingVO.getTotalScore();
                if (lastTotal.compareTo(totalScore) == 1) {
                    ++order;
                }
                supplierEvaRankingVO.setOrder(order);
            }
        }
        result.addAll(invalidSupplierList);
        return result;
    }
}

