/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.tender.evaluation.strategy.review.handler;

import com.els.common.util.SysUtil;
import com.els.modules.tender.attachment.entity.PurchaseTenderEvaluationGroup;
import com.els.modules.tender.attachment.entity.PurchaseTenderEvaluationPrinciples;
import com.els.modules.tender.evaluation.entity.PurchaseTenderProjectBidEvaRegulationResult;
import com.els.modules.tender.evaluation.strategy.review.AbstractSummaryStrategy;
import com.els.modules.tender.evaluation.vo.SupplierEvaRankingVO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;

@Component(value="scoreSummaryStrategy")
public class ScoreSummaryStrategy
extends AbstractSummaryStrategy {
    @Override
    public SupplierEvaRankingVO.EvaGroupSummaryResult summaryResult(PurchaseTenderEvaluationGroup evaluationGroup, PurchaseTenderEvaluationPrinciples evaluationPrinciples, List<PurchaseTenderProjectBidEvaRegulationResult> evaGroupRegulationResultList) {
        String summaryCalType = evaluationPrinciples.getSummaryCalType();
        Map<String, List<PurchaseTenderProjectBidEvaRegulationResult>> judgesMap = evaGroupRegulationResultList.parallelStream().collect(Collectors.groupingBy(regulationResult -> regulationResult.getJudgesElsAccount() + "_" + regulationResult.getJudgesElsSubAccount()));
        int judgesNumber = judgesMap.keySet().size();
        Map<String, List<PurchaseTenderProjectBidEvaRegulationResult>> regulationMap = evaGroupRegulationResultList.parallelStream().collect(Collectors.groupingBy(PurchaseTenderProjectBidEvaRegulationResult::getRegulationId));
        if ("1".equals(summaryCalType)) {
            return this.summaryScoreByRegulation(regulationMap, evaluationGroup, evaluationPrinciples, judgesNumber);
        }
        return this.summaryScoreByJudges(judgesMap, evaluationGroup, evaluationPrinciples, judgesNumber);
    }

    private SupplierEvaRankingVO.EvaGroupSummaryResult summaryScoreByRegulation(Map<String, List<PurchaseTenderProjectBidEvaRegulationResult>> regulationMap, PurchaseTenderEvaluationGroup evaluationGroup, PurchaseTenderEvaluationPrinciples evaluationPrinciples, int judgesNumber) {
        SupplierEvaRankingVO.EvaGroupSummaryResult.EvaGroupSummaryResultBuilder resultBuilder = SupplierEvaRankingVO.EvaGroupSummaryResult.builder().evaGroupName(evaluationGroup.getGroupName()).evaGroupId(evaluationGroup.getId()).evaGroupType(evaluationGroup.getGroupType()).invalid("0").evaGroupResult("1");
        Integer precision = evaluationPrinciples.getSummaryScorePrecision() == null ? 0 : Integer.valueOf(evaluationPrinciples.getSummaryScorePrecision());
        ArrayList<PurchaseTenderProjectBidEvaRegulationResult> summaryResultList = new ArrayList<PurchaseTenderProjectBidEvaRegulationResult>();
        for (String key : regulationMap.keySet()) {
            List<PurchaseTenderProjectBidEvaRegulationResult> regulationResultList = regulationMap.get(key);
            PurchaseTenderProjectBidEvaRegulationResult summaryResult = this.buildSummaryResult(regulationResultList);
            BigDecimal total = BigDecimal.ZERO;
            ArrayList<PurchaseTenderProjectBidEvaRegulationResult> actualsummaryResultList = new ArrayList<PurchaseTenderProjectBidEvaRegulationResult>();
            BigDecimal divideNumber = this.handlerPrinciples(judgesNumber, evaluationPrinciples, regulationResultList, actualsummaryResultList);
            for (PurchaseTenderProjectBidEvaRegulationResult regulationResult : actualsummaryResultList) {
                total = total.add(regulationResult.getScore());
            }
            summaryResult.setScore(total.divide(divideNumber, (int)precision, 4));
            summaryResultList.add(summaryResult);
        }
        resultBuilder.summaryRegulationResultList(summaryResultList);
        BigDecimal totalScope = BigDecimal.ZERO;
        for (PurchaseTenderProjectBidEvaRegulationResult regulationResult : summaryResultList) {
            totalScope = totalScope.add(regulationResult.getScore());
        }
        resultBuilder.totalScore(totalScope);
        return resultBuilder.build();
    }

    private SupplierEvaRankingVO.EvaGroupSummaryResult summaryScoreByJudges(Map<String, List<PurchaseTenderProjectBidEvaRegulationResult>> judgesMap, PurchaseTenderEvaluationGroup evaluationGroup, PurchaseTenderEvaluationPrinciples evaluationPrinciples, int judgesNumber) {
        SupplierEvaRankingVO.EvaGroupSummaryResult.EvaGroupSummaryResultBuilder resultBuilder = SupplierEvaRankingVO.EvaGroupSummaryResult.builder().evaGroupName(evaluationGroup.getGroupName()).evaGroupId(evaluationGroup.getId()).evaGroupType(evaluationGroup.getGroupType()).weight(evaluationGroup.getWeights()).orderBy(evaluationGroup.getOrderBy()).invalid("0").evaGroupResult("1");
        ArrayList<PurchaseTenderProjectBidEvaRegulationResult> summaryResultList = new ArrayList<PurchaseTenderProjectBidEvaRegulationResult>();
        for (String key : judgesMap.keySet()) {
            List<PurchaseTenderProjectBidEvaRegulationResult> regulationResultList = judgesMap.get(key);
            PurchaseTenderProjectBidEvaRegulationResult summaryResult = this.buildSummaryResult(regulationResultList);
            BigDecimal total = BigDecimal.ZERO;
            for (PurchaseTenderProjectBidEvaRegulationResult regulationResult : regulationResultList) {
                total = total.add(regulationResult.getScore());
            }
            summaryResult.setScore(total);
            summaryResultList.add(summaryResult);
        }
        resultBuilder.summaryRegulationResultList(summaryResultList);
        BigDecimal totalScope = BigDecimal.ZERO;
        ArrayList<PurchaseTenderProjectBidEvaRegulationResult> actualsummaryResultList = new ArrayList<PurchaseTenderProjectBidEvaRegulationResult>();
        BigDecimal divideNumber = this.handlerPrinciples(judgesNumber, evaluationPrinciples, summaryResultList, actualsummaryResultList);
        for (PurchaseTenderProjectBidEvaRegulationResult regulationResult : actualsummaryResultList) {
            totalScope = totalScope.add(regulationResult.getScore());
        }
        Integer precision = evaluationPrinciples.getSummaryScorePrecision() == null ? 0 : Integer.valueOf(evaluationPrinciples.getSummaryScorePrecision());
        resultBuilder.totalScore(totalScope.divide(divideNumber, (int)precision, 4));
        return resultBuilder.build();
    }

    private BigDecimal handlerPrinciples(int judgesNumber, PurchaseTenderEvaluationPrinciples evaluationPrinciples, List<PurchaseTenderProjectBidEvaRegulationResult> summaryResultList, List<PurchaseTenderProjectBidEvaRegulationResult> actualsummaryResultList) {
        String summaryCalRules = evaluationPrinciples.getSummaryCalRules();
        Integer precision = evaluationPrinciples.getSummaryScorePrecision() == null ? 0 : Integer.valueOf(evaluationPrinciples.getSummaryScorePrecision());
        Integer highestScoreNumber = evaluationPrinciples.getHighestScoreNumber() == null ? 0 : evaluationPrinciples.getHighestScoreNumber();
        Integer lowestScoreNumber = evaluationPrinciples.getLowestScoreNumber() == null ? 0 : evaluationPrinciples.getLowestScoreNumber();
        Integer offBase = evaluationPrinciples.getOffBase() == null ? 0 : evaluationPrinciples.getOffBase();
        BigDecimal divideNumber = BigDecimal.valueOf(judgesNumber);
        actualsummaryResultList.addAll(SysUtil.copyProperties(summaryResultList, PurchaseTenderProjectBidEvaRegulationResult.class));
        if ("1".equals(summaryCalRules)) {
            actualsummaryResultList.sort(Comparator.comparing(PurchaseTenderProjectBidEvaRegulationResult::getScore));
            this.removeFirsElements(lowestScoreNumber, actualsummaryResultList);
            actualsummaryResultList.sort(Comparator.comparing(PurchaseTenderProjectBidEvaRegulationResult::getScore).reversed());
            this.removeFirsElements(highestScoreNumber, actualsummaryResultList);
            divideNumber = divideNumber.subtract(BigDecimal.valueOf(lowestScoreNumber.intValue())).subtract(BigDecimal.valueOf(highestScoreNumber.intValue()));
        } else if ("2".equals(summaryCalRules)) {
            BigDecimal baseAverage = BigDecimal.ZERO;
            for (PurchaseTenderProjectBidEvaRegulationResult regulationResult : actualsummaryResultList) {
                baseAverage = baseAverage.add(regulationResult.getScore());
            }
            baseAverage = baseAverage.divide(BigDecimal.valueOf(judgesNumber), (int)precision, 4);
            Iterator<PurchaseTenderProjectBidEvaRegulationResult> iterator = actualsummaryResultList.iterator();
            while (iterator.hasNext()) {
                PurchaseTenderProjectBidEvaRegulationResult next = iterator.next();
                int flag = next.getScore().compareTo(baseAverage);
                int offset = 0;
                offset = flag == 1 ? next.getScore().subtract(baseAverage).multiply(new BigDecimal(100)).divide(baseAverage, (int)precision, 4).intValue() : baseAverage.subtract(next.getScore()).multiply(new BigDecimal(100)).divide(baseAverage, (int)precision, 4).intValue();
                if (offset <= offBase) continue;
                iterator.remove();
                divideNumber = divideNumber.subtract(BigDecimal.ONE);
            }
        }
        return divideNumber.compareTo(BigDecimal.ZERO) > 0 ? divideNumber : BigDecimal.valueOf(judgesNumber);
    }

    private void removeFirsElements(Integer nubmer, List<PurchaseTenderProjectBidEvaRegulationResult> regulationResultList) {
        if (nubmer == 0) {
            return;
        }
        int index = 0;
        Iterator<PurchaseTenderProjectBidEvaRegulationResult> iterator = regulationResultList.iterator();
        while (iterator.hasNext()) {
            iterator.next();
            iterator.remove();
            if (++index < nubmer) continue;
            break;
        }
    }
}

