/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.tender.notice.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.constant.CommonConstant;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.inquiry.api.enumerate.SourceTypeEnum;
import com.els.modules.inquiry.rpc.service.InquiryInvokeMessageRpcService;
import com.els.modules.inquiry.rpc.service.InquiryInvokeWorkFlowRpcService;
import com.els.modules.message.api.dto.PurchaseNoticeSupplierDTO;
import com.els.modules.notice.api.dto.PurchaseNoticeDTO;
import com.els.modules.tender.attachment.entity.PurchaseTenderProjectAttachmentInfo;
import com.els.modules.tender.attachment.service.PurchaseTenderProjectAttachmentInfoService;
import com.els.modules.tender.common.aspect.TenderFlagInjectionContext;
import com.els.modules.tender.common.event.TenderWriteBackSubpackageInfoEventDTO;
import com.els.modules.tender.common.utils.FastJsonUtils;
import com.els.modules.tender.common.utils.PushEventUtils;
import com.els.modules.tender.notice.entity.PurchaseTenderNoticeHead;
import com.els.modules.tender.notice.entity.PurchaseTenderNoticeItem;
import com.els.modules.tender.notice.entity.PurchaseTenderSupplierInvitation;
import com.els.modules.tender.notice.enumerate.PurchaseSysNoticeStatusEnum;
import com.els.modules.tender.notice.enumerate.PurchaseSysNoticeTypeEnum;
import com.els.modules.tender.notice.enumerate.PurchaseTenderNoticeBiddingTypeEnum;
import com.els.modules.tender.notice.enumerate.PurchaseTenderNoticeNoticeScopeEnum;
import com.els.modules.tender.notice.enumerate.PurchaseTenderNoticeStatusEnum;
import com.els.modules.tender.notice.enumerate.PurchaseTenderNoticeTypeEnum;
import com.els.modules.tender.notice.enumerate.TenderProjectMarginPayTypeEnum;
import com.els.modules.tender.notice.mapper.PurchaseTenderNoticeHeadMapper;
import com.els.modules.tender.notice.service.PurchaseTenderNoticeHeadService;
import com.els.modules.tender.notice.service.PurchaseTenderNoticeItemService;
import com.els.modules.tender.notice.service.PurchaseTenderSupplierInvitationService;
import com.els.modules.tender.notice.vo.PurchaseTenderNoticeHeadVO;
import com.els.modules.tender.openbid.enumerate.PurchaseOpenBidStatusEnum;
import com.els.modules.tender.openbid.job.TenderJobUtil;
import com.els.modules.tender.openbid.service.PurchaseTenderProjectOpenSettingHeadService;
import com.els.modules.tender.openbid.vo.PurchaseOpenSettingHeadVO;
import com.els.modules.tender.project.entity.PurchaseTenderProjectSubpackageInfo;
import com.els.modules.tender.project.enumerate.SubpackageInfoCheckTypeEnum;
import com.els.modules.tender.project.enumerate.TenderProjectSubpackageStatusEnum;
import com.els.modules.tender.project.service.PurchaseTenderProjectSubpackageInfoService;
import com.els.modules.tender.supplier.entity.TenderProjectSupplier;
import com.els.modules.tender.supplier.service.TenderInvitationSupplierReceiptService;
import com.els.modules.tender.supplier.service.TenderProjectSupplierService;
import com.els.modules.workflow.dto.AuditInputParamDTO;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class PurchaseTenderNoticeHeadServiceImpl
extends BaseServiceImpl<PurchaseTenderNoticeHeadMapper, PurchaseTenderNoticeHead>
implements PurchaseTenderNoticeHeadService {
    @Autowired
    private PurchaseTenderNoticeItemService purchaseTenderNoticeItemService;
    @Autowired
    private PurchaseTenderSupplierInvitationService purchaseTenderSupplierInvitationService;
    @Autowired
    private PurchaseTenderProjectSubpackageInfoService purchaseTenderProjectSubpackageInfoService;
    @Resource
    private InquiryInvokeMessageRpcService inquiryInvokeMessageRpcService;
    @Resource
    private InquiryInvokeWorkFlowRpcService inquiryInvokeWorkFlowRpcService;
    @Resource
    private InvokeBaseRpcService baseRpcService;
    @Autowired
    private PurchaseTenderProjectSubpackageInfoService subpackageInfoService;
    @Autowired
    private TenderProjectSupplierService tenderProjectSupplierService;
    @Autowired
    private PurchaseTenderProjectOpenSettingHeadService openSettingHeadService;
    @Autowired
    private PurchaseTenderProjectAttachmentInfoService attachmentInfoService;
    @Autowired
    private TenderInvitationSupplierReceiptService tenderInvitationSupplierReceiptService;

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void saveMain(PurchaseTenderNoticeHead purchaseTenderNoticeHead, List<PurchaseTenderNoticeItem> purchaseTenderNoticeItemList, List<PurchaseTenderSupplierInvitation> purchaseTenderSupplierInvitation) {
        boolean hasChangeNotic = PurchaseTenderNoticeTypeEnum.hasChange(purchaseTenderNoticeHead.getNoticeType());
        if (hasChangeNotic) {
            this.checkOpenBid(purchaseTenderNoticeHead);
            String noticeType = PurchaseTenderNoticeTypeEnum.getByChangeType(purchaseTenderNoticeHead.getNoticeType());
            List<PurchaseTenderNoticeHead> purchaseTenderNoticeHeadList = ((PurchaseTenderNoticeHeadMapper)this.baseMapper).selectBySubpackageId(purchaseTenderNoticeHead.getSubpackageId(), noticeType, null);
            PurchaseTenderNoticeHead tenderNoticeHead = purchaseTenderNoticeHeadList.get(0);
            tenderNoticeHead.setSignUpType(tenderNoticeHead.getSignUpType());
            tenderNoticeHead.setBiddingType(tenderNoticeHead.getBiddingType());
            tenderNoticeHead.setOfflineSaleAccount(tenderNoticeHead.getOfflineSaleAccount());
        }
        this.checkSubpackageStatus(purchaseTenderNoticeHead, purchaseTenderNoticeItemList);
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)purchaseTenderNoticeHead.getConsortiumBidding())) {
            purchaseTenderNoticeHead.setConsortiumBidding("0");
        }
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)purchaseTenderNoticeHead.getAudit())) {
            purchaseTenderNoticeHead.setAudit("0");
        }
        purchaseTenderNoticeHead.setDeleted(CommonConstant.DEL_FLAG_0);
        purchaseTenderNoticeHead.setNoticeStatus(PurchaseTenderNoticeStatusEnum.NEW.getValue());
        if ("0".equals(purchaseTenderNoticeHead.getAudit())) {
            purchaseTenderNoticeHead.setAuditStatus(AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
        } else {
            purchaseTenderNoticeHead.setAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
        }
        purchaseTenderNoticeHead.setNoticeNumber(this.baseRpcService.getNextCode("tenderNoticeNumber", (Object)purchaseTenderNoticeHead));
        purchaseTenderNoticeHead.setNoticeChangeNumber(this.baseRpcService.getNextCode("tenderChangeNoticeNumber", (Object)purchaseTenderNoticeHead));
        if (StringUtils.isBlank((String)purchaseTenderNoticeHead.getElsAccount())) {
            purchaseTenderNoticeHead.setElsAccount(TenantContext.getTenant());
        }
        ((PurchaseTenderNoticeHeadMapper)this.baseMapper).insert((Object)purchaseTenderNoticeHead);
        super.setHeadDefaultValue((BaseEntity)purchaseTenderNoticeHead);
        this.insertData(purchaseTenderNoticeHead, purchaseTenderNoticeItemList, purchaseTenderSupplierInvitation);
        if (hasChangeNotic) {
            return;
        }
        String subpackageStatus = TenderProjectSubpackageStatusEnum.getStatusValByNoticeType(purchaseTenderNoticeHead.getNoticeType(), AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
        this.updateTenderProjectSubpackageInfo(purchaseTenderNoticeHead, purchaseTenderNoticeItemList, subpackageStatus);
    }

    private void checkOpenBid(PurchaseTenderNoticeHead purchaseTenderNoticeHead) {
        PurchaseTenderProjectSubpackageInfo subpackageInfo = this.purchaseTenderProjectSubpackageInfoService.selectById(purchaseTenderNoticeHead.getSubpackageId());
        Assert.isTrue((boolean)ObjectUtil.isNotEmpty((Object)((Object)subpackageInfo)), (String)I18nUtil.translate((String)"", (String)"\u9879\u76ee\u4e0d\u5b58\u5728!"));
        if (PurchaseTenderNoticeTypeEnum.hasPreTrial(purchaseTenderNoticeHead.getNoticeType())) {
            Assert.isTrue((boolean)PurchaseOpenBidStatusEnum.NOT_OPEN_BID.getValue().equals(subpackageInfo.getPreOpenBidStatus()), (String)I18nUtil.translate((String)"", (String)"\u5f53\u524d\u5df2\u5f00\u6807\u4e0d\u5141\u8bb8\u53d8\u66f4\u516c\u544a!"));
        } else {
            Assert.isTrue((boolean)PurchaseOpenBidStatusEnum.NOT_OPEN_BID.getValue().equals(subpackageInfo.getOpenBidStatus()), (String)I18nUtil.translate((String)"", (String)"\u5f53\u524d\u5df2\u5f00\u6807\u4e0d\u5141\u8bb8\u53d8\u66f4\u516c\u544a!"));
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void updateMain(PurchaseTenderNoticeHead purchaseTenderNoticeHead, List<PurchaseTenderNoticeItem> purchaseTenderNoticeItemList, List<PurchaseTenderSupplierInvitation> purchaseTenderSupplierInvitation) {
        Assert.isTrue((boolean)org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)purchaseTenderNoticeHead.getId()), (String)I18nUtil.translate((String)"", (String)"\u8bf7\u5148\u4fdd\u5b58\u5355\u636e\uff01"));
        if ("0".equals(purchaseTenderNoticeHead.getAudit())) {
            purchaseTenderNoticeHead.setAuditStatus(AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
        } else {
            purchaseTenderNoticeHead.setAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
        }
        boolean hasChangeNotic = PurchaseTenderNoticeTypeEnum.hasChange(purchaseTenderNoticeHead.getNoticeType());
        if (hasChangeNotic) {
            this.checkOpenBid(purchaseTenderNoticeHead);
            List<PurchaseTenderNoticeHead> purchaseTenderNoticeHeadList = ((PurchaseTenderNoticeHeadMapper)this.baseMapper).selectBySubpackageId(purchaseTenderNoticeHead.getSubpackageId(), PurchaseTenderNoticeTypeEnum.getByChangeType(purchaseTenderNoticeHead.getNoticeType()), null);
            if (!purchaseTenderNoticeHeadList.isEmpty()) {
                PurchaseTenderNoticeHead tenderNoticeHead = purchaseTenderNoticeHeadList.get(0);
                purchaseTenderNoticeHead.setSignUpType(tenderNoticeHead.getSignUpType());
                purchaseTenderNoticeHead.setBiddingType(tenderNoticeHead.getBiddingType());
                purchaseTenderNoticeHead.setOfflineSaleAccount(tenderNoticeHead.getOfflineSaleAccount());
            }
        }
        this.checkSubpackageStatus(purchaseTenderNoticeHead, purchaseTenderNoticeItemList);
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)purchaseTenderNoticeHead.getConsortiumBidding())) {
            purchaseTenderNoticeHead.setConsortiumBidding("0");
        }
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)purchaseTenderNoticeHead.getAudit())) {
            purchaseTenderNoticeHead.setAudit("0");
        }
        ((PurchaseTenderNoticeHeadMapper)this.baseMapper).updateById((Object)purchaseTenderNoticeHead);
        this.purchaseTenderNoticeItemService.deleteByMainId(purchaseTenderNoticeHead.getId());
        this.purchaseTenderSupplierInvitationService.deleteByMainId(purchaseTenderNoticeHead.getId());
        this.insertData(purchaseTenderNoticeHead, purchaseTenderNoticeItemList, purchaseTenderSupplierInvitation);
        if (hasChangeNotic) {
            return;
        }
        String subpackageStatus = TenderProjectSubpackageStatusEnum.getStatusValByNoticeType(purchaseTenderNoticeHead.getNoticeType(), AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
        this.updateTenderProjectSubpackageInfo(purchaseTenderNoticeHead, purchaseTenderNoticeItemList, subpackageStatus);
    }

    private void checkSubpackageStatus(PurchaseTenderNoticeHead purchaseTenderNoticeHead, List<PurchaseTenderNoticeItem> purchaseTenderNoticeItemList) {
        Assert.isTrue((boolean)CollectionUtil.isNotEmpty(purchaseTenderNoticeItemList), (String)I18nUtil.translate((String)"", (String)"\u8bf7\u9009\u62e9\u5206\u5305!"));
        List<String> subpackageIds = purchaseTenderNoticeItemList.parallelStream().map(PurchaseTenderNoticeItem::getSubpackageId).collect(Collectors.toList());
        List<PurchaseTenderProjectSubpackageInfo> purchaseTenderProjectSubpackageInfos = this.subpackageInfoService.selectBatchIds(subpackageIds);
        for (PurchaseTenderProjectSubpackageInfo subpackageInfo : purchaseTenderProjectSubpackageInfos) {
            String changePoint = I18nUtil.translate((String)"", (String)"\u5f53\u524d[${0}]\u5206\u5305\u72b6\u6001\u4e3a[${1}] \u62db\u6807\u516c\u544a\u672a\u53d1\u51fa\u6216\u5df2\u5f00\u6807\u4e0d\u5141\u8bb8\u64cd\u4f5c\u5f53\u524d\u8282\u70b9!", (String[])new String[]{subpackageInfo.getSubpackageName(), TenderProjectSubpackageStatusEnum.getSubpackageStatusDesc(subpackageInfo.getStatus())});
            String noticePoint = I18nUtil.translate((String)"", (String)"\u5f53\u524d[${0}]\u5206\u5305\u72b6\u6001\u4e3a[${1}] \u62db\u6807\u6587\u4ef6\u672a\u53d1\u51fa\u6216\u62db\u6807\u516c\u544a\u5df2\u53d1\u51fa\u4e0d\u5141\u8bb8\u64cd\u4f5c\u5f53\u524d\u8282\u70b9!", (String[])new String[]{subpackageInfo.getSubpackageName(), TenderProjectSubpackageStatusEnum.getSubpackageStatusDesc(subpackageInfo.getStatus())});
            if (PurchaseTenderNoticeTypeEnum.hasChange(purchaseTenderNoticeHead.getNoticeType())) {
                Integer biddingFinishStatus = 0;
                Integer openBidingStatus = 0;
                if (PurchaseTenderNoticeTypeEnum.CHANGE_NOTICE.getValue().equals(purchaseTenderNoticeHead.getNoticeType())) {
                    biddingFinishStatus = TenderProjectSubpackageStatusEnum.BIDDING_FINISH.getValue();
                    openBidingStatus = TenderProjectSubpackageStatusEnum.OPEN_BIDING.getValue();
                }
                if (PurchaseTenderNoticeTypeEnum.PRE_CHANGE_NOTICE.getValue().equals(purchaseTenderNoticeHead.getNoticeType())) {
                    biddingFinishStatus = TenderProjectSubpackageStatusEnum.PRE_BIDDING_FINISH.getValue();
                    openBidingStatus = TenderProjectSubpackageStatusEnum.PRE_OPEN_BIDING.getValue();
                }
                if (PurchaseTenderNoticeTypeEnum.CHANGE_INVITATION_BID.getValue().equals(purchaseTenderNoticeHead.getNoticeType())) {
                    biddingFinishStatus = TenderProjectSubpackageStatusEnum.INVITATION_BIDDING_FINISH.getValue();
                    openBidingStatus = TenderProjectSubpackageStatusEnum.OPEN_BIDING.getValue();
                }
                Assert.isTrue((subpackageInfo.getStatus() >= biddingFinishStatus && subpackageInfo.getStatus() < openBidingStatus ? 1 : 0) != 0, (String)changePoint);
                continue;
            }
            Integer attachmentFinish = 0;
            Integer biddingPass = 0;
            Integer biddingAudit = 0;
            if (PurchaseTenderNoticeTypeEnum.INVITATION_BID.getValue().equals(purchaseTenderNoticeHead.getNoticeType())) {
                attachmentFinish = TenderProjectSubpackageStatusEnum.ATTACHMENT_FINISH.getValue();
                biddingPass = TenderProjectSubpackageStatusEnum.INVITATION_BIDDING_PASS.getValue();
                biddingAudit = TenderProjectSubpackageStatusEnum.INVITATION_BIDDING_AUDIT.getValue();
            }
            if (PurchaseTenderNoticeTypeEnum.PRE_NOTICE.getValue().equals(purchaseTenderNoticeHead.getNoticeType())) {
                attachmentFinish = TenderProjectSubpackageStatusEnum.PRE_ATTACHMENT_FINISH.getValue();
                biddingPass = TenderProjectSubpackageStatusEnum.PRE_BIDDING_PASS.getValue();
                biddingAudit = TenderProjectSubpackageStatusEnum.PRE_BIDDING_AUDIT.getValue();
            }
            if (PurchaseTenderNoticeTypeEnum.TENDER_NOTICE.getValue().equals(purchaseTenderNoticeHead.getNoticeType())) {
                attachmentFinish = TenderProjectSubpackageStatusEnum.ATTACHMENT_FINISH.getValue();
                biddingPass = TenderProjectSubpackageStatusEnum.BIDDING_PASS.getValue();
                biddingAudit = TenderProjectSubpackageStatusEnum.BIDDING_AUDIT.getValue();
            }
            Assert.isTrue((subpackageInfo.getStatus() >= attachmentFinish && subpackageInfo.getStatus() < biddingPass && !subpackageInfo.getStatus().equals(biddingAudit) ? 1 : 0) != 0, (String)noticePoint);
        }
    }

    private void insertData(PurchaseTenderNoticeHead purchaseTenderNoticeHead, List<PurchaseTenderNoticeItem> purchaseTenderNoticeItemList, List<PurchaseTenderSupplierInvitation> purchaseTenderSupplierInvitationList) {
        if (!CollectionUtils.isEmpty(purchaseTenderNoticeItemList)) {
            for (PurchaseTenderNoticeItem entity : purchaseTenderNoticeItemList) {
                entity.setHeadId(purchaseTenderNoticeHead.getId());
                entity.setElsAccount(TenantContext.getTenant());
                entity.setDeleted(CommonConstant.DEL_FLAG_0);
                entity.setTenderProjectId(purchaseTenderNoticeHead.getTenderProjectId());
                SysUtil.setSysParam((BaseEntity)entity, (BaseEntity)purchaseTenderNoticeHead);
            }
            this.purchaseTenderNoticeItemService.saveBatch(purchaseTenderNoticeItemList, 2000);
        }
        if (!purchaseTenderSupplierInvitationList.isEmpty() && PurchaseTenderNoticeTypeEnum.hasInvitationBid(purchaseTenderNoticeHead.getNoticeType())) {
            purchaseTenderSupplierInvitationList.parallelStream().forEach(invitation -> {
                invitation.setHeadId(purchaseTenderNoticeHead.getId());
                invitation.setSubpackageId(purchaseTenderNoticeHead.getSubpackageId());
                invitation.setTenderProjectId(purchaseTenderNoticeHead.getTenderProjectId());
                invitation.setElsAccount(TenantContext.getTenant());
                invitation.setDeleted(CommonConstant.DEL_FLAG_0);
                invitation.setId(IdWorker.getIdStr());
                SysUtil.setSysParam((BaseEntity)invitation, (BaseEntity)purchaseTenderNoticeHead);
            });
            this.purchaseTenderSupplierInvitationService.saveBatch(purchaseTenderSupplierInvitationList, 2000);
        }
        PurchaseTenderProjectSubpackageInfo subpackageInfo = this.subpackageInfoService.selectById(purchaseTenderNoticeHead.getSubpackageId());
        boolean hasPreTrial = PurchaseTenderNoticeTypeEnum.hasPreTrial(purchaseTenderNoticeHead.getNoticeType());
        if (hasPreTrial) {
            subpackageInfo.setPreConsortiumBidding(purchaseTenderNoticeHead.getConsortiumBidding());
        } else {
            subpackageInfo.setResultConsortiumBidding(purchaseTenderNoticeHead.getConsortiumBidding());
        }
        this.subpackageInfoService.updateById((Object)subpackageInfo);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void deleteMain(String id) {
        this.purchaseTenderNoticeItemService.deleteByMainId(id);
        this.purchaseTenderSupplierInvitationService.deleteByMainId(id);
        ((PurchaseTenderNoticeHeadMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void deleteBatchMain(List<String> idList) {
        for (Serializable serializable : idList) {
            this.purchaseTenderNoticeItemService.deleteByMainId(serializable.toString());
            this.purchaseTenderSupplierInvitationService.deleteByMainId(serializable.toString());
            ((PurchaseTenderNoticeHeadMapper)this.baseMapper).deleteById(serializable);
        }
    }

    @Override
    public PurchaseTenderNoticeHeadVO queryById(String id) {
        PurchaseTenderNoticeHead purchaseTenderNoticeHead = (PurchaseTenderNoticeHead)((Object)this.getById((Serializable)((Object)id)));
        PurchaseTenderNoticeHeadVO purchaseTenderNoticeHeadVO = new PurchaseTenderNoticeHeadVO();
        BeanUtils.copyProperties((Object)((Object)purchaseTenderNoticeHead), (Object)((Object)purchaseTenderNoticeHeadVO));
        List<PurchaseTenderNoticeItem> purchaseTenderNoticeItemList = this.purchaseTenderNoticeItemService.selectByMainId(id);
        purchaseTenderNoticeHeadVO.setPurchaseTenderNoticeItemList(purchaseTenderNoticeItemList);
        List<PurchaseTenderSupplierInvitation> purchaseTenderSupplierInvitationList = this.purchaseTenderSupplierInvitationService.selectByMainId(id);
        purchaseTenderNoticeHeadVO.setPurchaseTenderSupplierInvitation(purchaseTenderSupplierInvitationList);
        return purchaseTenderNoticeHeadVO;
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void submit(PurchaseTenderNoticeHead purchaseTenderNoticeHead, List<PurchaseTenderNoticeItem> purchaseTenderNoticeItemList, List<PurchaseTenderSupplierInvitation> purchaseTenderSupplierInvitationList) {
        Assert.isTrue((boolean)ObjectUtil.isNotEmpty((Object)((Object)purchaseTenderNoticeHead)), (String)I18nUtil.translate((String)"", (String)"\u91c7\u8d2d\u62db\u6807\u9879\u76ee\u516c\u544a\u4fe1\u606f\u4e0d\u5b58\u5728!"));
        Assert.isTrue((boolean)ObjectUtil.isNotEmpty((Object)((Object)purchaseTenderNoticeHead)), (String)I18nUtil.translate((String)"", (String)"\u91c7\u8d2d\u62db\u6807\u9879\u76ee\u516c\u544a\u4fe1\u606f\u4e0d\u5b58\u5728!"));
        this.checkOpenBid(purchaseTenderNoticeHead);
        this.checkParam(purchaseTenderNoticeHead, purchaseTenderNoticeItemList, purchaseTenderSupplierInvitationList);
        purchaseTenderNoticeHead.setNoticeStatus(PurchaseTenderNoticeStatusEnum.TO_BE_PUBLISHED.getValue());
        this.updateById((Object)purchaseTenderNoticeHead);
        PurchaseTenderNoticeTypeEnum noticeTypeEnum = PurchaseTenderNoticeTypeEnum.getPurchaseTenderNoticeTypeEnum(purchaseTenderNoticeHead.getNoticeType());
        String noticeNumber = null;
        noticeNumber = PurchaseTenderNoticeTypeEnum.hasChange(purchaseTenderNoticeHead.getNoticeType()) ? purchaseTenderNoticeHead.getNoticeChangeNumber() : purchaseTenderNoticeHead.getNoticeNumber();
        String subject = noticeTypeEnum.getDesc() + "\u5ba1\u6279,\u5355\u53f7\uff1a" + noticeNumber;
        AuditInputParamDTO dto = new AuditInputParamDTO();
        dto.setBusinessId(purchaseTenderNoticeHead.getId());
        dto.setBusinessType(noticeTypeEnum.getBusinessType());
        dto.setAuditSubject(subject);
        dto.setParams(JSONObject.toJSONString((Object)((Object)purchaseTenderNoticeHead)));
        this.inquiryInvokeWorkFlowRpcService.submit(dto);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void saveOrUpdatePublish(PurchaseTenderNoticeHead dbHead, List<PurchaseTenderNoticeItem> purchaseTenderNoticeItemList, List<PurchaseTenderSupplierInvitation> purchaseTenderSupplierInvitation) {
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)dbHead.getId())) {
            this.saveMain(dbHead, purchaseTenderNoticeItemList, purchaseTenderSupplierInvitation);
        } else {
            this.updateMain(dbHead, purchaseTenderNoticeItemList, purchaseTenderSupplierInvitation);
        }
        Assert.isTrue((boolean)PurchaseTenderNoticeStatusEnum.NEW.getValue().equals(dbHead.getNoticeStatus()), (String)I18nUtil.translate((String)"", (String)"\u5f53\u524d\u5355\u636e\u5df2\u53d1\u5e03\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u53d1\u5e03!"));
        if ("1".equals(dbHead.getAudit())) {
            this.submit(dbHead, purchaseTenderNoticeItemList, purchaseTenderSupplierInvitation);
            return;
        }
        this.publish(dbHead, purchaseTenderNoticeItemList, purchaseTenderSupplierInvitation);
    }

    @Override
    public List<PurchaseTenderNoticeHead> queryNoticeHeadBySubpackageId(String subpackageId, String noticeType, String noticeStatus) {
        return ((PurchaseTenderNoticeHeadMapper)this.baseMapper).selectBySubpackageId(subpackageId, noticeType, noticeStatus);
    }

    @Override
    public PurchaseTenderNoticeHeadVO queryBySubpackageId(String subpackageId, String noticeType) {
        PurchaseTenderNoticeHeadVO purchaseTenderNoticeHeadVO = new PurchaseTenderNoticeHeadVO();
        Assert.isTrue((boolean)org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)noticeType), (String)I18nUtil.translate((String)"", (String)"\u516c\u544a\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a!"));
        List<PurchaseTenderNoticeHead> purchaseTenderNoticeHeadList = ((PurchaseTenderNoticeHeadMapper)this.baseMapper).selectBySubpackageId(subpackageId, noticeType, null);
        if (CollectionUtil.isEmpty(purchaseTenderNoticeHeadList)) {
            if (PurchaseTenderNoticeTypeEnum.hasInvitationBid(noticeType)) {
                PurchaseTenderProjectSubpackageInfo purchaseTenderProjectSubpackageInfo = (PurchaseTenderProjectSubpackageInfo)((Object)this.purchaseTenderProjectSubpackageInfoService.getById((Serializable)((Object)subpackageId)));
                if (!SubpackageInfoCheckTypeEnum.hasPreTrial(purchaseTenderProjectSubpackageInfo.getCheckType())) {
                    return null;
                }
                TenderProjectSupplier querySupplier = new TenderProjectSupplier().setSubpackageId(subpackageId).setPreShortlisted("1");
                List<TenderProjectSupplier> tenderProjectSuppliers = this.tenderProjectSupplierService.selectBySubpackageId(querySupplier);
                if (CollectionUtil.isNotEmpty(tenderProjectSuppliers)) {
                    ArrayList supplierInvitations = SysUtil.copyProperties(tenderProjectSuppliers, PurchaseTenderSupplierInvitation.class);
                    purchaseTenderNoticeHeadVO.setPurchaseTenderSupplierInvitation(supplierInvitations);
                    purchaseTenderNoticeHeadVO.setNoticeStatus(PurchaseTenderNoticeStatusEnum.NEW.getValue());
                    return purchaseTenderNoticeHeadVO;
                }
            }
            return null;
        }
        PurchaseTenderNoticeHead purchaseTenderNoticeHead = purchaseTenderNoticeHeadList.get(0);
        BeanUtils.copyProperties((Object)((Object)purchaseTenderNoticeHead), (Object)((Object)purchaseTenderNoticeHeadVO));
        List<PurchaseTenderNoticeItem> purchaseTenderNoticeItems = this.purchaseTenderNoticeItemService.selectByMainId(purchaseTenderNoticeHeadVO.getId());
        purchaseTenderNoticeHeadVO.setPurchaseTenderNoticeItemList(purchaseTenderNoticeItems);
        if (PurchaseTenderNoticeTypeEnum.INVITATION_BID.getValue().equals(purchaseTenderNoticeHeadVO.getNoticeType())) {
            List<PurchaseTenderSupplierInvitation> purchaseTenderSupplierInvitations = this.purchaseTenderSupplierInvitationService.selectByMainId(purchaseTenderNoticeHeadVO.getId());
            purchaseTenderNoticeHeadVO.setPurchaseTenderSupplierInvitation(purchaseTenderSupplierInvitations);
        }
        return purchaseTenderNoticeHeadVO;
    }

    @Override
    public List<PurchaseTenderNoticeHeadVO> queryList(String subpackageId, String noticeType, String noticeStatus) {
        Assert.isTrue((boolean)org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)subpackageId), (String)I18nUtil.translate((String)"", (String)"\u5206\u5305Id\u4e0d\u80fd\u4e3a\u7a7a!"));
        Assert.isTrue((boolean)org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)noticeType), (String)I18nUtil.translate((String)"", (String)"\u516c\u544a\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a!"));
        List<PurchaseTenderNoticeHead> purchaseTenderNoticeHeadList = ((PurchaseTenderNoticeHeadMapper)this.baseMapper).selectBySubpackageId(subpackageId, noticeType, noticeStatus);
        if (CollectionUtil.isEmpty(purchaseTenderNoticeHeadList)) {
            return null;
        }
        List filterNoticeHead = purchaseTenderNoticeHeadList.stream().filter(noticeHead -> PurchaseTenderNoticeStatusEnum.CHANGE.getValue().equals(noticeHead.getNoticeStatus()) || PurchaseTenderNoticeStatusEnum.PUBLISHED.getValue().equals(noticeHead.getNoticeStatus())).collect(Collectors.toList());
        ArrayList noticeHeadVOS = SysUtil.copyProperties(filterNoticeHead, PurchaseTenderNoticeHeadVO.class);
        return noticeHeadVOS;
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void publish(PurchaseTenderNoticeHead purchaseTenderNoticeHead, List<PurchaseTenderNoticeItem> purchaseTenderNoticeItemList, List<PurchaseTenderSupplierInvitation> purchaseTenderSupplierInvitationList) {
        PurchaseTenderProjectSubpackageInfo subpackageInfo;
        PurchaseOpenSettingHeadVO purchaseOpenSettingHeadVO;
        Assert.isTrue((boolean)ObjectUtil.isNotEmpty((Object)((Object)purchaseTenderNoticeHead)), (String)I18nUtil.translate((String)"", (String)"\u91c7\u8d2d\u62db\u6807\u9879\u76ee\u516c\u544a\u4fe1\u606f\u4e0d\u5b58\u5728!"));
        this.checkOpenBid(purchaseTenderNoticeHead);
        HashSet<PurchaseTenderNoticeHead> purchaseTenderNoticeHeadList = new HashSet<PurchaseTenderNoticeHead>();
        if (PurchaseTenderNoticeTypeEnum.hasChange(purchaseTenderNoticeHead.getNoticeType())) {
            LambdaQueryWrapper qw = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)qw.in(PurchaseTenderNoticeHead::getSubpackageId, new Object[]{purchaseTenderNoticeHead.getSubpackageId()})).in(PurchaseTenderNoticeHead::getNoticeType, new Object[]{PurchaseTenderNoticeTypeEnum.getByChangeType(purchaseTenderNoticeHead.getNoticeType()), purchaseTenderNoticeHead.getNoticeType()})).eq(PurchaseTenderNoticeHead::getNoticeStatus, (Object)PurchaseTenderNoticeStatusEnum.PUBLISHED.getValue());
            List list = this.list((Wrapper)qw);
            if (CollectionUtil.isNotEmpty((Collection)list)) {
                for (PurchaseTenderNoticeHead tenderNoticeHead : list) {
                    tenderNoticeHead.setNoticeStatus(PurchaseTenderNoticeStatusEnum.CHANGE.getValue());
                    purchaseTenderNoticeHeadList.add(tenderNoticeHead);
                }
            }
        }
        PurchaseTenderProjectSubpackageInfo purchaseTenderProjectSubpackageInfo = this.checkParam(purchaseTenderNoticeHead, purchaseTenderNoticeItemList, purchaseTenderSupplierInvitationList);
        if (PurchaseTenderNoticeTypeEnum.INVITATION_BID.getValue().equals(purchaseTenderNoticeHead.getNoticeType()) && !SubpackageInfoCheckTypeEnum.hasPreTrial(TenderFlagInjectionContext.getTenderCheckType())) {
            this.tenderProjectSupplierService.addBatch(purchaseTenderNoticeHead, purchaseTenderNoticeItemList, purchaseTenderSupplierInvitationList);
            this.tenderInvitationSupplierReceiptService.addBatchByNotice(purchaseTenderNoticeItemList, purchaseTenderSupplierInvitationList);
        }
        purchaseTenderNoticeHead.setNoticeStatus(PurchaseTenderNoticeStatusEnum.PUBLISHED.getValue());
        purchaseTenderNoticeHead.setTenderProjectName(purchaseTenderProjectSubpackageInfo.getTenderProjectName());
        purchaseTenderNoticeHead.setPublishTime(new Date());
        this.publishSysNotice(purchaseTenderNoticeHead, purchaseTenderProjectSubpackageInfo);
        purchaseTenderNoticeHeadList.add(purchaseTenderNoticeHead);
        this.updateBatchById(purchaseTenderNoticeHeadList);
        Set subpackageIds = purchaseTenderNoticeItemList.parallelStream().map(PurchaseTenderNoticeItem::getSubpackageId).collect(Collectors.toSet());
        List<PurchaseTenderProjectAttachmentInfo> attachmentInfoList = this.attachmentInfoService.selectBySubpackageIds(new ArrayList<String>(subpackageIds));
        List noSubmitFileSubpackageInfo = attachmentInfoList.stream().filter(attachmentInfo -> !subpackageIds.contains(attachmentInfo.getSubpackageId())).map(PurchaseTenderProjectAttachmentInfo::getSubpackageName).collect(Collectors.toList());
        Assert.isTrue((boolean)noSubmitFileSubpackageInfo.isEmpty(), (String)I18nUtil.translate((String)"", (String)"\u5206\u5305{}\u7684\u62db\u6807\u6587\u4ef6\u672a\u53d1\u51fa!", (String[])new String[]{String.join((CharSequence)",", noSubmitFileSubpackageInfo)}));
        attachmentInfoList.stream().forEach(attachmentInfo -> {
            attachmentInfo.setTenderProjectName(purchaseTenderProjectSubpackageInfo.getTenderProjectName());
            attachmentInfo.setContactsPhone(purchaseTenderNoticeHead.getContactsPhone());
            attachmentInfo.setOfflineSaleAccount(purchaseTenderNoticeHead.getOfflineSaleAccount());
        });
        this.attachmentInfoService.updateBatchById(attachmentInfoList);
        String subpackageStatus = TenderProjectSubpackageStatusEnum.getStatusValByNoticeType(purchaseTenderNoticeHead.getNoticeType(), AuditStatusEnum.AUDIT_FINISH.getValue());
        this.updateTenderProjectSubpackageInfo(purchaseTenderNoticeHead, purchaseTenderNoticeItemList, subpackageStatus);
        if ((PurchaseTenderNoticeTypeEnum.CHANGE_NOTICE.getValue().equals(purchaseTenderNoticeHead.getNoticeType()) || PurchaseTenderNoticeTypeEnum.PRE_CHANGE_NOTICE.getValue().equals(purchaseTenderNoticeHead.getNoticeType()) || PurchaseTenderNoticeTypeEnum.CHANGE_INVITATION_BID.getValue().equals(purchaseTenderNoticeHead.getNoticeType())) && "1".equals((purchaseOpenSettingHeadVO = this.openSettingHeadService.queryBySubpackageId((subpackageInfo = this.subpackageInfoService.selectById(purchaseTenderNoticeHead.getSubpackageId())).getId())).getAutoOpenBid())) {
            TenderJobUtil.createOrUpdateOpenBidAlertJob(subpackageInfo, purchaseTenderNoticeHead.getOpenBiddingTime());
        }
        if (PurchaseTenderNoticeTypeEnum.CHANGE_NOTICE.getValue().equals(purchaseTenderNoticeHead.getNoticeType()) || PurchaseTenderNoticeTypeEnum.INVITATION_BID.getValue().equals(purchaseTenderNoticeHead.getNoticeType()) || PurchaseTenderNoticeTypeEnum.PRE_CHANGE_NOTICE.getValue().equals(purchaseTenderNoticeHead.getNoticeType()) || PurchaseTenderNoticeTypeEnum.CHANGE_INVITATION_BID.getValue().equals(purchaseTenderNoticeHead.getNoticeType())) {
            StringBuilder urlParams = new StringBuilder("tenderProjectId=").append(purchaseTenderNoticeHead.getTenderProjectId()).append("&subpackageId=").append(purchaseTenderNoticeHead.getSubpackageId());
            String operation = "tenderChangeNotice";
            TenderProjectSupplier supplier = new TenderProjectSupplier();
            supplier.setSubpackageId(purchaseTenderNoticeHead.getSubpackageId());
            supplier.setPreShortlisted("1");
            if (PurchaseTenderNoticeTypeEnum.PRE_CHANGE_NOTICE.getValue().equals(purchaseTenderNoticeHead.getNoticeType())) {
                operation = "preTenderChangeNotice";
                supplier.setPreShortlisted(null);
            } else if (PurchaseTenderNoticeTypeEnum.INVITATION_BID.getValue().equals(purchaseTenderNoticeHead.getNoticeType())) {
                operation = "tenderInvitationNotice";
            }
            List<TenderProjectSupplier> tenderProjectSuppliers = this.tenderProjectSupplierService.selectBySubpackageId(supplier);
            if (!tenderProjectSuppliers.isEmpty()) {
                List toElsAccountList = tenderProjectSuppliers.stream().map(TenderProjectSupplier::getSupplierAccount).collect(Collectors.toList());
                Map businessObj = FastJsonUtils.toMap((Object)purchaseTenderNoticeHead);
                businessObj.put("purchaseEnterpriseName", tenderProjectSuppliers.get(0).getPurchaseEnterpriseName());
                this.sendMsg(TenantContext.getTenant(), toElsAccountList, businessObj, urlParams.toString(), "tender", operation);
            }
        }
    }

    @Override
    public void updateAuditStatus(String id, String processInstanceId, String auditStatus, String bpmnType) {
        PurchaseTenderNoticeHead purchaseTenderNoticeHead = (PurchaseTenderNoticeHead)((Object)this.getById((Serializable)((Object)id)));
        purchaseTenderNoticeHead.setFlowId(processInstanceId);
        purchaseTenderNoticeHead.setAuditStatus(auditStatus);
        purchaseTenderNoticeHead.setWorkFlowType(bpmnType);
        List<PurchaseTenderNoticeItem> purchaseTenderNoticeItems = this.purchaseTenderNoticeItemService.selectByMainId(id);
        String subpackageStatus = TenderProjectSubpackageStatusEnum.getStatusValByNoticeType(purchaseTenderNoticeHead.getNoticeType(), auditStatus);
        String status = null;
        status = AuditStatusEnum.AUDIT_FINISH.getValue().equals(auditStatus) ? PurchaseTenderNoticeStatusEnum.PUBLISHED.getValue() : (AuditStatusEnum.AUDIT_REJECT.getValue().equals(auditStatus) ? PurchaseTenderNoticeStatusEnum.NEW.getValue() : (AuditStatusEnum.AUDIT_NEW.getValue().equals(auditStatus) ? PurchaseTenderNoticeStatusEnum.NEW.getValue() : PurchaseTenderNoticeStatusEnum.TO_BE_PUBLISHED.getValue()));
        purchaseTenderNoticeHead.setNoticeStatus(status);
        this.updateById((Object)purchaseTenderNoticeHead);
        this.updateTenderProjectSubpackageInfo(purchaseTenderNoticeHead, purchaseTenderNoticeItems, subpackageStatus);
    }

    private void updateTenderProjectSubpackageInfo(PurchaseTenderNoticeHead purchaseTenderNoticeHead, List<PurchaseTenderNoticeItem> purchaseTenderNoticeItems, String subPackageStatus) {
        PurchaseTenderNoticeHeadVO purchaseTenderNoticeHeadVO = (PurchaseTenderNoticeHeadVO)((Object)SysUtil.copyProperties((Object)((Object)purchaseTenderNoticeHead), PurchaseTenderNoticeHeadVO.class));
        purchaseTenderNoticeHeadVO.setPurchaseTenderNoticeItemList(purchaseTenderNoticeItems);
        TenderWriteBackSubpackageInfoEventDTO eventDTO = TenderWriteBackSubpackageInfoEventDTO.builder().event((Object)purchaseTenderNoticeHeadVO).subpackageId(purchaseTenderNoticeHeadVO.getSubpackageId()).subpackageStatus(subPackageStatus).build();
        PushEventUtils.updateSubpackageInfo(eventDTO);
    }

    private void publishSysNotice(PurchaseTenderNoticeHead purchaseTenderNoticeHead, PurchaseTenderProjectSubpackageInfo purchaseTenderProjectSubpackageInfo) {
        String signUp;
        PurchaseNoticeDTO notice = new PurchaseNoticeDTO();
        notice.setBusAccount(purchaseTenderNoticeHead.getElsAccount());
        notice.setBusinessType(SourceTypeEnum.TENDER_BULLETIN.getValue());
        notice.setBusinessId(purchaseTenderNoticeHead.getId());
        notice.setTemplateNumber(purchaseTenderNoticeHead.getTemplateNumber());
        notice.setTemplateVersion(purchaseTenderNoticeHead.getTemplateVersion());
        notice.setTemplateAccount(purchaseTenderNoticeHead.getTemplateAccount());
        notice.setNoticeTitle(purchaseTenderNoticeHead.getNoticeTitle());
        notice.setNoticeContent(purchaseTenderNoticeHead.getNoticeContent());
        notice.setNoticeType(PurchaseSysNoticeTypeEnum.CONVENTION_NOTICE.getValue());
        notice.setNoticeStatus(PurchaseSysNoticeStatusEnum.ISSUE.getValue());
        notice.setNoticeScope(purchaseTenderNoticeHead.getNoticeScope());
        notice.setTop("1");
        Date newDate = new Date();
        notice.setEffectiveTime(newDate);
        notice.setPublishTime(newDate);
        Date expiryTime = purchaseTenderNoticeHead.getSignUpEndTime();
        boolean hasInvitationBid = PurchaseTenderNoticeTypeEnum.hasInvitationBid(purchaseTenderNoticeHead.getNoticeType());
        String string = signUp = hasInvitationBid ? "0" : purchaseTenderProjectSubpackageInfo.getSignUp();
        if ("0".equals(signUp)) {
            expiryTime = "1".equals(purchaseTenderNoticeHead.getBidding()) ? purchaseTenderNoticeHead.getBiddingEndTime() : purchaseTenderNoticeHead.getFileSubmitEndTime();
        }
        notice.setExpiryTime(expiryTime);
        ArrayList<PurchaseNoticeSupplierDTO> purchaseNoticeSupplierList = new ArrayList<PurchaseNoticeSupplierDTO>();
        if (PurchaseTenderNoticeNoticeScopeEnum.APPOINT_SUPPLIER.getValue().equals(purchaseTenderNoticeHead.getNoticeScope())) {
            List<PurchaseTenderSupplierInvitation> purchaseTenderSupplierInvitations = this.purchaseTenderSupplierInvitationService.selectByMainId(purchaseTenderNoticeHead.getId());
            for (PurchaseTenderSupplierInvitation supplier : purchaseTenderSupplierInvitations) {
                PurchaseNoticeSupplierDTO noticeSupplier = new PurchaseNoticeSupplierDTO();
                BeanUtils.copyProperties((Object)((Object)supplier), (Object)noticeSupplier);
                noticeSupplier.setId(null);
                noticeSupplier.setToElsAccount(supplier.getSupplierAccount());
                purchaseNoticeSupplierList.add(noticeSupplier);
            }
        }
        notice.setElsAccount(purchaseTenderNoticeHead.getElsAccount());
        this.inquiryInvokeMessageRpcService.publish(notice, purchaseNoticeSupplierList, Collections.EMPTY_LIST);
    }

    private PurchaseTenderProjectSubpackageInfo checkParam(PurchaseTenderNoticeHead purchaseTenderNoticeHead, List<PurchaseTenderNoticeItem> purchaseTenderNoticeItems, List<PurchaseTenderSupplierInvitation> purchaseTenderSupplierInvitationList) {
        Assert.isTrue((boolean)org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)purchaseTenderNoticeHead.getSubpackageId()), (String)I18nUtil.translate((String)"", (String)"\u9879\u76ee\u4e0d\u80fd\u4e3a\u7a7a!"));
        Assert.isTrue((boolean)ObjectUtil.isNotEmpty((Object)((Object)purchaseTenderNoticeHead)), (String)I18nUtil.translate((String)"", (String)"\u91c7\u8d2d\u62db\u6807\u9879\u76ee\u516c\u544a\u4fe1\u606f\u4e0d\u5b58\u5728!"));
        Assert.isTrue((boolean)ObjectUtil.isNotEmpty((Object)purchaseTenderNoticeHead.getFileClarificationEndTime()), (String)I18nUtil.translate((String)"", (String)"\u6587\u4ef6\u6f84\u6e05\u622a\u6b62\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a!"));
        Assert.isTrue((boolean)ObjectUtil.isNotEmpty((Object)purchaseTenderNoticeHead.getFileSubmitEndTime()), (String)I18nUtil.translate((String)"", (String)"\u6587\u4ef6\u9012\u4ea4\u622a\u6b62\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a!"));
        Assert.isTrue((boolean)ObjectUtil.isNotEmpty((Object)purchaseTenderNoticeHead.getOpenBiddingTime()), (String)I18nUtil.translate((String)"", (String)"\u5f00\u6807\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a!"));
        Assert.isTrue((purchaseTenderNoticeHead.getFileClarificationEndTime().compareTo(purchaseTenderNoticeHead.getOpenBiddingTime()) != 1 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"", (String)"\u6587\u4ef6\u6f84\u6e05\u622a\u6b62\u65f6\u95f4\u5fc5\u987b\u5c0f\u4e8e\u6216\u7b49\u4e8e\u5f00\u6807\u65f6\u95f4!"));
        Assert.isTrue((purchaseTenderNoticeHead.getFileSubmitEndTime().compareTo(purchaseTenderNoticeHead.getOpenBiddingTime()) != 1 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"", (String)"\u6587\u4ef6\u9012\u4ea4\u622a\u6b62\u65f6\u95f4\u5fc5\u987b\u5c0f\u4e8e\u5f00\u6807\u65f6\u95f4!"));
        Assert.isTrue((boolean)org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)purchaseTenderNoticeHead.getNoticeTitle()), (String)I18nUtil.translate((String)"", (String)"\u516c\u544a\u6807\u9898\u4e0d\u80fd\u4e3a\u7a7a!"));
        Assert.isTrue((boolean)org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)purchaseTenderNoticeHead.getNoticeType()), (String)I18nUtil.translate((String)"", (String)"\u516c\u544a\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a!"));
        Assert.isTrue((boolean)ObjectUtil.isNotEmpty(purchaseTenderNoticeItems), (String)I18nUtil.translate((String)"", (String)"\u91c7\u8d2d\u62db\u6807\u9879\u76ee\u516c\u544a\u884c\u4e0d\u5b58\u5728!"));
        long count = purchaseTenderNoticeItems.stream().map(PurchaseTenderNoticeItem::getSubpackageId).distinct().count();
        Assert.isTrue(((long)purchaseTenderNoticeItems.size() == count ? 1 : 0) != 0, (String)I18nUtil.translate((String)"", (String)"\u540c\u4e00\u4e2a\u5206\u5305\u4e0d\u53ef\u4ee5\u9009\u62e9\u591a\u6b21!"));
        List<String> subpackageIds = purchaseTenderNoticeItems.stream().map(PurchaseTenderNoticeItem::getSubpackageId).distinct().collect(Collectors.toList());
        Assert.isTrue((boolean)subpackageIds.contains(purchaseTenderNoticeHead.getSubpackageId()), (String)I18nUtil.translate((String)"", (String)"\u5fc5\u987b\u9009\u62e9\u4e3b\u5206\u5305!"));
        List<PurchaseTenderProjectSubpackageInfo> purchaseTenderProjectSubpackageInfos = this.purchaseTenderProjectSubpackageInfoService.selectBatchIds(subpackageIds);
        PurchaseTenderProjectSubpackageInfo purchaseTenderProjectSubpackageInfo = null;
        Assert.isTrue((boolean)CollectionUtil.isNotEmpty(purchaseTenderProjectSubpackageInfos), (String)I18nUtil.translate((String)"", (String)"\u9879\u76ee\u4e0d\u5b58\u5728!"));
        for (PurchaseTenderProjectSubpackageInfo subpackageInfo : purchaseTenderProjectSubpackageInfos) {
            boolean hasInvitationBid;
            if ("1".equals(subpackageInfo.getSignUp()) && (!(hasInvitationBid = PurchaseTenderNoticeTypeEnum.hasInvitationBid(purchaseTenderNoticeHead.getNoticeType())) || hasInvitationBid && !SubpackageInfoCheckTypeEnum.hasPreTrial(subpackageInfo.getCheckType()))) {
                Assert.isTrue((boolean)org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)purchaseTenderNoticeHead.getSignUpType()), (String)I18nUtil.translate((String)"", (String)"\u8bf7\u9009\u62e9\u62a5\u540d\u65b9\u5f0f!"));
                Assert.isTrue((boolean)ObjectUtil.isNotEmpty((Object)purchaseTenderNoticeHead.getSignUpBeginTime()), (String)I18nUtil.translate((String)"", (String)"\u62a5\u540d\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a!"));
                Assert.isTrue((boolean)ObjectUtil.isNotEmpty((Object)purchaseTenderNoticeHead.getSignUpEndTime()), (String)I18nUtil.translate((String)"", (String)"\u62a5\u540d\u622a\u6b62\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a!"));
                Assert.isTrue((purchaseTenderNoticeHead.getSignUpBeginTime().compareTo(purchaseTenderNoticeHead.getSignUpEndTime()) == -1 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"", (String)"\u62a5\u540d\u622a\u6b62\u65f6\u95f4\u5fc5\u987b\u5927\u4e8e\u62a5\u540d\u5f00\u59cb\u65f6\u95f4!"));
            }
            Assert.isTrue((boolean)org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)purchaseTenderNoticeHead.getNoticeScope()), (String)I18nUtil.translate((String)"", (String)"\u901a\u77e5\u8303\u56f4\u4e0d\u80fd\u4e3a\u7a7a!"));
            if (subpackageInfo.getId().equals(purchaseTenderNoticeHead.getSubpackageId())) {
                purchaseTenderProjectSubpackageInfo = subpackageInfo;
            }
            Assert.isTrue((boolean)PurchaseOpenBidStatusEnum.NOT_OPEN_BID.getValue().equals(subpackageInfo.getOpenBidStatus()), (String)I18nUtil.translate((String)"", (String)"\u5f53\u524d\u5df2\u5f00\u6807\u4e0d\u5141\u8bb8\u53d8\u66f4\u516c\u544a!"));
        }
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)purchaseTenderNoticeHead.getConsortiumBidding())) {
            purchaseTenderNoticeHead.setConsortiumBidding("0");
        }
        if ("1".equals(purchaseTenderNoticeHead.getConsortiumBidding())) {
            Assert.isTrue((boolean)org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)purchaseTenderNoticeHead.getConsortiumBiddingCondition()), (String)I18nUtil.translate((String)"", (String)"\u8054\u5408\u4f53\u6295\u6807\u8981\u6c42\u4e0d\u80fd\u4e3a\u7a7a!"));
        }
        if ("1".equals(purchaseTenderNoticeHead.getBidding())) {
            Assert.isTrue((boolean)org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)purchaseTenderNoticeHead.getBiddingType()), (String)I18nUtil.translate((String)"", (String)"\u552e\u6807\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a!"));
            Assert.isTrue((boolean)ObjectUtil.isNotEmpty((Object)purchaseTenderNoticeHead.getBiddingBeginTime()), (String)I18nUtil.translate((String)"", (String)"\u552e\u6807\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a!"));
            Assert.isTrue((boolean)ObjectUtil.isNotEmpty((Object)purchaseTenderNoticeHead.getBiddingEndTime()), (String)I18nUtil.translate((String)"", (String)"\u552e\u6807\u622a\u6b62\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a!"));
            Assert.isTrue((purchaseTenderNoticeHead.getBiddingBeginTime().compareTo(purchaseTenderNoticeHead.getBiddingEndTime()) == -1 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"", (String)"\u552e\u6807\u622a\u6b62\u65f6\u95f4\u5fc5\u987b\u5927\u4e8e\u552e\u6807\u5f00\u59cb\u65f6\u95f4!"));
            Assert.isTrue((purchaseTenderNoticeHead.getFileSubmitEndTime().compareTo(purchaseTenderNoticeHead.getBiddingEndTime()) > -1 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"", (String)"\u9012\u4ea4\u622a\u6b62\u65f6\u95f4\u5fc5\u987b\u5927\u4e8e\u552e\u6807\u7ed3\u675f\u65f6\u95f4!"));
            if (!PurchaseTenderNoticeBiddingTypeEnum.ON_LINE.getValue().equals(purchaseTenderNoticeHead.getBiddingType())) {
                Assert.isTrue((boolean)org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)purchaseTenderNoticeHead.getOfflineSaleAccount()), (String)I18nUtil.translate((String)"", (String)"\u7ebf\u4e0b\u552e\u6807\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a!"));
            }
        }
        purchaseTenderNoticeItems.forEach(item -> {
            Assert.isTrue((boolean)org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)item.getMarginCollectionType()), (String)I18nUtil.translate((String)"", (String)"\u4fdd\u8bc1\u91d1\u6536\u53d6\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a!"));
            if (!TenderProjectMarginPayTypeEnum.FREE.getValue().equals(item.getMarginCollectionType())) {
                Assert.isTrue((boolean)ObjectUtil.isNotEmpty((Object)item.getMargin()), (String)I18nUtil.translate((String)"", (String)"\u4fdd\u8bc1\u91d1\u4e0d\u80fd\u4e3a\u7a7a!"));
            }
        });
        if (PurchaseTenderNoticeTypeEnum.hasInvitationBid(purchaseTenderNoticeHead.getNoticeType())) {
            Assert.isTrue((!purchaseTenderSupplierInvitationList.isEmpty() ? 1 : 0) != 0, (String)I18nUtil.translate((String)"", (String)"\u9080\u8bf7\u516c\u544a\u7684\u9080\u8bf7\u4f9b\u5e94\u5546\u4e0d\u80fd\u4e3a\u7a7a!"));
            purchaseTenderSupplierInvitationList.parallelStream().forEach(invitation -> {
                Assert.isTrue((boolean)org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)invitation.getSupplierAccount()), (String)I18nUtil.translate((String)"", (String)"\u9080\u8bf7\u4f9b\u5e94\u5546\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a!"));
                Assert.isTrue((boolean)org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)invitation.getSupplierName()), (String)I18nUtil.translate((String)"", (String)"\u9080\u8bf7\u4f9b\u5e94\u5546\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a!"));
                Assert.isTrue((boolean)org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)invitation.getContacts()), (String)I18nUtil.translate((String)"", (String)"\u9080\u8bf7\u4f9b\u5e94\u5546\u8054\u7cfb\u4eba\u4e0d\u80fd\u4e3a\u7a7a!"));
                Assert.isTrue((boolean)org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)invitation.getContactsPhone()), (String)I18nUtil.translate((String)"", (String)"\u9080\u8bf7\u4f9b\u5e94\u5546\u8054\u7cfb\u7535\u8bdd\u4e0d\u80fd\u4e3a\u7a7a!"));
            });
        }
        return purchaseTenderProjectSubpackageInfo;
    }
}

