/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.tender.openbid.job;

import com.alibaba.fastjson.JSONObject;
import com.els.common.constant.CommonConstant;
import com.els.common.util.DateUtils;
import com.els.common.util.I18nUtil;
import com.els.common.util.SpringContextUtils;
import com.els.config.mybatis.TenantContext;
import com.els.modules.inquiry.rpc.service.InquriyInvokeJobRpcService;
import com.els.modules.job.api.dto.QuartzJobDTO;
import com.els.modules.tender.common.aspect.TenderFlagInjectionContext;
import com.els.modules.tender.evaluation.entity.TenderEvaQuotedPriceHead;
import com.els.modules.tender.project.entity.PurchaseTenderProjectSubpackageInfo;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class TenderJobUtil {
    private static final Logger log = LoggerFactory.getLogger(TenderJobUtil.class);
    private static InquriyInvokeJobRpcService inquriyInvokeJobRpcService = (InquriyInvokeJobRpcService)SpringContextUtils.getBean(InquriyInvokeJobRpcService.class);
    public static final String OPEN_BID_ALERT_JOB = "tenderOpenBidAlertJobServiceImpl";
    public static final String OPEN_BID_DECRYPT_ALERT_JOB = "tenderOpenBidDecryptAlertJobServiceImpl";
    public static final String EVA_QUOTED_PRICE_JOB = "tenderEvaQuotedPriceJobBeanServiceImpl";

    private static void createJob(PurchaseTenderProjectSubpackageInfo purchaseTenderProjectSubpackageInfo, Date time, String jobName, String jobNameKey) {
        String elsAccount = TenantContext.getTenant();
        String cron = DateUtils.formatDate((Date)time, (String)"ss mm HH dd MM ? yyyy");
        QuartzJobDTO job = new QuartzJobDTO();
        job.setCronExpression(cron);
        job.setJobClassName("com.els.modules.quartz.job.BusinessJob");
        job.setStatus(CommonConstant.STATUS_NORMAL);
        job.setJobNameKey(jobNameKey);
        JSONObject paramObj = new JSONObject();
        paramObj.put("id", (Object)purchaseTenderProjectSubpackageInfo.getId());
        paramObj.put("jobImplName", (Object)jobName);
        paramObj.put("checkType", (Object)TenderFlagInjectionContext.getTenderCheckType());
        paramObj.put("processType", (Object)TenderFlagInjectionContext.getTenderProcessType());
        paramObj.put("currentStep", (Object)TenderFlagInjectionContext.getTenderCurrentStep());
        paramObj.put("jobKey", (Object)job.getJobNameKey());
        paramObj.put("tenantId", (Object)elsAccount);
        job.setParameter(paramObj.toJSONString());
        job.setElsAccount(elsAccount);
        try {
            inquriyInvokeJobRpcService.createJob(job);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            if (e.getMessage().contains("will never fire") && OPEN_BID_ALERT_JOB.equals(jobName)) {
                throw new RuntimeException(I18nUtil.translate((String)"i18n_alert_vBKIIRWxiTJOvBWVGRLlOvBW_f0535555", (String)"\u5f00\u6807\u65f6\u95f4\u5df2\u8fc7\uff0c\u4e0d\u5141\u8bb8\u81ea\u52a8\u5f00\u6807\uff0c\u8bf7\u8bbe\u7f6e\u4e3a\u624b\u52a8\u5f00\u6807\uff01"));
            }
            throw new RuntimeException(e.getMessage());
        }
    }

    public static void createOrUpdateOpenBidAlertJob(PurchaseTenderProjectSubpackageInfo subpackageInfo, Date time) {
        Assert.isTrue((boolean)new Date().before(time), (String)I18nUtil.translate((String)"i18n_alert_vBKIIRWxiTJOvBWVGRLlOvBW_f0535555", (String)"\u5f00\u6807\u65f6\u95f4\u5df2\u8fc7\uff0c\u4e0d\u5141\u8bb8\u81ea\u52a8\u5f00\u6807\uff0c\u8bf7\u8bbe\u7f6e\u4e3a\u624b\u52a8\u5f00\u6807\uff01"));
        String jobNameKey = "tenderOpenBidAlertJobServiceImpl_" + subpackageInfo.getSubpackageNumber() + "_" + subpackageInfo.getElsAccount();
        List<QuartzJobDTO> jobList = inquriyInvokeJobRpcService.findJobList(jobNameKey);
        if (!jobList.isEmpty()) {
            TenderJobUtil.deleteJob(jobNameKey);
        }
        TenderJobUtil.createJob(subpackageInfo, time, OPEN_BID_ALERT_JOB, jobNameKey);
    }

    public static void createOrUpdateOpenBidDecryptAlertJob(PurchaseTenderProjectSubpackageInfo subpackageInfo, Date time) {
        String jobNameKey = "tenderOpenBidDecryptAlertJobServiceImpl_" + subpackageInfo.getSubpackageNumber() + "_" + subpackageInfo.getElsAccount();
        List<QuartzJobDTO> jobList = inquriyInvokeJobRpcService.findJobList(jobNameKey);
        if (!jobList.isEmpty()) {
            TenderJobUtil.deleteJob(jobNameKey);
        }
        TenderJobUtil.createJob(subpackageInfo, time, OPEN_BID_DECRYPT_ALERT_JOB, jobNameKey);
    }

    public static void deleteOpenBidDecryptAlertJob(PurchaseTenderProjectSubpackageInfo subpackageInfo) {
        String jobNameKey = "tenderOpenBidDecryptAlertJobServiceImpl_" + subpackageInfo.getSubpackageNumber() + "_" + subpackageInfo.getElsAccount();
        TenderJobUtil.deleteJob(jobNameKey);
    }

    public static void deleteJob(String jobKey) {
        List<QuartzJobDTO> jobList = inquriyInvokeJobRpcService.findJobList(jobKey);
        if (!jobList.isEmpty()) {
            inquriyInvokeJobRpcService.deleteJob(jobList.get(0));
        }
    }

    public static void createEvaQuotedPriceJob(TenderEvaQuotedPriceHead tenderEvaQuotedPriceHead) {
        String jobNameKey = "tenderEvaQuotedPriceJobBeanServiceImpl_" + tenderEvaQuotedPriceHead.getId() + "_" + tenderEvaQuotedPriceHead.getElsAccount();
        List<QuartzJobDTO> jobList = inquriyInvokeJobRpcService.findJobList(jobNameKey);
        if (!jobList.isEmpty()) {
            TenderJobUtil.deleteJob(jobNameKey);
        }
        String elsAccount = TenantContext.getTenant();
        String cron = DateUtils.formatDate((Date)tenderEvaQuotedPriceHead.getQuotedPriceEndTime(), (String)"ss mm HH dd MM ? yyyy");
        QuartzJobDTO job = new QuartzJobDTO();
        job.setCronExpression(cron);
        job.setJobClassName("com.els.modules.quartz.job.BusinessJob");
        job.setStatus(CommonConstant.STATUS_NORMAL);
        job.setJobNameKey(jobNameKey);
        JSONObject paramObj = new JSONObject();
        paramObj.put("id", (Object)tenderEvaQuotedPriceHead.getId());
        paramObj.put("jobImplName", (Object)EVA_QUOTED_PRICE_JOB);
        paramObj.put("jobKey", (Object)job.getJobNameKey());
        paramObj.put("tenantId", (Object)elsAccount);
        job.setParameter(paramObj.toJSONString());
        job.setElsAccount(elsAccount);
        try {
            inquriyInvokeJobRpcService.createJob(job);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            if (e.getMessage().contains("will never fire")) {
                throw new RuntimeException(I18nUtil.translate((String)"i18n_alert_suyRKIRHWVVVGRW_b8b6df51", (String)"\u62a5\u4ef7\u622a\u6b62\u65f6\u95f4\u8fc7\u8fd1\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\uff01"));
            }
            throw new RuntimeException(e.getMessage());
        }
    }

    public static void deleteEvaQuotedPriceJob(TenderEvaQuotedPriceHead tenderEvaQuotedPriceHead) {
        String jobNameKey = "tenderEvaQuotedPriceJobBeanServiceImpl_" + tenderEvaQuotedPriceHead.getId() + "_" + tenderEvaQuotedPriceHead.getElsAccount();
        TenderJobUtil.deleteJob(jobNameKey);
    }
}

