/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.tender.sale.controller;

import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.aspect.annotation.SrmValidated;
import com.els.common.system.base.controller.BaseController;
import com.els.modules.base.api.dto.SaleAttachmentDTO;
import com.els.modules.tender.sale.entity.SaleTenderPriceOpenings;
import com.els.modules.tender.sale.service.SaleTenderPriceOpeningsService;
import com.els.modules.tender.sale.vo.SaleTenderProjectDocumentSubmitInfoVO;
import com.els.modules.tender.sale.vo.SaleTenderProjectDocumentSubmitInfoViewVO;
import com.els.modules.tender.supplier.entity.TenderProjectSupplier;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/tender/sale/supplierTenderDocumentSubmitInfo"})
@Api(tags={"\u6295\u6807\u5927\u5385-\u6587\u4ef6\u9012\u4ea4-\u57fa\u672c\u4fe1\u606f"})
public class SaleTenderDocumentSubmitInfoController
extends BaseController<SaleTenderPriceOpenings, SaleTenderPriceOpeningsService> {
    private static final Logger log = LoggerFactory.getLogger(SaleTenderDocumentSubmitInfoController.class);
    @Autowired
    private SaleTenderPriceOpeningsService saleTenderPriceOpeningsService;

    @AutoLog(busModule="\u6295\u6807\u5927\u5385-\u6587\u4ef6\u9012\u4ea4-\u57fa\u672c\u4fe1\u606f", value="\u6dfb\u52a0\u6240\u6709")
    @ApiOperation(value="\u6dfb\u52a0\u6240\u6709", notes="\u6dfb\u52a0\u6240\u6709")
    @PostMapping(value={"/addAll"})
    @SrmValidated
    @RequiresPermissions(value={"tender#tenderProject:add"})
    public Result<?> addAll(@RequestBody SaleTenderProjectDocumentSubmitInfoVO supplierTenderProjectMasterInfoPage) {
        this.saleTenderPriceOpeningsService.addAll(supplierTenderProjectMasterInfoPage);
        return Result.ok((Object)((Object)supplierTenderProjectMasterInfoPage));
    }

    @AutoLog(busModule="\u6295\u6807\u5927\u5385-\u6587\u4ef6\u9012\u4ea4-\u57fa\u672c\u4fe1\u606f", value="\u7f16\u8f91")
    @ApiOperation(value="\u7f16\u8f91\u6240\u6709", notes="\u7f16\u8f91")
    @PostMapping(value={"/editAll"})
    @SrmValidated
    @RequiresPermissions(value={"tender#tenderProject:edit"})
    public Result<?> editAll(@RequestBody SaleTenderProjectDocumentSubmitInfoVO supplierTenderProjectMasterInfoPage) {
        this.saleTenderPriceOpeningsService.editAll(supplierTenderProjectMasterInfoPage);
        return this.commonSuccessResult(3);
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryDocumentSubmitInfo"})
    @RequiresPermissions(value={"tender#tenderProject:queryById"})
    public Result<?> queryDocumentSubmitInfo(TenderProjectSupplier tenderProjectSupplier) {
        SaleTenderProjectDocumentSubmitInfoViewVO viewVO = this.saleTenderPriceOpeningsService.queryDocumentSubmitInfo(tenderProjectSupplier);
        return Result.ok((Object)((Object)viewVO));
    }

    @AutoLog(busModule="\u6295\u6807\u5927\u5385-\u6587\u4ef6\u9012\u4ea4-\u64a4\u9500\u4fdd\u5b58", value="\u64a4\u9500\u4fdd\u5b58")
    @ApiOperation(value="\u64a4\u9500\u4fdd\u5b58", notes="\u64a4\u9500\u4fdd\u5b58")
    @PostMapping(value={"/revokeSave"})
    @SrmValidated
    @RequiresPermissions(value={"tender#biddingHall:operational"})
    public Result<?> revokeSave(@RequestBody SaleTenderProjectDocumentSubmitInfoVO supplierTenderProjectMasterInfoPage) {
        this.saleTenderPriceOpeningsService.revokeSave(supplierTenderProjectMasterInfoPage);
        return this.commonSuccessResult(3);
    }

    @ApiOperation(value="\u901a\u8fc7\u4f9b\u5e94\u5546\u548c\u5206\u5305ID\u67e5\u8be2\u9644\u4ef6", notes="\u901a\u8fc7\u4f9b\u5e94\u5546\u548c\u5206\u5305ID\u67e5\u8be2\u9644\u4ef6")
    @GetMapping(value={"/queryAttachmentBySubpackageId"})
    @RequiresPermissions(value={"tender#tenderProject:queryById"})
    public Result<?> queryAttachmentBySubpackageId(String subpackageId, String supplierAccount) {
        List<SaleAttachmentDTO> saleAttachmentDTOList = this.saleTenderPriceOpeningsService.queryAttachmentBySubpackageId(subpackageId, supplierAccount);
        return Result.ok(saleAttachmentDTOList);
    }

    @ApiOperation(value="\u66f4\u6539\u6295\u6807\u51fd\u52a0\u89e3\u5bc6\u72b6\u6001", notes="\u66f4\u6539\u6295\u6807\u51fd\u52a0\u89e3\u5bc6\u72b6\u6001")
    @PostMapping(value={"/encryptionOrDecryptionLetterStatus"})
    @SrmValidated
    @RequiresPermissions(value={"tender#biddingHall:operational"})
    public Result<?> encryptionOrDecryptionLetterStatus(SaleTenderPriceOpenings saleTenderPriceOpenings, String operate) {
        this.saleTenderPriceOpeningsService.encryptionOrDecryptionLetterStatus(saleTenderPriceOpenings, operate);
        return Result.ok();
    }
}

