/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.tender.supplier.controller;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.modules.bidding.vo.SupplierRelationFindResultVO;
import com.els.modules.tender.common.aspect.TenderFlagInjectionContext;
import com.els.modules.tender.common.entity.BaseCheckTypeEntity;
import com.els.modules.tender.project.enumerate.SubpackageInfoCheckTypeEnum;
import com.els.modules.tender.sale.enumerate.TenderProjectPurchaseBidStatusEnum;
import com.els.modules.tender.sale.enumerate.TenderProjectSignUpStatusEnum;
import com.els.modules.tender.sale.enumerate.TenderProjectSourceTypeEnum;
import com.els.modules.tender.supplier.entity.TenderInvitationSupplierReceipt;
import com.els.modules.tender.supplier.entity.TenderProjectPurchaseBid;
import com.els.modules.tender.supplier.entity.TenderProjectSignUp;
import com.els.modules.tender.supplier.entity.TenderProjectSupplier;
import com.els.modules.tender.supplier.service.TenderInvitationSupplierReceiptService;
import com.els.modules.tender.supplier.service.TenderProjectPurchaseBidService;
import com.els.modules.tender.supplier.service.TenderProjectSignUpService;
import com.els.modules.tender.supplier.service.TenderProjectSupplierService;
import com.els.modules.tender.supplier.vo.PurchaseSupplierResponseVO;
import com.els.modules.tender.supplier.vo.TenderProjectSupplierInfoVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u4f9b\u5e94\u5546\u6295\u6807\u4e3b\u6570\u636e\u8868"})
@RestController
@RequestMapping(value={"/tender/purchase/supplierTenderProjectMasterInfo"})
public class TenderProjectSupplierController
extends BaseController<TenderProjectSupplier, TenderProjectSupplierService> {
    @Autowired
    private TenderProjectSupplierService tenderProjectSupplierService;
    @Autowired
    private TenderProjectSignUpService tenderProjectSignUpService;
    @Autowired
    private TenderProjectPurchaseBidService tenderProjectPurchaseBidService;
    @Autowired
    private TenderInvitationSupplierReceiptService tenderInvitationSupplierReceiptService;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    @RequiresPermissions(value={"tender#tenderProject:list"})
    public Result<?> queryPageList(TenderProjectSupplier saleTenderProjectSupplier, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        saleTenderProjectSupplier.setEffective("1");
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)saleTenderProjectSupplier), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.tenderProjectSupplierService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @ApiOperation(value="\u901a\u8fc7\u5206\u5305id\u67e5\u8be2\u54cd\u5e94\u5217\u8868", notes="\u901a\u8fc7\u5206\u5305id\u67e5\u8be2\u54cd\u5e94\u5217\u8868")
    @GetMapping(value={"/queryBySubpackageId"})
    @RequiresPermissions(value={"tender#tenderProject:queryById"})
    public Result<?> queryBySubpackageId(@RequestParam(name="subpackageId") String subpackageId) {
        TenderProjectSupplier querySupplier = new TenderProjectSupplier().setSubpackageId(subpackageId);
        List<TenderProjectSupplier> tenderProjectSuppliers = this.tenderProjectSupplierService.selectBySubpackageId(querySupplier);
        PurchaseSupplierResponseVO purchaseSupplierResponseVO = new PurchaseSupplierResponseVO();
        purchaseSupplierResponseVO.setTenderProjectSupplier(tenderProjectSuppliers);
        List<TenderProjectPurchaseBid> supplierPurchseBids = this.tenderProjectPurchaseBidService.selectBySubpackageId(subpackageId);
        Map<String, List<TenderProjectPurchaseBid>> purchaseBidMap = supplierPurchseBids.stream().collect(Collectors.groupingBy(BaseCheckTypeEntity::getCheckType));
        purchaseSupplierResponseVO.setParticipantsTotal(tenderProjectSuppliers.size());
        long biddersNumber = tenderProjectSuppliers.parallelStream().filter(response -> "1".equals(response.getResponseStatus())).count();
        long notBiddersNumber = tenderProjectSuppliers.parallelStream().filter(response -> "0".equals(response.getResponseStatus())).count();
        purchaseSupplierResponseVO.setBiddersNumber(biddersNumber);
        purchaseSupplierResponseVO.setNotBiddersNumber(notBiddersNumber);
        List<TenderProjectSupplier> supplierResponseList = tenderProjectSuppliers.parallelStream().filter(response -> "1".equals(response.getResponseStatus())).collect(Collectors.toList());
        purchaseSupplierResponseVO.setSupplierResponseList(supplierResponseList);
        long resultBiddersNumber = tenderProjectSuppliers.parallelStream().filter(response -> "1".equals(response.getResultResponseStatus())).count();
        long resultNotBiddersNumber = tenderProjectSuppliers.parallelStream().filter(response -> "0".equals(response.getResultResponseStatus())).count();
        purchaseSupplierResponseVO.setResultBiddersNumber(resultBiddersNumber);
        purchaseSupplierResponseVO.setResultNotBiddersNumber(resultNotBiddersNumber);
        List<TenderProjectSupplier> resultSupplierResponseList = tenderProjectSuppliers.parallelStream().filter(response -> "1".equals(response.getResultResponseStatus())).collect(Collectors.toList());
        purchaseSupplierResponseVO.setSupplierResultResponseList(resultSupplierResponseList);
        List<TenderProjectSignUp> signUpList = this.tenderProjectSignUpService.selectBySubpackageId(subpackageId);
        signUpList = signUpList.stream().filter(signUp -> !TenderProjectSourceTypeEnum.ON_LINE.getValue().equals(signUp.getSourceType()) || !TenderProjectSignUpStatusEnum.NEW.getValue().equals(signUp.getStatus())).collect(Collectors.toList());
        purchaseSupplierResponseVO.setSupplierSignUpList(signUpList);
        List<TenderProjectPurchaseBid> supplierPurchseBidList = purchaseBidMap.get(SubpackageInfoCheckTypeEnum.POST_TRIAL.getValue());
        if (CollectionUtil.isNotEmpty(supplierPurchseBidList)) {
            supplierPurchseBidList = supplierPurchseBidList.stream().filter(purchseBid -> !TenderProjectSourceTypeEnum.ON_LINE.getValue().equals(purchseBid.getSourceType()) || !TenderProjectPurchaseBidStatusEnum.NEW.getValue().equals(purchseBid.getStatus())).collect(Collectors.toList());
            purchaseSupplierResponseVO.setSupplierPurchaseBidList(supplierPurchseBidList);
        }
        long preBiddersNumber = tenderProjectSuppliers.parallelStream().filter(response -> "1".equals(response.getPreResponseStatus())).count();
        long preNotBiddersNumber = tenderProjectSuppliers.parallelStream().filter(response -> "0".equals(response.getPreResponseStatus())).count();
        purchaseSupplierResponseVO.setPreBiddersNumber(preBiddersNumber);
        purchaseSupplierResponseVO.setPreNotBiddersNumber(preNotBiddersNumber);
        List<TenderProjectSupplier> supplierPreResponseList = tenderProjectSuppliers.parallelStream().filter(response -> "1".equals(response.getPreResponseStatus())).collect(Collectors.toList());
        purchaseSupplierResponseVO.setSupplierPreResponseList(supplierPreResponseList);
        List<TenderProjectPurchaseBid> supplierPrePurchseBidList = purchaseBidMap.get(SubpackageInfoCheckTypeEnum.PRE_TRIAL.getValue());
        if (CollectionUtil.isNotEmpty(supplierPrePurchseBidList)) {
            supplierPrePurchseBidList = supplierPrePurchseBidList.stream().filter(purchseBid -> !TenderProjectSourceTypeEnum.ON_LINE.getValue().equals(purchseBid.getSourceType()) || !TenderProjectPurchaseBidStatusEnum.NEW.getValue().equals(purchseBid.getStatus())).collect(Collectors.toList());
            purchaseSupplierResponseVO.setSupplierPrePurchaseBidList(supplierPrePurchseBidList);
        }
        TenderInvitationSupplierReceipt tenderInvitationSupplierReceipt = new TenderInvitationSupplierReceipt();
        tenderInvitationSupplierReceipt.setSubpackageId(subpackageId);
        List<TenderInvitationSupplierReceipt> tenderInvitationSupplierReceipts = this.tenderInvitationSupplierReceiptService.selectBySubpackageId(tenderInvitationSupplierReceipt);
        purchaseSupplierResponseVO.setSupplierInviteReceiptList(tenderInvitationSupplierReceipts);
        return Result.ok((Object)((Object)purchaseSupplierResponseVO));
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2\u54cd\u8be6\u7ec6\u4fe1\u606f", notes="\u901a\u8fc7id\u67e5\u8be2\u54cd\u8be6\u7ec6\u4fe1\u606f")
    @GetMapping(value={"/queryInfoById"})
    @RequiresPermissions(value={"tender#tenderProject:queryById"})
    public Result<?> queryInfoById(@RequestParam(name="id") String id) {
        TenderProjectSupplierInfoVO tenderProjectSupplierInfoVO = this.tenderProjectSupplierService.queryInfoById(id);
        return Result.ok((Object)((Object)tenderProjectSupplierInfoVO));
    }

    @ApiOperation(value="\u67e5\u8be2\u89e3\u5bc6\u4f9b\u5e94\u5546(\u8bc4\u6807\u6f84\u6e05\u4f7f\u7528)", notes="\u67e5\u8be2\u89e3\u5bc6\u4f9b\u5e94\u5546")
    @GetMapping(value={"/getDecryptSupplier"})
    @RequiresPermissions(value={"tender#tenderProject:queryById"})
    public Result<?> getDecryptSupplier(@RequestParam(name="subpackageId") String subpackageId, String checkType, String processType, String currentStep) {
        String tenderCheckType = TenderFlagInjectionContext.getTenderCheckType();
        if (StringUtils.isBlank((CharSequence)tenderCheckType)) {
            TenderFlagInjectionContext.setTenderCheckType(checkType);
        }
        TenderFlagInjectionContext.setTenderProcessType(StringUtils.isBlank((CharSequence)processType) ? "0" : processType);
        TenderFlagInjectionContext.setTenderCurrentStep(currentStep);
        List<TenderProjectSupplier> decryptSupplier = this.tenderProjectSupplierService.getDecryptSupplier(subpackageId);
        return Result.ok(decryptSupplier);
    }

    @AutoLog(busModule="\u56f4\u6807\u63a2\u6d4b", value="\u56f4\u6807\u63a2\u6d4b")
    @ApiOperation(value="\u56f4\u6807\u63a2\u6d4b", notes="\u56f4\u6807\u63a2\u6d4b")
    @GetMapping(value={"/queryRisk"})
    @RequiresPermissions(value={"tender#tenderProject:queryById"})
    public Result<?> queryRisk(@RequestParam(name="subpackageId") String subpackageId) {
        TenderProjectSupplier querySupplier = new TenderProjectSupplier().setSubpackageId(subpackageId);
        List<TenderProjectSupplier> tenderProjectSuppliers = this.tenderProjectSupplierService.selectBySubpackageId(querySupplier);
        Map<String, TenderProjectSupplier> tenderProjectSupplierMap = tenderProjectSuppliers.stream().collect(Collectors.toMap(TenderProjectSupplier::getSupplierAccount, Function.identity()));
        List<SupplierRelationFindResultVO> relationFindResultVOS = this.tenderProjectSupplierService.queryRiskRelationFind(tenderProjectSupplierMap);
        return Result.ok(relationFindResultVOS);
    }
}

