/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.tender.supplier.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.constant.CommonConstant;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.SaleAttachmentDTO;
import com.els.modules.tender.archive.enumerate.TenderProjectArchiveAttachmentEnum;
import com.els.modules.tender.archive.utils.ArchiveUtil;
import com.els.modules.tender.project.entity.PurchaseTenderProjectSubpackageInfo;
import com.els.modules.tender.project.service.PurchaseTenderProjectHeadService;
import com.els.modules.tender.project.service.PurchaseTenderProjectSubpackageInfoService;
import com.els.modules.tender.project.vo.PurchaseTenderProjectInfoVO;
import com.els.modules.tender.sale.enumerate.TenderProjectSignUpStatusEnum;
import com.els.modules.tender.sale.enumerate.TenderProjectSourceTypeEnum;
import com.els.modules.tender.sale.vo.TenderProjectSignUpVO;
import com.els.modules.tender.supplier.entity.TenderProjectSignUp;
import com.els.modules.tender.supplier.entity.TenderProjectSignUpExamine;
import com.els.modules.tender.supplier.mapper.TenderProjectSignUpMapper;
import com.els.modules.tender.supplier.service.TenderProjectSignUpRejectService;
import com.els.modules.tender.supplier.service.TenderProjectSignUpService;
import com.els.modules.tender.supplier.service.TenderProjectSupplierService;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@Service
public class TenderProjectSignUpServiceImpl
extends BaseServiceImpl<TenderProjectSignUpMapper, TenderProjectSignUp>
implements TenderProjectSignUpService {
    @Autowired
    private TenderProjectSupplierService tenderProjectSupplierService;
    @Autowired
    private TenderProjectSignUpRejectService tenderProjectSignUpRejectService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Autowired
    private PurchaseTenderProjectSubpackageInfoService purchaseTenderProjectSubpackageInfoService;
    @Autowired
    private PurchaseTenderProjectHeadService purchaseTenderProjectHeadService;

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void submit(TenderProjectSignUp tenderProjectSignUp, List<SaleAttachmentDTO> attachmentList) {
        LoginUser loginUser = SysUtil.getLoginUser();
        tenderProjectSignUp.setElsAccount(loginUser.getElsAccount());
        this.checkParam(tenderProjectSignUp);
        Assert.isTrue((boolean)CollectionUtil.isNotEmpty(attachmentList), (String)I18nUtil.translate((String)"", (String)"\u62a5\u540d\u9644\u4ef6\u4e0d\u80fd\u4e3a\u7a7a!"));
        this.buildParam(tenderProjectSignUp);
        TenderProjectSignUp projectSignUp = (TenderProjectSignUp)((Object)((TenderProjectSignUpMapper)this.baseMapper).selectById((Serializable)((Object)tenderProjectSignUp.getId())));
        Assert.isTrue((boolean)ObjectUtil.isNotEmpty((Object)((Object)projectSignUp)), (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u91cd\u8bd5\uff01"));
        tenderProjectSignUp.setDataVersion(projectSignUp.getDataVersion());
        int count = ((TenderProjectSignUpMapper)this.baseMapper).updateById((Object)tenderProjectSignUp);
        Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        this.invokeBaseRpcService.deleteSaleAttachmentByMainId(tenderProjectSignUp.getId());
        attachmentList.parallelStream().forEach(attachment -> attachment.setHeadId(tenderProjectSignUp.getId()));
        this.invokeBaseRpcService.insertSaleAttachmentBatchSomeColumn(attachmentList);
        ArchiveUtil.saveArchiveBySaleAttachmentDTO(attachmentList, tenderProjectSignUp.getId(), tenderProjectSignUp.getSubpackageId(), tenderProjectSignUp.getTenderProjectId(), TenderProjectArchiveAttachmentEnum.SIGN_UP_PREFIX.getValue());
        this.tenderProjectSupplierService.saveOrUpdateBySign(tenderProjectSignUp);
        if (TenderProjectSourceTypeEnum.OFF_LINE.getValue().equals(tenderProjectSignUp.getSourceType())) {
            this.updateStatus(tenderProjectSignUp.getId(), TenderProjectSignUpStatusEnum.AUDIT_PASS.getValue(), null);
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void add(TenderProjectSignUp tenderProjectSignUp, List<SaleAttachmentDTO> attachmentList) {
        this.add(tenderProjectSignUp, attachmentList, true);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void add(TenderProjectSignUp tenderProjectSignUp, List<SaleAttachmentDTO> attachmentList, boolean isCheck) {
        LoginUser loginUser = SysUtil.getLoginUser();
        tenderProjectSignUp.setElsAccount(loginUser.getElsAccount());
        List<TenderProjectSignUp> tenderProjectSignUps = ((TenderProjectSignUpMapper)this.baseMapper).selectBySubpackageId(tenderProjectSignUp.getSubpackageId(), tenderProjectSignUp.getSupplierAccount());
        Assert.isTrue((boolean)CollectionUtil.isEmpty(tenderProjectSignUps), (String)I18nUtil.translate((String)"", (String)"\u5df2\u5b58\u5728\u62a5\u540d\u4fe1\u606f\uff0c\u4e0d\u53ef\u91cd\u590d\u62a5\u540d!"));
        PurchaseTenderProjectSubpackageInfo purchaseTenderProjectSubpackageInfo = this.buildParam(tenderProjectSignUp);
        if (isCheck) {
            this.checkSignUp(purchaseTenderProjectSubpackageInfo);
        }
        tenderProjectSignUp.setStatus(TenderProjectSignUpStatusEnum.NEW.getValue());
        ((TenderProjectSignUpMapper)this.baseMapper).insert((Object)tenderProjectSignUp);
        if (CollectionUtil.isNotEmpty(attachmentList)) {
            this.invokeBaseRpcService.deleteSaleAttachmentByMainId(tenderProjectSignUp.getId());
            attachmentList.parallelStream().forEach(attachment -> attachment.setHeadId(tenderProjectSignUp.getId()));
            this.invokeBaseRpcService.insertSaleAttachmentBatchSomeColumn(attachmentList);
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void edit(TenderProjectSignUp tenderProjectSignUp, List<SaleAttachmentDTO> attachmentList) {
        TenderProjectSignUp projectSignUp = (TenderProjectSignUp)((Object)((TenderProjectSignUpMapper)this.baseMapper).selectById((Serializable)((Object)tenderProjectSignUp.getId())));
        Assert.isTrue((boolean)ObjectUtil.isNotEmpty((Object)((Object)projectSignUp)), (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u91cd\u8bd5\uff01"));
        Assert.isTrue((TenderProjectSignUpStatusEnum.NEW.getValue().equals(projectSignUp.getStatus()) || TenderProjectSignUpStatusEnum.AUDIT_REJECT.getValue().equals(projectSignUp.getStatus()) ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u72b6\u6001\u4e0d\u53ef\u4fee\u6539\uff01"));
        tenderProjectSignUp.setDataVersion(projectSignUp.getDataVersion());
        LoginUser loginUser = SysUtil.getLoginUser();
        tenderProjectSignUp.setElsAccount(loginUser.getElsAccount());
        PurchaseTenderProjectSubpackageInfo purchaseTenderProjectSubpackageInfo = this.buildParam(tenderProjectSignUp);
        this.checkSignUp(purchaseTenderProjectSubpackageInfo);
        tenderProjectSignUp.setStatus(TenderProjectSignUpStatusEnum.NEW.getValue());
        int count = ((TenderProjectSignUpMapper)this.baseMapper).updateById((Object)tenderProjectSignUp);
        Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        if (CollectionUtil.isNotEmpty(attachmentList)) {
            this.invokeBaseRpcService.deleteSaleAttachmentByMainId(tenderProjectSignUp.getId());
            attachmentList.parallelStream().forEach(attachment -> attachment.setHeadId(tenderProjectSignUp.getId()));
            this.invokeBaseRpcService.insertSaleAttachmentBatchSomeColumn(attachmentList);
        }
    }

    @Override
    public TenderProjectSignUpVO querySignInfo(String subpackageId) {
        TenderProjectSignUpVO tenderProjectSignUpVO = new TenderProjectSignUpVO();
        LambdaQueryWrapper qw = new LambdaQueryWrapper();
        String elsAccount = TenantContext.getTenant();
        ((LambdaQueryWrapper)qw.eq(TenderProjectSignUp::getSubpackageId, (Object)subpackageId)).eq(TenderProjectSignUp::getSupplierAccount, (Object)elsAccount);
        List tenderProjectSignUps = ((TenderProjectSignUpMapper)this.baseMapper).selectList((Wrapper)qw);
        if (CollectionUtil.isNotEmpty((Collection)tenderProjectSignUps)) {
            TenderProjectSignUp tenderProjectSignUp = (TenderProjectSignUp)((Object)tenderProjectSignUps.get(0));
            BeanUtils.copyProperties((Object)((Object)tenderProjectSignUp), (Object)((Object)tenderProjectSignUpVO));
            List saleAttachmentDemandDTOS = this.invokeBaseRpcService.selectSaleAttachmentByMainId(tenderProjectSignUp.getId());
            tenderProjectSignUpVO.setAttachmentList(saleAttachmentDemandDTOS);
            List<TenderProjectSignUpExamine> tenderProjectSignUpRejects = this.tenderProjectSignUpRejectService.selectByMainId(tenderProjectSignUp.getId());
            tenderProjectSignUpVO.setTenderProjectSignUpRejectList(tenderProjectSignUpRejects);
            return tenderProjectSignUpVO;
        }
        PurchaseTenderProjectInfoVO purchaseTenderProjectInfoVO = this.purchaseTenderProjectHeadService.queryProjectInfoBySubpackageId(subpackageId);
        if (ObjectUtil.isNotNull((Object)purchaseTenderProjectInfoVO)) {
            BeanUtils.copyProperties((Object)purchaseTenderProjectInfoVO, (Object)((Object)tenderProjectSignUpVO));
            PurchaseTenderProjectSubpackageInfo subpackageInfo = (PurchaseTenderProjectSubpackageInfo)((Object)this.purchaseTenderProjectSubpackageInfoService.getById((Serializable)((Object)subpackageId)));
            tenderProjectSignUpVO.setCombination(subpackageInfo.getConsortiumBidding());
        }
        return tenderProjectSignUpVO;
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void updateStatus(String id, String status, String remark) {
        TenderProjectSignUp tenderProjectSignUp = (TenderProjectSignUp)((Object)((TenderProjectSignUpMapper)this.baseMapper).selectById((Serializable)((Object)id)));
        Assert.isTrue((boolean)ObjectUtil.isNotEmpty((Object)((Object)tenderProjectSignUp)), (String)I18nUtil.translate((String)"", (String)"\u62a5\u540d\u6570\u636e\u4e0d\u5b58\u5728!"));
        if (TenderProjectSignUpStatusEnum.AUDIT_REJECT.getValue().equals(status)) {
            Assert.isTrue((boolean)StringUtils.hasText((String)remark), (String)I18nUtil.translate((String)"", (String)"\u62d2\u7edd\u539f\u56e0\u4e0d\u80fd\u4e3a\u7a7a!"));
        }
        TenderProjectSignUpExamine tenderProjectSignUpReject = new TenderProjectSignUpExamine();
        tenderProjectSignUpReject.setHeadId(tenderProjectSignUp.getId());
        tenderProjectSignUpReject.setRemark(remark);
        tenderProjectSignUpReject.setSubpackageId(tenderProjectSignUp.getSubpackageId());
        tenderProjectSignUpReject.setStatus(status);
        this.tenderProjectSignUpRejectService.save((Object)tenderProjectSignUpReject);
        tenderProjectSignUp.setStatus(status);
        ((TenderProjectSignUpMapper)this.baseMapper).updateById((Object)tenderProjectSignUp);
        this.tenderProjectSupplierService.updateBySignUpExamine(tenderProjectSignUp.getSubpackageId(), tenderProjectSignUp.getSupplierAccount(), status);
    }

    @Override
    public List<TenderProjectSignUp> selectBySubpackageId(String subpackageId) {
        return ((TenderProjectSignUpMapper)this.baseMapper).selectBySubpackageId(subpackageId, null);
    }

    @Override
    public TenderProjectSignUpVO selectBySubpackageId(String subpackageId, String supplierAccount) {
        TenderProjectSignUpVO tenderProjectSignUpVO = new TenderProjectSignUpVO();
        List<TenderProjectSignUp> tenderProjectSignUps = ((TenderProjectSignUpMapper)this.baseMapper).selectBySubpackageId(subpackageId, supplierAccount);
        if (CollectionUtil.isNotEmpty(tenderProjectSignUps)) {
            TenderProjectSignUp tenderProjectSignUp = tenderProjectSignUps.get(0);
            BeanUtils.copyProperties((Object)((Object)tenderProjectSignUp), (Object)((Object)tenderProjectSignUpVO));
            List saleAttachmentDemandDTOS = this.invokeBaseRpcService.selectSaleAttachmentByMainId(tenderProjectSignUp.getId());
            tenderProjectSignUpVO.setAttachmentList(saleAttachmentDemandDTOS);
            List<TenderProjectSignUpExamine> tenderProjectSignUpRejects = this.tenderProjectSignUpRejectService.selectByMainId(tenderProjectSignUp.getId());
            tenderProjectSignUpVO.setTenderProjectSignUpRejectList(tenderProjectSignUpRejects);
            return tenderProjectSignUpVO;
        }
        return null;
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delete(String id) {
        TenderProjectSignUp tenderProjectSignUp = (TenderProjectSignUp)((Object)((TenderProjectSignUpMapper)this.baseMapper).selectById((Serializable)((Object)id)));
        Assert.isTrue((boolean)ObjectUtil.isNotEmpty((Object)((Object)tenderProjectSignUp)), (String)I18nUtil.translate((String)"", (String)"\u6570\u636e\u4e0d\u5b58\u5728!"));
        Assert.isTrue((boolean)TenderProjectSignUpStatusEnum.NEW.getValue().equals(tenderProjectSignUp.getStatus()), (String)I18nUtil.translate((String)"", (String)"\u5f53\u524d\u72b6\u6001\u4e0d\u53ef\u5220\u9664!"));
        ((TenderProjectSignUpMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void saveOrUpdatePublish(TenderProjectSignUp tenderProjectSignUp, List<SaleAttachmentDTO> attachmentList) {
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)tenderProjectSignUp.getId())) {
            this.add(tenderProjectSignUp, attachmentList);
        } else {
            this.edit(tenderProjectSignUp, attachmentList);
        }
        tenderProjectSignUp.setStatus(TenderProjectSignUpStatusEnum.AUDIT_IN.getValue());
        this.submit(tenderProjectSignUp, attachmentList);
    }

    @Override
    public List<TenderProjectSignUpVO> selectByMainIds(List<String> oldIds) {
        List<TenderProjectSignUp> tenderProjectSignUps = ((TenderProjectSignUpMapper)this.baseMapper).selectByMainIds(oldIds);
        if (CollectionUtil.isEmpty(tenderProjectSignUps)) {
            return null;
        }
        List<String> signUpIds = tenderProjectSignUps.stream().map(BaseEntity::getId).collect(Collectors.toList());
        List<TenderProjectSignUpExamine> tenderProjectSignUpExamine = this.tenderProjectSignUpRejectService.selectByMainIds(signUpIds);
        Map<String, List<TenderProjectSignUpExamine>> SignUpExamineMaps = tenderProjectSignUpExamine.stream().collect(Collectors.groupingBy(TenderProjectSignUpExamine::getHeadId));
        ArrayList projectSignUpVOList = SysUtil.copyProperties(tenderProjectSignUps, TenderProjectSignUpVO.class);
        for (TenderProjectSignUpVO tenderProjectSignUpVO : projectSignUpVOList) {
            List<TenderProjectSignUpExamine> signUpExamines = SignUpExamineMaps.get(tenderProjectSignUpVO.getId());
            tenderProjectSignUpVO.setTenderProjectSignUpRejectList(signUpExamines);
            List saleAttachmentDemandDTOS = this.invokeBaseRpcService.selectSaleAttachmentByMainId(tenderProjectSignUpVO.getId());
            tenderProjectSignUpVO.setAttachmentList(saleAttachmentDemandDTOS);
        }
        return projectSignUpVOList;
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void dataVoSaveBatch(List<TenderProjectSignUpVO> newTenderProjectSignUpVOS) {
        if (CollectionUtil.isEmpty(newTenderProjectSignUpVOS)) {
            return;
        }
        ArrayList tenderProjectSignUpRejectList = new ArrayList();
        ArrayList attachmentList = new ArrayList();
        ArrayList tenderProjectSignUps = SysUtil.copyProperties(newTenderProjectSignUpVOS, TenderProjectSignUp.class);
        newTenderProjectSignUpVOS.stream().forEach(itemVo -> {
            List<SaleAttachmentDTO> saleAttachmentDTOS;
            List<TenderProjectSignUpExamine> rejectList = itemVo.getTenderProjectSignUpRejectList();
            if (CollectionUtil.isNotEmpty(rejectList)) {
                rejectList.stream().forEach(item -> {
                    item.setHeadId(itemVo.getId());
                    item.setId(null);
                    item.setSubpackageId(item.getSubpackageId());
                });
                tenderProjectSignUpRejectList.addAll(rejectList);
            }
            if (CollectionUtil.isNotEmpty(saleAttachmentDTOS = itemVo.getAttachmentList())) {
                saleAttachmentDTOS.stream().forEach(item -> {
                    item.setHeadId(itemVo.getId());
                    item.setId(null);
                });
                attachmentList.addAll(saleAttachmentDTOS);
            }
        });
        this.saveBatch(tenderProjectSignUps);
        this.tenderProjectSignUpRejectService.saveBatch(tenderProjectSignUpRejectList);
        this.invokeBaseRpcService.insertSaleAttachmentBatchSomeColumn(attachmentList);
    }

    private void checkSignUp(PurchaseTenderProjectSubpackageInfo purchaseTenderProjectSubpackageInfo) {
        Date nowDate = new Date();
        Assert.isTrue((boolean)nowDate.after(purchaseTenderProjectSubpackageInfo.getSignUpBeginTime()), (String)I18nUtil.translate((String)"", (String)"\u62a5\u540d\u65f6\u95f4\u672a\u5230!"));
        Assert.isTrue((boolean)nowDate.before(purchaseTenderProjectSubpackageInfo.getSignUpEndTime()), (String)I18nUtil.translate((String)"", (String)"\u62a5\u540d\u65f6\u95f4\u5df2\u622a\u6b62!"));
    }

    private void checkParam(TenderProjectSignUp tenderProjectSignUp) {
        Assert.isTrue((boolean)StringUtils.hasText((String)tenderProjectSignUp.getTenderProjectNumber()), (String)I18nUtil.translate((String)"", (String)"\u9879\u76ee\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a!"));
        Assert.isTrue((boolean)StringUtils.hasText((String)tenderProjectSignUp.getTenderProjectName()), (String)I18nUtil.translate((String)"", (String)"\u9879\u76ee\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a!"));
        Assert.isTrue((boolean)StringUtils.hasText((String)tenderProjectSignUp.getSubpackageId()), (String)I18nUtil.translate((String)"", (String)"\u5206\u5305\u4e0d\u80fd\u4e3a\u7a7a!"));
        Assert.isTrue((boolean)StringUtils.hasText((String)tenderProjectSignUp.getSubpackageName()), (String)I18nUtil.translate((String)"", (String)"\u5206\u5305\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a!"));
        Assert.isTrue((boolean)StringUtils.hasText((String)tenderProjectSignUp.getSupplierName()), (String)I18nUtil.translate((String)"", (String)"\u6295\u6807\u5355\u4f4d\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a!"));
        Assert.isTrue((boolean)StringUtils.hasText((String)tenderProjectSignUp.getPurchaseEnterpriseAccount()), (String)I18nUtil.translate((String)"", (String)"\u62db\u6807\u5355\u4f4d\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a!"));
        if ("1".equals(tenderProjectSignUp.getCombination())) {
            Assert.isTrue((boolean)StringUtils.hasText((String)tenderProjectSignUp.getCombinationName()), (String)I18nUtil.translate((String)"", (String)"\u8054\u5408\u4f53\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a!"));
        }
        Assert.isTrue((boolean)StringUtils.hasText((String)tenderProjectSignUp.getContacts()), (String)I18nUtil.translate((String)"", (String)"\u8054\u7cfb\u4eba\u4e0d\u80fd\u4e3a\u7a7a!"));
        Assert.isTrue((boolean)StringUtils.hasText((String)tenderProjectSignUp.getContactsPhone()), (String)I18nUtil.translate((String)"", (String)"\u8054\u7cfb\u4eba\u7535\u8bdd\u4e0d\u80fd\u4e3a\u7a7a!"));
    }

    private PurchaseTenderProjectSubpackageInfo buildParam(TenderProjectSignUp tenderProjectSignUp) {
        PurchaseTenderProjectSubpackageInfo purchaseTenderProjectSubpackageInfo = this.purchaseTenderProjectSubpackageInfoService.selectById(tenderProjectSignUp.getSubpackageId());
        Assert.isTrue((boolean)ObjectUtil.isNotEmpty((Object)((Object)purchaseTenderProjectSubpackageInfo)), (String)I18nUtil.translate((String)"", (String)"\u9879\u76ee\u4fe1\u606f\u4e0d\u5b58\u5728!"));
        tenderProjectSignUp.setElsAccount(tenderProjectSignUp.getSupplierAccount());
        tenderProjectSignUp.setSubpackageName(purchaseTenderProjectSubpackageInfo.getSubpackageName());
        tenderProjectSignUp.setTenderProjectId(purchaseTenderProjectSubpackageInfo.getHeadId());
        tenderProjectSignUp.setDeleted(CommonConstant.DEL_FLAG_0);
        return purchaseTenderProjectSubpackageInfo;
    }
}

