/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.tender.supplier.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.extra.spring.SpringUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.els.api.dto.BaseDTO;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.constant.CommonConstant;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.GenerateSignatureUtil;
import com.els.common.util.I18nUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.common.util.encryption.AesEncryptUtil;
import com.els.config.DecryptTenderProperties;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.SaleAttachmentDTO;
import com.els.modules.bidding.enumerate.RiskTypeEnum;
import com.els.modules.bidding.vo.SupplierInvesttreeInfoVO;
import com.els.modules.bidding.vo.SupplierRelationFindResultVO;
import com.els.modules.inquiry.rpc.service.InquiryInvokeSupplierRpcService;
import com.els.modules.supplier.api.dto.EnterpriseRiskDTO;
import com.els.modules.supplier.api.dto.SupplierCompanyHoldingDTO;
import com.els.modules.supplier.api.dto.SupplierHumanHoldingDTO;
import com.els.modules.tender.attachment.entity.PurchaseTenderBidLetter;
import com.els.modules.tender.attachment.service.PurchaseTenderBidLetterService;
import com.els.modules.tender.common.aspect.TenderFlagInjectionContext;
import com.els.modules.tender.common.utils.OpenBidRecordLogUtils;
import com.els.modules.tender.common.utils.TenderOperationFieldUtils;
import com.els.modules.tender.notice.entity.PurchaseTenderNoticeHead;
import com.els.modules.tender.notice.entity.PurchaseTenderNoticeItem;
import com.els.modules.tender.notice.entity.PurchaseTenderSupplierInvitation;
import com.els.modules.tender.openbid.entity.PurchaseTenderProjectOpenInfoRecords;
import com.els.modules.tender.openbid.entity.PurchaseTenderProjectOpenSettingHead;
import com.els.modules.tender.openbid.enumerate.PurchaseOpenBidStatusEnum;
import com.els.modules.tender.openbid.service.PurchaseTenderProjectOpenInfoRecordsService;
import com.els.modules.tender.openbid.service.PurchaseTenderProjectOpenSettingHeadService;
import com.els.modules.tender.openbid.websocket.TenderOnlineWebSocket;
import com.els.modules.tender.project.entity.PurchaseTenderProjectHead;
import com.els.modules.tender.project.entity.PurchaseTenderProjectSubpackageInfo;
import com.els.modules.tender.project.enumerate.SubpackageInfoCheckTypeEnum;
import com.els.modules.tender.project.enumerate.SubpackageInfoProcessTypeEnum;
import com.els.modules.tender.project.service.PurchaseTenderProjectHeadService;
import com.els.modules.tender.project.service.PurchaseTenderProjectSubpackageInfoService;
import com.els.modules.tender.project.vo.PurchaseTenderProjectHeadVO;
import com.els.modules.tender.project.vo.PurchaseTenderProjectOpenInfoHeadVO;
import com.els.modules.tender.sale.entity.SaleTenderPriceOpenings;
import com.els.modules.tender.sale.enumerate.SaleTenderDocumentSubmitEnum;
import com.els.modules.tender.sale.enumerate.TenderProjectSignUpStatusEnum;
import com.els.modules.tender.sale.enumerate.TenderProjectSourceTypeEnum;
import com.els.modules.tender.sale.enumerate.TenderProjectSupplieInviteQuotedPriceStatusEnum;
import com.els.modules.tender.sale.enumerate.TenderProjectSupplieResponseStatusEnum;
import com.els.modules.tender.sale.enumerate.TenderProjectSupplierPurchaseBidStatusEnum;
import com.els.modules.tender.sale.service.SaleTenderPriceOpeningsService;
import com.els.modules.tender.sale.service.SaleTenderProjectMarginHeadService;
import com.els.modules.tender.sale.vo.SaleTenderBidLetterVo;
import com.els.modules.tender.sale.vo.TenderProjectSupplierDecrptVO;
import com.els.modules.tender.supplier.entity.TenderProjectPurchaseBid;
import com.els.modules.tender.supplier.entity.TenderProjectSignUp;
import com.els.modules.tender.supplier.entity.TenderProjectSupplier;
import com.els.modules.tender.supplier.mapper.TenderProjectSupplierMapper;
import com.els.modules.tender.supplier.service.TenderProjectSupplierService;
import com.els.modules.tender.supplier.vo.TenderProjectSupplierInfoVO;
import com.els.modules.tender.supplier.vo.TenderProjectSupplierMessageVO;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.web.client.RestTemplate;

@Service
public class TenderProjectSupplierServiceImpl
extends BaseServiceImpl<TenderProjectSupplierMapper, TenderProjectSupplier>
implements TenderProjectSupplierService {
    private static final Logger log = LoggerFactory.getLogger(TenderProjectSupplierServiceImpl.class);
    @Autowired
    private PurchaseTenderProjectSubpackageInfoService subpackageInfoService;
    @Autowired
    private PurchaseTenderProjectHeadService purchaseTenderProjectHeadService;
    @Autowired
    private PurchaseTenderProjectOpenSettingHeadService purchaseTenderProjectOpenSettingHeadServiceImpl;
    @Autowired
    @Lazy
    private SaleTenderPriceOpeningsService saleTenderPriceOpeningsServiceImpl;
    @Autowired
    @Lazy
    private PurchaseTenderProjectOpenInfoRecordsService projectOpenInfoRecordsService;
    @Autowired
    @Lazy
    private PurchaseTenderBidLetterService purchaseTenderBidLetterService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Autowired
    private SaleTenderProjectMarginHeadService tenderProjectMarginHeadService;
    @Resource
    private InquiryInvokeSupplierRpcService inquiryInvokeSupplierRpcService;
    @Autowired
    private DecryptTenderProperties decryptTenderProperties;

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void add(TenderProjectSupplier tenderProjectSupplier) {
        this.checkParam(tenderProjectSupplier);
        this.builDefaultParam(tenderProjectSupplier);
        ((TenderProjectSupplierMapper)this.baseMapper).insert((Object)tenderProjectSupplier);
        this.tenderProjectMarginHeadService.add(tenderProjectSupplier);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void edit(TenderProjectSupplier tenderProjectSupplier) {
        this.checkParam(tenderProjectSupplier);
        this.builDefaultParam(tenderProjectSupplier);
        TenderProjectSupplier projectSupplier = (TenderProjectSupplier)((Object)((TenderProjectSupplierMapper)this.baseMapper).selectById((Serializable)((Object)tenderProjectSupplier.getId())));
        tenderProjectSupplier.setDataVersion(projectSupplier.getDataVersion());
        int count = ((TenderProjectSupplierMapper)this.baseMapper).updateById((Object)tenderProjectSupplier);
        Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
    }

    @Override
    public void delete(String id) {
        ((TenderProjectSupplierMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void deleteBatch(List<String> idList) {
        ((TenderProjectSupplierMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void saveOrUpdateBySign(TenderProjectSignUp saleTenderProjectSignUp) {
        TenderProjectSupplier dataSource = new TenderProjectSupplier();
        BeanUtils.copyProperties((Object)((Object)saleTenderProjectSignUp), (Object)((Object)dataSource));
        TenderProjectSupplier querySupplier = new TenderProjectSupplier().setSubpackageId(dataSource.getSubpackageId()).setSupplierAccount(dataSource.getSupplierAccount());
        List<TenderProjectSupplier> tenderProjectSupplierList = this.selectBySubpackageId(querySupplier, false);
        TenderProjectSupplier tenderProjectSupplier = new TenderProjectSupplier();
        if (CollectionUtil.isNotEmpty(tenderProjectSupplierList)) {
            tenderProjectSupplier = tenderProjectSupplierList.get(0);
        }
        this.buildParam(dataSource, tenderProjectSupplier);
        tenderProjectSupplier.setSignUpStatus(saleTenderProjectSignUp.getStatus());
        tenderProjectSupplier.setPurchaseBidStatus(TenderProjectSupplierPurchaseBidStatusEnum.NOT_PURCHASE_BID.getValue());
        tenderProjectSupplier.setPrePurchaseBidStatus(TenderProjectSupplierPurchaseBidStatusEnum.NOT_PURCHASE_BID.getValue());
        tenderProjectSupplier.setPreResponseStatus(TenderProjectSupplieResponseStatusEnum.PENDING_BID.getValue());
        tenderProjectSupplier.setResponseStatus(TenderProjectSupplieResponseStatusEnum.PENDING_BID.getValue());
        tenderProjectSupplier.setResultResponseStatus(TenderProjectSupplieResponseStatusEnum.PENDING_BID.getValue());
        tenderProjectSupplier.setCombination(saleTenderProjectSignUp.getCombination());
        tenderProjectSupplier.setCombinationName(saleTenderProjectSignUp.getCombinationName());
        tenderProjectSupplier.setConsortiumBidding(saleTenderProjectSignUp.getConsortiumBidding());
        if (org.springframework.util.StringUtils.hasText((String)tenderProjectSupplier.getId())) {
            this.edit(tenderProjectSupplier);
        } else {
            this.add(tenderProjectSupplier);
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void saveOrUpdateByPurchaseBid(TenderProjectPurchaseBid saleTenderProjectPurchaseBid) {
        TenderProjectSupplier dataSource = new TenderProjectSupplier();
        BeanUtils.copyProperties((Object)((Object)saleTenderProjectPurchaseBid), (Object)((Object)dataSource));
        TenderProjectSupplier querySupplier = new TenderProjectSupplier().setSubpackageId(dataSource.getSubpackageId()).setSupplierAccount(dataSource.getSupplierAccount());
        List<TenderProjectSupplier> tenderProjectSupplierList = this.selectBySubpackageId(querySupplier, false);
        TenderProjectSupplier tenderProjectSupplier = new TenderProjectSupplier();
        if (CollectionUtil.isNotEmpty(tenderProjectSupplierList)) {
            tenderProjectSupplier = tenderProjectSupplierList.get(0);
        }
        this.buildParam(dataSource, tenderProjectSupplier);
        if (SubpackageInfoCheckTypeEnum.PRE_TRIAL.getValue().equals(saleTenderProjectPurchaseBid.getCheckType())) {
            tenderProjectSupplier.setPrePurchaseBidStatus(TenderProjectSupplierPurchaseBidStatusEnum.PURCHASE_BID.getValue());
            tenderProjectSupplier.setPreResponseStatus(TenderProjectSupplieResponseStatusEnum.PENDING_BID.getValue());
            tenderProjectSupplier.setPrePurchaseBid("0");
        } else {
            tenderProjectSupplier.setPurchaseBidStatus(TenderProjectSupplierPurchaseBidStatusEnum.PURCHASE_BID.getValue());
            tenderProjectSupplier.setResponseStatus(TenderProjectSupplieResponseStatusEnum.PENDING_BID.getValue());
            tenderProjectSupplier.setPurchaseBid("0");
        }
        if (TenderProjectSourceTypeEnum.OFF_LINE.getValue().equals(saleTenderProjectPurchaseBid.getSourceType())) {
            tenderProjectSupplier.setEffective("1");
        }
        if (org.springframework.util.StringUtils.hasText((String)tenderProjectSupplier.getId())) {
            this.edit(tenderProjectSupplier);
            return;
        }
        this.add(tenderProjectSupplier);
    }

    @Override
    public List<TenderProjectSupplier> selectBySubpackageId(TenderProjectSupplier querySupplier) {
        return this.selectBySubpackageId(querySupplier, true);
    }

    @Override
    public List<TenderProjectSupplier> selectBySubpackageId(TenderProjectSupplier querySupplier, boolean hasEffective) {
        if (hasEffective) {
            querySupplier.setEffective("1");
        }
        return ((TenderProjectSupplierMapper)this.baseMapper).selectBySubpackageId(querySupplier);
    }

    @Override
    public List<TenderProjectSupplier> getDecryptSupplier(String subpackageId) {
        String tenderCheckType = TenderFlagInjectionContext.getTenderCheckType();
        String tenderProcessType = TenderFlagInjectionContext.getTenderProcessType();
        String currentStep = TenderFlagInjectionContext.getTenderCurrentStep();
        return ((TenderProjectSupplierMapper)this.baseMapper).getDecryptSupplier(subpackageId, tenderCheckType, tenderProcessType, currentStep);
    }

    @Override
    public void join(TenderProjectSupplier saleTenderProjectSupplier) {
        LoginUser sysUser = SysUtil.getLoginUser();
        saleTenderProjectSupplier.setSupplierAccount(sysUser.getElsAccount());
        saleTenderProjectSupplier.setSupplierSubAccount(sysUser.getSubAccount());
        saleTenderProjectSupplier.setSupplierName(sysUser.getEnterpriseName());
        TenderProjectSupplier querySupplier = new TenderProjectSupplier().setSubpackageId(saleTenderProjectSupplier.getSubpackageId()).setSupplierAccount(saleTenderProjectSupplier.getSupplierAccount());
        List<TenderProjectSupplier> tenderProjectSuppliers = ((TenderProjectSupplierMapper)this.baseMapper).selectBySubpackageId(querySupplier);
        if (tenderProjectSuppliers.isEmpty()) {
            saleTenderProjectSupplier.setSourceType(TenderProjectSourceTypeEnum.ON_LINE.getValue());
            PurchaseTenderProjectHeadVO purchaseTenderProjectHead = this.purchaseTenderProjectHeadService.queryProjectHeadBySubpackageId(saleTenderProjectSupplier.getSubpackageId());
            saleTenderProjectSupplier.setSourceType(TenderProjectSourceTypeEnum.ON_LINE.getValue());
            Assert.isTrue((boolean)ObjectUtil.isNotEmpty((Object)((Object)purchaseTenderProjectHead)), (String)I18nUtil.translate((String)"i18n_alert_dIxMKW_dfe46939", (String)"\u9879\u76ee\u4e0d\u5b58\u5728!"));
            saleTenderProjectSupplier.setPurchaseEnterpriseAccount(purchaseTenderProjectHead.getElsAccount());
            saleTenderProjectSupplier.setPurchaseEnterpriseName(purchaseTenderProjectHead.getElsRealname());
            saleTenderProjectSupplier.setTenderProjectNumber(purchaseTenderProjectHead.getTenderProjectNumber());
            saleTenderProjectSupplier.setTenderProjectName(purchaseTenderProjectHead.getTenderProjectName());
            saleTenderProjectSupplier.setElsAccount(TenantContext.getTenant());
            saleTenderProjectSupplier.setResponseStatus(TenderProjectSupplieResponseStatusEnum.PENDING_BID.getValue());
            saleTenderProjectSupplier.setPreResponseStatus(TenderProjectSupplieResponseStatusEnum.PENDING_BID.getValue());
            saleTenderProjectSupplier.setConsortiumBidding(purchaseTenderProjectHead.getSubpackageInfoVOList().get(0).getConsortiumBidding());
            saleTenderProjectSupplier.setEffective("1");
            this.add(saleTenderProjectSupplier);
            return;
        }
        TenderProjectSupplier tenderProjectSupplier = tenderProjectSuppliers.get(0);
        tenderProjectSupplier.setEffective("1");
        this.updateById((Object)tenderProjectSupplier);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void updateByPurchaseBidApproved(String subpackageId, String toElsAccount) {
        TenderProjectSupplier querySupplier = new TenderProjectSupplier().setSubpackageId(subpackageId).setSupplierAccount(toElsAccount);
        List<TenderProjectSupplier> tenderProjectSupplierList = this.selectBySubpackageId(querySupplier, false);
        Assert.isTrue((boolean)CollectionUtil.isNotEmpty(tenderProjectSupplierList), (String)I18nUtil.translate((String)"i18n_alert_RdXdWFxMKW_a3df2a70", (String)"\u4f9b\u5e94\u5546\u4e3b\u6570\u636e\u4e0d\u5b58\u5728!"));
        TenderProjectSupplier tenderProjectSupplier = tenderProjectSupplierList.get(0);
        if (SubpackageInfoCheckTypeEnum.PRE_TRIAL.getValue().equals(TenderFlagInjectionContext.getTenderCheckType())) {
            tenderProjectSupplier.setPrePurchaseBidStatus(TenderProjectSupplierPurchaseBidStatusEnum.PURCHASE_BID_SECCESS.getValue());
            tenderProjectSupplier.setPrePurchaseBid("1");
        } else {
            tenderProjectSupplier.setPurchaseBidStatus(TenderProjectSupplierPurchaseBidStatusEnum.PURCHASE_BID_SECCESS.getValue());
            tenderProjectSupplier.setPurchaseBid("1");
        }
        tenderProjectSupplier.setEffective("1");
        ((TenderProjectSupplierMapper)this.baseMapper).updateById((Object)tenderProjectSupplier);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void updateBySignUpExamine(String subpackageId, String toElsAccount, String signUpStatus) {
        TenderProjectSupplier querySupplier = new TenderProjectSupplier().setSubpackageId(subpackageId).setSupplierAccount(toElsAccount);
        List<TenderProjectSupplier> tenderProjectSupplierList = this.selectBySubpackageId(querySupplier, false);
        Assert.isTrue((boolean)CollectionUtil.isNotEmpty(tenderProjectSupplierList), (String)I18nUtil.translate((String)"i18n_alert_RdXdWFxMKW_a3df2a70", (String)"\u4f9b\u5e94\u5546\u4e3b\u6570\u636e\u4e0d\u5b58\u5728!"));
        TenderProjectSupplier tenderProjectSupplier = tenderProjectSupplierList.get(0);
        tenderProjectSupplier.setSignUpStatus(signUpStatus);
        if (TenderProjectSignUpStatusEnum.AUDIT_PASS.getValue().equals(signUpStatus)) {
            tenderProjectSupplier.setEffective("1");
        } else {
            tenderProjectSupplier.setEffective("0");
        }
        ((TenderProjectSupplierMapper)this.baseMapper).updateById((Object)tenderProjectSupplier);
    }

    @Override
    public void signIn(TenderProjectSupplier tenderProjectSupplier) {
        long count;
        TenderProjectSupplier querySupplier = new TenderProjectSupplier().setSubpackageId(tenderProjectSupplier.getSubpackageId()).setSupplierAccount(TenantContext.getTenant());
        List<TenderProjectSupplier> tenderProjectSupplierList = this.selectBySubpackageId(querySupplier);
        Assert.isTrue((!tenderProjectSupplierList.isEmpty() ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_tkIHWVXVsKW_58a1a970", (String)"\u64cd\u4f5c\u5f02\u5e38\uff0c\u8bf7\u5237\u65b0\u91cd\u8bd5!"));
        tenderProjectSupplier = tenderProjectSupplierList.get(0);
        Assert.isTrue((boolean)"0".equals(tenderProjectSupplier.getInvalid()), (String)I18nUtil.translate((String)"", (String)"\u5f53\u524d\u72b6\u6001\u4e0d\u5141\u8bb8\u8fdb\u5165\u5f00\u6807\u5927\u5385!"));
        String responseStatus = TenderOperationFieldUtils.getFieldStringValue((Object)tenderProjectSupplier, "responseStatus");
        Assert.isTrue((boolean)TenderProjectSupplieResponseStatusEnum.RESPONSE_BID.getValue().equals(responseStatus), (String)I18nUtil.translate((String)"i18n_alert_VWHcQInJW_da66025e", (String)"\u8bf7\u5148\u8fdb\u884c\u6587\u4ef6\u9012\u4ea4!"));
        TenderOperationFieldUtils.setFieldValue((Object)tenderProjectSupplier, "1", "signIn");
        tenderProjectSupplier.setPreSignIn("1");
        ((TenderProjectSupplierMapper)this.baseMapper).updateById((Object)tenderProjectSupplier);
        LoginUser loginUser = SysUtil.getLoginUser();
        String msg = "\u6295\u6807\u4eba " + loginUser.getEnterpriseName() + " " + loginUser.getRealname() + " \u5df2\u7b7e\u5230";
        List<PurchaseTenderProjectOpenInfoRecords> projectOpenInfoRecordsList = this.projectOpenInfoRecordsService.queryOpenInfoRecordsSignMessageBySubpackageId(tenderProjectSupplier.getSubpackageId(), TenantContext.getTenant());
        if (!projectOpenInfoRecordsList.isEmpty() && (count = projectOpenInfoRecordsList.parallelStream().filter(projectOpenInfoRecords -> msg.equals(projectOpenInfoRecords.getContent())).count()) > 0L) {
            return;
        }
        PurchaseTenderProjectOpenInfoHeadVO projectOpenInfoHeadVO = this.subpackageInfoService.queryOpenInfoById(tenderProjectSupplier.getSubpackageId());
        OpenBidRecordLogUtils.saveRecordMsg(projectOpenInfoHeadVO, msg);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void decrypt(TenderProjectSupplierDecrptVO tenderProjectSupplierDecrptVO) {
        TenderProjectSupplier querySupplier = new TenderProjectSupplier().setSubpackageId(tenderProjectSupplierDecrptVO.getSubpackageId()).setSupplierAccount(TenantContext.getTenant());
        List<TenderProjectSupplier> tenderProjectSupplierList = this.selectBySubpackageId(querySupplier);
        Assert.isTrue((!tenderProjectSupplierList.isEmpty() ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_tkIHWVXVsKW_58a1a970", (String)"\u64cd\u4f5c\u5f02\u5e38\uff0c\u8bf7\u5237\u65b0\u91cd\u8bd5!"));
        TenderProjectSupplier tenderProjectSupplier = tenderProjectSupplierList.get(0);
        PurchaseTenderProjectOpenInfoHeadVO openInfoHeadVO = this.subpackageInfoService.queryOpenInfoById(tenderProjectSupplier.getSubpackageId());
        String openBidStatus = TenderOperationFieldUtils.getOpenBidStatus((Object)openInfoHeadVO);
        String filePassword = "";
        String checkType = TenderFlagInjectionContext.getTenderCheckType();
        if ("1".equals(checkType)) {
            filePassword = tenderProjectSupplier.getFilePassword();
        } else if ("0".equals(checkType)) {
            filePassword = tenderProjectSupplier.getPreFilePassword();
        }
        this.checkStatus(tenderProjectSupplierDecrptVO, openBidStatus, filePassword);
        PurchaseTenderProjectSubpackageInfo subpackageInfo = this.subpackageInfoService.selectById(tenderProjectSupplier.getSubpackageId());
        if ("1".equals(subpackageInfo.getUseCa())) {
            List saleAttachmentDTOList = this.invokeBaseRpcService.selectSaleAttachmentByMainId(tenderProjectSupplier.getId() + "_" + checkType);
            String processType = TenderFlagInjectionContext.getTenderProcessType();
            String currentStep = TenderFlagInjectionContext.getTenderCurrentStep();
            if ("1".equals(checkType) && "1".equals(processType)) {
                String fileType = null;
                fileType = "0".equals(currentStep) ? SaleTenderDocumentSubmitEnum.ONE_STEP_PROCESS.getValue() : SaleTenderDocumentSubmitEnum.TWO_STEP_PROCESS.getValue();
                String finalFileType = fileType;
                saleAttachmentDTOList = saleAttachmentDTOList.stream().filter(item -> finalFileType.equals(item.getFileType())).collect(Collectors.toList());
            }
            if (CollectionUtil.isEmpty((Collection)saleAttachmentDTOList)) {
                throw new ELSBootException("\u65e0\u89e3\u5bc6\u9644\u4ef6\u4fe1\u606f\uff0c\u89e3\u5bc6\u6587\u4ef6\u5931\u8d25");
            }
            this.decryptCAServer(saleAttachmentDTOList, tenderProjectSupplierDecrptVO.getPassword());
            this.invokeBaseRpcService.updateSaleAttachmentBatchById(saleAttachmentDTOList);
            List<SaleTenderPriceOpenings> salePriceOpenings = this.saleTenderPriceOpeningsServiceImpl.getSalePriceOpeningsBySubpackageId(tenderProjectSupplier.getSubpackageId(), Arrays.asList(TenantContext.getTenant()), "0");
            if (CollectionUtil.isEmpty(salePriceOpenings)) {
                throw new ELSBootException("\u65e0\u6295\u6807\u51fd\u4fe1\u606f\uff0c\u89e3\u5bc6\u6570\u636e\u56de\u586b\u5931\u8d25");
            }
            SaleTenderPriceOpenings saleTenderPriceOpening = salePriceOpenings.get(0);
            saleTenderPriceOpening.setCustomizeFieldData(tenderProjectSupplierDecrptVO.getCustomizeFieldData());
            saleTenderPriceOpening.setEncryption("2");
            this.saleTenderPriceOpeningsServiceImpl.updateById((Object)saleTenderPriceOpening);
        }
        TenderOperationFieldUtils.setFieldValue((Object)tenderProjectSupplier, "1", "decrypt");
        ((TenderProjectSupplierMapper)this.baseMapper).updateById((Object)tenderProjectSupplier);
        LoginUser loginUser = SysUtil.getLoginUser();
        OpenBidRecordLogUtils.saveRecordMsg(openInfoHeadVO, "\u6295\u6807\u4eba " + loginUser.getEnterpriseName() + " " + loginUser.getRealname() + " \u5df2\u89e3\u5bc6");
        TenderOnlineWebSocket webSocket = (TenderOnlineWebSocket)SpringContextUtils.getBean(TenderOnlineWebSocket.class);
        JSONObject messageJson = new JSONObject();
        messageJson.put("type", (Object)"updateOpenBidStatus");
        messageJson.put("result", (Object)openInfoHeadVO);
        webSocket.sendQuoteMessage(tenderProjectSupplierDecrptVO.getSubpackageId(), messageJson.toString());
    }

    private void checkStatus(TenderProjectSupplierDecrptVO tenderProjectSupplierDecrptVO, String openBidStatus, String filePassword) {
        Assert.isTrue((boolean)PurchaseOpenBidStatusEnum.DECRYPTING.getValue().equals(openBidStatus), (String)I18nUtil.translate((String)"", (String)"\u5f53\u524d\u5f00\u6807\u5927\u5385\u72b6\u6001\u4e3a[${0}],\u4e0d\u80fd\u8fdb\u884c\u89e3\u5bc6\u64cd\u4f5c\uff01", (String[])new String[]{PurchaseOpenBidStatusEnum.getOpenBidStatusDesc(openBidStatus)}));
        PurchaseTenderProjectSubpackageInfo subpackageInfo = this.subpackageInfoService.selectById(tenderProjectSupplierDecrptVO.getSubpackageId());
        if ("1".equals(subpackageInfo.getUseCa())) {
            return;
        }
        String encryptPassword = AesEncryptUtil.encrypt((String)tenderProjectSupplierDecrptVO.getPassword());
        Assert.isTrue((boolean)org.springframework.util.StringUtils.hasText((String)encryptPassword), (String)I18nUtil.translate((String)"i18n_alert_SXwoW_cb0bb61e", (String)"\u65e0\u6548\u5bc6\u7801!"));
        Assert.isTrue((boolean)encryptPassword.equals(filePassword), (String)I18nUtil.translate((String)"i18n_alert_QIwoNSWVsKW_13cb602e", (String)"\u6587\u4ef6\u5bc6\u7801\u9519\u8bef\uff0c\u8bf7\u91cd\u8bd5!"));
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void signature(String subpackageId) {
        PurchaseTenderProjectSubpackageInfo projectSubpackageInfo = (PurchaseTenderProjectSubpackageInfo)((Object)this.subpackageInfoService.getById((Serializable)((Object)subpackageId)));
        Assert.isTrue((boolean)PurchaseOpenBidStatusEnum.SIGNING.equals(projectSubpackageInfo.getOpenBidStatus()), (String)I18nUtil.translate((String)"", (String)"\u5f53\u524d\u72b6\u6001\u4e0d\u5141\u8bb8\u64cd\u4f5c\uff01"));
        TenderProjectSupplier querySupplier = new TenderProjectSupplier().setSubpackageId(subpackageId).setSupplierAccount(TenantContext.getTenant());
        List<TenderProjectSupplier> tenderProjectSupplierList = this.selectBySubpackageId(querySupplier);
        Assert.isTrue((!tenderProjectSupplierList.isEmpty() ? 1 : 0) != 0, (String)I18nUtil.translate((String)"", (String)"\u64cd\u4f5c\u5f02\u5e38\uff0c\u8bf7\u5237\u65b0\u91cd\u8bd5!"));
        TenderProjectSupplier tenderProjectSupplier = tenderProjectSupplierList.get(0);
        String decrypt = TenderOperationFieldUtils.getFieldStringValue((Object)tenderProjectSupplier, "decrypt");
        Assert.isTrue((boolean)"1".equals(decrypt), (String)I18nUtil.translate((String)"", (String)"\u8bf7\u5148\u89e3\u5bc6\uff0c\u518d\u7b7e\u540d!"));
        TenderOperationFieldUtils.setFieldValue((Object)tenderProjectSupplier, "1", "signature");
        ((TenderProjectSupplierMapper)this.baseMapper).updateById((Object)tenderProjectSupplier);
        LoginUser loginUser = SysUtil.getLoginUser();
        PurchaseTenderProjectOpenInfoHeadVO projectOpenInfoHeadVO = this.subpackageInfoService.queryOpenInfoById(tenderProjectSupplier.getSubpackageId());
        OpenBidRecordLogUtils.saveRecordMsg(projectOpenInfoHeadVO, "\u6295\u6807\u4eba " + loginUser.getEnterpriseName() + " " + loginUser.getRealname() + " \u5df2\u7b7e\u540d");
    }

    @Override
    public List<SaleTenderPriceOpenings> getSalePriceOpeningsBySubpackageId(String subpackageId) {
        List<PurchaseTenderProjectOpenSettingHead> purchaseTenderProjectOpenSettingHeadList = this.purchaseTenderProjectOpenSettingHeadServiceImpl.selectByMainId(subpackageId);
        Assert.isTrue((!CollectionUtil.isEmpty(purchaseTenderProjectOpenSettingHeadList) ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_vBGRjSWVImW_7865a794", (String)"\u5f00\u6807\u8bbe\u7f6e\u6709\u8bef,\u8bf7\u68c0\u67e5!"));
        String tenderCheckType = TenderFlagInjectionContext.getTenderCheckType();
        String processType = TenderFlagInjectionContext.getTenderProcessType();
        String currentStep = TenderFlagInjectionContext.getTenderCurrentStep();
        TenderProjectSupplier querySupplier = new TenderProjectSupplier().setSubpackageId(subpackageId);
        List<TenderProjectSupplier> tenderProjectSuppliers = this.selectBySubpackageId(querySupplier);
        List supplierAccountList = tenderProjectSuppliers.stream().filter(tenderProjectSupplier -> "1".equals(TenderOperationFieldUtils.getFieldStringValue(tenderProjectSupplier, "decrypt"))).map(TenderProjectSupplier::getSupplierAccount).collect(Collectors.toList());
        PurchaseTenderProjectOpenSettingHead purchaseTenderProjectOpenSettingHead = purchaseTenderProjectOpenSettingHeadList.get(0);
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.eq(SaleTenderPriceOpenings::getSubpackageId, (Object)subpackageId);
        if ("0".equals(purchaseTenderProjectOpenSettingHead.getAnnoQuote())) {
            lambdaQueryWrapper.eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant());
        } else if (!supplierAccountList.isEmpty()) {
            lambdaQueryWrapper.in(BaseEntity::getElsAccount, supplierAccountList);
        }
        lambdaQueryWrapper.eq(SaleTenderPriceOpenings::getCheckType, (Object)tenderCheckType);
        if (SubpackageInfoCheckTypeEnum.POST_TRIAL.getValue().equals(tenderCheckType) && SubpackageInfoProcessTypeEnum.ONE_STEP.getValue().equals(processType)) {
            lambdaQueryWrapper.eq(SaleTenderPriceOpenings::getProcessType, (Object)processType);
        } else if (SubpackageInfoCheckTypeEnum.POST_TRIAL.getValue().equals(tenderCheckType) && SubpackageInfoProcessTypeEnum.TWO_STEP.getValue().equals(processType)) {
            lambdaQueryWrapper.eq(SaleTenderPriceOpenings::getProcessType, (Object)processType);
            lambdaQueryWrapper.eq(SaleTenderPriceOpenings::getCurrentStep, (Object)currentStep);
        }
        lambdaQueryWrapper.eq(SaleTenderPriceOpenings::getStageQuote, (Object)"0");
        List tenderPriceOpeningsList = this.saleTenderPriceOpeningsServiceImpl.list((Wrapper)lambdaQueryWrapper);
        return tenderPriceOpeningsList;
    }

    @Override
    public TenderProjectSupplierMessageVO selectProjectSupplierBySubpackageId(String subpackageId) {
        TenderProjectSupplier querySupplier = new TenderProjectSupplier().setSubpackageId(subpackageId).setSupplierAccount(TenantContext.getTenant());
        List<TenderProjectSupplier> tenderProjectSuppliers = this.selectBySubpackageId(querySupplier);
        TenderProjectSupplierMessageVO supplierMessageVO = new TenderProjectSupplierMessageVO();
        BeanUtils.copyProperties((Object)((Object)tenderProjectSuppliers.get(0)), (Object)((Object)supplierMessageVO));
        PurchaseTenderProjectOpenInfoHeadVO openInfoHeadVO = this.subpackageInfoService.queryOpenInfoById(subpackageId);
        String openBidStatus = TenderOperationFieldUtils.getOpenBidStatus((Object)openInfoHeadVO);
        TenderOperationFieldUtils.setOpenBidStatus((Object)supplierMessageVO, openBidStatus);
        Date announceOpenBidTime = TenderOperationFieldUtils.getFieldDateValue((Object)openInfoHeadVO, "announceOpenBidTime");
        TenderOperationFieldUtils.setFieldValue((Object)supplierMessageVO, announceOpenBidTime, "announceOpenBidTime");
        PurchaseTenderProjectOpenInfoRecordsService projectOpenInfoRecordsService = (PurchaseTenderProjectOpenInfoRecordsService)SpringUtil.getBean(PurchaseTenderProjectOpenInfoRecordsService.class);
        List<PurchaseTenderProjectOpenInfoRecords> recordsList = projectOpenInfoRecordsService.queryOpenInfoRecordsBySubpackageId(subpackageId);
        supplierMessageVO.setOpenInfoRecordsList(recordsList);
        return supplierMessageVO;
    }

    @Override
    public TenderProjectSupplierInfoVO queryInfoById(String id) {
        List<SaleTenderPriceOpenings> saleTenderPriceOpenings;
        List resultSaleAttachmentDTO;
        TenderProjectSupplierInfoVO tenderProjectSupplierInfoVO = new TenderProjectSupplierInfoVO();
        TenderProjectSupplier tenderProjectSupplier = (TenderProjectSupplier)((Object)((TenderProjectSupplierMapper)this.baseMapper).selectById((Serializable)((Object)id)));
        Assert.isTrue((boolean)ObjectUtil.isNotEmpty((Object)((Object)tenderProjectSupplier)), (String)I18nUtil.translate((String)"", (String)"\u6570\u636e\u4e0d\u5b58\u5728!"));
        BeanUtils.copyProperties((Object)((Object)tenderProjectSupplier), (Object)((Object)tenderProjectSupplierInfoVO));
        PurchaseTenderProjectSubpackageInfo subpackageInfo = this.subpackageInfoService.selectById(tenderProjectSupplier.getSubpackageId());
        ArrayList<SaleAttachmentDTO> saleAttachmentDTOList = new ArrayList<SaleAttachmentDTO>();
        ArrayList<PurchaseTenderBidLetter> purchaseTenderBidLetterList = new ArrayList<PurchaseTenderBidLetter>();
        if ("1".equals(tenderProjectSupplier.getPreDecrypt())) {
            List preSaleAttachmentDTO = this.invokeBaseRpcService.selectSaleAttachmentByMainId(tenderProjectSupplier.getId() + "_" + SubpackageInfoCheckTypeEnum.PRE_TRIAL.getValue());
            if (CollectionUtil.isNotEmpty((Collection)preSaleAttachmentDTO)) {
                saleAttachmentDTOList.addAll(preSaleAttachmentDTO);
            }
            TenderFlagInjectionContext.setTenderCheckType("0");
            List<PurchaseTenderBidLetter> purchaseTenderBidLetters = this.purchaseTenderBidLetterService.queryPurchaseTenderBidLetter(tenderProjectSupplier.getSubpackageId());
            if (CollectionUtil.isNotEmpty(purchaseTenderBidLetters)) {
                purchaseTenderBidLetterList.addAll(purchaseTenderBidLetters);
            }
            TenderFlagInjectionContext.clear();
        }
        if (CollectionUtil.isNotEmpty((Collection)(resultSaleAttachmentDTO = this.invokeBaseRpcService.selectSaleAttachmentByMainId(tenderProjectSupplier.getId() + "_" + SubpackageInfoCheckTypeEnum.POST_TRIAL.getValue())))) {
            List resultSaleAttachmentList;
            List<PurchaseTenderBidLetter> purchaseTenderBidLetters;
            String processType = subpackageInfo.getProcessType();
            if ("1".equals(processType)) {
                if ("1".equals(tenderProjectSupplier.getDecrypt())) {
                    List saleAttachmentDTOS = resultSaleAttachmentDTO.stream().filter(saleItem -> SaleTenderDocumentSubmitEnum.ONE_STEP_PROCESS.getValue().equals(saleItem.getFileType())).collect(Collectors.toList());
                    if (CollectionUtil.isNotEmpty(saleAttachmentDTOS)) {
                        saleAttachmentDTOList.addAll(saleAttachmentDTOS);
                    }
                    TenderFlagInjectionContext.setTenderCheckType("1");
                    TenderFlagInjectionContext.setTenderProcessType("1");
                    TenderFlagInjectionContext.setTenderCurrentStep("0");
                    purchaseTenderBidLetters = this.purchaseTenderBidLetterService.queryPurchaseTenderBidLetter(tenderProjectSupplier.getSubpackageId(), true);
                    if (CollectionUtil.isNotEmpty(purchaseTenderBidLetters)) {
                        purchaseTenderBidLetterList.addAll(purchaseTenderBidLetters);
                    }
                    TenderFlagInjectionContext.clear();
                }
                if ("1".equals(tenderProjectSupplier.getResultDecrypt())) {
                    resultSaleAttachmentList = resultSaleAttachmentDTO.stream().filter(saleItem -> SaleTenderDocumentSubmitEnum.TWO_STEP_PROCESS.getValue().equals(saleItem.getFileType())).collect(Collectors.toList());
                    if (CollectionUtil.isNotEmpty(resultSaleAttachmentList)) {
                        saleAttachmentDTOList.addAll(resultSaleAttachmentList);
                    }
                    TenderFlagInjectionContext.setTenderCheckType("1");
                    TenderFlagInjectionContext.setTenderProcessType("1");
                    TenderFlagInjectionContext.setTenderCurrentStep("1");
                    purchaseTenderBidLetters = this.purchaseTenderBidLetterService.queryPurchaseTenderBidLetter(tenderProjectSupplier.getSubpackageId(), true);
                    if (CollectionUtil.isNotEmpty(purchaseTenderBidLetters)) {
                        purchaseTenderBidLetterList.addAll(purchaseTenderBidLetters);
                    }
                    TenderFlagInjectionContext.clear();
                }
            } else if ("1".equals(tenderProjectSupplier.getResultDecrypt())) {
                resultSaleAttachmentList = resultSaleAttachmentDTO.stream().filter(saleItem -> SaleTenderDocumentSubmitEnum.PROCESS.getValue().equals(saleItem.getFileType())).collect(Collectors.toList());
                if (CollectionUtil.isNotEmpty(resultSaleAttachmentList)) {
                    saleAttachmentDTOList.addAll(resultSaleAttachmentList);
                }
                TenderFlagInjectionContext.setTenderCheckType("1");
                TenderFlagInjectionContext.setTenderProcessType("0");
                purchaseTenderBidLetters = this.purchaseTenderBidLetterService.queryPurchaseTenderBidLetter(tenderProjectSupplier.getSubpackageId());
                if (CollectionUtil.isNotEmpty(purchaseTenderBidLetters)) {
                    purchaseTenderBidLetterList.addAll(purchaseTenderBidLetters);
                }
                TenderFlagInjectionContext.clear();
            }
        }
        ArrayList saleTenderBidLetterList = SysUtil.copyProperties(purchaseTenderBidLetterList, SaleTenderBidLetterVo.class);
        List<String> bidLetterIds = purchaseTenderBidLetterList.stream().map(BaseEntity::getId).collect(Collectors.toList());
        if (CollectionUtil.isNotEmpty(bidLetterIds) && CollectionUtil.isNotEmpty(saleTenderPriceOpenings = this.saleTenderPriceOpeningsServiceImpl.queryByBidLetterIdIn(bidLetterIds, tenderProjectSupplier.getSupplierAccount()))) {
            Map<String, List<SaleTenderPriceOpenings>> saleTenderPriceOpeningsMap = saleTenderPriceOpenings.stream().collect(Collectors.groupingBy(SaleTenderPriceOpenings::getBidLetterId));
            saleTenderBidLetterList.forEach(saleTenderBidLetter -> {
                List tenderPriceOpenings = (List)saleTenderPriceOpeningsMap.get(saleTenderBidLetter.getId());
                saleTenderBidLetter.setPriceOpeningsList(tenderPriceOpenings);
            });
        }
        tenderProjectSupplierInfoVO.setSaleTenderBidLetterList(saleTenderBidLetterList);
        tenderProjectSupplierInfoVO.setAttachmentInfoList(saleAttachmentDTOList);
        return tenderProjectSupplierInfoVO;
    }

    @Override
    public void updateInvalidStatusByMainId(String subpackageId, List<String> invalidSupplierAccountList) {
        if (invalidSupplierAccountList.isEmpty()) {
            return;
        }
        ((TenderProjectSupplierMapper)this.baseMapper).updateInvalidStatusByMainId(subpackageId, invalidSupplierAccountList);
    }

    @Override
    public void updateShortlistedStatus(String subpackageId, List<String> shortlistedSupplierAccountList) {
        String tenderCheckType = TenderFlagInjectionContext.getTenderCheckType();
        String tenderProcessType = TenderFlagInjectionContext.getTenderProcessType();
        String currentStep = TenderFlagInjectionContext.getTenderCurrentStep();
        ((TenderProjectSupplierMapper)this.baseMapper).updateShortListedStatus(subpackageId, tenderCheckType, tenderProcessType, currentStep, shortlistedSupplierAccountList);
    }

    private void checkParam(TenderProjectSupplier tenderProjectSupplier) {
        Assert.isTrue((boolean)org.springframework.util.StringUtils.hasText((String)tenderProjectSupplier.getPurchaseEnterpriseAccount()), (String)I18nUtil.translate((String)"", (String)"\u62db\u6807\u5355\u4f4d\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a!"));
        Assert.isTrue((boolean)org.springframework.util.StringUtils.hasText((String)tenderProjectSupplier.getSupplierAccount()), (String)I18nUtil.translate((String)"", (String)"\u6295\u6807\u5355\u4f4d\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a!"));
        Assert.isTrue((boolean)org.springframework.util.StringUtils.hasText((String)tenderProjectSupplier.getSupplierName()), (String)I18nUtil.translate((String)"", (String)"\u6295\u6807\u5355\u4f4d\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a!"));
        Assert.isTrue((boolean)org.springframework.util.StringUtils.hasText((String)tenderProjectSupplier.getSubpackageId()), (String)I18nUtil.translate((String)"", (String)"\u5206\u5305ID\u4e0d\u80fd\u4e3a\u7a7a!"));
        Assert.isTrue((boolean)org.springframework.util.StringUtils.hasText((String)tenderProjectSupplier.getTenderProjectId()), (String)I18nUtil.translate((String)"", (String)"\u9879\u76eeID\u4e0d\u80fd\u4e3a\u7a7a!"));
        Assert.isTrue((boolean)org.springframework.util.StringUtils.hasText((String)tenderProjectSupplier.getTenderProjectNumber()), (String)I18nUtil.translate((String)"", (String)"\u9879\u76ee\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a!"));
        Assert.isTrue((boolean)org.springframework.util.StringUtils.hasText((String)tenderProjectSupplier.getTenderProjectName()), (String)I18nUtil.translate((String)"", (String)"\u9879\u76ee\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a!"));
        Assert.isTrue((boolean)org.springframework.util.StringUtils.hasText((String)tenderProjectSupplier.getSourceType()), (String)I18nUtil.translate((String)"", (String)"\u6570\u636e\u6765\u6e90\u4e0d\u80fd\u4e3a\u7a7a!"));
    }

    private void buildParam(TenderProjectSupplier dataSource, TenderProjectSupplier dataTarget) {
        dataTarget.setSubpackageId(dataSource.getSubpackageId());
        dataTarget.setSupplierAccount(dataSource.getSupplierAccount());
        dataTarget.setSupplierName(dataSource.getSupplierName());
        dataTarget.setTenderProjectId(dataSource.getTenderProjectId());
        dataTarget.setPurchaseEnterpriseAccount(dataSource.getPurchaseEnterpriseAccount());
        dataTarget.setPurchaseEnterpriseName(dataSource.getPurchaseEnterpriseName());
        dataTarget.setSourceType(dataSource.getSourceType());
        dataTarget.setTenderProjectNumber(dataSource.getTenderProjectNumber());
        dataTarget.setTenderProjectName(dataSource.getTenderProjectName());
        dataTarget.setElsAccount(dataSource.getSupplierAccount());
        dataTarget.setCombination(dataSource.getCombination());
        dataTarget.setCombinationName(dataSource.getCombinationName());
        dataTarget.setContacts(dataSource.getContacts());
        dataTarget.setContactsPhone(dataSource.getContactsPhone());
        dataTarget.setRemark(dataSource.getRemark());
        dataTarget.setDataVersion(dataSource.getDataVersion());
        if (!org.springframework.util.StringUtils.hasText((String)dataTarget.getId())) {
            this.builDefaultParam(dataTarget);
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void updateResponseById(TenderProjectSupplier tenderProjectSupplier) {
        int count = ((TenderProjectSupplierMapper)this.baseMapper).updateResponseById(tenderProjectSupplier, TenderFlagInjectionContext.getTenderCheckType());
        Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
    }

    private void builDefaultParam(TenderProjectSupplier tenderProjectSupplier) {
        tenderProjectSupplier.setPreSignIn("0");
        tenderProjectSupplier.setPreDecrypt("0");
        tenderProjectSupplier.setSignature("0");
        tenderProjectSupplier.setPreShortlisted("0");
        tenderProjectSupplier.setSignUp("1");
        tenderProjectSupplier.setInvite("0");
        tenderProjectSupplier.setPurchaseBid("0");
        tenderProjectSupplier.setBail("0");
        tenderProjectSupplier.setDecrypt("0");
        tenderProjectSupplier.setResultDecrypt("0");
        tenderProjectSupplier.setWinner("0");
        tenderProjectSupplier.setOpenBidStatus(PurchaseOpenBidStatusEnum.NOT_OPEN_BID.getValue());
        tenderProjectSupplier.setSignature("0");
        tenderProjectSupplier.setSignIn("0");
        tenderProjectSupplier.setDeleted(CommonConstant.DEL_FLAG_0);
        tenderProjectSupplier.setInvalid("0");
        tenderProjectSupplier.setShortlisted("0");
        tenderProjectSupplier.setResultShortlisted("0");
        tenderProjectSupplier.setInviteQuotedPriceStatus(TenderProjectSupplieInviteQuotedPriceStatusEnum.UNINVITED.getValue());
        PurchaseTenderProjectSubpackageInfo purchaseTenderProjectSubpackageInfo = this.subpackageInfoService.selectById(tenderProjectSupplier.getSubpackageId());
        tenderProjectSupplier.setCheckType(purchaseTenderProjectSubpackageInfo.getCheckType());
        tenderProjectSupplier.setSubpackageName(purchaseTenderProjectSubpackageInfo.getSubpackageName());
    }

    @Override
    public PurchaseTenderProjectOpenInfoHeadVO openBidPermission(String subpackageId) {
        TenderProjectSupplier querySupplier = new TenderProjectSupplier().setSubpackageId(subpackageId).setSupplierAccount(TenantContext.getTenant());
        List<TenderProjectSupplier> tenderProjectSupplierList = this.selectBySubpackageId(querySupplier);
        Assert.isTrue((!tenderProjectSupplierList.isEmpty() ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_tkIHWVXVsKW_58a1a970", (String)"\u64cd\u4f5c\u5f02\u5e38\uff0c\u8bf7\u5237\u65b0\u91cd\u8bd5!"));
        TenderProjectSupplier tenderProjectSupplier = tenderProjectSupplierList.get(0);
        Assert.isTrue((boolean)"1".equals(TenderOperationFieldUtils.getFieldStringValue((Object)tenderProjectSupplier, "responseStatus")), (String)I18nUtil.translate((String)"", (String)"\u5f53\u524d\u72b6\u6001\u4e0d\u5141\u8bb8\u8fdb\u5165\u5f00\u6807\u5927\u5385!"));
        return this.subpackageInfoService.queryOpenInfoById(subpackageId);
    }

    @Override
    public void deleteBySubpackageId(String subpackageId) {
        ((TenderProjectSupplierMapper)this.baseMapper).deleteBySubpackageId(subpackageId);
    }

    @Override
    public void addBatch(PurchaseTenderNoticeHead purchaseTenderNoticeHead, List<PurchaseTenderNoticeItem> purchaseTenderNoticeItemList, List<PurchaseTenderSupplierInvitation> purchaseTenderSupplierInvitationList) {
        ArrayList<TenderProjectSupplier> tenderProjectSupplierList = new ArrayList<TenderProjectSupplier>();
        LoginUser loginUser = SysUtil.getLoginUser();
        PurchaseTenderProjectHead projectHead = (PurchaseTenderProjectHead)((Object)this.purchaseTenderProjectHeadService.getById((Serializable)((Object)purchaseTenderNoticeHead.getTenderProjectId())));
        for (PurchaseTenderNoticeItem purchaseTenderNoticeItem : purchaseTenderNoticeItemList) {
            for (PurchaseTenderSupplierInvitation invitation : purchaseTenderSupplierInvitationList) {
                TenderProjectSupplier tenderProjectSupplier = new TenderProjectSupplier();
                tenderProjectSupplier.setElsAccount(invitation.getSupplierAccount());
                tenderProjectSupplier.setPurchaseEnterpriseAccount(loginUser.getElsAccount());
                tenderProjectSupplier.setPurchaseEnterpriseName(loginUser.getAliasName());
                tenderProjectSupplier.setSupplierSubAccount("1001");
                tenderProjectSupplier.setSupplierAccount(invitation.getSupplierAccount());
                tenderProjectSupplier.setSupplierName(invitation.getSupplierName());
                tenderProjectSupplier.setElsAccount(invitation.getSupplierAccount());
                tenderProjectSupplier.setSubpackageId(purchaseTenderNoticeItem.getSubpackageId());
                tenderProjectSupplier.setSubpackageName(purchaseTenderNoticeItem.getSubpackageName());
                tenderProjectSupplier.setTenderProjectId(purchaseTenderNoticeItem.getTenderProjectId());
                tenderProjectSupplier.setTenderProjectName(projectHead.getTenderProjectName());
                tenderProjectSupplier.setTenderProjectNumber(projectHead.getTenderProjectNumber());
                tenderProjectSupplier.setSourceType("0");
                tenderProjectSupplier.setInviteQuotedPriceStatus(TenderProjectSupplieInviteQuotedPriceStatusEnum.UNINVITED.getValue());
                tenderProjectSupplierList.add(tenderProjectSupplier);
            }
        }
        this.saveBatch(tenderProjectSupplierList);
        this.tenderProjectMarginHeadService.addBatch(tenderProjectSupplierList);
    }

    @Override
    public void updateWinnerById(List<String> supplierAccounts, String subpacakgeId) {
        ((TenderProjectSupplierMapper)this.baseMapper).updateWinnerById(supplierAccounts, subpacakgeId);
    }

    @Override
    public void updateInviteQuotedPriceStatus(Collection supplierAccounts, String subpackageId, String inviteQuotedPriceStatus) {
        ((TenderProjectSupplierMapper)this.baseMapper).updateInviteQuotedPriceStatus(supplierAccounts, subpackageId, inviteQuotedPriceStatus);
    }

    @Override
    public void updateEffectiveById(String id, String effective) {
        ((TenderProjectSupplierMapper)this.baseMapper).updateEffectiveById(id, effective);
    }

    @Override
    public List<TenderProjectSupplier> selectByMainIds(List<String> oldSubpackageIds) {
        return ((TenderProjectSupplierMapper)this.baseMapper).selectByMainIds(oldSubpackageIds);
    }

    @Override
    public List<SupplierRelationFindResultVO> queryRiskRelationFind(Map<String, TenderProjectSupplier> projectSupplierMap) {
        ArrayList<SupplierRelationFindResultVO> relationFindResultList = new ArrayList<SupplierRelationFindResultVO>();
        Set<String> elsAccountList = projectSupplierMap.keySet();
        List<EnterpriseRiskDTO> riskDTOS = this.inquiryInvokeSupplierRpcService.queryRiskRelationFind(elsAccountList);
        if (riskDTOS.isEmpty()) {
            return relationFindResultList;
        }
        Map riskDTOMap = riskDTOS.parallelStream().collect(Collectors.toMap(EnterpriseRiskDTO::getElsAccount, Function.identity()));
        HashMap<String, Map<String, String>> supplierInvesttreeMap = new HashMap<String, Map<String, String>>();
        HashMap<String, Map<String, String>> supplierHumanHoldingMap = new HashMap<String, Map<String, String>>();
        HashMap<String, Map<String, String>> supplierCompanyHoldingMap = new HashMap<String, Map<String, String>>();
        for (String elsAccount : riskDTOMap.keySet()) {
            EnterpriseRiskDTO enterpriseRiskDTO = (EnterpriseRiskDTO)riskDTOMap.get(elsAccount);
            HashMap supplierMap = new HashMap();
            enterpriseRiskDTO.getSupplierInvesttreeList().parallelStream().forEach(supplierInvesttreeDTO -> {
                supplierMap.put(supplierInvesttreeDTO.getCreditCode(), supplierInvesttreeDTO.getSupplierName());
                this.getAllSupplierCreditCode(supplierMap, supplierInvesttreeDTO.getChildren());
            });
            supplierInvesttreeMap.put(elsAccount, supplierMap);
            Map<String, String> humanHoldingMap = enterpriseRiskDTO.getSupplierHumanHoldingList().parallelStream().collect(Collectors.toMap(SupplierHumanHoldingDTO::getCid, SupplierHumanHoldingDTO::getName, (key1, key2) -> key2));
            supplierHumanHoldingMap.put(elsAccount, humanHoldingMap);
            Map<String, String> companyHoldingMap = enterpriseRiskDTO.getSupplierCompanyHoldingList().parallelStream().collect(Collectors.toMap(SupplierCompanyHoldingDTO::getCid, SupplierCompanyHoldingDTO::getName, (key1, key2) -> key2));
            supplierCompanyHoldingMap.put(elsAccount, companyHoldingMap);
        }
        relationFindResultList.addAll(this.analyseSupplierRelationRisk(projectSupplierMap, supplierInvesttreeMap, RiskTypeEnum.INVESTTREE.getValue()));
        relationFindResultList.addAll(this.analyseSupplierRelationRisk(projectSupplierMap, supplierHumanHoldingMap, RiskTypeEnum.HUMANHOLDING.getValue()));
        relationFindResultList.addAll(this.analyseSupplierRelationRisk(projectSupplierMap, supplierCompanyHoldingMap, RiskTypeEnum.COMPANYHOLD.getValue()));
        return relationFindResultList;
    }

    private void getAllSupplierCreditCode(Map<String, String> supplierMap, String children) {
        if (StringUtils.isBlank((CharSequence)children) || "[]".equals(children)) {
            return;
        }
        List supplierInvesttreeInfos = JSON.parseArray((String)children, SupplierInvesttreeInfoVO.class);
        supplierInvesttreeInfos.parallelStream().forEach(supplierInvesttreeInfo -> {
            if (StringUtils.isNotBlank((CharSequence)supplierInvesttreeInfo.getCreditCode())) {
                supplierMap.put(supplierInvesttreeInfo.getCreditCode(), supplierInvesttreeInfo.getName());
            }
            this.getAllSupplierCreditCode(supplierMap, supplierInvesttreeInfo.getChildren());
        });
    }

    private List<SupplierRelationFindResultVO> analyseSupplierRelationRisk(Map<String, TenderProjectSupplier> projectSupplierMap, Map<String, Map<String, String>> supplierInvesttreeMap, String type) {
        ArrayList<SupplierRelationFindResultVO> relationFindResultList = new ArrayList<SupplierRelationFindResultVO>();
        ArrayList<String> hadCheckedSupplierElsAccount = new ArrayList<String>();
        for (String elsAccount : supplierInvesttreeMap.keySet()) {
            Map<String, String> supplierMap = supplierInvesttreeMap.get(elsAccount);
            hadCheckedSupplierElsAccount.add(elsAccount);
            for (String nextElsAccount : supplierInvesttreeMap.keySet()) {
                if (hadCheckedSupplierElsAccount.contains(nextElsAccount)) continue;
                Map<String, String> nextSupplierMap = supplierInvesttreeMap.get(nextElsAccount);
                Set<String> compareKeySet = nextSupplierMap.keySet();
                for (String compareKey : compareKeySet) {
                    if (!supplierMap.containsKey(compareKey)) continue;
                    SupplierRelationFindResultVO findResultVO = new SupplierRelationFindResultVO();
                    findResultVO.setSourceName(projectSupplierMap.get(elsAccount).getSupplierName());
                    findResultVO.setToName(projectSupplierMap.get(nextElsAccount).getSupplierName());
                    findResultVO.setResult(nextSupplierMap.get(compareKey));
                    findResultVO.setType(type);
                    relationFindResultList.add(findResultVO);
                }
            }
        }
        return relationFindResultList;
    }

    @Override
    public SaleTenderPriceOpenings getLetterEncryptionInfoBySubpackageId(String subpackageId) {
        List<SaleTenderPriceOpenings> salePriceOpeningsBySubpackageId = this.saleTenderPriceOpeningsServiceImpl.getSalePriceOpeningsBySubpackageId(subpackageId, Arrays.asList(TenantContext.getTenant()), "0");
        if (CollectionUtil.isNotEmpty(salePriceOpeningsBySubpackageId)) {
            return salePriceOpeningsBySubpackageId.get(0);
        }
        return null;
    }

    private void decryptCAServer(List<SaleAttachmentDTO> saleAttachmentDTOList, String password) {
        Map<String, Object> params;
        String ids = saleAttachmentDTOList.stream().map(BaseDTO::getId).collect(Collectors.joining(","));
        RestTemplate restTemplate = new RestTemplate();
        String url = this.decryptTenderProperties.getUrl() + "/tender/certification/decryptedFile?appId={appId}&signature={signature}&ids={ids}&password={password}";
        ResponseEntity responseEntity = restTemplate.getForEntity(url, String.class, params = this.getParams(ids, password));
        String body = (String)responseEntity.getBody();
        JSONObject jsonObject = JSON.parseObject((String)body);
        if ("0".equals(jsonObject.get((Object)"code").toString())) {
            for (SaleAttachmentDTO saleAttachmentDTO : saleAttachmentDTOList) {
                String fileName;
                String originFileName = fileName = saleAttachmentDTO.getFileName();
                int firstIndex = fileName.indexOf(".");
                if (firstIndex != -1) {
                    String fileExtension = fileName.substring(firstIndex + 1);
                    int firstFileExtendsionIndex = fileExtension.indexOf(".");
                    int endIndex = firstIndex + 1;
                    if (firstFileExtendsionIndex != -1) {
                        originFileName = fileName.substring(0, endIndex += firstFileExtendsionIndex);
                    }
                }
                saleAttachmentDTO.setFileName(originFileName);
            }
            return;
        }
        log.error("\u8c03\u7528\u6587\u4ef6\u89e3\u5bc6\u670d\u52a1\u5931\u8d25{},\u8f93\u5165\u5bc6\u7801\u4e3a\u3010{}\u3011,\u89e3\u5bc6\u7ed3\u679c\uff1a{}", new Object[]{ids, password, jsonObject.get((Object)"msg")});
        throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u8c03\u7528\u6587\u4ef6\u89e3\u5bc6\u5931\u8d25"));
    }

    private Map<String, Object> getParams(String ids, String password) {
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("appId", this.decryptTenderProperties.getAppId());
        String signature = GenerateSignatureUtil.getSignature((String)this.decryptTenderProperties.getAppKey(), (String)this.decryptTenderProperties.getAppId(), (String)this.decryptTenderProperties.getSecret());
        try {
            params.put("signature", URLEncoder.encode(signature, "utf-8"));
            params.put("ids", ids);
            params.put("password", password);
        }
        catch (UnsupportedEncodingException e) {
            log.error(e.getMessage());
        }
        return params;
    }
}

