/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.material.third.u8.api.extend;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.els.common.constant.CommonConstant;
import com.els.common.exception.ELSBootException;
import com.els.common.util.DateUtils;
import com.els.common.util.InterfaceUtil;
import com.els.common.util.SpringContextUtils;
import com.els.modules.base.api.service.InterfaceCustomExtendRpcService;
import com.els.modules.material.entity.PurchaseMaterialCode;
import com.els.modules.material.enumerate.MaterialCateStatusEnum;
import com.els.modules.material.service.PurchaseMaterialCodeService;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class GetMaterialCodeFromLuoShiU8Impl
implements InterfaceCustomExtendRpcService {
    private static final Logger log = LoggerFactory.getLogger(GetMaterialCodeFromLuoShiU8Impl.class);
    @Resource
    private PurchaseMaterialCodeService purchaseMaterialCodeService;

    public JSONObject before(JSONObject jsonObject, Object custom) {
        JSONObject body = new JSONObject();
        JSONObject customObject = (JSONObject)custom;
        boolean isIncrement = true;
        if (customObject.containsKey((Object)"custom_param") && null != customObject.getJSONObject("custom_param")) {
            isIncrement = customObject.getJSONObject("custom_param").getBoolean("isIncrement");
        }
        body.put("page_now", (Object)1);
        body.put("page_size", (Object)1000);
        if (isIncrement) {
            Calendar calendar = Calendar.getInstance();
            calendar.add(6, -5);
            Date date = calendar.getTime();
            body.put("startTs", (Object)(DateUtils.formatDate((Date)date, (String)"yyyy-MM-dd") + " 00:00:00"));
            body.put("endTs", (Object)(DateUtils.formatDate((Date)new Date(), (String)"yyyy-MM-dd") + " 23:59:59"));
        } else if (null == customObject.getString("url_param")) {
            String startTs = customObject.getJSONObject("custom_param").getString("startTs");
            String endTs = customObject.getJSONObject("custom_param").getString("endTs");
            body.put("startTs", (Object)startTs);
            body.put("endTs", (Object)endTs);
            customObject.put("url_param", (Object)"getMaterialCodeFromLuoShi");
        } else {
            return jsonObject;
        }
        jsonObject.put("body", (Object)body);
        log.info("SRM\u83b7\u53d6ERP\u7269\u6599\u5206\u7c7b\u6811\u7ea7\u63a5\u53e3\uff0c\u5165\u53c2\u4e3a\uff1a" + jsonObject);
        return jsonObject;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public JSONObject after(JSONObject jsonObject, JSONObject paramObj, Object custom) {
        log.info("SRM\u83b7\u53d6ERP\u7269\u6599\u5206\u7c7b\u6811\u7ea7\u63a5\u53e3\uff0c\u51fa\u53c2\u4e3a\uff1a" + jsonObject);
        JSONObject customObject = (JSONObject)custom;
        if (!CommonConstant.SC_OK_200.equals(jsonObject.getIntValue("code"))) throw new ELSBootException("\u8c03\u7528\u63a5\u53e3\u5e73\u53f0\u5931\u8d25: " + jsonObject.getString("message"));
        JSONObject result = JSONObject.parseObject((String)jsonObject.getString("result"));
        String returnStatus = result.getString("status");
        if ("success".equals(returnStatus)) {
            JSONObject data = JSONObject.parseObject((String)result.getString("data"));
            if (data.getInteger("retcount") == 0) {
                return null;
            }
            JSONArray codeArray = JSONObject.parseArray((String)data.getString("datas"));
            List<PurchaseMaterialCode> mateCodeList = this.parseTreeData(codeArray);
            if (!mateCodeList.isEmpty()) {
                this.purchaseMaterialCodeService.saveOrUpdateBatch(mateCodeList, 2000);
            }
        } else {
            String errorMsg = result.getString("errormsg");
            throw new ELSBootException("SRM\u83b7\u53d6ERP\u7269\u6599\u5206\u7c7b\u63a5\u53e3,\u5931\u8d25\u4fe1\u606f\u4e3a\uff1a" + errorMsg);
        }
        boolean isIncrement = true;
        if (customObject.containsKey((Object)"custom_param") && null != customObject.getJSONObject("custom_param")) {
            isIncrement = customObject.getJSONObject("custom_param").getBoolean("isIncrement");
        }
        if (isIncrement) return jsonObject;
        this.getPageInfo(jsonObject, paramObj, custom);
        return jsonObject;
    }

    private void getPageInfo(JSONObject jsonObject, JSONObject object, Object custom) {
        JSONObject customObj = (JSONObject)custom;
        String elsAccount = customObj.getString("bus_account");
        JSONObject resultData = jsonObject.getJSONObject("result");
        JSONObject data = resultData.getJSONObject("data");
        Integer count = data.getInteger("allcount");
        JSONObject body = JSONObject.parseObject((String)object.getString("body"));
        Integer page = body.getInteger("page_now");
        Integer page_size = body.getInteger("page_size");
        customObj.put("srm_interface_code", (Object)object.getString("srm_interface_code"));
        if (count >= page * page_size) {
            String param = null != customObj.getString("url_param") ? customObj.getString("url_param") : null;
            body.put("page_now", (Object)(page + 1));
            body.put("page_size", (Object)page_size);
            customObj.put("url_param", (Object)param);
            customObj.put("body", (Object)body);
            ((InterfaceUtil)SpringContextUtils.getBean(InterfaceUtil.class)).callInterface(elsAccount, null, customObj, custom);
        }
    }

    private List<PurchaseMaterialCode> parseTreeData(JSONArray codeArray) {
        Map codeMap = this.purchaseMaterialCodeService.list().stream().collect(Collectors.toMap(PurchaseMaterialCode::getCateCode, Function.identity()));
        HashMap jsonMap = new HashMap();
        codeArray.forEach(object -> {
            JSONObject json = (JSONObject)object;
            if ("1".equals(json.getString("invclasslev"))) {
                jsonMap.put(json.getString("invclasscode"), json.getString("invclassname"));
            }
        });
        ArrayList<PurchaseMaterialCode> materialCodeList = new ArrayList<PurchaseMaterialCode>();
        for (int i = 0; i < codeArray.size(); ++i) {
            JSONObject codeJson = codeArray.getJSONObject(i);
            String cateCode = codeJson.getString("invclasscode");
            String cateName = codeJson.getString("invclassname");
            String cateLevelCode = codeJson.getString("invclasslev");
            PurchaseMaterialCode purchaseMaterialCode = new PurchaseMaterialCode();
            purchaseMaterialCode.setCateCode(cateCode);
            purchaseMaterialCode.setCateName(cateName);
            purchaseMaterialCode.setCateLevelCode(cateLevelCode);
            if (!"1".equals(cateLevelCode)) {
                String upCateCode = this.initUpCateCode(cateLevelCode, cateCode);
                purchaseMaterialCode.setUpCateCode(upCateCode);
                purchaseMaterialCode.setUpCateName((String)jsonMap.get(upCateCode));
            }
            if (codeMap.containsKey(cateCode)) {
                String codeId = ((PurchaseMaterialCode)codeMap.get(cateCode)).getId();
                purchaseMaterialCode.setId(codeId);
            }
            purchaseMaterialCode.setSourceType("erp");
            purchaseMaterialCode.setCateStatus(MaterialCateStatusEnum.NORMAL.getValue());
            purchaseMaterialCode.setQuotaStrategy("0");
            materialCodeList.add(purchaseMaterialCode);
        }
        return materialCodeList;
    }

    private String initUpCateCode(String cateLevelCode, String cateCode) {
        String upCateCode = "";
        if ("2".equals(cateLevelCode)) {
            upCateCode = cateCode.substring(0, 2);
        }
        if ("3".equals(cateLevelCode)) {
            upCateCode = cateCode.substring(0, 4);
        }
        return upCateCode;
    }
}

