/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.material.third.xk.api;

import cn.hutool.core.text.CharSequenceUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.Assert;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.exception.ELSBootException;
import com.els.common.util.InterfaceUtil;
import com.els.common.util.SysUtil;
import com.els.modules.base.api.dto.TemplateHeadDTO;
import com.els.modules.base.api.service.InterfaceCustomExtendRpcService;
import com.els.modules.base.api.service.TemplateRpcService;
import com.els.modules.material.entity.PurchaseMaterialHead;
import com.els.modules.material.service.PurchaseMaterialCodeService;
import com.els.modules.material.service.PurchaseMaterialHeadService;
import com.els.modules.material.third.xk.vo.XkPurchaseMaterialHead;
import com.els.modules.material.vo.PurchaseMaterialHeadVO;
import com.els.modules.third.vo.QueryParam;
import com.els.modules.third.xk.util.XkUtil;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class GetMaterialListFromCQGGXkDbImpl
implements InterfaceCustomExtendRpcService {
    private static final Logger log = LoggerFactory.getLogger(GetMaterialListFromCQGGXkDbImpl.class);
    @Resource
    private PurchaseMaterialHeadService purchaseMaterialHeadService;
    @Resource
    private TemplateRpcService templateRpcService;
    @Resource
    private InterfaceUtil interfaceUtil;
    @Resource
    private PurchaseMaterialCodeService purchaseMaterialCodeService;
    private static final String FIELDKEYS = "FMaterialId,FNumber,FMaterialGroup.FNumber,FMaterialGroup.FName,FName,FDescription,FSpecification,FBASEUNITID.FName,FPURCHASEUNITID.FNumber,FAUXPROPERTYID,FZZ_WLWJ,FZZ_WLBH,FTAXRATEID,FTUISHUILV,FSALEUNITID.FName,FSALEPRICEUNITID.FName,FApproveDate";
    private Integer pageSize = 2000;

    public JSONObject before(JSONObject obj, Object custom) {
        JSONObject object = (JSONObject)custom;
        JSONObject paramObject = object.getJSONObject("custom_param");
        String isIncrement = "false";
        if (paramObject != null) {
            isIncrement = paramObject.getString("isIncrement");
        }
        StringBuffer filterString = new StringBuffer();
        filterString.append("FNumber not like '%\u7981\u7528%' and FForbidStatus='A' and FDocumentStatus='C'");
        filterString.append(" and FMaterialGroup.FNumber NOT IN ('88','99','50','00001','00002','00003','00004','00034','51','00005','00006','52','00007','53','00008','54','00009','00010','00011','00012','00013','00014','00015','00016','00017','00018','00019','00020','00021','00022','00023','00024','00025','00026','00027','00028','55','00029','00030','00031','00032','56','00033','57','00035')");
        QueryParam queryParam = new QueryParam();
        if (isIncrement.equals("true")) {
            Calendar calendar = Calendar.getInstance();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            String dateStr = sdf.format(calendar.getTime());
            filterString.append(" and FModifyDate >= '" + dateStr + "'");
        }
        int startRow = 0;
        if (CharSequenceUtil.isNotBlank((CharSequence)object.getString("startRow"))) {
            startRow = object.getIntValue("startRow");
        } else {
            object.put("startRow", (Object)startRow);
        }
        ((JSONObject)custom).putAll((Map)object);
        queryParam.setFormId("BD_MATERIAL");
        queryParam.setFieldKeys(FIELDKEYS);
        queryParam.setFilterString(filterString.toString());
        queryParam.setOrderString("FModifyDate");
        queryParam.setStartRow(startRow);
        queryParam.setLimit(this.pageSize.intValue());
        obj.put("body", (Object)queryParam);
        obj.put("startRow", (Object)startRow);
        return obj;
    }

    public JSONObject after(JSONObject obj, JSONObject custom, Object o) {
        JSONObject customObj = (JSONObject)o;
        String elsAccount = customObj.getString("bus_account");
        int resultSize = 0;
        try {
            List datas = XkUtil.loadDataListNew((String)FIELDKEYS, XkPurchaseMaterialHead.class, (String)XkUtil.getResultArray((JSONObject)obj).toJSONString());
            if (CollectionUtils.isEmpty((Collection)datas)) {
                log.info("EVENT = \u6682\u65e0\u7269\u6599\u4e3b\u6570\u636e\u9700\u8981\u540c\u6b65");
                obj.put("message", (Object)"\u6682\u65e0\u7269\u6599\u4e3b\u6570\u636e\u9700\u8981\u540c\u6b65");
                return obj;
            }
            log.info("EVENT = GetMaterialListFromXkDbImpl====\u63a5\u53e3\u8fd4\u56de\u7269\u6599\u4e3b\u6570\u636e\u6570\u91cf\uff1a{} ", (Object)JSON.toJSONString((Object)datas.size()));
            resultSize = datas.size();
            List templateList = this.templateRpcService.getDefaultTemplateByType("material");
            Assert.notEmpty((Collection)templateList, (String)"\u8bf7\u5148\u914d\u7f6e\u7269\u6599\u4e3b\u6570\u636e\u9ed8\u8ba4\u6a21\u677f", (Object[])new Object[0]);
            TemplateHeadDTO templateHead = (TemplateHeadDTO)templateList.get(0);
            ArrayList<PurchaseMaterialHead> purchaseMaterialHeads = new ArrayList<PurchaseMaterialHead>();
            Map<String, List<XkPurchaseMaterialHead>> dataMap = datas.stream().collect(Collectors.groupingBy(XkPurchaseMaterialHead::getFNumber));
            for (Map.Entry<String, List<XkPurchaseMaterialHead>> entry : dataMap.entrySet()) {
                List<XkPurchaseMaterialHead> heads = entry.getValue();
                PurchaseMaterialHead purchaseMaterialHead = new PurchaseMaterialHead();
                for (int i = 0; i < heads.size(); ++i) {
                    XkPurchaseMaterialHead data = heads.get(i);
                    if (i != 0) continue;
                    purchaseMaterialHead.setSourceId(data.getFMaterialId());
                    purchaseMaterialHead.setSourceSystem("erp");
                    purchaseMaterialHead.setWriteErp("1");
                    purchaseMaterialHead.setSourceType("ERP");
                    purchaseMaterialHead.setTemplateNumber(templateHead.getTemplateNumber());
                    purchaseMaterialHead.setTemplateName(templateHead.getTemplateName());
                    purchaseMaterialHead.setTemplateVersion(templateHead.getTemplateVersion());
                    purchaseMaterialHead.setTemplateAccount(templateHead.getElsAccount());
                    purchaseMaterialHead.setAuditStatus(AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
                    purchaseMaterialHead.setCreateById(String.valueOf(data.getFCreatorId()));
                    purchaseMaterialHead.setCreateTime(data.getFCreateDate());
                    purchaseMaterialHead.setUpdateById(String.valueOf(data.getFModifierId()));
                    purchaseMaterialHead.setFreeze("0");
                    purchaseMaterialHead.setBlocDel("0");
                    purchaseMaterialHead.setMaterialNumber(data.getFNumber());
                    purchaseMaterialHead.setMaterialName(data.getFName());
                    purchaseMaterialHead.setMaterialSpec(data.getFSpecification());
                    purchaseMaterialHead.setMaterialDesc(data.getFName());
                    if (data.getFMaterialGroup() != null) {
                        purchaseMaterialHead.setMaterialGroup(data.getFMaterialGroup().getFNumber());
                        purchaseMaterialHead.setMaterialGroupName(data.getFMaterialGroup().getFName());
                    }
                    purchaseMaterialHead.setFbk7(data.getFBaseUnitId() != null ? data.getFBaseUnitId().getFName() : "");
                    purchaseMaterialHead.setFbk8(data.getFZZ_WLWJ().setScale(2, 4).toString());
                    purchaseMaterialHead.setFbk9(data.getFZZ_WLBH().setScale(2, 4).toString());
                    purchaseMaterialHead.setFbk10("13%");
                    purchaseMaterialHead.setFbk11(data.getFTUISHUILV().multiply(new BigDecimal("100")).stripTrailingZeros().toPlainString() + "%");
                    purchaseMaterialHead.setFbk12(data.getFSALEUNITID() != null ? data.getFSALEUNITID().getFName() : "");
                    purchaseMaterialHead.setFbk13(data.getFSALEPRICEUNITID() != null ? data.getFSALEPRICEUNITID().getFName() : "");
                    purchaseMaterialHead.setFbk15(data.getFApproveDate());
                }
                purchaseMaterialHeads.add(purchaseMaterialHead);
            }
            ArrayList<String> saveColumn = new ArrayList<String>(Arrays.asList("materialNumber", "materialNumber", "materialName", "materialSpec", "materialDesc", "fbk1", "fbk2", "fbk3", "fbk4", "fbk6", "fbk8", "fbk9", "fbk10", "fbk11", "fbk12", "fbk13", "fbk14", "fbk15"));
            Integer saveLeven = 1;
            String sourceType = "ERP";
            this.purchaseMaterialHeadService.batchSaveMain((List)SysUtil.copyProperties(purchaseMaterialHeads, PurchaseMaterialHeadVO.class), saveColumn, saveLeven, sourceType);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("EVENT=\u7269\u6599\u4e3b\u6570\u636e\u540c\u6b65\u51fa\u9519\u4e86\uff1a{}", (Object)JSON.toJSONString((Object)e.getMessage()));
            throw new ELSBootException("\u540c\u6b65\u7269\u6599\u4e3b\u6570\u636e\u51fa\u9519\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01");
        }
        if (this.pageSize == resultSize) {
            int startRow = customObj.getIntValue("startRow") + this.pageSize;
            customObj.put("startRow", (Object)startRow);
            JSONObject bodyJSON = new JSONObject();
            bodyJSON.put("srm_interface_code", (Object)"getMaterialData");
            bodyJSON.put("bus_account", (Object)elsAccount);
            this.interfaceUtil.callInterface(elsAccount, null, bodyJSON, (Object)customObj);
        }
        return obj;
    }
}

