/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.org.api.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.els.common.api.service.InterfaceConverter;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.util.InterfaceConverterUtil;
import com.els.common.util.RedisUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.org.entity.PurchaseOrganizationInfo;
import com.els.modules.org.service.PurchaseOrganizationInfoService;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service(value="findColumnByPurOrgInfoConverter")
public class FindColumnByPurOrgInfoConverter
implements InterfaceConverter {
    private static final String REDIS_PREFIX = "srm:findColumnByPurOrgInfoConverter_";
    @Autowired
    private RedisUtil redisUtil;
    @Lazy
    @Resource
    private PurchaseOrganizationInfoService purchaseOrganizationInfoService;

    public Object convertData(Object data, Object obj, String ... args) throws Exception {
        String searData = (String)data;
        String elsAccount = TenantContext.getTenant();
        String searColumn = args[0];
        String outColumn = args[1];
        if (StringUtils.isNotBlank((CharSequence)searData)) {
            Map<String, PurchaseOrganizationInfo> dbMap;
            List dbAccount = (List)this.redisUtil.get(REDIS_PREFIX + elsAccount);
            if (CollectionUtils.isEmpty((Collection)dbAccount)) {
                dbAccount = ((LambdaQueryChainWrapper)this.purchaseOrganizationInfoService.lambdaQuery().select(new SFunction[]{PurchaseOrganizationInfo::getOrgCode, BaseEntity::getId, PurchaseOrganizationInfo::getOrgName, PurchaseOrganizationInfo::getSourceId}).eq(BaseEntity::getElsAccount, (Object)elsAccount)).list();
                if (CollectionUtils.isEmpty((Collection)dbAccount)) {
                    return "";
                }
                this.redisUtil.set(REDIS_PREFIX + elsAccount, (Object)dbAccount, 300L);
            }
            if ((dbMap = this.getSearKeyMap(searColumn, JSON.parseArray((String)JSON.toJSONString((Object)dbAccount)))).containsKey(searData)) {
                if (outColumn.indexOf("_") > 0) {
                    String[] columns = outColumn.split("_");
                    StringBuilder sb = new StringBuilder();
                    for (int i = 0; i < columns.length; ++i) {
                        sb.append(InterfaceConverterUtil.findName((String)columns[i], (Object)dbMap.get(searData)));
                        if (i == columns.length) continue;
                        sb.append("_");
                    }
                    return InterfaceConverterUtil.findName((String)outColumn, (Object)sb.toString());
                }
                return InterfaceConverterUtil.findName((String)outColumn, (Object)dbMap.get(searData));
            }
            return "";
        }
        return searData;
    }

    private Map<String, PurchaseOrganizationInfo> getSearKeyMap(String searColumn, JSONArray arrays) {
        HashMap<String, PurchaseOrganizationInfo> result = new HashMap<String, PurchaseOrganizationInfo>();
        for (int i = 0; i < arrays.size(); ++i) {
            JSONObject obj = arrays.getJSONObject(i);
            if (!obj.containsKey((Object)searColumn)) continue;
            String key = obj.getString(searColumn);
            result.put(key, (PurchaseOrganizationInfo)JSON.parseObject((String)obj.toJSONString(), PurchaseOrganizationInfo.class));
        }
        return result;
    }
}

