/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.third.api;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.els.modules.base.api.service.InterfaceCustomExtendRpcService;
import com.els.modules.price.entity.PurchaseInformationRecords;
import com.els.modules.price.service.PurchaseInformationRecordsService;
import com.els.modules.third.base.util.ThirdUtil;
import com.els.modules.third.oa.util.OAUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PushPurchaseInformationFromThirdDbImpl
implements InterfaceCustomExtendRpcService {
    private static final Logger log = LoggerFactory.getLogger(PushPurchaseInformationFromThirdDbImpl.class);
    @Autowired
    private PurchaseInformationRecordsService reservationService;

    public boolean invokeCheck(JSONObject obj, Object custom) {
        PurchaseInformationRecords informationRecords = (PurchaseInformationRecords)custom;
        if (!"3".equals(informationRecords.getReturnState())) {
            informationRecords.setReturnState("0");
            return true;
        }
        return false;
    }

    public JSONObject before(JSONObject obj, Object custom) {
        String elsAccount = obj.getString("bus_account");
        obj.put("body", (Object)this.getSupplierVo(custom, elsAccount));
        return obj;
    }

    public JSONObject after(JSONObject object, JSONObject paramObj, Object custom) {
        log.info(JSON.toJSONString((Object)object));
        PurchaseInformationRecords informationRecords = (PurchaseInformationRecords)custom;
        String result = OAUtil.getResult((JSONObject)object);
        informationRecords.setReturnState("1");
        informationRecords.setInterfaceMsg(result);
        this.reservationService.updateById((Object)informationRecords);
        return object;
    }

    private JSONObject getSupplierVo(Object custom, String elsAccount) {
        PurchaseInformationRecords informationRecords = (PurchaseInformationRecords)custom;
        Object dataSource = ThirdUtil.newConvertMapping((String)elsAccount, (String)"pushPriceMainData", (Object)JSON.toJSONString((Object)informationRecords), null);
        return OAUtil.getDoCreateWorkflowRequest((JSONObject)JSON.parseObject((String)dataSource.toString()));
    }
}

