/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.material.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.common.util.I18nUtil;
import com.els.modules.material.entity.PurchaseMaterialHead;
import com.els.modules.material.entity.PurchaseMaterialItem;
import com.els.modules.material.excel.PurchaseMaterialHeadExportServiceImpl;
import com.els.modules.material.service.PurchaseMaterialHeadService;
import com.els.modules.material.service.PurchaseMaterialItemService;
import com.els.modules.material.vo.PurchaseMaterialHeadVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@RestController
@RequestMapping(value={"/material/purchaseMaterialHead"})
@Api(tags={"\u7269\u6599\u4e3b\u6570\u636e\u5934"})
public class PurchaseMaterialHeadController
extends BaseController<PurchaseMaterialHead, PurchaseMaterialHeadService> {
    private static final Logger log = LoggerFactory.getLogger(PurchaseMaterialHeadController.class);
    @Autowired
    private PurchaseMaterialHeadService purchaseMaterialHeadService;
    @Autowired
    private PurchaseMaterialItemService purchaseMaterialItemService;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    public Result<?> queryPageList(PurchaseMaterialHead purchaseMaterialHead, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)purchaseMaterialHead), (Map)req.getParameterMap());
        queryWrapper.lambda().eq(PurchaseMaterialHead::getBlocDel, (Object)"0");
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.purchaseMaterialHeadService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @AutoLog(value="\u7269\u6599\u4e3b\u6570\u636e-\u6dfb\u52a0")
    @ApiOperation(value="\u6dfb\u52a0", notes="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    public Result<?> add(@RequestBody PurchaseMaterialHeadVO purchaseMaterialHeadPage) {
        Assert.hasText((String)purchaseMaterialHeadPage.getTemplateNumber(), (String)I18nUtil.translate((String)"i18n_alert_empty_notTempNum", (String)"\u6a21\u677f\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a"));
        Assert.notNull((Object)purchaseMaterialHeadPage.getTemplateVersion(), (String)I18nUtil.translate((String)"i18n_alert_empty_notTempVersion", (String)"\u6a21\u677f\u7248\u672c\u4e0d\u80fd\u4e3a\u7a7a"));
        PurchaseMaterialHeadVO purchaseMaterialHead = new PurchaseMaterialHeadVO();
        BeanUtils.copyProperties((Object)((Object)purchaseMaterialHeadPage), (Object)((Object)purchaseMaterialHead));
        String elsAccount = this.getTenantId();
        purchaseMaterialHead.setElsAccount(elsAccount);
        purchaseMaterialHead.setBlocDel("0");
        this.purchaseMaterialHeadService.saveMain(purchaseMaterialHead, purchaseMaterialHeadPage.getPurchaseMaterialItemList());
        return Result.ok((Object)((Object)purchaseMaterialHead));
    }

    @AutoLog(value="\u7269\u6599\u4e3b\u6570\u636e-\u7f16\u8f91")
    @ApiOperation(value="\u7f16\u8f91", notes="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    public Result<?> edit(@RequestBody PurchaseMaterialHeadVO purchaseMaterialHeadPage) {
        PurchaseMaterialHead purchaseMaterialHead = new PurchaseMaterialHead();
        BeanUtils.copyProperties((Object)((Object)purchaseMaterialHeadPage), (Object)((Object)purchaseMaterialHead));
        this.purchaseMaterialHeadService.updateMain(purchaseMaterialHead, purchaseMaterialHeadPage.getPurchaseMaterialItemList());
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u7269\u6599\u4e3b\u6570\u636e-\u6839\u636e\u5de5\u5382\u67e5\u8be2\u7269\u6599\u884c")
    @ApiOperation(value="\u6839\u636e\u5de5\u5382\u67e5\u8be2\u7269\u6599\u884c", notes="\u6839\u636e\u5de5\u5382\u67e5\u8be2\u7269\u6599\u884c")
    @GetMapping(value={"/queryMaterialItemByFactory"})
    public Result<?> queryMaterialItemByFactory(@RequestParam(name="materialNumber") String materialNumber, @RequestParam(name="factory") String factory) {
        PurchaseMaterialHead purchaseMaterialHead = new PurchaseMaterialHead();
        purchaseMaterialHead.setMaterialNumber(materialNumber);
        purchaseMaterialHead.setFactory(factory);
        PurchaseMaterialHead resultMaterialHead = this.purchaseMaterialHeadService.queryMaterialItemByFactory(purchaseMaterialHead);
        return Result.ok((Object)((Object)resultMaterialHead));
    }

    @AutoLog(value="\u7269\u6599\u4e3b\u6570\u636e-\u901a\u8fc7id\u5220\u9664")
    @ApiOperation(value="\u901a\u8fc7id\u5220\u9664", notes="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    public Result<?> delete(@RequestParam(name="id") String id) {
        this.purchaseMaterialHeadService.delHead(id);
        return this.commonSuccessResult(4);
    }

    @AutoLog(value="\u7269\u6599\u4e3b\u6570\u636e-\u6279\u91cf\u5220\u9664")
    @ApiOperation(value="\u6279\u91cf\u5220\u9664", notes="\u6279\u91cf\u5220\u9664")
    @GetMapping(value={"/deleteBatch"})
    public Result<?> deleteBatch(@RequestParam(name="ids") String ids) {
        this.purchaseMaterialHeadService.delBatchMain(Arrays.asList(ids.split(",")));
        return this.commonSuccessResult(4);
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        PurchaseMaterialHead purchaseMaterialHead = (PurchaseMaterialHead)((Object)this.purchaseMaterialHeadService.getById((Serializable)((Object)id)));
        PurchaseMaterialHeadVO purchaseMaterialHeadVO = new PurchaseMaterialHeadVO();
        BeanUtils.copyProperties((Object)((Object)purchaseMaterialHead), (Object)((Object)purchaseMaterialHeadVO));
        List<PurchaseMaterialItem> purchaseMaterialItemList = this.purchaseMaterialItemService.selectByMainId(id);
        purchaseMaterialHeadVO.setPurchaseMaterialItemList(purchaseMaterialItemList);
        return Result.ok((Object)((Object)purchaseMaterialHeadVO));
    }

    @ApiOperation(value="\u901a\u8fc7\u7269\u6599\u4e3b\u6570\u636e\u5934id\u67e5\u8be2\u7269\u6599\u4e3b\u6570\u636e\u884c", notes="\u901a\u8fc7\u7269\u6599\u4e3b\u6570\u636e\u5934id\u67e5\u8be2\u7269\u6599\u4e3b\u6570\u636e\u884c")
    @GetMapping(value={"/queryPurchaseMaterialItemByMainId"})
    public Result<?> queryPurchaseMaterialItemListByMainId(@RequestParam(name="id") String id) {
        List<PurchaseMaterialItem> purchaseMaterialItemList = this.purchaseMaterialItemService.selectByMainId(id);
        return Result.ok(purchaseMaterialItemList);
    }

    @GetMapping(value={"/exportXls"})
    public ModelAndView exportXls(HttpServletRequest request, @RequestParam Map<String, Object> object) {
        return super.exportXls(request, object, PurchaseMaterialHeadExportServiceImpl.class);
    }
}

