/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.material.excel;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.els.common.constant.CommonConstant;
import com.els.common.exception.ELSBootException;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.service.ExcelImportRpcService;
import com.els.modules.material.entity.PurchaseMaterialHead;
import com.els.modules.material.entity.PurchaseMaterialRelation;
import com.els.modules.material.entity.SaleMaterialRelation;
import com.els.modules.material.service.PurchaseMaterialHeadService;
import com.els.modules.material.service.PurchaseMaterialRelationService;
import com.els.modules.material.service.SaleMaterialRelationService;
import com.els.modules.supplier.api.dto.SupplierMasterDataDTO;
import com.els.modules.supplier.api.service.SupplierMasterDataRpcService;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="saleMaterialRelationImportImpl")
public class SaleMaterialRelationImportImpl
implements ExcelImportRpcService {
    @Autowired
    private PurchaseMaterialHeadService purchaseMaterialHeadService;
    @Autowired
    private SupplierMasterDataRpcService supplierMasterDataRpcService;
    @Autowired
    private PurchaseMaterialRelationService purchaseMaterialRelationService;
    @Autowired
    private SaleMaterialRelationService saleMaterialRelationService;

    public void importExcel(List<Map<String, Object>> dataList) {
        String elsAccount = TenantContext.getTenant();
        HashMap<String, SupplierMasterDataDTO> supplierMap = new HashMap<String, SupplierMasterDataDTO>();
        HashMap<String, PurchaseMaterialHead> materialMap = new HashMap<String, PurchaseMaterialHead>();
        ArrayList<Object> list = new ArrayList<Object>();
        ArrayList<String> toElsAccountList = new ArrayList<String>();
        ArrayList<String> materialNumberList = new ArrayList<String>();
        Date currentTime = new Date();
        for (Map<String, Object> data : dataList) {
            PurchaseMaterialHead materialHead;
            SupplierMasterDataDTO masterData;
            SaleMaterialRelation materialRelation = (SaleMaterialRelation)((Object)JSON.parseObject((String)JSON.toJSONString(data), SaleMaterialRelation.class));
            materialRelation.setId(IdWorker.getIdStr());
            materialRelation.setRelationId(IdWorker.getIdStr());
            materialRelation.setElsAccount(elsAccount);
            materialRelation.setCreateAccount(elsAccount);
            materialRelation.setDeleted(CommonConstant.DEL_FLAG_0);
            materialRelation.setCreateTime(currentTime);
            if (StrUtil.isBlank((CharSequence)materialRelation.getBlocked())) {
                materialRelation.setBlocked("0");
            }
            materialRelation.setCreateBy(SysUtil.getUserRealName());
            materialRelation.setUpdateTime(currentTime);
            materialRelation.setUpdateBy(materialRelation.getCreateBy());
            String toElsAccount = materialRelation.getToElsAccount();
            if (supplierMap.containsKey(toElsAccount)) {
                masterData = (SupplierMasterDataDTO)supplierMap.get(toElsAccount);
            } else {
                masterData = this.supplierMasterDataRpcService.getByAccount(toElsAccount, elsAccount);
                if (masterData == null) {
                    throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_nRCWWWeyWWWWWWxMKWVnIWFW_39c1d946", (String)("\u91c7\u8d2d\u65b9ELS\u8d26\u53f7\uff1a" + toElsAccount + " \u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u5bf9\u6570\u636e\uff01"), (String[])new String[]{toElsAccount}));
                }
                supplierMap.put(toElsAccount, masterData);
                toElsAccountList.add(toElsAccount);
            }
            materialRelation.setSupplierCode(masterData.getSupplierCode());
            materialRelation.setSupplierName(masterData.getSupplierName());
            String materialNumber = materialRelation.getMaterialNumber();
            if (materialMap.containsKey(materialNumber)) {
                materialHead = (PurchaseMaterialHead)((Object)materialMap.get(materialNumber));
            } else {
                TenantContext.setTenant((String)toElsAccount);
                List list2 = this.purchaseMaterialHeadService.list((Wrapper)new QueryWrapper().eq((Object)"material_number", (Object)materialNumber));
                if (list2.isEmpty()) {
                    throw new ELSBootException(I18nUtil.translate((String)"", (String)("\u91c7\u8d2d\u65b9\u7269\u6599\u7f16\u53f7\uff1a" + materialNumber + " \u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u5bf9\u6570\u636e\uff01")));
                }
                materialHead = (PurchaseMaterialHead)((Object)list2.get(0));
                materialMap.put(materialNumber, materialHead);
                materialNumberList.add(materialNumber);
            }
            materialRelation.setMaterialDesc(materialHead.getMaterialDesc());
            materialRelation.setMaterialSpec(materialHead.getMaterialSpec());
            list.add((Object)materialRelation);
        }
        TenantContext.setTenant((String)elsAccount);
        List materialRelationList = this.saleMaterialRelationService.list((Wrapper)((QueryWrapper)new QueryWrapper().in((Object)"to_els_account", toElsAccountList)).in((Object)"material_number", materialNumberList));
        HashMap<String, SaleMaterialRelation> relationMap = new HashMap<String, SaleMaterialRelation>();
        for (SaleMaterialRelation relation : materialRelationList) {
            relationMap.put(relation.getToElsAccount() + relation.getMaterialNumber(), relation);
        }
        ArrayList<PurchaseMaterialRelation> insertList = new ArrayList<PurchaseMaterialRelation>();
        ArrayList<SaleMaterialRelation> insertSaleList = new ArrayList<SaleMaterialRelation>();
        ArrayList<PurchaseMaterialRelation> updateList = new ArrayList<PurchaseMaterialRelation>();
        ArrayList<SaleMaterialRelation> updateSaleList = new ArrayList<SaleMaterialRelation>();
        for (SaleMaterialRelation saleMaterialRelation : list) {
            if (relationMap.containsKey(saleMaterialRelation.getToElsAccount() + saleMaterialRelation.getMaterialNumber())) {
                SaleMaterialRelation materialRelation = (SaleMaterialRelation)((Object)relationMap.get(saleMaterialRelation.getToElsAccount() + saleMaterialRelation.getMaterialNumber()));
                saleMaterialRelation.setId(materialRelation.getId());
                saleMaterialRelation.setRelationId(materialRelation.getRelationId());
                if (!elsAccount.equals(materialRelation.getCreateAccount())) {
                    throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_nRCWWWeyWWWWWWWWnRCSLAyWWWWWWjtHnRCIOcIWxqKmcIW_6e9f438d", (String)("\u91c7\u8d2d\u65b9ELS\u8d26\u53f7\uff1a" + materialRelation.getToElsAccount() + " , \u91c7\u8d2d\u65b9\u7269\u6599\u7f16\u53f7\uff1a" + materialRelation.getMaterialNumber() + " \u7684\u8bb0\u5f55\u91c7\u8d2d\u65b9\u5df2\u7ecf\u521b\u5efa\uff0c\u4e0d\u53ef\u518d\u6b21\u521b\u5efa\uff01"), (String[])new String[]{materialRelation.getToElsAccount(), materialRelation.getMaterialNumber()}));
                }
                updateSaleList.add(saleMaterialRelation);
                PurchaseMaterialRelation purcahseMaterialRelation = new PurchaseMaterialRelation();
                BeanUtils.copyProperties((Object)((Object)saleMaterialRelation), (Object)((Object)purcahseMaterialRelation));
                purcahseMaterialRelation.setId(saleMaterialRelation.getRelationId());
                purcahseMaterialRelation.setRelationId(saleMaterialRelation.getId());
                purcahseMaterialRelation.setElsAccount(saleMaterialRelation.getToElsAccount());
                purcahseMaterialRelation.setToElsAccount(saleMaterialRelation.getElsAccount());
                updateList.add(purcahseMaterialRelation);
                continue;
            }
            insertSaleList.add(saleMaterialRelation);
            PurchaseMaterialRelation purcahseMaterialRelation = new PurchaseMaterialRelation();
            BeanUtils.copyProperties((Object)((Object)saleMaterialRelation), (Object)((Object)purcahseMaterialRelation));
            purcahseMaterialRelation.setId(saleMaterialRelation.getRelationId());
            purcahseMaterialRelation.setRelationId(saleMaterialRelation.getId());
            purcahseMaterialRelation.setElsAccount(saleMaterialRelation.getToElsAccount());
            purcahseMaterialRelation.setToElsAccount(saleMaterialRelation.getElsAccount());
            insertList.add(purcahseMaterialRelation);
        }
        if (!insertList.isEmpty()) {
            this.purchaseMaterialRelationService.saveBatch(insertList, 200);
            this.saleMaterialRelationService.saveBatch(insertSaleList, 200);
        }
        if (!updateList.isEmpty()) {
            this.purchaseMaterialRelationService.updateBatchById(updateList, 200);
            this.saleMaterialRelationService.updateBatchById(updateSaleList, 200);
        }
    }
}

