/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.material.service.impl;

import cn.hutool.core.collection.CollUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.util.I18nUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.material.entity.PurchaseMaterialCode;
import com.els.modules.material.enumerate.MaterialCateStatusEnum;
import com.els.modules.material.mapper.PurchaseMaterialCodeMapper;
import com.els.modules.material.service.PurchaseMaterialCodeService;
import com.els.modules.material.vo.TreeMaterialCodeNode;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class PurchaseMaterialCodeServiceImpl
extends ServiceImpl<PurchaseMaterialCodeMapper, PurchaseMaterialCode>
implements PurchaseMaterialCodeService {
    @Autowired
    private PurchaseMaterialCodeMapper purchaseMaterialCodeMapper;

    @Override
    public void savePurchaseMaterialCode(PurchaseMaterialCode purchaseMaterialCode) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"cate_code", (Object)purchaseMaterialCode.getCateCode());
        List code = ((PurchaseMaterialCodeMapper)this.baseMapper).selectList((Wrapper)queryWrapper);
        if (!CollectionUtils.isEmpty((Collection)code) && code.size() >= 1) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_MKdejSLzAAoWWWWWW_cb8a8ba", (String)("\u5b58\u5728\u76f8\u540c\u7684\u7269\u6599\u5206\u7c7b\u7f16\u7801\uff1a" + purchaseMaterialCode.getCateCode()), (String[])new String[]{purchaseMaterialCode.getCateCode()}));
        }
        if (null == purchaseMaterialCode.getUpCateCode()) {
            purchaseMaterialCode.setUpCateCode("");
        }
        purchaseMaterialCode.setCateStatus(MaterialCateStatusEnum.NORMAL.getValue());
        ((PurchaseMaterialCodeMapper)this.baseMapper).insert((Object)purchaseMaterialCode);
    }

    @Override
    public void updatePurchaseMaterialCode(PurchaseMaterialCode purchaseMaterialCode) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"cate_code", (Object)purchaseMaterialCode.getCateCode());
        List code = ((PurchaseMaterialCodeMapper)this.baseMapper).selectList((Wrapper)queryWrapper);
        if (!CollectionUtils.isEmpty((Collection)code) && code.size() > 1 || !CollectionUtils.isEmpty((Collection)code) && !((PurchaseMaterialCode)((Object)code.get(0))).getId().equals(purchaseMaterialCode.getId())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_MKdejSLzAAoWWWWWW_cb8a8ba", (String)("\u5b58\u5728\u76f8\u540c\u7684\u7269\u6599\u5206\u7c7b\u7f16\u7801\uff1a" + purchaseMaterialCode.getCateCode()), (String[])new String[]{purchaseMaterialCode.getCateCode()}));
        }
        if (null == purchaseMaterialCode.getUpCateCode()) {
            purchaseMaterialCode.setUpCateCode("");
        }
        ((PurchaseMaterialCodeMapper)this.baseMapper).updateById((Object)purchaseMaterialCode);
    }

    @Override
    public void frozenPurchaseMaterialCode(String id) {
        PurchaseMaterialCode materialCode = new PurchaseMaterialCode();
        materialCode.setId(id);
        materialCode.setCateStatus(MaterialCateStatusEnum.FROZEN.getValue());
        this.purchaseMaterialCodeMapper.updateById((Object)materialCode);
    }

    @Override
    public void thawPurchaseMaterialCode(String id) {
        PurchaseMaterialCode materialCode = new PurchaseMaterialCode();
        materialCode.setId(id);
        materialCode.setCateStatus(MaterialCateStatusEnum.NORMAL.getValue());
        this.purchaseMaterialCodeMapper.updateById((Object)materialCode);
    }

    @Override
    public void cancelPurchaseMaterialCode(String id) {
        PurchaseMaterialCode materialCode = new PurchaseMaterialCode();
        materialCode.setId(id);
        materialCode.setCateStatus(MaterialCateStatusEnum.CANCEL.getValue());
        this.purchaseMaterialCodeMapper.updateById((Object)materialCode);
    }

    @Override
    public void delPurchaseMaterialCode(String id) {
        ((PurchaseMaterialCodeMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void delBatchPurchaseMaterialCode(List<String> idList) {
        ((PurchaseMaterialCodeMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    public List<TreeMaterialCodeNode> getMaterialCodeTree(QueryWrapper<PurchaseMaterialCode> queryWrapper) {
        queryWrapper.lambda().eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant());
        List<TreeMaterialCodeNode> list = ((PurchaseMaterialCodeMapper)this.getBaseMapper()).selectByElsAccount((Wrapper)queryWrapper);
        for (TreeMaterialCodeNode node2 : list) {
            node2.setKey(node2.getCateCode());
            node2.setValue(node2.getCateLevelCode());
        }
        List<TreeMaterialCodeNode> rootNodeList = list.stream().filter(o -> StringUtils.isBlank((CharSequence)o.getUpCateCode())).collect(Collectors.toList());
        Map<String, List<TreeMaterialCodeNode>> groupMap = list.parallelStream().filter(node -> StringUtils.isNotBlank((CharSequence)node.getUpCateCode())).collect(Collectors.groupingBy(TreeMaterialCodeNode::getUpCateCode));
        for (TreeMaterialCodeNode node3 : rootNodeList) {
            this.forEach(groupMap, node3);
        }
        return rootNodeList;
    }

    @Override
    public List<PurchaseMaterialCode> listByCodeList(List<String> parentCodeList, String elsAccount) {
        if (CollUtil.isEmpty(parentCodeList)) {
            return Lists.newArrayList();
        }
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.select(new SFunction[]{BaseEntity::getId, PurchaseMaterialCode::getCateCode, PurchaseMaterialCode::getCateName});
        ((LambdaQueryWrapper)wrapper.eq(BaseEntity::getElsAccount, (Object)elsAccount)).in(PurchaseMaterialCode::getCateCode, parentCodeList);
        return ((PurchaseMaterialCodeMapper)this.baseMapper).selectList((Wrapper)wrapper);
    }

    private void forEach(Map<String, List<TreeMaterialCodeNode>> collect, TreeMaterialCodeNode treeNode) {
        List<TreeMaterialCodeNode> treeNodelist = collect.get(treeNode.getKey());
        if (collect.get(treeNode.getKey()) != null) {
            treeNode.setChildren(treeNodelist);
            treeNode.setHasChildren(true);
            treeNode.getChildren().forEach(t -> this.forEach(collect, (TreeMaterialCodeNode)t));
        }
    }
}

