/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.price.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.common.util.I18nUtil;
import com.els.common.vo.CountVO;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.DictDTO;
import com.els.modules.price.entity.PurchaseInformationRecords;
import com.els.modules.price.enumerate.PriceStatusEnum;
import com.els.modules.price.excel.PurchaseInformationRecordsExportServiceImpl;
import com.els.modules.price.service.PurchaseInformationRecordsService;
import com.els.modules.price.vo.HisQuotePriceTrendVO;
import com.els.modules.price.vo.PurchaseInformationRecordsVO;
import com.els.rpc.service.InvokeBaseRpcService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@Api(tags={"\u4ef7\u683c\u4e3b\u6570\u636e"})
@RestController
@RequestMapping(value={"/price/purchaseInformationRecords"})
public class PurchaseInformationRecordsController
extends BaseController<PurchaseInformationRecords, PurchaseInformationRecordsService> {
    @Autowired
    private PurchaseInformationRecordsService purchaseInformationRecordsService;
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    public Result<?> queryPageList(PurchaseInformationRecords purchaseInformationRecords, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)purchaseInformationRecords), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.purchaseInformationRecordsService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @AutoLog(value="\u4ef7\u683c\u4e3b\u6570\u636e-\u5206\u9875\u67e5\u8be2\u6709\u6548\u671f\u5185\u7684\u4ef7\u683c")
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u6709\u6548\u671f\u5185\u7684\u4ef7\u683c", notes="\u5206\u9875\u67e5\u8be2\u6709\u6548\u671f\u5185\u7684\u4ef7\u683c")
    @GetMapping(value={"/avliabledPrice"})
    public Result<?> queryPageAvliabledPriceList(PurchaseInformationRecords purchaseInformationRecords, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"purchase_org", (Object)purchaseInformationRecords.getPurchaseOrg());
        queryWrapper.eq((Object)"to_els_account", (Object)purchaseInformationRecords.getToElsAccount());
        queryWrapper.eq((Object)"material_number", (Object)purchaseInformationRecords.getMaterialNumber());
        queryWrapper.eq((Object)"factory", (Object)purchaseInformationRecords.getFactory());
        ((QueryWrapper)((QueryWrapper)queryWrapper.eq((Object)"record_status", (Object)PriceStatusEnum.NORMAL.getValue())).or()).eq((Object)"record_status", (Object)PriceStatusEnum.EFFECTIVE.getValue());
        queryWrapper.le((Object)"effective_date", (Object)new Date());
        queryWrapper.ge((Object)"expiry_date", (Object)new Date());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.purchaseInformationRecordsService.page((IPage)page, (Wrapper)queryWrapper);
        if (pageList.getRecords() == null || pageList.getRecords().size() == 0) {
            QueryWrapper queryWrapper2 = new QueryWrapper();
            queryWrapper2.eq((Object)"purchase_org", (Object)purchaseInformationRecords.getPurchaseOrg());
            queryWrapper2.eq((Object)"to_els_account", (Object)purchaseInformationRecords.getToElsAccount());
            queryWrapper2.eq((Object)"material_number", (Object)purchaseInformationRecords.getMaterialNumber());
            queryWrapper2.eq((Object)"factory", (Object)"");
            ((QueryWrapper)((QueryWrapper)queryWrapper2.eq((Object)"record_status", (Object)PriceStatusEnum.NORMAL.getValue())).or()).eq((Object)"record_status", (Object)PriceStatusEnum.EFFECTIVE.getValue());
            queryWrapper2.le((Object)"effective_date", (Object)new Date());
            queryWrapper2.ge((Object)"expiry_date", (Object)new Date());
            Page page2 = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
            IPage pageList2 = this.purchaseInformationRecordsService.page((IPage)page2, (Wrapper)queryWrapper2);
            return Result.ok((Object)pageList2);
        }
        return Result.ok((Object)pageList);
    }

    @AutoLog(value="\u4ef7\u683c\u4e3b\u6570\u636e-\u6dfb\u52a0")
    @ApiOperation(value="\u6dfb\u52a0", notes="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    public Result<?> add(@RequestBody PurchaseInformationRecords purchaseInformationRecords) {
        this.purchaseInformationRecordsService.savePurchaseInformationRecords(purchaseInformationRecords);
        return Result.ok((Object)((Object)purchaseInformationRecords));
    }

    @AutoLog(value="\u4ef7\u683c\u4e3b\u6570\u636e-\u7f16\u8f91")
    @ApiOperation(value="\u7f16\u8f91", notes="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    public Result<?> edit(@RequestBody PurchaseInformationRecords purchaseInformationRecords) {
        this.purchaseInformationRecordsService.updatePurchaseInformationRecords(purchaseInformationRecords);
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u4ef7\u683c\u4e3b\u6570\u636e-\u901a\u8fc7id\u51bb\u7ed3")
    @ApiOperation(value="\u901a\u8fc7id\u51bb\u7ed3", notes="\u901a\u8fc7id\u51bb\u7ed3")
    @GetMapping(value={"/frozen"})
    public Result<?> frozen(@RequestParam(name="id") String id) {
        this.purchaseInformationRecordsService.frozenPurchaseInformationRecords(id);
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u4ef7\u683c\u4e3b\u6570\u636e-\u901a\u8fc7id\u89e3\u51bb")
    @ApiOperation(value="\u901a\u8fc7id\u89e3\u51bb", notes="\u901a\u8fc7id\u89e3\u51bb")
    @GetMapping(value={"/thaw"})
    public Result<?> thaw(@RequestParam(name="id") String id) {
        this.purchaseInformationRecordsService.thawPurchaseInformationRecords(id);
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u4ef7\u683c\u4e3b\u6570\u636e-\u901a\u8fc7id\u4f5c\u5e9f")
    @ApiOperation(value="\u901a\u8fc7id\u4f5c\u5e9f", notes="\u901a\u8fc7id\u4f5c\u5e9f")
    @GetMapping(value={"/cancel"})
    public Result<?> cancel(@RequestParam(name="id") String id) {
        this.purchaseInformationRecordsService.cancelPurchaseInformationRecords(id);
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u4ef7\u683c\u4e3b\u6570\u636e-\u901a\u8fc7id\u5220\u9664")
    @ApiOperation(value="\u901a\u8fc7id\u5220\u9664", notes="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    public Result<?> delete(@RequestParam(name="id") String id) {
        this.purchaseInformationRecordsService.delPurchaseInformationRecords(id);
        return this.commonSuccessResult(4);
    }

    @AutoLog(value="\u4ef7\u683c\u4e3b\u6570\u636e-\u6279\u91cf\u5220\u9664")
    @ApiOperation(value="\u6279\u91cf\u5220\u9664", notes="\u6279\u91cf\u5220\u9664")
    @GetMapping(value={"/deleteBatch"})
    public Result<?> deleteBatch(@RequestParam(name="ids") String ids) {
        List<String> idList = Arrays.asList(ids.split(","));
        this.purchaseInformationRecordsService.delBatchPurchaseInformationRecords(idList);
        return this.commonSuccessResult(4);
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        PurchaseInformationRecords purchaseInformationRecords = (PurchaseInformationRecords)((Object)this.purchaseInformationRecordsService.getById((Serializable)((Object)id)));
        return Result.ok((Object)((Object)purchaseInformationRecords));
    }

    @AutoLog(value="\u4ef7\u683c\u4e3b\u6570\u636e-\u6839\u636e\u7269\u6599\u7f16\u7801\u67e5\u8be2\u5386\u53f2\u4ef7\u683c")
    @ApiOperation(value="\u6839\u636e\u7269\u6599\u7f16\u7801\u67e5\u8be2\u5386\u53f2\u4ef7\u683c", notes="\u6839\u636e\u7269\u6599\u7f16\u7801\u67e5\u8be2\u5386\u53f2\u4ef7\u683c")
    @GetMapping(value={"/queryPriceByMaterial"})
    public Result<?> queryPriceByMaterial(@RequestParam(name="materialNumber") String materialNumber) {
        HisQuotePriceTrendVO trendVO = this.purchaseInformationRecordsService.findTrendByMaterial(materialNumber);
        return Result.ok((Object)trendVO);
    }

    @AutoLog(value="\u4ef7\u683c\u4e3b\u6570\u636e-\u521b\u5efa\u8d27\u6e90\u6e05\u5355")
    @ApiOperation(value="\u521b\u5efa\u8d27\u6e90\u6e05\u5355", notes="\u521b\u5efa\u8d27\u6e90\u6e05\u5355")
    @PostMapping(value={"/createMaterialSource"})
    public Result<?> createMaterialSource(@RequestBody PurchaseInformationRecordsVO recordsVO) {
        String sourceNumber = this.purchaseInformationRecordsService.createMaterialSource(recordsVO.getPurchaseInformationRecordsList());
        return Result.ok((String)("\u521b\u5efa\u6210\u529f\uff0c\u8d27\u6e90\u6e05\u5355\u5355\u53f7\u4e3a\uff1a" + sourceNumber));
    }

    @ApiOperation(value="\u901a\u8fc7\u5217\u8868\u9875\u9875\u7b7e\u6570\u91cf\u67e5\u8be2", notes="\u5217\u8868\u9875\u9875\u7b7e\u6570\u91cf\u67e5\u8be2")
    @GetMapping(value={"/counts"})
    public Result<?> queryTabsCount(PurchaseInformationRecords purchaseInformationRecords, HttpServletRequest req) {
        ArrayList<CountVO> result = new ArrayList<CountVO>();
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)purchaseInformationRecords), (Map)req.getParameterMap());
        queryWrapper.select(new String[]{"record_status", "count(0) as participateQuantity"});
        queryWrapper.groupBy((Object)"record_status");
        List list = ((PurchaseInformationRecordsService)this.service).list((Wrapper)queryWrapper);
        Map<String, Integer> countMap = list.stream().collect(Collectors.toMap(PurchaseInformationRecords::getRecordStatus, PurchaseInformationRecords::getParticipateQuantity));
        Integer all = 0;
        for (Map.Entry<String, Integer> entry : countMap.entrySet()) {
            all = all + entry.getValue();
        }
        result.add(new CountVO(I18nUtil.translate((String)"i18n_title_all", (String)"\u5168\u90e8"), "recordStatus", null, all));
        List srmRectificationAppealStatus = this.invokeBaseRpcService.queryDictItemsByCode("priceStatus", TenantContext.getTenant());
        for (DictDTO status : srmRectificationAppealStatus) {
            Integer total = countMap.get(status.getValue()) == null ? Integer.valueOf(0) : countMap.get(status.getValue());
            result.add(new CountVO(I18nUtil.translate((String)status.getTextI18nKey(), (String)status.getText()), "recordStatus", status.getValue(), total));
        }
        return Result.ok(result);
    }

    @GetMapping(value={"/exportXls"})
    public ModelAndView exportXls(HttpServletRequest request, @RequestParam Map<String, Object> object) {
        return super.exportXls(request, object, PurchaseInformationRecordsExportServiceImpl.class);
    }
}

