/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.price.job;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.lang.UUID;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.els.common.api.service.JobRpcService;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.util.I18nUtil;
import com.els.common.util.RedisUtil;
import com.els.common.util.SpringContextUtils;
import com.els.config.mybatis.TenantContext;
import com.els.modules.price.entity.PurchaseInformationRecords;
import com.els.modules.price.enumerate.PriceStatusEnum;
import com.els.modules.price.service.PurchaseInformationRecordsService;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="srmPriceStatusChangeJob")
public class SrmPriceStatusChangeJob
implements JobRpcService {
    private static final Logger logger = LoggerFactory.getLogger(SrmPriceStatusChangeJob.class);
    private final String LOCK_PREFIX = "purchaseInformationRecords_schedule_";
    private final long EXPIRE_TIME = 50000L;
    @Autowired
    private RedisUtil redisUtil;

    public void execute(String parameter) {
        block9: {
            JSONObject paramObj = JSONObject.parseObject((String)parameter);
            String tenantId = paramObj.getString("tenantId");
            if (StrUtil.isBlank((CharSequence)tenantId)) {
                tenantId = "100000";
            }
            TenantContext.setTenant((String)tenantId);
            String lockKey = "purchaseInformationRecords_schedule_" + tenantId;
            String requestId = UUID.fastUUID().toString();
            try {
                if (this.redisUtil.tryGetDistributedLock(lockKey, requestId, 50000L)) {
                    logger.info("SrmPriceStatusChangeJob start");
                    LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
                    queryWrapper.select(new SFunction[]{PurchaseInformationRecords::getEffectiveDate, PurchaseInformationRecords::getExpiryDate, BaseEntity::getId});
                    queryWrapper.eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant());
                    queryWrapper.in(PurchaseInformationRecords::getRecordStatus, (Collection)Lists.newArrayList((Object[])new String[]{PriceStatusEnum.NORMAL.getValue(), PriceStatusEnum.EFFECTIVE.getValue(), PriceStatusEnum.INVALID.getValue()}));
                    queryWrapper.in(PurchaseInformationRecords::getAuditStatus, (Collection)Lists.newArrayList((Object[])new String[]{AuditStatusEnum.NO_AUDIT_REQUIRED.getValue(), AuditStatusEnum.AUDIT_FINISH.getValue()}));
                    DateTime date = DateUtil.date();
                    queryWrapper.and(arg_0 -> SrmPriceStatusChangeJob.lambda$execute$0((Date)date, arg_0));
                    PurchaseInformationRecordsService purchaseInformationRecordsService = (PurchaseInformationRecordsService)SpringContextUtils.getBean(PurchaseInformationRecordsService.class);
                    List recordsList = purchaseInformationRecordsService.list((Wrapper)queryWrapper);
                    for (PurchaseInformationRecords item : recordsList) {
                        if (null != item.getEffectiveDate() && item.getEffectiveDate().before((Date)date)) {
                            item.setRecordStatus(PriceStatusEnum.EFFECTIVE.getValue());
                        }
                        if (null == item.getExpiryDate() || !item.getExpiryDate().before((Date)date)) continue;
                        item.setRecordStatus(PriceStatusEnum.INVALID.getValue());
                    }
                    logger.info("SrmPriceStatusChangeJob end");
                    purchaseInformationRecordsService.updateBatchById(recordsList);
                    break block9;
                }
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_umdWFzEHrLSiKRcWVxPVBRc_268e90d8", (String)" \u4ef7\u683c\u4e3b\u6570\u636e\u72b6\u6001\u66f4\u6539\u4efb\u52a1\u6b63\u5728\u6267\u884c\uff0c\u8bf7\u4e0d\u8981\u91cd\u590d\u6267\u884c"));
            }
            catch (Exception e) {
                logger.info(Thread.currentThread().getName() + "\u4ef7\u683c\u4e3b\u6570\u636e\u72b6\u6001\u66f4\u6539\u4efb\u52a1\u51fa\u73b0\u5f02\u5e38:", (Throwable)e);
                throw e;
            }
            finally {
                this.redisUtil.releaseDistributedLock(lockKey, requestId);
            }
        }
    }

    private static /* synthetic */ void lambda$execute$0(Date date, LambdaQueryWrapper a) {
        LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)a.lt(PurchaseInformationRecords::getExpiryDate, (Object)date)).or()).lt(PurchaseInformationRecords::getEffectiveDate, (Object)date);
    }
}

