/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.material.job;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.els.common.api.service.JobRpcService;
import com.els.common.util.DateUtils;
import com.els.common.util.SpringContextUtils;
import com.els.config.mybatis.TenantContext;
import com.els.modules.material.api.enumerate.MaterialSourceStatusEnum;
import com.els.modules.material.entity.PurchaseMaterialSource;
import com.els.modules.material.service.PurchaseMaterialSourceService;
import com.els.modules.material.service.impl.PurchaseMaterialSourceServiceImpl;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class PurchaseMaterialSourceJob
implements JobRpcService {
    private static final Logger log = LoggerFactory.getLogger(PurchaseMaterialSourceJob.class);

    public void execute(String parameter) {
        log.info(" \u8d27\u6e90\u6e05\u5355\u5b9a\u65f6\u4efb\u52a1 PurchaseMaterialSourceJob \u5f00\u59cb\u6267\u884c\u65f6\u95f4:" + DateUtils.getTimestamp() + parameter);
        if (StrUtil.isEmpty((CharSequence)parameter)) {
            log.error("parameter must not be null.");
            return;
        }
        JSONObject paramObj = JSONObject.parseObject((String)parameter);
        String id = paramObj.getString("id");
        if (StrUtil.isEmpty((CharSequence)id)) {
            log.error("parameter must contain id.");
            return;
        }
        String tenantId = paramObj.getString("tenantId");
        if (StrUtil.isBlank((CharSequence)tenantId)) {
            tenantId = "100000";
        }
        TenantContext.setTenant((String)tenantId);
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.and(a -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)a.lt(PurchaseMaterialSource::getEffectiveDate, (Object)new Date());
        });
        queryWrapper.eq(PurchaseMaterialSource::getStatus, (Object)MaterialSourceStatusEnum.INVALID.getValue());
        PurchaseMaterialSourceService purchaseMaterialSourceService = (PurchaseMaterialSourceService)SpringContextUtils.getBean(PurchaseMaterialSourceServiceImpl.class);
        List purchaseMaterialSourceList = purchaseMaterialSourceService.list((Wrapper)queryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)purchaseMaterialSourceList)) {
            purchaseMaterialSourceList.forEach(purchaseMaterialSource -> purchaseMaterialSource.setStatus(MaterialSourceStatusEnum.NORMAL.getValue()));
            purchaseMaterialSourceService.updateBatchById(purchaseMaterialSourceList);
        }
        log.info(" \u8d27\u6e90\u6e05\u5355\u5b9a\u65f6\u4efb\u52a1 PurchaseMaterialSourceJob \u6267\u884c\u5b8c\u6210\u65f6\u95f4:" + DateUtils.getTimestamp() + parameter);
    }
}

