/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.industryinfo.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.SysUtil;
import com.els.modules.industryinfo.dto.GoodsHeadQueryDTO;
import com.els.modules.industryinfo.entity.GoodsFavorite;
import com.els.modules.industryinfo.entity.GoodsHead;
import com.els.modules.industryinfo.entity.GoodsLiveItem;
import com.els.modules.industryinfo.entity.GoodsLiveList;
import com.els.modules.industryinfo.entity.GoodsTopmanItem;
import com.els.modules.industryinfo.entity.GoodsVideoItem;
import com.els.modules.industryinfo.entity.GoodsVideoList;
import com.els.modules.industryinfo.mapper.GoodsFavoriteMapper;
import com.els.modules.industryinfo.mapper.GoodsHeadMapper;
import com.els.modules.industryinfo.mapper.GoodsLiveItemMapper;
import com.els.modules.industryinfo.mapper.GoodsLiveListMapper;
import com.els.modules.industryinfo.mapper.GoodsTopmanItemMapper;
import com.els.modules.industryinfo.mapper.GoodsVideoItemMapper;
import com.els.modules.industryinfo.mapper.GoodsVideoListMapper;
import com.els.modules.industryinfo.service.GoodsHeadService;
import com.els.modules.industryinfo.vo.GoodsHeadVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class GoodsHeadServiceImpl
extends BaseServiceImpl<GoodsHeadMapper, GoodsHead>
implements GoodsHeadService {
    @Resource
    private GoodsHeadMapper goodsHeadMapper;
    @Resource
    private GoodsTopmanItemMapper goodsTopmanItemMapper;
    @Resource
    private GoodsVideoItemMapper goodsVideoItemMapper;
    @Resource
    private GoodsVideoListMapper goodsVideoListMapper;
    @Resource
    private GoodsLiveItemMapper goodsLiveItemMapper;
    @Resource
    private GoodsLiveListMapper goodsLiveListMapper;
    @Resource
    private GoodsFavoriteMapper goodsFavoriteMapper;

    @Override
    public IPage<GoodsHead> queryPage(Page<GoodsHead> page, QueryWrapper<GoodsHead> queryWrapper, GoodsHeadQueryDTO queryDTO) {
        this.criteriaQuery(queryWrapper, queryDTO);
        Page goodsHeadPage = (Page)this.page((IPage)page, (Wrapper)queryWrapper);
        this.replenish(goodsHeadPage.getRecords());
        return goodsHeadPage;
    }

    @Override
    public IPage<GoodsHead> queryFavoritePage(Page<GoodsHead> page, QueryWrapper<GoodsHead> queryWrapper, GoodsHeadQueryDTO queryDTO) {
        LoginUser loginUser = SysUtil.getLoginUser();
        String elsAccount = loginUser.getElsAccount();
        List<GoodsFavorite> goodsFavoriteList = this.goodsFavoriteMapper.selectByElsAccount(elsAccount);
        if (!CollectionUtils.isEmpty(goodsFavoriteList)) {
            List goodsIds = goodsFavoriteList.stream().map(GoodsFavorite::getGoodsId).collect(Collectors.toList());
            queryWrapper.lambda().in(GoodsHead::getId, goodsIds);
            this.criteriaQuery(queryWrapper, queryDTO);
        } else {
            queryWrapper.lambda().eq(GoodsHead::getId, null);
        }
        Page goodsHeadPage = (Page)this.page((IPage)page, (Wrapper)queryWrapper);
        this.replenish(goodsHeadPage.getRecords());
        return goodsHeadPage;
    }

    private void replenish(List<GoodsHead> records) {
        if (!CollectionUtils.isEmpty(records)) {
            for (GoodsHead goodsHead : records) {
                LoginUser loginUser = SysUtil.getLoginUser();
                String elsAccount = loginUser.getElsAccount();
                GoodsFavorite goodsFavorite = this.goodsFavoriteMapper.selectGoodsFavorite(goodsHead.getId(), elsAccount);
                goodsHead.setFavoriteGoods(false);
                if (goodsFavorite == null) continue;
                goodsHead.setFavoriteGoods(true);
            }
        }
    }

    @Override
    public QueryWrapper<GoodsHead> criteriaQuery(QueryWrapper<GoodsHead> queryWrapper, GoodsHeadQueryDTO queryDTO) {
        String timeSelect;
        Boolean goodsVideo;
        Boolean goodsLive;
        String goodsBrowsesNum;
        String salesNum;
        String topman;
        String goodsRate;
        String goodsPrice = queryDTO.getGoodsPrice();
        if (StringUtils.isNotBlank((CharSequence)goodsPrice)) {
            String price;
            String[] prices;
            if (goodsPrice.contains("-")) {
                prices = goodsPrice.split("-");
                queryWrapper.lambda().between(GoodsHead::getPrice, (Object)new BigDecimal(prices[0]), (Object)new BigDecimal(prices[1]));
            }
            if (goodsPrice.contains("<")) {
                prices = goodsPrice.split("<");
                price = goodsPrice.substring(goodsPrice.indexOf("<") + 1);
                queryWrapper.lambda().lt(GoodsHead::getPrice, (Object)new BigDecimal(prices[1]));
            }
            if (goodsPrice.contains(">")) {
                prices = goodsPrice.split(">");
                price = goodsPrice.substring(goodsPrice.indexOf(">") + 1);
                queryWrapper.lambda().gt(GoodsHead::getPrice, (Object)new BigDecimal(prices[1]));
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(goodsRate = queryDTO.getGoodsCommissionRate()))) {
            String[] strings;
            if (goodsRate.contains("-")) {
                strings = goodsRate.split("-");
                String split = strings[0].contains("%") ? strings[0].split("%")[0] : strings[0];
                String split1 = strings[1].split("%")[0];
                queryWrapper.lambda().between(GoodsHead::getCommissionRate, (Object)split, (Object)split1);
            }
            if (goodsRate.contains(">=")) {
                strings = goodsRate.split(">=");
                String split1 = strings[1].split("%")[0];
                queryWrapper.lambda().ge(GoodsHead::getCommissionRate, (Object)split1);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(topman = queryDTO.getGoodsTopmanNum()))) {
            String[] strings;
            if (topman.contains("-")) {
                strings = topman.split("-");
                queryWrapper.lambda().between(GoodsHead::getTopmanNum, (Object)new BigDecimal(strings[0]), (Object)new BigDecimal(strings[1]));
            } else if (topman.contains(">")) {
                strings = topman.split(">");
                String string = topman.substring(topman.indexOf(">") + 1);
                queryWrapper.lambda().gt(GoodsHead::getTopmanNum, (Object)new BigDecimal(strings[1]));
            } else {
                queryWrapper.lambda().eq(GoodsHead::getTopmanNum, (Object)topman);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(salesNum = queryDTO.getGoodsSalesNum()))) {
            String[] strings;
            if (salesNum.contains("-")) {
                strings = salesNum.split("-");
                queryWrapper.lambda().between(GoodsHead::getSalesNumTotal, (Object)new BigDecimal(strings[0]), (Object)new BigDecimal(strings[1]));
            }
            if (salesNum.contains(">=")) {
                strings = salesNum.split(">=");
                queryWrapper.lambda().ge(GoodsHead::getSalesNumTotal, (Object)new BigDecimal(strings[1]));
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(goodsBrowsesNum = queryDTO.getGoodsBrowsesNum()))) {
            String[] strings;
            if (goodsBrowsesNum.contains("-")) {
                strings = goodsBrowsesNum.split("-");
                queryWrapper.lambda().between(GoodsHead::getBrowsesNum, (Object)new BigDecimal(strings[0]), (Object)new BigDecimal(strings[1]));
            }
            if (goodsBrowsesNum.contains(">=")) {
                strings = goodsBrowsesNum.split(">=");
                queryWrapper.lambda().ge(GoodsHead::getBrowsesNum, (Object)new BigDecimal(strings[1]));
            }
        }
        if ((goodsLive = queryDTO.getGoodsLive()) != null && goodsLive.booleanValue()) {
            queryWrapper.lambda().isNotNull(GoodsHead::getLivesNum);
        }
        if ((goodsVideo = queryDTO.getGoodsVideo()) != null && goodsVideo.booleanValue()) {
            queryWrapper.lambda().isNotNull(GoodsHead::getVideosNum);
        }
        if (StringUtils.isNotBlank((CharSequence)(timeSelect = queryDTO.getTimeSelect()))) {
            Calendar cal = Calendar.getInstance();
            cal.set(cal.get(1), cal.get(2), cal.get(5), 0, 0, 0);
            Date today = cal.getTime();
            cal.set(cal.get(1), cal.get(2), cal.get(5) - Integer.valueOf(timeSelect), 0, 0, 0);
            Date selectDay = cal.getTime();
            queryWrapper.lambda().between(BaseEntity::getUpdateTime, (Object)selectDay, (Object)today);
        }
        return queryWrapper;
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void saveMain(GoodsHead goodsHead, GoodsHeadVO headVO) {
        this.goodsHeadMapper.insert((Object)goodsHead);
        super.setHeadDefaultValue((BaseEntity)goodsHead);
        this.insertData(goodsHead, headVO);
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void updateMain(GoodsHead goodsHead, GoodsHeadVO headVO) {
        this.goodsHeadMapper.updateById((Object)goodsHead);
        this.goodsTopmanItemMapper.deleteByMainId(goodsHead.getId());
        this.goodsVideoItemMapper.deleteByMainId(goodsHead.getId());
        this.goodsLiveItemMapper.deleteByMainId(goodsHead.getId());
        this.insertData(goodsHead, headVO);
    }

    @Override
    public void favorite(String id) {
        GoodsHead goodsHead = (GoodsHead)((Object)((GoodsHeadMapper)this.baseMapper).selectById((Serializable)((Object)id)));
        GoodsFavorite goodsFavorite = new GoodsFavorite();
        LoginUser loginUser = SysUtil.getLoginUser();
        String elsAccount = loginUser.getElsAccount();
        goodsFavorite.setElsAccount(elsAccount);
        goodsFavorite.setGoodsId(goodsHead.getId());
        goodsFavorite.setPlatform(goodsHead.getPlatform());
        goodsFavorite.setFavoriteTime(new Date());
        this.goodsFavoriteMapper.insert((Object)goodsFavorite);
    }

    @Override
    public void cancelFavorite(String id) {
        LoginUser loginUser = SysUtil.getLoginUser();
        String elsAccount = loginUser.getElsAccount();
        this.goodsFavoriteMapper.deleteGoodsFavorite(id, elsAccount);
    }

    private void insertData(GoodsHead goodsHead, GoodsHeadVO headVO) {
        List<GoodsTopmanItem> goodsTopmanItemList = headVO.getGoodsTopmanItemList();
        List<GoodsVideoItem> goodsVideoItemList = headVO.getGoodsVideoItemList();
        List<GoodsVideoList> goodsVideoLists = headVO.getGoodsVideoLists();
        List<GoodsLiveItem> goodsLiveItemList = headVO.getGoodsLiveItemList();
        List<GoodsLiveList> goodsLiveLists = headVO.getGoodsLiveLists();
        if (!CollectionUtils.isEmpty(goodsTopmanItemList)) {
            for (GoodsTopmanItem goodsTopmanItem : goodsTopmanItemList) {
                goodsTopmanItem.setHeadId(goodsHead.getId());
                SysUtil.setSysParam((BaseEntity)goodsTopmanItem, (BaseEntity)goodsHead);
            }
            if (!goodsTopmanItemList.isEmpty()) {
                this.goodsTopmanItemMapper.insertBatchSomeColumn(goodsTopmanItemList);
            }
        }
        if (!CollectionUtils.isEmpty(goodsVideoItemList)) {
            for (GoodsVideoItem goodsVideoItem : goodsVideoItemList) {
                goodsVideoItem.setHeadId(goodsHead.getId());
                SysUtil.setSysParam((BaseEntity)goodsVideoItem, (BaseEntity)goodsHead);
            }
            if (!goodsVideoItemList.isEmpty()) {
                this.goodsVideoItemMapper.insertBatchSomeColumn(goodsVideoItemList);
            }
        }
        if (!CollectionUtils.isEmpty(goodsVideoLists)) {
            for (GoodsVideoList goodsVideoList : goodsVideoLists) {
                goodsVideoList.setGoodsId(goodsHead.getId());
                SysUtil.setSysParam((BaseEntity)goodsVideoList, (BaseEntity)goodsHead);
            }
            if (!goodsVideoLists.isEmpty()) {
                this.goodsVideoListMapper.insertBatchSomeColumn(goodsVideoLists);
            }
        }
        if (!CollectionUtils.isEmpty(goodsLiveItemList)) {
            for (GoodsLiveItem goodsLiveItem : goodsLiveItemList) {
                goodsLiveItem.setHeadId(goodsHead.getId());
                SysUtil.setSysParam((BaseEntity)goodsLiveItem, (BaseEntity)goodsHead);
            }
            if (!goodsLiveItemList.isEmpty()) {
                this.goodsLiveItemMapper.insertBatchSomeColumn(goodsLiveItemList);
            }
        }
        if (!CollectionUtils.isEmpty(goodsLiveLists)) {
            for (GoodsLiveList goodsLiveList : goodsLiveLists) {
                goodsLiveList.setGoodsId(goodsHead.getId());
                SysUtil.setSysParam((BaseEntity)goodsLiveList, (BaseEntity)goodsHead);
            }
            if (!goodsLiveLists.isEmpty()) {
                this.goodsLiveListMapper.insertBatchSomeColumn(goodsLiveLists);
            }
        }
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void delMain(String id) {
        this.goodsTopmanItemMapper.deleteByMainId(id);
        this.goodsVideoItemMapper.deleteByMainId(id);
        this.goodsLiveItemMapper.deleteByMainId(id);
        this.goodsHeadMapper.deleteById((Serializable)((Object)id));
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void delBatchMain(List<String> idList) {
        for (Serializable serializable : idList) {
            this.goodsTopmanItemMapper.deleteByMainId(serializable.toString());
            this.goodsVideoItemMapper.deleteByMainId(serializable.toString());
            this.goodsLiveItemMapper.deleteByMainId(serializable.toString());
            this.goodsHeadMapper.deleteById(serializable);
        }
    }
}

