/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.industryinfo.excel;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.els.common.excel.service.BaseExportService;
import com.els.common.system.base.entity.BaseEntity;
import com.els.modules.industryinfo.dto.GoodsTopmanItemQueryDTO;
import com.els.modules.industryinfo.entity.GoodsTopmanItem;
import com.els.modules.industryinfo.service.GoodsTopmanItemService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="goodsHeadStatisticsExportServiceImpl")
public class GoodsHeadStatisticsExportServiceImpl
extends BaseExportService<GoodsTopmanItem, GoodsTopmanItem, GoodsTopmanItem> {
    @Autowired
    private GoodsTopmanItemService goodsTopmanItemService;

    public List<GoodsTopmanItem> queryExportData(QueryWrapper<GoodsTopmanItem> queryWrapper, GoodsTopmanItem param, Map<String, String[]> paramMap) {
        String[] topmanTimeSelects = paramMap.get("topmanTimeSelect");
        GoodsTopmanItemQueryDTO queryDTO = new GoodsTopmanItemQueryDTO();
        if (topmanTimeSelects != null && topmanTimeSelects.length > 0) {
            String timeSelect = topmanTimeSelects[0];
            queryDTO.setTopmanTimeSelect(timeSelect);
        }
        QueryWrapper<GoodsTopmanItem> goodsHeadQueryWrapper = this.goodsTopmanItemService.criteriaQuery(queryWrapper, queryDTO);
        List list = this.goodsTopmanItemService.list((Wrapper)goodsHeadQueryWrapper);
        ArrayList<GoodsTopmanItem> statisticsVOList = new ArrayList<GoodsTopmanItem>();
        if (CollectionUtil.isNotEmpty((Collection)list)) {
            Map<Date, List<GoodsTopmanItem>> map = list.stream().collect(Collectors.groupingBy(BaseEntity::getCreateTime));
            for (Map.Entry<Date, List<GoodsTopmanItem>> entry : map.entrySet()) {
                List<GoodsTopmanItem> value = entry.getValue();
                BigDecimal salesNum = value.stream().map(GoodsTopmanItem::getSalesNum).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal salesAmountMin = value.stream().map(GoodsTopmanItem::getSalesAmountMin).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal salesAmountMax = value.stream().map(GoodsTopmanItem::getSalesAmountMax).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal browsesNum = value.stream().map(GoodsTopmanItem::getBrowsesNum).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal videosNum = value.stream().map(GoodsTopmanItem::getVideosNum).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal livesNum = value.stream().map(GoodsTopmanItem::getLivesNum).reduce(BigDecimal.ZERO, BigDecimal::add);
                GoodsTopmanItem statisticsVO = new GoodsTopmanItem();
                statisticsVO.setCreateTimeSta(entry.getKey());
                statisticsVO.setSalesNumSta(salesNum);
                statisticsVO.setSalesAmountMinSta(salesAmountMin);
                statisticsVO.setSalesAmountMaxSta(salesAmountMax);
                statisticsVO.setBrowsesNumSta(browsesNum);
                statisticsVO.setTopmanNumSta(new BigDecimal(value.size()));
                statisticsVO.setVideosNumSta(videosNum);
                statisticsVO.setLivesNumSta(livesNum);
                statisticsVOList.add(statisticsVO);
            }
        }
        return statisticsVOList;
    }
}

