/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.industryinfo.excel;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.els.common.excel.ExcelExportDTO;
import com.els.common.excel.service.BaseExportService;
import com.els.modules.industryinfo.dto.SimplePostRequestParam;
import com.els.modules.industryinfo.dto.TopManInformationParam;
import com.els.modules.industryinfo.entity.TopManParamEntity;
import com.els.modules.industryinfo.entity.TopManResultEntity;
import com.els.modules.industryinfo.enumerate.TopManQueryType;
import com.els.modules.industryinfo.service.TopManInformationService;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="topManInformationExportServiceImpl")
public class TopManInformationExportServiceImpl
extends BaseExportService<TopManParamEntity, TopManResultEntity, TopManExportBean> {
    @Autowired
    private TopManInformationService topManInformationService;

    public List<TopManResultEntity> queryExportData(QueryWrapper<TopManParamEntity> queryWrapper, TopManExportBean map, final Map<String, String[]> paramMap) {
        try {
            SimplePostRequestParam<TopManInformationParam> bean = new SimplePostRequestParam<TopManInformationParam>(){
                {
                    this.setFilterInfo(new TopManInformationParam(){
                        {
                            String[] params = (String[])paramMap.get("param");
                            String[] ids = params[0].split(",");
                            this.setIds(ids);
                        }
                    });
                }
            };
            String[] defineColumnCodes = paramMap.get("defineColumnCode");
            TopManQueryType queryType = TopManQueryType.getQueryType(defineColumnCodes[0]);
            List records = this.topManInformationService.queryTopManList(bean, queryType).getRecords();
            return records;
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public ExcelExportDTO builderExcelEntityList(List<TopManResultEntity> dataList, Class<TopManResultEntity> clazz) {
        Class<TopManResultEntity> aClass = null;
        if (dataList != null && dataList.size() > 0) {
            aClass = ((Object)((Object)dataList.get(0))).getClass();
        }
        List column = this.buildExcelExportData(aClass != null ? aClass : clazz, null, null);
        return new ExcelExportDTO(column, JSON.toJSONString(dataList));
    }

    public static final class TopManExportBean
    extends SimplePostRequestParam<TopManInformationParam> {
    }
}

