/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.industryinfo.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.modules.industryinfo.dto.GoodsHeadQueryDTO;
import com.els.modules.industryinfo.entity.GoodsItem;
import com.els.modules.industryinfo.mapper.GoodsItemMapper;
import com.els.modules.industryinfo.service.GoodsItemService;
import java.math.BigDecimal;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GoodsItemServiceImpl
extends BaseServiceImpl<GoodsItemMapper, GoodsItem>
implements GoodsItemService {
    @Autowired
    private GoodsItemMapper goodsItemMapper;

    @Override
    public List<GoodsItem> selectByMainId(String mainId) {
        return this.goodsItemMapper.selectByMainId(mainId);
    }

    @Override
    public List<GoodsItem> queryList(GoodsHeadQueryDTO queryDTO) {
        QueryWrapper queryWrapper = new QueryWrapper();
        this.criteriaQuery((QueryWrapper<GoodsItem>)queryWrapper, queryDTO);
        return ((GoodsItemMapper)this.baseMapper).selectList((Wrapper)queryWrapper);
    }

    @Override
    public GoodsItem queryGoodsItem(String goodsId, String timeSelect) {
        LambdaQueryWrapper queryWrapper = new QueryWrapper().lambda();
        queryWrapper.eq(GoodsItem::getGoodsId, (Object)goodsId);
        if (StringUtils.isBlank((CharSequence)timeSelect)) {
            timeSelect = "1";
        }
        queryWrapper.eq(GoodsItem::getQueryDay, (Object)timeSelect);
        return (GoodsItem)((Object)((GoodsItemMapper)this.baseMapper).selectOne((Wrapper)queryWrapper));
    }

    private QueryWrapper<GoodsItem> criteriaQuery(QueryWrapper<GoodsItem> queryWrapper, GoodsHeadQueryDTO queryDTO) {
        Boolean goodsVideo;
        Boolean goodsLive;
        String goodsBrowsesNum;
        String salesNum;
        String timeSelect = queryDTO.getTimeSelect();
        if (StringUtils.isBlank((CharSequence)timeSelect)) {
            timeSelect = "1";
        }
        queryWrapper.lambda().eq(GoodsItem::getQueryDay, (Object)timeSelect);
        String topman = queryDTO.getGoodsTopmanNum();
        if (StringUtils.isNotBlank((CharSequence)topman)) {
            String[] strings;
            if (topman.contains("-")) {
                strings = topman.split("-");
                queryWrapper.lambda().gt(GoodsItem::getTopmanNum, (Object)new BigDecimal(strings[0]));
                queryWrapper.lambda().le(GoodsItem::getTopmanNum, (Object)new BigDecimal(strings[1]));
            } else if (topman.contains(">")) {
                strings = topman.split(">");
                String string = topman.substring(topman.indexOf(">") + 1);
                queryWrapper.lambda().gt(GoodsItem::getTopmanNum, (Object)new BigDecimal(strings[1]));
            } else {
                queryWrapper.lambda().eq(GoodsItem::getTopmanNum, (Object)topman);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(salesNum = queryDTO.getGoodsSalesNum()))) {
            String[] strings;
            if (salesNum.contains("-")) {
                strings = salesNum.split("-");
                queryWrapper.lambda().between(GoodsItem::getSalesNum, (Object)new BigDecimal(strings[0]), (Object)new BigDecimal(strings[1]));
            }
            if (salesNum.contains(">=")) {
                strings = salesNum.split(">=");
                queryWrapper.lambda().ge(GoodsItem::getSalesNum, (Object)new BigDecimal(strings[1]));
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(goodsBrowsesNum = queryDTO.getGoodsBrowsesNum()))) {
            String[] strings;
            if (goodsBrowsesNum.contains("-")) {
                strings = goodsBrowsesNum.split("-");
                queryWrapper.lambda().between(GoodsItem::getBrowsesNum, (Object)new BigDecimal(strings[0]), (Object)new BigDecimal(strings[1]));
            }
            if (goodsBrowsesNum.contains(">=")) {
                strings = goodsBrowsesNum.split(">=");
                queryWrapper.lambda().ge(GoodsItem::getBrowsesNum, (Object)new BigDecimal(strings[1]));
            }
        }
        if ((goodsLive = queryDTO.getGoodsLive()) != null && goodsLive.booleanValue()) {
            queryWrapper.lambda().isNotNull(GoodsItem::getLivesNum);
        }
        if ((goodsVideo = queryDTO.getGoodsVideo()) != null && goodsVideo.booleanValue()) {
            queryWrapper.lambda().isNotNull(GoodsItem::getVideosNum);
        }
        return queryWrapper;
    }
}

