/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.industryinfo.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.SysUtil;
import com.els.modules.industryinfo.dto.StoreHeadQueryDTO;
import com.els.modules.industryinfo.entity.StoreFavorite;
import com.els.modules.industryinfo.entity.StoreHead;
import com.els.modules.industryinfo.entity.StoreItem;
import com.els.modules.industryinfo.entity.StoreTopmanItem;
import com.els.modules.industryinfo.entity.StoreTopmanRecord;
import com.els.modules.industryinfo.mapper.StoreFavoriteMapper;
import com.els.modules.industryinfo.mapper.StoreHeadMapper;
import com.els.modules.industryinfo.mapper.StoreItemMapper;
import com.els.modules.industryinfo.mapper.StoreTopmanItemMapper;
import com.els.modules.industryinfo.mapper.StoreTopmanRecordMapper;
import com.els.modules.industryinfo.service.StoreHeadService;
import com.els.modules.industryinfo.service.StoreItemService;
import com.els.modules.industryinfo.vo.StoreHeadVO;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class StoreHeadServiceImpl
extends BaseServiceImpl<StoreHeadMapper, StoreHead>
implements StoreHeadService {
    @Autowired
    private StoreHeadMapper storeHeadMapper;
    @Autowired
    private StoreItemService storeItemService;
    @Autowired
    private StoreItemMapper storeItemMapper;
    @Autowired
    private StoreTopmanItemMapper storeTopmanItemMapper;
    @Autowired
    private StoreTopmanRecordMapper storeTopmanRecordMapper;
    @Autowired
    private StoreFavoriteMapper storeFavoriteMapper;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;

    @Override
    public IPage<StoreHead> queryPage(Page<StoreHead> page, QueryWrapper<StoreHead> queryWrapper, StoreHeadQueryDTO queryDTO) {
        if (StringUtils.isBlank((CharSequence)queryDTO.getTimeSelect())) {
            queryDTO.setTimeSelect("1");
        }
        this.criteriaQuery(queryWrapper, queryDTO);
        Page storeHeadPage = (Page)this.page((IPage)page, (Wrapper)queryWrapper);
        this.replenish(storeHeadPage.getRecords(), queryDTO);
        return storeHeadPage;
    }

    @Override
    public IPage<StoreHead> queryFavoritePage(Page<StoreHead> page, QueryWrapper<StoreHead> queryWrapper, StoreHeadQueryDTO queryDTO) {
        LoginUser loginUser = SysUtil.getLoginUser();
        String elsAccount = loginUser.getElsAccount();
        List<StoreFavorite> goodsFavoriteList = this.storeFavoriteMapper.selectByElsAccount(elsAccount);
        if (!CollectionUtils.isEmpty(goodsFavoriteList)) {
            List storeIds = goodsFavoriteList.stream().map(StoreFavorite::getStoreId).collect(Collectors.toList());
            queryWrapper.lambda().in(BaseEntity::getId, storeIds);
            this.criteriaQuery(queryWrapper, queryDTO);
        } else {
            queryWrapper.lambda().eq(BaseEntity::getId, null);
        }
        Page storeHeadPage = (Page)this.page((IPage)page, (Wrapper)queryWrapper);
        this.replenish(storeHeadPage.getRecords(), queryDTO);
        return storeHeadPage;
    }

    @Override
    public List<StoreHead> replenish(List<StoreHead> list, StoreHeadQueryDTO queryDTO) {
        if (!CollectionUtils.isEmpty(list)) {
            for (StoreHead storeHead : list) {
                StoreItem storeItem = this.storeItemService.queryStoreItem(storeHead.getId(), queryDTO.getTimeSelect());
                if (storeItem != null) {
                    storeHead.setSalesNum(storeItem.getSalesNum());
                    storeHead.setSalesAmountMin(storeItem.getSalesAmountMin());
                    storeHead.setSalesAmountMax(storeItem.getSalesAmountMax());
                    storeHead.setGoodsNum(storeItem.getGoodsNum());
                    storeHead.setTopmanNum(storeItem.getTopmanNum());
                    storeHead.setVideosNum(storeItem.getVideosNum());
                    storeHead.setLivesNum(storeItem.getLivesNum());
                    storeHead.setQueryDay(storeItem.getQueryDay());
                }
                LoginUser loginUser = SysUtil.getLoginUser();
                String elsAccount = loginUser.getElsAccount();
                StoreFavorite storeFavorite = this.storeFavoriteMapper.selectGoodsFavorite(storeHead.getId(), elsAccount);
                storeHead.setFavoriteStore(false);
                if (storeFavorite == null) continue;
                storeHead.setFavoriteStore(true);
            }
        }
        return list;
    }

    @Override
    public StoreHeadVO queryById(String id) {
        StoreHeadVO storeHeadVO = new StoreHeadVO();
        StoreHead storeHead = (StoreHead)((Object)this.getById((Serializable)((Object)id)));
        if (storeHead == null) {
            return storeHeadVO;
        }
        BeanUtils.copyProperties((Object)((Object)storeHead), (Object)((Object)storeHeadVO));
        String timeSelect = "30";
        StoreItem storeItem = this.storeItemService.queryStoreItem(id, timeSelect);
        if (storeItem != null) {
            storeHeadVO.setSalesNum(storeItem.getSalesNum());
            storeHeadVO.setSalesAmountMin(storeItem.getSalesAmountMin());
            storeHeadVO.setSalesAmountMax(storeItem.getSalesAmountMax());
            storeHeadVO.setGoodsNum(storeItem.getGoodsNum());
            storeHeadVO.setTopmanNum(storeItem.getTopmanNum());
            storeHeadVO.setVideosNum(storeItem.getVideosNum());
            storeHeadVO.setLivesNum(storeItem.getLivesNum());
            storeHeadVO.setQueryDay(storeItem.getQueryDay());
        }
        LoginUser loginUser = SysUtil.getLoginUser();
        String elsAccount = loginUser.getElsAccount();
        StoreFavorite storeFavorite = this.storeFavoriteMapper.selectGoodsFavorite(storeHead.getId(), elsAccount);
        storeHeadVO.setFavoriteStore(false);
        if (storeFavorite != null) {
            storeHeadVO.setFavoriteStore(true);
        }
        return storeHeadVO;
    }

    @Override
    public QueryWrapper<StoreHead> criteriaQuery(QueryWrapper<StoreHead> queryWrapper, StoreHeadQueryDTO queryDTO) {
        List<StoreItem> goodsItems;
        String experienceNum;
        String timeSelect = queryDTO.getTimeSelect();
        if (StringUtils.isNotBlank((CharSequence)timeSelect)) {
            Calendar cal = Calendar.getInstance();
            cal.set(cal.get(1), cal.get(2), cal.get(5), 0, 0, 0);
            Date today = cal.getTime();
            cal.set(cal.get(1), cal.get(2), cal.get(5) - Integer.valueOf(timeSelect), 0, 0, 0);
            Date selectDay = cal.getTime();
            queryWrapper.lambda().between(BaseEntity::getCreateTime, (Object)selectDay, (Object)today);
        }
        if (StringUtils.isNotBlank((CharSequence)(experienceNum = queryDTO.getStoreExperienceNum())) && experienceNum.contains("~")) {
            String[] strings = experienceNum.split("~");
            queryWrapper.lambda().gt(StoreHead::getExperienceNum, (Object)new BigDecimal(strings[0]));
            queryWrapper.lambda().le(StoreHead::getExperienceNum, (Object)new BigDecimal(strings[1]));
        }
        if (CollectionUtil.isNotEmpty(goodsItems = this.storeItemService.queryList(queryDTO))) {
            List ids = goodsItems.stream().map(StoreItem::getHeadId).distinct().collect(Collectors.toList());
            queryWrapper.lambda().in(BaseEntity::getId, ids);
        }
        return queryWrapper;
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void saveMain(StoreHead storeHead, StoreHeadVO headVO) {
        String platform = storeHead.getPlatform();
        String account = storeHead.getBusAccount();
        storeHead.setStoreCode(platform + account + this.invokeBaseRpcService.getNextCode("mcnSrmStoreCode", (Object)storeHead));
        this.storeHeadMapper.insert((Object)storeHead);
        super.setHeadDefaultValue((BaseEntity)storeHead);
        this.insertData(storeHead, headVO);
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void updateMain(StoreHead storeHead, StoreHeadVO headVO) {
        this.storeHeadMapper.updateById((Object)storeHead);
        this.storeTopmanItemMapper.deleteByMainId(storeHead.getId());
        this.insertData(storeHead, headVO);
    }

    @Override
    public void favorite(String id) {
        StoreHead storeHead = (StoreHead)((Object)((StoreHeadMapper)this.baseMapper).selectById((Serializable)((Object)id)));
        StoreFavorite storeFavorite = new StoreFavorite();
        LoginUser loginUser = SysUtil.getLoginUser();
        String elsAccount = loginUser.getElsAccount();
        storeFavorite.setElsAccount(elsAccount);
        storeFavorite.setStoreId(storeHead.getId());
        storeFavorite.setPlatform(storeHead.getPlatform());
        storeFavorite.setFavoriteTime(new Date());
        this.storeFavoriteMapper.insert((Object)storeFavorite);
    }

    @Override
    public void cancelFavorite(String id) {
        LoginUser loginUser = SysUtil.getLoginUser();
        String elsAccount = loginUser.getElsAccount();
        this.storeFavoriteMapper.deleteGoodsFavorite(id, elsAccount);
    }

    private void insertData(StoreHead storeHead, StoreHeadVO headVO) {
        List<StoreTopmanRecord> records;
        List<StoreItem> storeItemList = headVO.getStoreItemList();
        List<StoreTopmanItem> storeTopmanItemList = headVO.getStoreTopmanItemList();
        List<StoreTopmanRecord> storeTopmanRecordList = headVO.getStoreTopmanRecordList();
        if (!CollectionUtils.isEmpty(storeItemList)) {
            for (StoreItem storeItem : storeItemList) {
                storeItem.setHeadId(storeHead.getId());
                SysUtil.setSysParam((BaseEntity)storeItem, (BaseEntity)storeHead);
            }
            if (!storeItemList.isEmpty()) {
                this.storeItemMapper.insertBatchSomeColumn(storeItemList);
            }
        }
        if (!CollectionUtils.isEmpty(storeTopmanRecordList)) {
            for (StoreTopmanRecord storeTopmanRecord : storeTopmanRecordList) {
                storeTopmanRecord.setHeadId(storeHead.getId());
                SysUtil.setSysParam((BaseEntity)storeTopmanRecord, (BaseEntity)storeHead);
            }
            if (!storeTopmanRecordList.isEmpty()) {
                this.storeTopmanRecordMapper.insertBatchSomeColumn(storeTopmanRecordList);
            }
        }
        if (!CollectionUtils.isEmpty(records = this.storeTopmanRecordMapper.selectByMainId(storeHead.getId()))) {
            for (StoreTopmanRecord entity : records) {
                if (CollectionUtils.isEmpty(storeTopmanItemList)) continue;
                for (StoreTopmanItem entity2 : storeTopmanItemList) {
                    entity2.setRecordId(entity.getId());
                    SysUtil.setSysParam((BaseEntity)entity2, (BaseEntity)storeHead);
                }
                if (storeTopmanItemList.isEmpty()) continue;
                this.storeTopmanItemMapper.insertBatchSomeColumn(storeTopmanItemList);
            }
        }
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void delMain(String id) {
        this.storeTopmanRecordMapper.deleteByMainId(id);
        this.storeHeadMapper.deleteById((Serializable)((Object)id));
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void delBatchMain(List<String> idList) {
        for (Serializable serializable : idList) {
            this.storeTopmanRecordMapper.deleteByMainId(serializable.toString());
            this.storeHeadMapper.deleteById(serializable);
        }
    }
}

