/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.material.api.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.convert.Convert;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.els.common.constant.CommonConstant;
import com.els.common.excel.ExcelExportClassColumnDTO;
import com.els.common.util.ClassTypeBuilder;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.TemplateConfigHeadDTO;
import com.els.modules.base.api.dto.TemplateConfigItemDTO;
import com.els.modules.base.api.dto.TemplateHeadDTO;
import com.els.modules.base.api.service.OpenApiRpcService;
import com.els.modules.material.entity.PurchaseMaterialSource;
import com.els.modules.material.service.PurchaseMaterialSourceService;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PurchaseMaterialSourceCreateOpenServiceImpl
implements OpenApiRpcService {
    @Autowired
    private PurchaseMaterialSourceService purchaseMaterialSourceService;

    public JSONObject doCreateInvoke(JSONArray array, TemplateHeadDTO templateHead, Map<String, String> defaultHeadMap, Map<String, String> defaultItemMap) {
        String account = TenantContext.getTenant();
        Date currentTime = new Date();
        ArrayList<PurchaseMaterialSource> headList = new ArrayList<PurchaseMaterialSource>();
        for (Object obj : array) {
            JSONObject object = (JSONObject)Convert.convert(JSONObject.class, obj);
            if (object.size() == 0) continue;
            PurchaseMaterialSource head = (PurchaseMaterialSource)((Object)JSON.parseObject((String)object.toString(), PurchaseMaterialSource.class));
            head.setElsAccount(account);
            head.setCreateTime(currentTime);
            head.setCreateBy("interface");
            head.setUpdateBy("interface");
            head.setDeleted(CommonConstant.DEL_FLAG_0);
            head.setTemplateName(templateHead.getTemplateName());
            head.setTemplateNumber(templateHead.getTemplateNumber());
            head.setTemplateVersion(templateHead.getTemplateVersion().toString());
            BeanUtil.copyProperties(defaultHeadMap, (Object)((Object)head), (String[])new String[0]);
            headList.add(head);
        }
        if (!headList.isEmpty()) {
            this.purchaseMaterialSourceService.saveBatch(headList, 2000);
        }
        return null;
    }

    public void doParamCheck(JSONArray array, TemplateHeadDTO templateHead, Map<String, String> defaultHeadMap, Map<String, String> defaultItemMap, List<TemplateConfigHeadDTO> configHeadList, List<TemplateConfigItemDTO> configItemList) {
    }

    public String getBusinessType() {
        return "materialSource";
    }

    public List<ExcelExportClassColumnDTO> getBusinessClass() {
        return ClassTypeBuilder.buildClassTypeList(PurchaseMaterialSource.class, null, null);
    }

    public List<String> supportItemList() {
        return Lists.newArrayList((Object[])new String[]{"itemList"});
    }
}

